/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.question;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.questions.QuestionLabelProvider;
import upc.gessi.architech.controller.types.TypeContentProvider;
import upc.gessi.architech.controller.types.TypeLabelProvider;
import upc.gessi.architech.controller.types.TypeSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.question.Question;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public class QuestionDialog
extends TitleAreaDialog {
    private Combo orderCombo;
    private Text questionText;
    private Text restrictionText;
    private List rulesList;
    private List questionsList;
    private TableViewer typesList;
    private boolean isNew;
    private Question question;
    private DataType type;
    private HashMap<String, HashMap<String, String>> rulesMap;
    private Shell shell;
    private static final int NUM_ERRORS = 3;
    private static final int EMPTY_NAME = 0;
    private static final int NO_TYPE = 1;
    private static final int ALREADY_EXISTS = 2;
    private static final int NO_ERROR = -1;
    private static final int PARSING_ERROR = 0;
    private static final int ERROR = 2;
    private ErrorInfo[] errors = new ErrorInfo[3];

    public QuestionDialog(Shell parentShell) {
        super(parentShell);
        this.isNew = true;
        this.rulesMap = new HashMap();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public QuestionDialog(Shell parentShell, Question q) throws DomainException {
        super(parentShell);
        this.question = q = DomainController.getInstance().getQuestionById(q.getId());
        this.isNew = false;
        this.type = DomainController.getInstance().getTypeById(q.getQuestionType().getId());
        this.rulesMap = DomainController.getInstance().getQuestionRulesInfo(q);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point p = new Point(550, 550);
        return p;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.shell = this.getShell();
        if (this.isNew) {
            this.shell.setText("New Question");
        } else {
            this.shell.setText("Edit Question");
        }
        this.setTitle("Question");
        this.setMessage("Enter the data for this question");
        this.setTitleImage(Activator.getImageDescriptor("questionIcon_48x48.png").createImage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        TabFolder tabs = new TabFolder(contents, 128);
        tabs.setLayoutData((Object)new GridData(4, 4, true, true));
        tabs.setLayout((Layout)new GridLayout());
        this.createInformationTab(tabs);
        this.createRulesTab(tabs);
        this.initErrors();
        this.fillValues();
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    private void createInformationTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Information");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Put this question: ");
        this.orderCombo = new Combo(content, 12);
        GridData gd0 = new GridData(4, 0x1000000, true, false);
        gd0.horizontalSpan = 2;
        this.orderCombo.setLayoutData((Object)gd0);
        this.fillComboValues();
        Label label2 = new Label(content, 0);
        label2.setText("Question: ");
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 3;
        label2.setLayoutData((Object)gd1);
        this.questionText = new Text(content, 2048);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.horizontalSpan = 3;
        this.questionText.setLayoutData((Object)gd2);
        this.questionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                try {
                    boolean oldErr1 = ((QuestionDialog)QuestionDialog.this).errors[0].isError;
                    boolean newErr1 = QuestionDialog.this.questionText.getText().length() == 0;
                    boolean oldErr2 = ((QuestionDialog)QuestionDialog.this).errors[2].isError;
                    Long id = null;
                    if (!QuestionDialog.this.isNew) {
                        id = QuestionDialog.this.question.getId();
                    }
                    boolean newErr2 = DomainController.getInstance().questionAlredyExists(QuestionDialog.this.questionText.getText(), QuestionDialog.this.isNew, id);
                    if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                        ((QuestionDialog)QuestionDialog.this).errors[0].isError = newErr1;
                        ((QuestionDialog)QuestionDialog.this).errors[2].isError = newErr2;
                        QuestionDialog.this.validate();
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, QuestionDialog.this.getShell());
                    dd.open();
                }
            }
        });
        Label label3 = new Label(content, 0);
        label3.setText("Type: ");
        GridData gd3 = new GridData(4, 0x1000000, true, false);
        gd3.horizontalSpan = 3;
        label3.setLayoutData((Object)gd3);
        this.typesList = new TableViewer(content, 2052);
        this.typesList.setContentProvider((IContentProvider)new TypeContentProvider());
        this.typesList.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        this.typesList.setSorter((ViewerSorter)new TypeSorter());
        GridData gd4 = new GridData(0x1000000, 4, false, true);
        gd4.heightHint = 50;
        gd4.widthHint = 250;
        this.typesList.getTable().setLayoutData((Object)gd4);
        try {
            this.typesList.setInput((Object)Model.getInstance().getTypes());
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
        this.typesList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                boolean newErr;
                boolean oldErr = ((QuestionDialog)QuestionDialog.this).errors[1].isError;
                boolean bl = newErr = QuestionDialog.this.typesList.getTable().getSelectionCount() == 0;
                if (oldErr != newErr) {
                    ((QuestionDialog)QuestionDialog.this).errors[1].isError = newErr;
                    QuestionDialog.this.validate();
                }
            }
        });
    }

    private void createRulesTab(TabFolder tabs) {
        TabItem tabitem = new TabItem(tabs, 0);
        tabitem.setText("Rules");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabitem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Rules:");
        Label label2 = new Label(content, 0);
        label2.setText("IF:");
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 2;
        label2.setLayoutData((Object)gd1);
        this.rulesList = new List(content, 2820);
        GridData gd2 = new GridData(0x1000000, 4, false, true);
        gd2.verticalSpan = 4;
        gd2.heightHint = 100;
        gd2.widthHint = 60;
        this.rulesList.setLayoutData((Object)gd2);
        this.rulesList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                QuestionDialog.this.questionsList.removeAll();
                QuestionDialog.this.restrictionText.setText("");
                HashMap res = (HashMap)QuestionDialog.this.rulesMap.get(QuestionDialog.this.rulesList.getSelection()[0]);
                for (String q : res.keySet()) {
                    QuestionDialog.this.questionsList.add(q);
                }
            }
        });
        this.questionsList = new List(content, 2820);
        GridData gd3 = new GridData(0x1000000, 0x1000000, false, false);
        gd3.verticalSpan = 2;
        gd3.heightHint = 120;
        gd3.widthHint = 200;
        this.questionsList.setLayoutData((Object)gd3);
        this.questionsList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                HashMap res = (HashMap)QuestionDialog.this.rulesMap.get(QuestionDialog.this.rulesList.getSelection()[0]);
                QuestionDialog.this.restrictionText.setText((String)res.get(QuestionDialog.this.questionsList.getSelection()[0]));
            }
        });
        Button addQuestionButton = new Button(content, 8);
        addQuestionButton.setText("Add");
        addQuestionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    if (QuestionDialog.this.rulesList.getSelection().length != 0) {
                        ElementListSelectionDialog dg = new ElementListSelectionDialog(QuestionDialog.this.shell, (ILabelProvider)new QuestionLabelProvider());
                        HashSet allQuestions = Model.getInstance().getQuestions();
                        HashSet<Question> validQuestions = new HashSet<Question>();
                        String[] items = QuestionDialog.this.questionsList.getItems();
                        for (Question q : allQuestions) {
                            boolean add = true;
                            int i = 0;
                            while (i < items.length) {
                                if (q.getText().equals(items[i])) {
                                    add = false;
                                }
                                ++i;
                            }
                            if (!add) continue;
                            validQuestions.add(q);
                        }
                        dg.setElements(validQuestions.toArray());
                        dg.setTitle("Browse Question");
                        dg.setMessage("Select a Question:");
                        dg.setMultipleSelection(false);
                        if (dg.open() == 0) {
                            Question result = (Question)dg.getFirstResult();
                            String qText = result.getText();
                            QuestionDialog.this.questionsList.add(qText);
                            HashMap res = (HashMap)QuestionDialog.this.rulesMap.get(QuestionDialog.this.rulesList.getSelection()[0]);
                            res.put(qText, "");
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, QuestionDialog.this.shell);
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, QuestionDialog.this.shell);
                    dd.open();
                }
            }
        });
        Button delQuestionButton = new Button(content, 8);
        delQuestionButton.setText("Delete");
        delQuestionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (QuestionDialog.this.rulesList.getSelection().length != 0) {
                    HashMap res = (HashMap)QuestionDialog.this.rulesMap.get(QuestionDialog.this.rulesList.getSelection()[0]);
                    String selQuestion = QuestionDialog.this.questionsList.getSelection()[0];
                    QuestionDialog.this.questionsList.remove(selQuestion);
                    res.remove(selQuestion);
                    QuestionDialog.this.restrictionText.setText("");
                }
            }
        });
        Label label3 = new Label(content, 0);
        label3.setText("Restriction on the answer: ");
        GridData gd4 = new GridData(4, 0x1000000, true, false);
        gd4.horizontalSpan = 2;
        label3.setLayoutData((Object)gd4);
        this.restrictionText = new Text(content, 2818);
        GridData gd5 = new GridData(4, 4, true, true);
        gd5.horizontalSpan = 2;
        this.restrictionText.setLayoutData((Object)gd5);
        this.restrictionText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (QuestionDialog.this.questionsList.getSelection().length == 0) {
                    QuestionDialog.this.questionsList.setFocus();
                }
            }

            public void focusLost(FocusEvent e) {
                HashMap selRes = (HashMap)QuestionDialog.this.rulesMap.get(QuestionDialog.this.rulesList.getSelection()[0]);
                selRes.put(QuestionDialog.this.questionsList.getSelection()[0], QuestionDialog.this.restrictionText.getText());
            }
        });
        Button addRule = new Button(content, 8);
        addRule.setText("New Rule");
        GridData gd6 = new GridData(1, 0x1000000, false, false);
        gd6.horizontalSpan = 3;
        addRule.setLayoutData((Object)gd6);
        addRule.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                InputDialog dg = new InputDialog(QuestionDialog.this.shell, "New Rule", "Introduce a name for the rule: ", "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText == null || newText.equals("")) {
                            return "Introdue a Name";
                        }
                        return null;
                    }
                });
                if (dg.open() == 0) {
                    String rName = dg.getValue();
                    QuestionDialog.this.rulesList.add(rName);
                    QuestionDialog.this.rulesMap.put(rName, new HashMap());
                }
            }
        });
        Button delRule = new Button(content, 8);
        delRule.setText("Delete Rule");
        GridData gd7 = new GridData(1, 0x1000000, false, false);
        gd7.horizontalSpan = 3;
        delRule.setLayoutData((Object)gd7);
        delRule.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                String rName = QuestionDialog.this.rulesList.getSelection()[0];
                QuestionDialog.this.rulesList.remove(rName);
                QuestionDialog.this.questionsList.removeAll();
                QuestionDialog.this.restrictionText.setText("");
                QuestionDialog.this.rulesMap.remove(rName);
            }
        });
    }

    private void fillValues() {
        if (!this.isNew) {
            this.questionText.setText(this.question.getText());
            this.typesList.setSelection((ISelection)new StructuredSelection((Object)this.type), true);
            for (String qr : this.rulesMap.keySet()) {
                this.rulesList.add(qr);
            }
            this.orderCombo.select(this.question.getOrder() - 1);
        } else {
            this.orderCombo.select(this.orderCombo.getItemCount() - 1);
        }
    }

    private void fillComboValues() {
        try {
            HashSet allQ = Model.getInstance().getQuestions();
            String[] toAdd = new String[allQ.size() + 1];
            toAdd[0] = "in the first place";
            for (Question q : allQ) {
                toAdd[q.getOrder()] = "after \"" + q.getText() + "\"";
            }
            this.orderCombo.setItems(toAdd);
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int validRules() {
        try {
            int qOrder = this.orderCombo.getSelectionIndex() + 1;
            Iterator<String> iterator = this.rulesMap.keySet().iterator();
            block2: while (true) {
                if (!iterator.hasNext()) {
                    return -1;
                }
                String rule = iterator.next();
                HashMap<String, String> res = this.rulesMap.get(rule);
                if (res.isEmpty()) {
                    return 2;
                }
                Iterator<String> iterator2 = res.keySet().iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block2;
                    String q = iterator2.next();
                    if (DomainController.getInstance().getQuestionFromText(q).getOrder() >= qOrder) {
                        return 2;
                    }
                    if (res.get(q).equals("")) {
                        return 2;
                    }
                    res.get(q);
                }
                break;
            }
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
            return 2;
        }
    }

    protected void okPressed() {
        try {
            String qText = this.questionText.getText();
            String typeName = ((DataType)((IStructuredSelection)this.typesList.getSelection()).getFirstElement()).getName();
            int qOrder = this.orderCombo.getSelectionIndex() + 1;
            int err = this.validRules();
            if (err >= 0) {
                if (err == 0) {
                    this.setErrorMessage("Error parsing one of the restrictions");
                } else {
                    this.setErrorMessage("There is some problem with the rules");
                }
            } else {
                if (this.isNew) {
                    DomainController.getInstance().newQuestion(typeName, qText, qOrder, this.rulesMap);
                } else {
                    DomainController.getInstance().updateQuestion(this.question, typeName, qText, qOrder, this.rulesMap);
                }
                super.okPressed();
            }
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.setErrorMessage(e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void initErrors() {
        this.errors[0] = new ErrorInfo("The text can't be empty", 3, this.isNew);
        this.errors[1] = new ErrorInfo("You have to select a type", 3, this.isNew);
        this.errors[2] = new ErrorInfo("A Question with the same text alredy exists", 3, false);
    }

    private void validate() {
        boolean error = false;
        ErrorInfo[] errorInfoArray = this.errors;
        int n = this.errors.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorInfo err = errorInfoArray[n2];
            if (err.isError) {
                this.setErrorMessage(err.message);
                error = true;
                break;
            }
            ++n2;
        }
        if (!error) {
            this.setErrorMessage(null);
        }
        this.getButton(0).setEnabled(!error);
    }
}

