/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.views.decisions;

import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.decisions.DecisionContentProvider;
import upc.gessi.architech.controller.decisions.DecisionLabelProvider;
import upc.gessi.architech.controller.decisions.DecisionSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.decision.DecisionDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.Decision;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public class DecisionsView
extends ViewPart {
    private Action newDecisionAction;
    private Action editDecisionAction;
    private Action deleteDecisionAction;
    private ListViewer decisionsList;
    private Composite owner;
    private HashSet<Decision> allDecisions = null;
    Shell shell;

    public void createPartControl(Composite parent) {
        try {
            this.owner = parent;
            this.decisionsList = new ListViewer(parent);
            this.decisionsList.setContentProvider((IContentProvider)new DecisionContentProvider());
            this.decisionsList.setLabelProvider((IBaseLabelProvider)new DecisionLabelProvider());
            this.decisionsList.setSorter((ViewerSorter)new DecisionSorter());
            if (this.allDecisions == null) {
                this.allDecisions = Model.getInstance().getDecisions();
            }
            this.decisionsList.setInput(this.allDecisions);
            this.getSite().setSelectionProvider((ISelectionProvider)this.decisionsList);
            this.shell = this.decisionsList.getControl().getShell();
            this.createActions();
            this.createMenu();
            this.addListeners();
            this.setEnabledActions();
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void createActions() {
        this.newDecisionAction = new Action("New Decision", Activator.getImageDescriptor("add_16x16.png")){

            public void run() {
                try {
                    DecisionDialog dd = new DecisionDialog(DecisionsView.this.owner.getShell());
                    if (dd.open() == 0) {
                        DecisionsView.this.decisionsList.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, DecisionsView.this.shell);
                    dd.open();
                }
            }
        };
        this.editDecisionAction = new Action("Edit Decision"){

            public void run() {
                try {
                    if (!DecisionsView.this.decisionsList.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)DecisionsView.this.decisionsList.getSelection();
                        Decision selectedDecision = (Decision)sel.getFirstElement();
                        DecisionDialog dd = new DecisionDialog(DecisionsView.this.owner.getShell(), selectedDecision);
                        dd.open();
                        DecisionsView.this.decisionsList.refresh();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        DecisionsView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DecisionsView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, DecisionsView.this.shell);
                    dd.open();
                }
            }
        };
        this.deleteDecisionAction = new Action("Delete Decision", Activator.getImageDescriptor("remove_16x16.png")){

            public void run() {
                if (!DecisionsView.this.decisionsList.getSelection().isEmpty()) {
                    try {
                        IStructuredSelection sel = (IStructuredSelection)DecisionsView.this.decisionsList.getSelection();
                        Decision selectedDecision = (Decision)sel.getFirstElement();
                        DomainController.getInstance().remove(selectedDecision);
                        DecisionsView.this.decisionsList.refresh();
                    }
                    catch (DomainException e) {
                        if (e.getCause() == null) {
                            DecisionsView.this.showError("Error", e.getMessage());
                        } else {
                            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DecisionsView.this.shell);
                            dd.open();
                        }
                    }
                    catch (Exception e) {
                        DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, DecisionsView.this.shell);
                        dd.open();
                    }
                }
            }
        };
    }

    private void createMenu() {
        IToolBarManager tmgr = this.getViewSite().getActionBars().getToolBarManager();
        tmgr.add((IAction)this.newDecisionAction);
        tmgr.add((IAction)this.deleteDecisionAction);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)DecisionsView.this.newDecisionAction);
                mgr.add((IAction)DecisionsView.this.editDecisionAction);
                mgr.add((IAction)DecisionsView.this.deleteDecisionAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.decisionsList.getControl());
        this.decisionsList.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.decisionsList);
    }

    private void addListeners() {
        this.decisionsList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DecisionsView.this.editDecisionAction.run();
            }
        });
        this.decisionsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DecisionsView.this.setEnabledActions();
            }
        });
    }

    private void setEnabledActions() {
        boolean enabledED = true;
        if (this.decisionsList.getSelection().isEmpty()) {
            enabledED = false;
        }
        this.editDecisionAction.setEnabled(enabledED);
        this.deleteDecisionAction.setEnabled(enabledED);
    }

    public ListViewer getDecisionsList() {
        return this.decisionsList;
    }

    public void setFocus() {
        this.decisionsList.getControl().setFocus();
    }

    public void refresh() {
        this.decisionsList.refresh();
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }
}

