/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.views.elements;

import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.controller.elements.ElementsTreeContentProvider;
import upc.gessi.architech.controller.elements.ElementsTreeSorter;
import upc.gessi.architech.dnd.ElementDragListener;
import upc.gessi.architech.dnd.ElementTransfer;
import upc.gessi.architech.dnd.ElementsTreeDropAdapter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.element.ArchitecturalComponentTypeDialog;
import upc.gessi.architech.gui.dialogs.element.ArchitecturalStyleDialog;
import upc.gessi.architech.gui.dialogs.element.ArchitecturalUnitDialog;
import upc.gessi.architech.gui.dialogs.element.ConcreteTechnologyDialog;
import upc.gessi.architech.gui.dialogs.element.TechnologicalRoleDialog;
import upc.gessi.architech.gui.dialogs.element.TechnologicalStyleDialog;
import upc.gessi.architech.gui.dialogs.element.TechnologicalUnitDialog;
import upc.gessi.architech.gui.dialogs.element.TechnologyProductDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalComponentType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalStyle;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalUnit;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ConcreteTechnology;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalRole;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalStyle;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalUnit;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologyProduct;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public class ElementsView
extends ViewPart {
    private static final int ARCHITECTURE_COMPONENT_TYPES_SELECTION = 0;
    private static final int TECHNOLOGICAL_ROLES_SELECTION = 1;
    private static final int TECHNOLOGIES_SELECTION = 2;
    private static final int ARCHITECTURAL_STYLES_SELECTION = 3;
    private static final int TECHNOLOGICAL_STYLES_SELECTION = 4;
    private Action newArchitecturalComponentTypeAction;
    private Action newTechnologicalRoleAction;
    private Action newConcreteTechnologyAction;
    private Action newTechnologyProductAction;
    private Action newArchitecturalStyleAction;
    private Action newTechnologicalStyleAction;
    private Action newArchitecturalUnitAction;
    private Action newTechnologicalUnitAction;
    private Action editElementAction;
    private Action deleteElementAction;
    private Composite owner;
    private Combo elementSelectorCombo;
    private TreeViewer elementsTree;
    private HashSet selectedElements = null;
    int selIndex;
    private MenuManager popUpMenu;
    Shell shell;

    public void createPartControl(Composite parent) {
        try {
            this.owner = parent;
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            parent.setLayout((Layout)layout);
            this.elementSelectorCombo = new Combo(parent, 12);
            this.initComboEntrys();
            this.elementSelectorCombo.select(0);
            this.selIndex = 0;
            this.elementSelectorCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                }

                public void widgetSelected(SelectionEvent event) {
                    int i = ElementsView.this.elementSelectorCombo.getSelectionIndex();
                    if (i != ElementsView.this.selIndex) {
                        switch (i) {
                            case 0: {
                                ElementsView.this.setArchitectureComponentTypes();
                                break;
                            }
                            case 1: {
                                ElementsView.this.setTechnologicalRoles();
                                break;
                            }
                            case 2: {
                                ElementsView.this.setTechnologies();
                                break;
                            }
                            case 3: {
                                ElementsView.this.setArchitecturalStyles();
                                break;
                            }
                            case 4: {
                                ElementsView.this.setTechnologicalStyles();
                            }
                        }
                        ElementsView.this.selIndex = i;
                        ElementsView.this.setMenuElements();
                    }
                }
            });
            this.elementsTree = new TreeViewer(parent);
            this.elementsTree.setContentProvider((IContentProvider)new ElementsTreeContentProvider());
            this.elementsTree.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
            this.elementsTree.setSorter((ViewerSorter)new ElementsTreeSorter());
            GridData gd = new GridData(4, 4, true, true);
            this.elementsTree.getTree().setLayoutData((Object)gd);
            Transfer[] transfers = new Transfer[]{ElementTransfer.getInstance()};
            this.elementsTree.addDragSupport(2, transfers, (DragSourceListener)new ElementDragListener((StructuredViewer)this.elementsTree));
            this.elementsTree.addDropSupport(2, transfers, (DropTargetListener)new ElementsTreeDropAdapter(this.elementsTree));
            this.setArchitectureComponentTypes();
            this.getSite().setSelectionProvider((ISelectionProvider)this.elementsTree);
            this.shell = this.elementsTree.getControl().getShell();
            this.createActions();
            this.createMenu();
            this.addListeners();
            this.setEnabledActions();
        }
        catch (Exception exception) {}
    }

    public void createActions() {
        this.newArchitecturalComponentTypeAction = new Action("New Architectural Component Type", Activator.getImageDescriptor("addGreen_16x16.png")){

            public void run() {
                try {
                    ArchitecturalComponentTypeDialog actd = new ArchitecturalComponentTypeDialog(ElementsView.this.owner.getShell());
                    if (actd.open() == 0) {
                        ElementsView.this.elementsTree.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.newTechnologicalRoleAction = new Action("New Technological Role", Activator.getImageDescriptor("addGreen_16x16.png")){

            public void run() {
                try {
                    TechnologicalRoleDialog trd = new TechnologicalRoleDialog(ElementsView.this.owner.getShell());
                    if (trd.open() == 0) {
                        ElementsView.this.elementsTree.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.newTechnologyProductAction = new Action("New Technology Product", Activator.getImageDescriptor("addBlue_16x16.png")){

            public void run() {
                try {
                    TechnologyProductDialog tpd;
                    IStructuredSelection sel;
                    TechnologyProduct selProduct = null;
                    if (!ElementsView.this.elementsTree.getSelection().isEmpty() && (sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement() instanceof TechnologyProduct && !((TechnologyProduct)sel.getFirstElement()).equals((Object)DomainController.getInstance().getNotClassifiedProduct())) {
                        selProduct = (TechnologyProduct)sel.getFirstElement();
                    }
                    if ((tpd = new TechnologyProductDialog(selProduct, ElementsView.this.owner.getShell())).open() == 0) {
                        ElementsView.this.elementsTree.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.newConcreteTechnologyAction = new Action("New Concrete Technology", Activator.getImageDescriptor("addGreen_16x16.png")){

            public void run() {
                try {
                    ConcreteTechnologyDialog ctd;
                    IStructuredSelection sel;
                    TechnologyProduct selProduct = null;
                    if (!ElementsView.this.elementsTree.getSelection().isEmpty() && (sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement() instanceof TechnologyProduct && !((TechnologyProduct)sel.getFirstElement()).equals((Object)DomainController.getInstance().getNotClassifiedProduct())) {
                        selProduct = (TechnologyProduct)sel.getFirstElement();
                    }
                    if ((ctd = new ConcreteTechnologyDialog(ElementsView.this.owner.getShell(), selProduct)).open() == 0) {
                        ElementsView.this.elementsTree.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.newArchitecturalStyleAction = new Action("New Architectural Style", Activator.getImageDescriptor("addBlue_16x16.png")){

            public void run() {
                try {
                    ArchitecturalStyleDialog asd;
                    IStructuredSelection sel;
                    ArchitecturalStyle selStyle = null;
                    if (!ElementsView.this.elementsTree.getSelection().isEmpty() && (sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement() instanceof ArchitecturalStyle) {
                        selStyle = (ArchitecturalStyle)sel.getFirstElement();
                    }
                    if ((asd = new ArchitecturalStyleDialog(selStyle, ElementsView.this.owner.getShell())).open() == 0) {
                        ElementsView.this.elementsTree.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.newTechnologicalStyleAction = new Action("New Technological Style", Activator.getImageDescriptor("addBlue_16x16.png")){

            public void run() {
                try {
                    TechnologicalStyleDialog tsd;
                    IStructuredSelection sel;
                    TechnologicalStyle selStyle = null;
                    if (!ElementsView.this.elementsTree.getSelection().isEmpty() && (sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement() instanceof TechnologicalStyle) {
                        selStyle = (TechnologicalStyle)sel.getFirstElement();
                    }
                    if ((tsd = new TechnologicalStyleDialog(selStyle, ElementsView.this.owner.getShell())).open() == 0) {
                        ElementsView.this.elementsTree.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.newArchitecturalUnitAction = new Action("New Architectural Unit", Activator.getImageDescriptor("addGreen_16x16.png")){

            public void run() {
                try {
                    ArchitecturalUnitDialog aud;
                    IStructuredSelection sel;
                    ArchitecturalStyle selStyle = null;
                    if (!ElementsView.this.elementsTree.getSelection().isEmpty() && (sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement() instanceof ArchitecturalStyle) {
                        selStyle = (ArchitecturalStyle)sel.getFirstElement();
                    }
                    if ((aud = new ArchitecturalUnitDialog(ElementsView.this.owner.getShell(), selStyle)).open() == 0) {
                        ElementsView.this.elementsTree.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.newTechnologicalUnitAction = new Action("New Technological Unit", Activator.getImageDescriptor("addGreen_16x16.png")){

            public void run() {
                try {
                    TechnologicalUnitDialog tud;
                    IStructuredSelection sel;
                    TechnologicalStyle selStyle = null;
                    if (!ElementsView.this.elementsTree.getSelection().isEmpty() && (sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement() instanceof TechnologicalStyle) {
                        selStyle = (TechnologicalStyle)sel.getFirstElement();
                    }
                    if ((tud = new TechnologicalUnitDialog(ElementsView.this.owner.getShell(), selStyle)).open() == 0) {
                        ElementsView.this.elementsTree.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.editElementAction = new Action("Edit Element"){

            public void run() {
                if (!ElementsView.this.elementsTree.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection();
                    Element selectedElement = (Element)sel.getFirstElement();
                    try {
                        if (selectedElement instanceof ArchitecturalComponentType) {
                            ArchitecturalComponentTypeDialog actd = new ArchitecturalComponentTypeDialog(ElementsView.this.owner.getShell(), (ArchitecturalComponentType)selectedElement);
                            actd.open();
                        } else if (selectedElement instanceof TechnologicalRole) {
                            TechnologicalRoleDialog trd = new TechnologicalRoleDialog(ElementsView.this.owner.getShell(), (TechnologicalRole)selectedElement);
                            trd.open();
                        } else if (selectedElement instanceof TechnologyProduct) {
                            TechnologyProductDialog tpd = new TechnologyProductDialog(ElementsView.this.owner.getShell(), (TechnologyProduct)selectedElement);
                            tpd.open();
                        } else if (selectedElement instanceof ConcreteTechnology) {
                            ConcreteTechnologyDialog ctd = new ConcreteTechnologyDialog(ElementsView.this.owner.getShell(), (ConcreteTechnology)selectedElement);
                            ctd.open();
                        } else if (selectedElement instanceof ArchitecturalStyle) {
                            ArchitecturalStyleDialog asd = new ArchitecturalStyleDialog(ElementsView.this.owner.getShell(), (ArchitecturalStyle)selectedElement);
                            asd.open();
                        } else if (selectedElement instanceof TechnologicalStyle) {
                            TechnologicalStyleDialog asd = new TechnologicalStyleDialog(ElementsView.this.owner.getShell(), (TechnologicalStyle)selectedElement);
                            asd.open();
                        } else if (selectedElement instanceof ArchitecturalUnit) {
                            ArchitecturalUnitDialog aud = new ArchitecturalUnitDialog(ElementsView.this.owner.getShell(), (ArchitecturalUnit)selectedElement);
                            aud.open();
                        } else if (selectedElement instanceof TechnologicalUnit) {
                            TechnologicalUnitDialog tud = new TechnologicalUnitDialog(ElementsView.this.owner.getShell(), (TechnologicalUnit)selectedElement);
                            tud.open();
                        }
                        ElementsView.this.refresh();
                    }
                    catch (DomainException e) {
                        if (e.getCause() == null) {
                            ElementsView.this.showError("Error", e.getMessage());
                        } else {
                            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                            dd.open();
                        }
                    }
                    catch (Exception e) {
                        DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                        dd.open();
                    }
                }
            }
        };
        this.deleteElementAction = new Action("Delete Element", Activator.getImageDescriptor("remove_16x16.png")){

            public void run() {
                try {
                    if (!ElementsView.this.elementsTree.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection();
                        Element selectedElement = (Element)sel.getFirstElement();
                        if (selectedElement instanceof TechnologyProduct) {
                            TechnologyProduct selectedProduct = (TechnologyProduct)selectedElement;
                            boolean del = true;
                            if (!selectedProduct.getTechnologies().isEmpty()) {
                                del = MessageDialog.openConfirm((Shell)ElementsView.this.shell, (String)"Delete Product", (String)"All the technologies inside the product will be deleted.\nDo yo want to continue?");
                            }
                            if (del) {
                                DomainController.getInstance().remove((Element)selectedProduct);
                            }
                        } else if (selectedElement instanceof ArchitecturalStyle) {
                            ArchitecturalStyle selectedStyle = (ArchitecturalStyle)selectedElement;
                            boolean del = true;
                            if (!selectedStyle.getArchitecturalUnits().isEmpty() || !selectedStyle.getChildStyles().isEmpty()) {
                                del = MessageDialog.openConfirm((Shell)ElementsView.this.shell, (String)"Delete Style", (String)"All the elements inside the style will be deleted.\nDo yo want to continue?");
                            }
                            if (del) {
                                DomainController.getInstance().remove((Element)selectedStyle);
                            }
                        } else if (selectedElement instanceof TechnologicalStyle) {
                            TechnologicalStyle selectedStyle = (TechnologicalStyle)selectedElement;
                            boolean del = true;
                            if (!selectedStyle.getTechnologicalUnits().isEmpty() || !selectedStyle.getChildStyles().isEmpty()) {
                                del = MessageDialog.openConfirm((Shell)ElementsView.this.shell, (String)"Delete Style", (String)"All the elemens inside the style will be deleted.\nDo yo want to continue?");
                            }
                            if (del) {
                                DomainController.getInstance().remove((Element)selectedStyle);
                            }
                        } else {
                            DomainController.getInstance().remove(selectedElement);
                        }
                        ElementsView.this.elementsTree.refresh();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        ElementsView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
    }

    public void createMenu() {
        this.popUpMenu = new MenuManager();
        this.popUpMenu.setRemoveAllWhenShown(true);
        this.popUpMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                switch (ElementsView.this.selIndex) {
                    case 0: {
                        mgr.add((IAction)ElementsView.this.newArchitecturalComponentTypeAction);
                        break;
                    }
                    case 1: {
                        mgr.add((IAction)ElementsView.this.newTechnologicalRoleAction);
                        break;
                    }
                    case 2: {
                        mgr.add((IAction)ElementsView.this.newTechnologyProductAction);
                        mgr.add((IAction)ElementsView.this.newConcreteTechnologyAction);
                        break;
                    }
                    case 3: {
                        mgr.add((IAction)ElementsView.this.newArchitecturalStyleAction);
                        mgr.add((IAction)ElementsView.this.newArchitecturalUnitAction);
                        break;
                    }
                    case 4: {
                        mgr.add((IAction)ElementsView.this.newTechnologicalStyleAction);
                        mgr.add((IAction)ElementsView.this.newTechnologicalUnitAction);
                    }
                }
                mgr.add((IAction)ElementsView.this.editElementAction);
                mgr.add((IAction)ElementsView.this.deleteElementAction);
            }
        });
        Menu menu = this.popUpMenu.createContextMenu(this.elementsTree.getControl());
        this.elementsTree.getControl().setMenu(menu);
        this.getSite().registerContextMenu(this.popUpMenu, (ISelectionProvider)this.elementsTree);
        this.setMenuElements();
    }

    private void setMenuElements() {
        IToolBarManager tmgr = this.getViewSite().getActionBars().getToolBarManager();
        tmgr.removeAll();
        switch (this.selIndex) {
            case 0: {
                tmgr.add((IAction)this.newArchitecturalComponentTypeAction);
                break;
            }
            case 1: {
                tmgr.add((IAction)this.newTechnologicalRoleAction);
                break;
            }
            case 2: {
                tmgr.add((IAction)this.newTechnologyProductAction);
                tmgr.add((IAction)this.newConcreteTechnologyAction);
                break;
            }
            case 4: {
                tmgr.add((IAction)this.newTechnologicalStyleAction);
                tmgr.add((IAction)this.newTechnologicalUnitAction);
                break;
            }
            case 3: {
                tmgr.add((IAction)this.newArchitecturalStyleAction);
                tmgr.add((IAction)this.newArchitecturalUnitAction);
            }
        }
        tmgr.add((IAction)this.deleteElementAction);
        tmgr.update(false);
    }

    private void addListeners() {
        this.elementsTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ElementsView.this.editElementAction.isEnabled()) {
                    ElementsView.this.editElementAction.run();
                }
            }
        });
        this.elementsTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementsView.this.setEnabledActions();
            }
        });
    }

    private void setEnabledActions() {
        try {
            boolean enabledED = true;
            boolean enabledNCT = false;
            boolean enabledNAU = false;
            boolean enabledNTU = false;
            if (!this.elementsTree.getSelection().isEmpty()) {
                IStructuredSelection sel = (IStructuredSelection)this.elementsTree.getSelection();
                if (sel.getFirstElement() instanceof TechnologyProduct) {
                    if (((TechnologyProduct)sel.getFirstElement()).equals((Object)DomainController.getInstance().getNotClassifiedProduct())) {
                        enabledED = false;
                    } else {
                        enabledNCT = true;
                    }
                } else if (sel.getFirstElement() instanceof ArchitecturalStyle) {
                    enabledNAU = true;
                } else if (sel.getFirstElement() instanceof TechnologicalStyle) {
                    enabledNTU = true;
                }
            } else {
                enabledED = false;
            }
            this.editElementAction.setEnabled(enabledED);
            this.deleteElementAction.setEnabled(enabledED);
            this.newConcreteTechnologyAction.setEnabled(enabledNCT);
            this.newArchitecturalUnitAction.setEnabled(enabledNAU);
            this.newTechnologicalUnitAction.setEnabled(enabledNTU);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void initComboEntrys() {
        this.elementSelectorCombo.add("Architecture Component Types", 0);
        this.elementSelectorCombo.add("Technological Roles", 1);
        this.elementSelectorCombo.add("Technologies", 2);
        this.elementSelectorCombo.add("Arch. Styles & Units", 3);
        this.elementSelectorCombo.add("Tech. Styles & Units", 4);
    }

    private void setArchitectureComponentTypes() {
        try {
            this.selectedElements = Model.getInstance().getArchitecturalComponentTypes();
            this.elementsTree.setInput((Object)this.selectedElements);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void setTechnologicalRoles() {
        try {
            this.selectedElements = Model.getInstance().getTechnologicalRoles();
            this.elementsTree.setInput((Object)this.selectedElements);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void setTechnologies() {
        try {
            this.selectedElements = Model.getInstance().getTechnologyProducts();
            this.selectedElements.add(DomainController.getInstance().getNotClassifiedProduct());
            this.elementsTree.setInput((Object)this.selectedElements);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void setArchitecturalStyles() {
        try {
            this.selectedElements = Model.getInstance().getArchitecturalStyles();
            this.elementsTree.setInput((Object)this.selectedElements);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void setTechnologicalStyles() {
        try {
            this.selectedElements = Model.getInstance().getTechnologicalStyles();
            this.elementsTree.setInput((Object)this.selectedElements);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    public TreeViewer getElementsTree() {
        return this.elementsTree;
    }

    public void setFocus() {
        this.elementsTree.getControl().setFocus();
        this.setArchitectureComponentTypes();
    }

    public void refresh() {
        this.elementsTree.refresh();
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }
}

