/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domain.controller;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Condition;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Constraint;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Restriction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.Decision;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decisionEffect.DecisionEffect;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalComponentType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalStyle;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalUnit;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitectureComponent;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Component;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ConcreteTechnology;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.PropertyValue;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalRole;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalStyle;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologicalUnit;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Technology;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.TechnologyProduct;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.ElementProperty;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.QualityAttribute;
import upc.gessi.architech.hibernatehelper.domain.domainModel.propertyRule.PropertyRule;
import upc.gessi.architech.hibernatehelper.domain.domainModel.propertyRule.prQuestionRestriction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.question.Question;
import upc.gessi.architech.hibernatehelper.domain.domainModel.questionRule.QuestionRule;
import upc.gessi.architech.hibernatehelper.domain.domainModel.questionRule.qrQuestionRestriction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.EnumerateType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.IntegerType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.RealType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.StringType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.persistence.HibernateController;
import upc.gessi.architech.hibernatehelper.persistence.daos.constraint.ConditionDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.constraint.ConstraintDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.constraint.RestrictionDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.decision.DecisionDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.ArchitecturalComponentTypeDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.ArchitecturalStyleDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.ArchitecturalUnitDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.ArchitectureComponentDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.ComponentDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.ConcreteTechnologyDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.ElementDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.PropertyValueDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.TechnologicalRoleDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.TechnologicalStyleDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.TechnologicalUnitDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.TechnologyDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.TechnologyProductDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.property.ElementPropertyDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.property.QualityAttributeDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.question.QuestionDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.type.DataTypeDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.type.EnumerateTypeDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.type.IntegerTypeDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.type.RealTypeDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.type.StringTypeDAO;
import upc.gessi.architech.hibernatehelper.utils.TupleCondition;
import upc.gessi.architech.hibernatehelper.utils.TuplePropertyRulesMap;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;

public class DomainController {
    private static DomainController controller = null;
    private TechnologyProduct notClassifiedProduct = null;

    private DomainController() {
    }

    public static DomainController getInstance() {
        if (controller == null) {
            controller = new DomainController();
        }
        return controller;
    }

    public void createInitialData() throws DomainException {
        this.newIntegerType("Integer", "Any Integer value", 0, false, 0, false);
        this.newIntegerType("Natural", "Any Integer value greater or equal than 0", 0, true, 0, false);
        this.newRealType("Float", "Any Real value", 0.0f, false, 0.0f, false);
        this.newRealType("Positive Float", "Any Real value greater or equal than 0", 0.0f, true, 0.0f, false);
        this.newEnumerateType("Boolean", "A Boolean value", new HashSet<String>(Arrays.asList("YES", "NO")));
        this.newEnumerateType("Quality", "A value defining the quality, from very bad to very good", new HashSet<String>(Arrays.asList("VERY BAD", "BAD", "AVERAGE", "GOOD", "VERY GOOD")));
        this.newStringType("String", "Any String value");
    }

    public HashSet<Question> getAllQuestions() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Question> qs = new QuestionDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return qs;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nQuestions cannot be retrieved!", e);
        }
    }

    public HashSet<IntegerType> getIntegerTypes() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<IntegerType> itypes = new IntegerTypeDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return itypes;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nTypes cannot be retrieved!", e);
        }
    }

    public HashSet<RealType> getRealTypes() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<RealType> rtypes = new RealTypeDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return rtypes;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nTypes cannot be retrieved!", e);
        }
    }

    public HashSet<EnumerateType> getEnumerateTypes() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<EnumerateType> etypes = new EnumerateTypeDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return etypes;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nTypes cannot be retrieved!", e);
        }
    }

    public HashSet<StringType> getStringTypes() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<StringType> stypes = new StringTypeDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return stypes;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nTypes cannot be retrieved!", e);
        }
    }

    public HashSet<QualityAttribute> getAllQualityAttributes() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<QualityAttribute> props = new QualityAttributeDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return props;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nProperties cannot be retrieved!", e);
        }
    }

    public HashSet<ElementProperty> getAllElementProperties() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<ElementProperty> props = new ElementPropertyDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return props;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nProperties cannot be retrieved!", e);
        }
    }

    public HashSet<Decision> getAllDecisions() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Decision> ds = new DecisionDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return ds;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nDecisions cannot be retrieved!", e);
        }
    }

    public HashSet<Restriction> getAllRestrictions() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Restriction> rs = new RestrictionDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return rs;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nRestrictions cannot be retrieved!", e);
        }
    }

    public HashSet<Condition> getAllConditions() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Condition> cs = new ConditionDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return cs;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nConditions cannot be retrieved!", e);
        }
    }

    public HashSet<ArchitecturalComponentType> getAllArchitecturalComponentTypes() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<ArchitecturalComponentType> acts = new ArchitecturalComponentTypeDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return acts;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Architectural Component Types cannot be retrieved!", e);
        }
    }

    public HashSet<ArchitectureComponent> getAllArchitectureComponents() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<ArchitectureComponent> acs = new ArchitectureComponentDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return acs;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Architecture Components cannot be retrieved!", e);
        }
    }

    public HashSet<TechnologicalRole> getAllTechnologicalRoles() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<TechnologicalRole> trs = new TechnologicalRoleDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return trs;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nTechnological Roles cannot be retrieved!", e);
        }
    }

    public HashSet<ConcreteTechnology> getAllConcreteTechnologies() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<ConcreteTechnology> cts = new ConcreteTechnologyDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return cts;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nConcrete Technologies cannot be retrieved!", e);
        }
    }

    public HashSet<TechnologyProduct> getAllTechnologyProducts() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<TechnologyProduct> tps = new TechnologyProductDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return tps;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nTechnology products cannot be retrieved!", e);
        }
    }

    public HashSet<ArchitecturalStyle> getAllArchitecturalStyles() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<ArchitecturalStyle> ass = new ArchitecturalStyleDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return ass;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nArchitectural Styles cannot be retrieved!", e);
        }
    }

    public HashSet<TechnologicalStyle> getAllTechnologicalStyles() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<TechnologicalStyle> tss = new TechnologicalStyleDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return tss;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nTechnological Styles cannot be retrieved!", e);
        }
    }

    public HashSet<ArchitecturalUnit> getAllArchitecturalUnits() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<ArchitecturalUnit> aus = new ArchitecturalUnitDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return aus;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nArchitectural Units cannot be retrieved!", e);
        }
    }

    public HashSet<TechnologicalUnit> getAllTechnologicalUnits() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<TechnologicalUnit> tus = new TechnologicalUnitDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return tus;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nTechnological Units cannot be retrieved!", e);
        }
    }

    public HashSet<PropertyValue> getAllPropertyValues() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<PropertyValue> pvs = new PropertyValueDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return pvs;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\nProperty Values cannot be retrieved!", e);
        }
    }

    public void remove(Question q) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            q = (Question)new QuestionDAO().getById(q.getId());
            q.remove();
            int qOrder = q.getOrder();
            HashSet<Question> auxqs = Model.getInstance().getQuestions();
            HashSet<Question> updateQ = new HashSet<Question>();
            for (Question qaux : auxqs) {
                int auxOrder = qaux.getOrder();
                if (auxOrder <= qOrder) continue;
                updateQ.add(qaux);
            }
            this.updateQuestionsOrder(updateQ, -1);
            new QuestionDAO().delete(q);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getQuestions().remove(q);
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Question cannot be removed!", e);
        }
        catch (ConcurrentModificationException e) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", e);
        }
    }

    private void removeAllChildren(QualityAttribute qAttribute) throws DomainException {
        Set<QualityAttribute> childAttributes = qAttribute.getChildAttributes();
        for (QualityAttribute qp : childAttributes) {
            this.removeAllChildren(qp);
        }
        for (QualityAttribute qp : childAttributes) {
            qp = (QualityAttribute)new QualityAttributeDAO().getById(qp.getId());
            qp.remove();
            new QualityAttributeDAO().delete(qp);
            HibernateController.commitTransaction();
            Model.getInstance().getQualityAttributes().remove(qp);
            HibernateController.beginTransaction();
        }
    }

    public void remove(ElementProperty ep) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ep = (ElementProperty)new ElementPropertyDAO().getById(ep.getId());
            ep.remove();
            new ElementPropertyDAO().delete(ep);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getElementProperties().remove(ep);
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Property cannot be removed!", e);
        }
        catch (ConcurrentModificationException e) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", e);
        }
    }

    public void remove(QualityAttribute qa) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            qa = (QualityAttribute)new QualityAttributeDAO().getById(qa.getId());
            qa.remove();
            this.removeAllChildren(qa);
            new QualityAttributeDAO().delete(qa);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HibernateController.openSession();
            HibernateController.beginTransaction();
            QualityAttribute parent = qa.getParentAttribute();
            if (parent != null) {
                new QualityAttributeDAO().lock(parent);
                Model.getInstance().getQualityAttributes().remove(parent);
                parent = (QualityAttribute)new QualityAttributeDAO().getById(parent.getId());
                Model.getInstance().getQualityAttributes().add(parent);
                parent.removeChildAttribute(qa);
                this.refreshAllParents(parent.getParentAttribute());
                new QualityAttributeDAO().update(parent);
            }
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getQualityAttributes().remove(qa);
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe attribute cannot be removed!", e);
        }
        catch (ConcurrentModificationException e) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", e);
        }
    }

    public void remove(Decision d) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            d = (Decision)new DecisionDAO().getById(d.getId());
            d.remove();
            new DecisionDAO().delete(d);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getDecisions().remove(d);
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Decision cannot be removed!", e);
        }
        catch (ConcurrentModificationException e) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", e);
        }
    }

    public void remove(DataType dt) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            dt = (DataType)new DataTypeDAO().getById(dt.getId());
            dt.remove();
            new DataTypeDAO().delete(dt);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            if (dt instanceof IntegerType) {
                Model.getInstance().getIntegerTypes().remove((IntegerType)dt);
            } else if (dt instanceof RealType) {
                Model.getInstance().getRealTypes().remove((RealType)dt);
            } else if (dt instanceof EnumerateType) {
                Model.getInstance().getEnumerateTypes().remove((EnumerateType)dt);
            } else if (dt instanceof StringType) {
                Model.getInstance().getStringTypes().remove((StringType)dt);
            }
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be removed!", e);
        }
        catch (ConcurrentModificationException e) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", e);
        }
    }

    private void removeAllChildren(TechnologyProduct tProduct) throws DomainException {
        Set<Technology> techs = tProduct.getTechnologies();
        for (Technology t : techs) {
            if (!(t = (Technology)new TechnologyDAO().getById(t.getId())).getDecisions().isEmpty()) {
                throw new DomainException("Some of the technologies can't be deleted");
            }
            if (!(t instanceof TechnologyProduct)) continue;
            this.removeAllChildren((TechnologyProduct)t);
        }
        for (Technology t : techs) {
            t = (Technology)new TechnologyDAO().getById(t.getId());
            t.remove();
            new TechnologyDAO().delete(t);
            HibernateController.commitTransaction();
            Model.getInstance().getMappingElements().get(t.getClass()).remove(t);
            HibernateController.beginTransaction();
        }
    }

    private void removeAllChildren(TechnologicalStyle techStyle) throws DomainException {
        Set<TechnologicalUnit> units = techStyle.getTechnologicalUnits();
        Set<TechnologicalStyle> childStyles = techStyle.getChildStyles();
        for (TechnologicalUnit u : units) {
            if ((u = (TechnologicalUnit)new TechnologicalUnitDAO().getById(u.getId())).getDecisions().isEmpty()) continue;
            throw new DomainException("Some of the units can't be deleted");
        }
        for (TechnologicalStyle s : childStyles) {
            if ((s = (TechnologicalStyle)new TechnologicalStyleDAO().getById(s.getId())).getDecisions().isEmpty()) continue;
            throw new DomainException("Some of the styles can't be deleted");
        }
        for (TechnologicalUnit u : units) {
            u = (TechnologicalUnit)new TechnologicalUnitDAO().getById(u.getId());
            u.remove();
            new TechnologicalUnitDAO().delete(u);
            Model.getInstance().getTechnologicalUnits().remove(u);
        }
        for (TechnologicalStyle s : childStyles) {
            this.removeAllChildren(s);
            s = (TechnologicalStyle)new TechnologicalStyleDAO().getById(s.getId());
            s.remove();
            new TechnologicalStyleDAO().delete(s);
            Model.getInstance().getTechnologicalStyles().remove(s);
        }
    }

    private void removeAllChildren(ArchitecturalStyle archStyle) throws DomainException {
        Set<ArchitecturalUnit> units = archStyle.getArchitecturalUnits();
        Set<ArchitecturalStyle> childStyles = archStyle.getChildStyles();
        for (ArchitecturalUnit u : units) {
            if ((u = (ArchitecturalUnit)new ArchitecturalUnitDAO().getById(u.getId())).getDecisions().isEmpty()) continue;
            throw new DomainException("Some of the units can't be deleted");
        }
        for (ArchitecturalStyle s : childStyles) {
            if ((s = (ArchitecturalStyle)new ArchitecturalStyleDAO().getById(s.getId())).getDecisions().isEmpty()) continue;
            throw new DomainException("Some of the styles can't be deleted");
        }
        for (ArchitecturalUnit u : units) {
            u = (ArchitecturalUnit)new ArchitecturalUnitDAO().getById(u.getId());
            u.remove();
            new ArchitecturalUnitDAO().delete(u);
            Model.getInstance().getArchitecturalUnits().remove(u);
        }
        for (ArchitecturalStyle s : childStyles) {
            this.removeAllChildren(s);
            s = (ArchitecturalStyle)new ArchitecturalStyleDAO().getById(s.getId());
            s.remove();
            new ArchitecturalStyleDAO().delete(s);
            Model.getInstance().getArchitecturalStyles().remove(s);
        }
    }

    public void remove(Element e) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            e = (Element)new ElementDAO().getById(e.getId());
            e.remove();
            if (e instanceof Technology) {
                if (e instanceof TechnologyProduct) {
                    this.removeAllChildren((TechnologyProduct)e);
                }
            } else if (e instanceof TechnologicalStyle) {
                this.removeAllChildren((TechnologicalStyle)e);
            } else if (e instanceof ArchitecturalStyle) {
                this.removeAllChildren((ArchitecturalStyle)e);
            }
            new ElementDAO().delete(e);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HibernateController.openSession();
            HibernateController.beginTransaction();
            if (e instanceof Technology) {
                Technology tech = (Technology)e;
                TechnologyProduct parent = tech.getTechnologyProduct();
                if (parent != null) {
                    new TechnologyProductDAO().lock(parent);
                    Model.getInstance().getTechnologyProducts().remove(parent);
                    parent = (TechnologyProduct)new TechnologyProductDAO().getById(parent.getId());
                    Model.getInstance().getTechnologyProducts().add(parent);
                    parent.removeTechnology(tech);
                    this.refreshAllParents(parent.getTechnologyProduct());
                    new TechnologyProductDAO().update(parent);
                } else if (e instanceof ConcreteTechnology) {
                    this.notClassifiedProduct.removeTechnology(tech);
                }
            } else if (e instanceof TechnologicalStyle) {
                TechnologicalStyle style = (TechnologicalStyle)e;
                TechnologicalStyle parent = style.getParentStyle();
                if (parent != null) {
                    new TechnologicalStyleDAO().lock(parent);
                    Model.getInstance().getTechnologicalStyles().remove(parent);
                    parent = (TechnologicalStyle)new TechnologicalStyleDAO().getById(parent.getId());
                    Model.getInstance().getTechnologicalStyles().add(parent);
                    parent.removeStyle(style);
                    this.refreshAllParents(parent.getParentStyle());
                    new TechnologicalStyleDAO().update(parent);
                }
            } else if (e instanceof ArchitecturalStyle) {
                ArchitecturalStyle style = (ArchitecturalStyle)e;
                ArchitecturalStyle parent = style.getParentStyle();
                if (parent != null) {
                    new ArchitecturalStyleDAO().lock(parent);
                    Model.getInstance().getArchitecturalStyles().remove(parent);
                    parent = (ArchitecturalStyle)new ArchitecturalStyleDAO().getById(parent.getId());
                    Model.getInstance().getArchitecturalStyles().add(parent);
                    parent.removeStyle(style);
                    this.refreshAllParents(parent.getParentStyle());
                    new ArchitecturalStyleDAO().update(parent);
                }
            } else if (e instanceof ArchitecturalUnit) {
                ArchitecturalUnit archUnit = (ArchitecturalUnit)e;
                ArchitecturalStyle as = archUnit.getArchitecturalStyle();
                new ArchitecturalStyleDAO().lock(as);
                Model.getInstance().getArchitecturalStyles().remove(as);
                as = (ArchitecturalStyle)new ArchitecturalStyleDAO().getById(as.getId());
                Model.getInstance().getArchitecturalStyles().add(as);
                as.removeUnit(archUnit);
                new ArchitecturalStyleDAO().update(as);
            } else if (e instanceof TechnologicalUnit) {
                TechnologicalUnit techUnit = (TechnologicalUnit)e;
                TechnologicalStyle ts = techUnit.getTechnologicalStyle();
                new TechnologicalStyleDAO().lock(ts);
                Model.getInstance().getTechnologicalStyles().remove(ts);
                ts = (TechnologicalStyle)new TechnologicalStyleDAO().getById(ts.getId());
                Model.getInstance().getTechnologicalStyles().add(ts);
                ts.removeUnit(techUnit);
                this.refreshAllParents(ts.getParentStyle());
                new TechnologicalStyleDAO().update(ts);
            }
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getMappingElements().get(e.getClass()).remove(e);
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Element cannot be removed!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void remove(Constraint c) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            c = (Constraint)new ConstraintDAO().getById(c.getId());
            c.remove();
            new ConstraintDAO().delete(c);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            if (c instanceof Restriction) {
                Model.getInstance().getRestrictions().remove((Restriction)c);
            } else if (c instanceof Condition) {
                Model.getInstance().getConditions().remove((Condition)c);
            }
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be removed!", e);
        }
        catch (ConcurrentModificationException e) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", e);
        }
    }

    public void newQuestion(String typeName, String qText, int qOrder, HashMap<String, HashMap<String, String>> rules) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            DataType type = this.getTypeFromName(typeName);
            new DataTypeDAO().lock(type);
            Question q = new Question();
            type.addQuestion(q);
            q.setText(qText);
            q.setOrder(qOrder);
            HashSet<Question> auxqs = Model.getInstance().getQuestions();
            HashSet<Question> updateQ = new HashSet<Question>();
            for (Question qaux : auxqs) {
                int auxOrder = qaux.getOrder();
                if (auxOrder < qOrder) continue;
                updateQ.add(qaux);
            }
            this.updateQuestionsOrder(updateQ, 1);
            this.newQuestionRules(q, rules);
            new QuestionDAO().save(q);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getQuestions().add(q);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Question cannot be created!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void newQualityAttribute(String name, String description, String parentName) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            QualityAttribute p = new QualityAttribute();
            p.setName(name);
            if (description != null) {
                p.setDescription(description);
            }
            QualityAttribute parent = null;
            if (parentName != null) {
                parent = this.getQualityAttributeFromName(parentName);
            }
            if (parent != null) {
                new QualityAttributeDAO().lock(parent);
                parent.addChildAttribute(p);
                this.refreshAllParents(parent);
            }
            new QualityAttributeDAO().save(p);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getQualityAttributes().add(p);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Attribute cannot be created!", he);
        }
    }

    public void newElementProperty(String typeName, String name, String description, HashMap<String, TuplePropertyRulesMap> rules) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ElementProperty p = new ElementProperty();
            DataType type = this.getTypeFromName(typeName);
            new DataTypeDAO().lock(type);
            p.setName(name);
            if (description != null) {
                p.setDescription(description);
            }
            type.addProperty(p);
            this.newPropertyRules(p, rules);
            new ElementPropertyDAO().save(p);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getElementProperties().add(p);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Property cannot be created!", he);
        }
    }

    public void newDecision(String name, String desc, String elementName, Map<String, String> effectsMap, Integer type) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Decision d = new Decision();
            d.setName(name);
            d.setType(type);
            if (desc != null) {
                d.setDescription(desc);
            }
            Element element = this.getElementFromName(elementName);
            new ElementDAO().lock(element);
            element.addDecision(d);
            Set<String> attributeNames = effectsMap.keySet();
            for (String attr : attributeNames) {
                String value = effectsMap.get(attr);
                if (value.equals("")) continue;
                QualityAttributeDAO dao = new QualityAttributeDAO();
                QualityAttribute aRes = (QualityAttribute)dao.getByAlternativeKey(attr);
                DecisionEffect de = new DecisionEffect();
                de.setValue(value);
                d.addDecisionEffect(de);
                aRes.addDecisionEffect(de);
                dao.update(aRes);
            }
            new DecisionDAO().save(d);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getDecisions().add(d);
            HibernateController.openSession();
            HibernateController.beginTransaction();
            element = (Element)new ElementDAO().getById(element.getId());
            System.out.println(element);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Decision cannot be created!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void newIntegerType(String name, String desc, int min, boolean hasMin, int max, boolean hasMax) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            IntegerType type = new IntegerType();
            this.setIntegerTypeValues(type, name, desc, min, hasMin, max, hasMax);
            new IntegerTypeDAO().save(type);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getIntegerTypes().add(type);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be created!", he);
        }
    }

    public void newRealType(String name, String desc, float min, boolean hasMin, float max, boolean hasMax) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            RealType type = new RealType();
            this.setRealTypeValues(type, name, desc, min, hasMin, max, hasMax);
            new RealTypeDAO().save(type);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getRealTypes().add(type);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be created!", he);
        }
    }

    public void newEnumerateType(String name, String desc, Set<String> values) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            EnumerateType type = new EnumerateType();
            type.setName(name);
            type.setDescription(desc);
            for (String value : values) {
                type.addValue(value);
            }
            new EnumerateTypeDAO().save(type);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getEnumerateTypes().add(type);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be created!", he);
        }
    }

    public void newStringType(String name, String desc) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            StringType type = new StringType();
            type.setName(name);
            type.setDescription(desc);
            new StringTypeDAO().save(type);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getStringTypes().add(type);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be created!", he);
        }
    }

    private void setIntegerTypeValues(IntegerType type, String name, String desc, int min, boolean hasMin, int max, boolean hasMax) {
        type.setName(name);
        type.setDescription(desc);
        if (hasMin) {
            type.setMin(new Integer(min));
        } else {
            type.setMin(null);
        }
        if (hasMax) {
            type.setMax(new Integer(max));
        } else {
            type.setMax(null);
        }
    }

    private void setRealTypeValues(RealType type, String name, String desc, float min, boolean hasMin, float max, boolean hasMax) {
        type.setName(name);
        type.setDescription(desc);
        if (hasMin) {
            type.setMin(new Float(min));
        } else {
            type.setMin(null);
        }
        if (hasMax) {
            type.setMax(new Float(max));
        } else {
            type.setMax(null);
        }
    }

    public void newRestriction(String name, HashSet<Decision> decision) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Restriction restriction = new Restriction();
            restriction.setName(name);
            for (Decision d : decision) {
                d = (Decision)new DecisionDAO().getById(d.getId());
                restriction.addDecision(d);
                new DecisionDAO().update(d);
            }
            new RestrictionDAO().save(restriction);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getRestrictions().add(restriction);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Restriction cannot be created!", he);
        }
    }

    public void newCondition(String name, String propertyCondition, String propertyName) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ElementProperty property = this.getElementPropertyFromName(propertyName);
            new ElementPropertyDAO().lock(property);
            Condition condition = new Condition();
            condition.setName(name);
            if (propertyCondition != null) {
                condition.setPropertyCondition(propertyCondition);
            }
            property.addCondition(condition);
            new ElementPropertyDAO().update(property);
            new ConditionDAO().save(condition);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getConditions().add(condition);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Condition cannot be created!", he);
        }
    }

    public void setElementAttributes(Element e, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap) throws DomainException {
        ElementProperty pRes;
        e.setName(name);
        e.setDescription(desc);
        Set<String> restrictionNames = restrictionsMap.keySet();
        Set<String> conditionNames = conditionsMap.keySet();
        Set<String> propertyNames = valuesMap.keySet();
        for (String rest : restrictionNames) {
            TupleRestriction restriction = restrictionsMap.get(rest);
            Restriction r = new Restriction();
            r.setName(rest);
            e.addConstraint(r);
            for (Decision d : restriction.decisions) {
                new DecisionDAO().lock(d);
                if (d == null) continue;
                r.addDecision(d);
            }
        }
        for (String cond : conditionNames) {
            TupleCondition condition = conditionsMap.get(cond);
            Condition c = new Condition();
            c.setName(cond);
            c.setPropertyCondition(condition.propertyCondition);
            e.addConstraint(c);
            pRes = (ElementProperty)new ElementPropertyDAO().getByAlternativeKey(condition.property);
            if (pRes == null) continue;
            pRes.addCondition(c);
            new ElementPropertyDAO().update(pRes);
        }
        for (String prop : propertyNames) {
            String value = valuesMap.get(prop);
            if (value.equals("")) continue;
            ElementPropertyDAO dao = new ElementPropertyDAO();
            pRes = (ElementProperty)dao.getByAlternativeKey(prop);
            PropertyValue pv = new PropertyValue();
            pv.setValue(value);
            e.addPropertyValue(pv);
            pRes.addPropertyValue(pv);
            dao.update(pRes);
        }
    }

    public void setComponentAttributes(Component comp, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<Component> composedComponents) throws DomainException {
        this.setElementAttributes(comp, name, desc, restrictionsMap, conditionsMap, valuesMap);
        for (Component c : composedComponents) {
            ComponentDAO dao = new ComponentDAO();
            c = (Component)dao.getById(c.getId());
            comp.addComposed(c);
            dao.update(c);
        }
    }

    public void newArchitecturalComponentType(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<Component> composedComponents) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ArchitecturalComponentType act = new ArchitecturalComponentType();
            this.setComponentAttributes(act, name, desc, restrictionsMap, conditionsMap, valuesMap, composedComponents);
            new ArchitecturalComponentTypeDAO().save(act);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getArchitecturalComponentTypes().add(act);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Architectural Component Type cannot be created!", he);
        }
    }

    public void newTehcnologicalRole(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<Component> composedComponents, HashSet<Technology> technologies) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            TechnologicalRole techRole = new TechnologicalRole();
            this.setComponentAttributes(techRole, name, desc, restrictionsMap, conditionsMap, valuesMap, composedComponents);
            for (Technology t : technologies) {
                TechnologyDAO dao = new TechnologyDAO();
                t = (Technology)dao.getById(t.getId());
                t.addTechnologicalRole(techRole);
                dao.update(t);
            }
            new TechnologicalRoleDAO().save(techRole);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getTechnologicalRoles().add(techRole);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Technological Role cannot be created!", he);
        }
    }

    public void setTechnologyAttributes(Technology tech, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<Component> composedComponents, HashSet<TechnologicalRole> techRoles, String techProductName, boolean isNew) throws DomainException {
        this.setComponentAttributes(tech, name, desc, restrictionsMap, conditionsMap, valuesMap, composedComponents);
        for (TechnologicalRole tr : techRoles) {
            TechnologicalRoleDAO dao = new TechnologicalRoleDAO();
            tr = (TechnologicalRole)dao.getById(tr.getId());
            tech.addTechnologicalRole(tr);
            dao.update(tr);
        }
        if (isNew) {
            TechnologyProduct parent = null;
            if (techProductName != null) {
                parent = this.getTechnologyProductFromName(techProductName);
            }
            if (parent != null) {
                new TechnologyProductDAO().lock(parent);
                parent.addTechnology(tech);
                this.refreshAllParents(parent);
            }
        }
    }

    public void newConcreteTechnology(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<Component> composedComponents, HashSet<TechnologicalRole> techRoles, String techProductName) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ConcreteTechnology tech = new ConcreteTechnology();
            this.setTechnologyAttributes(tech, name, desc, restrictionsMap, conditionsMap, valuesMap, composedComponents, techRoles, techProductName, true);
            new ConcreteTechnologyDAO().save(tech);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getConcreteTechnologies().add(tech);
            if (techProductName == null) {
                this.notClassifiedProduct.getTechnologies().add(tech);
            }
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Technology cannot be created!", he);
        }
    }

    public void newTechnologyProduct(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<Component> composedComponents, HashSet<TechnologicalRole> techRoles, String techProductName) throws DomainException {
        HashSet<TechnologyProduct> prods = Model.getInstance().getTechnologyProducts();
        System.out.println(prods);
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            TechnologyProduct tech = new TechnologyProduct();
            this.setTechnologyAttributes(tech, name, desc, restrictionsMap, conditionsMap, valuesMap, composedComponents, techRoles, techProductName, true);
            new TechnologyProductDAO().save(tech);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getTechnologyProducts().add(tech);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Technology cannot be created!", he);
        }
    }

    public void newArchitecturalStyle(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, String parentName) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ArchitecturalStyle style = new ArchitecturalStyle();
            this.setElementAttributes(style, name, desc, restrictionsMap, conditionsMap, valuesMap);
            ArchitecturalStyle parent = null;
            if (parentName != null) {
                parent = this.getArchitecturalStyleFromName(parentName);
            }
            if (parent != null) {
                new ArchitecturalStyleDAO().lock(parent);
                parent.addChildStyle(style);
                this.refreshAllParents(parent);
            }
            new ArchitecturalStyleDAO().save(style);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getArchitecturalStyles().add(style);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Style cannot be created!", he);
        }
    }

    public void newTechnologicalStyle(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, String parentName) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            TechnologicalStyle style = new TechnologicalStyle();
            this.setElementAttributes(style, name, desc, restrictionsMap, conditionsMap, valuesMap);
            TechnologicalStyle parent = null;
            if (parentName != null) {
                parent = this.getTechnologicalStyleFromName(parentName);
            }
            if (parent != null) {
                new TechnologicalStyleDAO().lock(parent);
                parent.addChildStyle(style);
                this.refreshAllParents(parent);
            }
            new TechnologicalStyleDAO().save(style);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getTechnologicalStyles().add(style);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Style cannot be created!", he);
        }
    }

    public void newArchitecturalUnit(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<ArchitecturalComponentType> types, String styleName) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ArchitecturalUnit unit = new ArchitecturalUnit();
            this.setElementAttributes(unit, name, desc, restrictionsMap, conditionsMap, valuesMap);
            for (ArchitecturalComponentType act : types) {
                ArchitecturalComponentTypeDAO dao = new ArchitecturalComponentTypeDAO();
                act = (ArchitecturalComponentType)dao.getById(act.getId());
                unit.addComponentType(act);
                dao.update(act);
            }
            ArchitecturalStyle archStyle = this.getArchitecturalStyleFromName(styleName);
            new ArchitecturalStyleDAO().lock(archStyle);
            archStyle.addUnit(unit);
            this.refreshAllParents(archStyle);
            new ArchitecturalUnitDAO().save(unit);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getArchitecturalUnits().add(unit);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Unit cannot be created!", he);
        }
    }

    public void newTechnologicalUnit(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<TechnologicalRole> roles, String styleName) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            TechnologicalUnit unit = new TechnologicalUnit();
            this.setElementAttributes(unit, name, desc, restrictionsMap, conditionsMap, valuesMap);
            for (TechnologicalRole tr : roles) {
                TechnologicalRoleDAO dao = new TechnologicalRoleDAO();
                tr = (TechnologicalRole)dao.getById(tr.getId());
                unit.addTechnologicalRole(tr);
                dao.update(tr);
            }
            TechnologicalStyle techStyle = this.getTechnologicalStyleFromName(styleName);
            new TechnologicalStyleDAO().lock(techStyle);
            techStyle.addUnit(unit);
            this.refreshAllParents(techStyle);
            new TechnologicalUnitDAO().save(unit);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Model.getInstance().getTechnologicalUnits().add(unit);
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Unit cannot be created!", he);
        }
    }

    public Question getQuestionById(Long id) throws DomainException {
        try {
            Question q2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (Question q2 : Model.getInstance().getQuestions()) {
                if (!q2.getId().equals(id)) continue;
                Model.getInstance().getQuestions().remove(q2);
                break;
            }
            q2 = (Question)new QuestionDAO().getById(id);
            Model.getInstance().getQuestions().add(q2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return q2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Question cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateQuestion(Question q, String typeName, String qText, int qOrder, HashMap<String, HashMap<String, String>> rules) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            new QuestionDAO().lock(q);
            DataType type = this.getTypeFromName(typeName);
            q.setText(qText);
            int orderChange = 0;
            int oldOrder = q.getOrder();
            HashSet<Question> updateQ = new HashSet<Question>();
            HashSet<Question> auxqs = Model.getInstance().getQuestions();
            if (oldOrder > qOrder) {
                orderChange = 1;
                for (Question qaux : auxqs) {
                    int auxOrder = qaux.getOrder();
                    if (auxOrder < qOrder || auxOrder >= oldOrder) continue;
                    updateQ.add(qaux);
                }
            } else if (oldOrder < qOrder) {
                --qOrder;
                orderChange = -1;
                for (Question qaux : auxqs) {
                    int auxOrder = qaux.getOrder();
                    if (auxOrder <= oldOrder || auxOrder > qOrder) continue;
                    updateQ.add(qaux);
                }
            }
            this.updateQuestionsOrder(updateQ, orderChange);
            q.setOrder(qOrder);
            DataType oldType = q.getQuestionType();
            if (!oldType.equals(type)) {
                new DataTypeDAO().lock(type);
                new DataTypeDAO().lock(oldType);
                oldType.removeQuestion(q);
                type.addQuestion(q);
            }
            this.removeQuestionRules(q);
            new QuestionDAO().update(q);
            HibernateController.commitTransaction();
            HibernateController.beginTransaction();
            this.newQuestionRules(q, rules);
            new QuestionDAO().update(q);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Question cannot be updated!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    private void refreshAllParents(QualityAttribute actualParent) throws DomainException {
        if (actualParent != null) {
            Model.getInstance().getQualityAttributes().remove(actualParent);
            actualParent = (QualityAttribute)new QualityAttributeDAO().getById(actualParent.getId());
            Model.getInstance().getQualityAttributes().add(actualParent);
            this.refreshAllParents(actualParent.getParentAttribute());
        }
    }

    public QualityAttribute getQualityAttributeById(Long id) throws DomainException {
        try {
            QualityAttribute p2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (QualityAttribute p2 : Model.getInstance().getQualityAttributes()) {
                if (!p2.getId().equals(id)) continue;
                Model.getInstance().getQualityAttributes().remove(p2);
                break;
            }
            p2 = (QualityAttribute)new QualityAttributeDAO().getById(id);
            Model.getInstance().getQualityAttributes().add(p2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return p2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Attribute cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateQualityAttribute(QualityAttribute qa, String name, String description) throws DomainException {
        try {
            QualityAttribute parent;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            QualityAttributeDAO dao = new QualityAttributeDAO();
            dao.lock(qa);
            qa.setName(name);
            if (description != null) {
                qa.setDescription(description);
            }
            if ((parent = qa.getParentAttribute()) != null) {
                dao.lock(parent);
            }
            if (parent != null) {
                Model.getInstance().getQualityAttributes().remove(parent);
                parent = (QualityAttribute)dao.getById(parent.getId());
                Model.getInstance().getQualityAttributes().add(parent);
                parent.removeChildAttribute(qa);
                parent.addChildAttribute(qa);
                this.refreshAllParents(parent);
            }
            dao.update(qa);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Attribute cannot be updated!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public ElementProperty getElementPropertyById(Long id) throws DomainException {
        try {
            ElementProperty p2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (ElementProperty p2 : Model.getInstance().getElementProperties()) {
                if (!p2.getId().equals(id)) continue;
                Model.getInstance().getElementProperties().remove(p2);
                break;
            }
            p2 = (ElementProperty)new ElementPropertyDAO().getById(id);
            Model.getInstance().getElementProperties().add(p2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return p2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Property cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateElementProperty(ElementProperty p, String typeName, String name, String description, HashMap<String, TuplePropertyRulesMap> rules) throws DomainException {
        try {
            DataType oldType;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            DataType type = this.getTypeFromName(typeName);
            ElementPropertyDAO dao = new ElementPropertyDAO();
            dao.lock(p);
            p.setName(name);
            if (description != null) {
                p.setDescription(description);
            }
            if (!(oldType = p.getType()).equals(type)) {
                new DataTypeDAO().lock(type);
                new DataTypeDAO().lock(oldType);
                oldType.removeProperty(p);
                type.addProperty(p);
            }
            this.removePropertyRules(p);
            dao.update(p);
            HibernateController.commitTransaction();
            HibernateController.beginTransaction();
            this.newPropertyRules(p, rules);
            dao.update(p);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Property cannot be updated!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public Decision getDecisionById(Long id) throws DomainException {
        try {
            Decision d2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (Decision d2 : Model.getInstance().getDecisions()) {
                if (!d2.getId().equals(id)) continue;
                Model.getInstance().getDecisions().remove(d2);
                break;
            }
            d2 = (Decision)new DecisionDAO().getById(id);
            Model.getInstance().getDecisions().add(d2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return d2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Decision cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateDecision(Decision d, String name, String desc, String elementName, Map<String, String> effectsMap, Integer type) throws DomainException {
        try {
            Element oldElement;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            new DecisionDAO().lock(d);
            Element element = this.getElementFromName(elementName);
            d.setName(name);
            d.setType(type);
            if (desc != null) {
                d.setDescription(desc);
            }
            if (!(oldElement = d.getElement()).equals(type)) {
                new ElementDAO().lock(element);
                new ElementDAO().lock(oldElement);
                oldElement.removeDecision(d);
                element.addDecision(d);
            }
            this.removeEffects(d);
            new DecisionDAO().update(d);
            HibernateController.commitTransaction();
            HibernateController.beginTransaction();
            Set<String> attributeNames = effectsMap.keySet();
            for (String attr : attributeNames) {
                String value = effectsMap.get(attr);
                if (value.equals("")) continue;
                QualityAttributeDAO dao = new QualityAttributeDAO();
                QualityAttribute aRes = (QualityAttribute)dao.getByAlternativeKey(attr);
                DecisionEffect de = new DecisionEffect();
                de.setValue(value);
                d.addDecisionEffect(de);
                aRes.addDecisionEffect(de);
                dao.update(aRes);
            }
            new DecisionDAO().update(d);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Decision cannot be updated!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public DataType getTypeById(Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            DataType t = (DataType)new DataTypeDAO().getById(id);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return t;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be retreived!", he);
        }
    }

    public IntegerType getIntegerTypeById(Long id) throws DomainException {
        try {
            IntegerType t2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (IntegerType t2 : Model.getInstance().getIntegerTypes()) {
                if (!t2.getId().equals(id)) continue;
                Model.getInstance().getIntegerTypes().remove(t2);
                break;
            }
            t2 = (IntegerType)new IntegerTypeDAO().getById(id);
            Model.getInstance().getIntegerTypes().add(t2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return t2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateIntegerType(IntegerType type, String name, String desc, int min, boolean hasMin, int max, boolean hasMax) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            this.setIntegerTypeValues(type, name, desc, min, hasMin, max, hasMax);
            new IntegerTypeDAO().update(type);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be updated!", he);
        }
    }

    public RealType getRealTypeById(Long id) throws DomainException {
        try {
            RealType t2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (RealType t2 : Model.getInstance().getRealTypes()) {
                if (!t2.getId().equals(id)) continue;
                Model.getInstance().getRealTypes().remove(t2);
                break;
            }
            t2 = (RealType)new RealTypeDAO().getById(id);
            Model.getInstance().getRealTypes().add(t2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return t2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateRealType(RealType type, String name, String desc, float min, boolean hasMin, float max, boolean hasMax) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            this.setRealTypeValues(type, name, desc, min, hasMin, max, hasMax);
            new RealTypeDAO().update(type);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be updated!", he);
        }
    }

    public EnumerateType getEnumerateTypeById(Long id) throws DomainException {
        try {
            EnumerateType t2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (EnumerateType t2 : Model.getInstance().getEnumerateTypes()) {
                if (!t2.getId().equals(id)) continue;
                Model.getInstance().getEnumerateTypes().remove(t2);
                break;
            }
            t2 = (EnumerateType)new EnumerateTypeDAO().getById(id);
            Model.getInstance().getEnumerateTypes().add(t2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return t2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateEnumerateType(EnumerateType type, String name, String desc, Set<String> values) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            type.setName(name);
            type.setDescription(desc);
            type.clearValues();
            for (String value : values) {
                type.addValue(value);
            }
            new EnumerateTypeDAO().update(type);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be updated!", he);
        }
    }

    public StringType getStringTypeById(Long id) throws DomainException {
        try {
            StringType t2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (StringType t2 : Model.getInstance().getStringTypes()) {
                if (!t2.getId().equals(id)) continue;
                Model.getInstance().getStringTypes().remove(t2);
                break;
            }
            t2 = (StringType)new StringTypeDAO().getById(id);
            Model.getInstance().getStringTypes().add(t2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return t2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateStringType(StringType type, String name, String desc) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            type.setName(name);
            type.setDescription(desc);
            new StringTypeDAO().update(type);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be updated!", he);
        }
    }

    public Constraint getConstraintById(Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Constraint c = (Constraint)new ConstraintDAO().getById(id);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return c;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be retreived!", he);
        }
    }

    public Restriction getRestrictionById(Long id) throws DomainException {
        try {
            Restriction r2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (Restriction r2 : Model.getInstance().getRestrictions()) {
                if (!r2.getId().equals(id)) continue;
                Model.getInstance().getRestrictions().remove(r2);
                break;
            }
            r2 = (Restriction)new RestrictionDAO().getById(id);
            Model.getInstance().getRestrictions().add(r2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return r2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateRestriction(Restriction r, String name, HashSet<Decision> decisions) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            new RestrictionDAO().lock(r);
            r.setName(name);
            r.clearDecisions();
            for (Decision d : decisions) {
                new DecisionDAO().lock(d);
                r.addDecision(d);
            }
            new RestrictionDAO().update(r);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Restriction cannot be updated!", he);
        }
    }

    public Condition getConditionById(Long id) throws DomainException {
        try {
            Condition c2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (Condition c2 : Model.getInstance().getConditions()) {
                if (!c2.getId().equals(id)) continue;
                Model.getInstance().getConditions().remove(c2);
                break;
            }
            c2 = (Condition)new ConditionDAO().getById(id);
            Model.getInstance().getConditions().add(c2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return c2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateCondition(Condition c, String name, String propertyCondition, String propertyName) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ElementProperty property = this.getElementPropertyFromName(propertyName);
            new ConditionDAO().lock(c);
            new ElementPropertyDAO().lock(property);
            c.setName(name);
            c.setPropertyCondition(propertyCondition);
            property.addCondition(c);
            new ElementPropertyDAO().update(property);
            new ConditionDAO().update(c);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Condition cannot be updated!", he);
        }
    }

    public Element getElementById(Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Element e = (Element)new ElementDAO().getById(id);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return e;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Type cannot be retreived!", he);
        }
    }

    public ArchitecturalComponentType getArchitecturalComponentTypeById(Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (ArchitecturalComponentType act : Model.getInstance().getArchitecturalComponentTypes()) {
                if (!act.getId().equals(id)) continue;
                Model.getInstance().getArchitecturalComponentTypes().remove(act);
                break;
            }
            ArchitecturalComponentTypeDAO dao = new ArchitecturalComponentTypeDAO();
            ArchitecturalComponentType act = (ArchitecturalComponentType)dao.getById(id);
            Model.getInstance().getArchitecturalComponentTypes().add(act);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return act;
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Architectural Component Type cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateArchitecturalComponentType(ArchitecturalComponentType type, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<Component> composedComponents) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ArchitecturalComponentTypeDAO dao = new ArchitecturalComponentTypeDAO();
            dao.lock(type);
            this.removeConstraints(type);
            this.removeValues(type);
            dao.update(type);
            HibernateController.commitTransaction();
            HibernateController.beginTransaction();
            Set<Component> comps = type.getComponentsComposedBy();
            for (Component c : comps) {
                new ComponentDAO().lock(c);
                c.removeComponentComponent(type);
            }
            type.clearComposedComponents();
            this.setComponentAttributes(type, name, desc, restrictionsMap, conditionsMap, valuesMap, composedComponents);
            dao.update(type);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Architectural Component Type cannot be updated!", he);
        }
    }

    public TechnologicalRole getTechnologicalRoleById(Long id) throws DomainException {
        try {
            TechnologicalRole tr2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (TechnologicalRole tr2 : Model.getInstance().getTechnologicalRoles()) {
                if (!tr2.getId().equals(id)) continue;
                Model.getInstance().getTechnologicalRoles().remove(tr2);
                break;
            }
            tr2 = (TechnologicalRole)new TechnologicalRoleDAO().getById(id);
            Model.getInstance().getTechnologicalRoles().add(tr2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return tr2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Technological Role cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateTechnologicalRole(TechnologicalRole techRole, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<Component> composedComponents, HashSet<Technology> technologies) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            TechnologicalRoleDAO dao = new TechnologicalRoleDAO();
            dao.lock(techRole);
            this.removeConstraints(techRole);
            this.removeValues(techRole);
            dao.update(techRole);
            HibernateController.commitTransaction();
            HibernateController.beginTransaction();
            Set<Component> comps = techRole.getComponentsComposedBy();
            for (Component c : comps) {
                new ComponentDAO().lock(c);
                c.removeComponentComponent(techRole);
            }
            techRole.clearComposedComponents();
            Set<Technology> roleTechnologies = techRole.getTechnologies();
            for (Technology t : roleTechnologies) {
                new TechnologyDAO().lock(t);
                t.removeTechnologicalRole(techRole);
            }
            techRole.clearTechnologies();
            for (Technology t : technologies) {
                TechnologyDAO dao2 = new TechnologyDAO();
                t = (Technology)dao2.getById(t.getId());
                t.addTechnologicalRole(techRole);
                dao2.update(t);
            }
            this.setComponentAttributes(techRole, name, desc, restrictionsMap, conditionsMap, valuesMap, composedComponents);
            dao.update(techRole);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Technological Role cannot be updated!", he);
        }
    }

    public ConcreteTechnology getConcreteTechnologyById(Long id) throws DomainException {
        try {
            ConcreteTechnology ct2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (ConcreteTechnology ct2 : Model.getInstance().getConcreteTechnologies()) {
                if (!ct2.getId().equals(id)) continue;
                Model.getInstance().getConcreteTechnologies().remove(ct2);
                break;
            }
            ct2 = (ConcreteTechnology)new ConcreteTechnologyDAO().getById(id);
            Model.getInstance().getConcreteTechnologies().add(ct2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return ct2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Technology cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    private void refreshAllParents(TechnologyProduct actualParent) throws DomainException {
        if (actualParent != null) {
            Model.getInstance().getTechnologyProducts().remove(actualParent);
            actualParent = (TechnologyProduct)new TechnologyProductDAO().getById(actualParent.getId());
            Model.getInstance().getTechnologyProducts().add(actualParent);
            this.refreshAllParents(actualParent.getTechnologyProduct());
        }
    }

    public void updateConcreteTechnology(ConcreteTechnology concreteTechnology, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<Component> composedComponents, HashSet<TechnologicalRole> techRoles, String techProductName) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ConcreteTechnologyDAO dao = new ConcreteTechnologyDAO();
            dao.lock(concreteTechnology);
            this.removeConstraints(concreteTechnology);
            this.removeValues(concreteTechnology);
            dao.update(concreteTechnology);
            HibernateController.commitTransaction();
            HibernateController.beginTransaction();
            Set<Component> comps = concreteTechnology.getComponentsComposedBy();
            for (Component c : comps) {
                new ComponentDAO().lock(c);
                c.removeComponentComponent(concreteTechnology);
            }
            concreteTechnology.clearComposedComponents();
            Set<TechnologicalRole> roles = concreteTechnology.getTechnologicalRoles();
            for (TechnologicalRole tr : roles) {
                new TechnologicalRoleDAO().lock(tr);
                tr.removeTechnology(concreteTechnology);
            }
            concreteTechnology.clearRoles();
            this.setTechnologyAttributes(concreteTechnology, name, desc, restrictionsMap, conditionsMap, valuesMap, composedComponents, techRoles, techProductName, false);
            dao.update(concreteTechnology);
            TechnologyProduct oldParent = concreteTechnology.getTechnologyProduct();
            TechnologyProduct parent = null;
            if (techProductName != null) {
                parent = this.getTechnologyProductFromName(techProductName);
            }
            if (oldParent != null || parent != null) {
                if (oldParent == null && parent != null || !oldParent.equals(parent)) {
                    if (oldParent != null) {
                        Model.getInstance().getTechnologyProducts().remove(oldParent);
                        oldParent = (TechnologyProduct)new TechnologyProductDAO().getById(oldParent.getId());
                        Model.getInstance().getTechnologyProducts().add(oldParent);
                        oldParent.removeTechnology(concreteTechnology);
                        this.refreshAllParents(oldParent.getTechnologyProduct());
                    } else {
                        this.notClassifiedProduct.removeTechnology(concreteTechnology);
                    }
                    concreteTechnology.setTechnologyProduct(parent);
                    if (parent != null) {
                        Model.getInstance().getTechnologyProducts().remove(parent);
                        parent = (TechnologyProduct)new TechnologyProductDAO().getById(parent.getId());
                        Model.getInstance().getTechnologyProducts().add(parent);
                        parent.addTechnology(concreteTechnology);
                        this.refreshAllParents(parent.getTechnologyProduct());
                    } else {
                        this.notClassifiedProduct.getTechnologies().add(concreteTechnology);
                    }
                } else if (oldParent.equals(parent)) {
                    Model.getInstance().getTechnologyProducts().remove(oldParent);
                    oldParent = (TechnologyProduct)new TechnologyProductDAO().getById(oldParent.getId());
                    Model.getInstance().getTechnologyProducts().add(oldParent);
                    oldParent.removeTechnology(concreteTechnology);
                    oldParent.addTechnology(concreteTechnology);
                    this.refreshAllParents(oldParent);
                }
            } else {
                this.notClassifiedProduct.getTechnologies().remove(concreteTechnology);
                this.notClassifiedProduct.getTechnologies().add(concreteTechnology);
            }
            dao.update(concreteTechnology);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Technology cannot be updated!", he);
        }
    }

    public TechnologyProduct getTechnologyProductById(Long id) throws DomainException {
        try {
            TechnologyProduct tp2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (TechnologyProduct tp2 : Model.getInstance().getTechnologyProducts()) {
                if (!tp2.getId().equals(id)) continue;
                Model.getInstance().getTechnologyProducts().remove(tp2);
                break;
            }
            tp2 = (TechnologyProduct)new TechnologyProductDAO().getById(id);
            Model.getInstance().getTechnologyProducts().add(tp2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return tp2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Technology cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateTechnologyProduct(TechnologyProduct technologyProduct, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<Component> composedComponents, HashSet<TechnologicalRole> techRoles, String techProductName) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            TechnologyProductDAO dao = new TechnologyProductDAO();
            dao.lock(technologyProduct);
            this.removeConstraints(technologyProduct);
            this.removeValues(technologyProduct);
            dao.update(technologyProduct);
            HibernateController.commitTransaction();
            HibernateController.beginTransaction();
            Set<Component> comps = technologyProduct.getComponentsComposedBy();
            for (Component c : comps) {
                new ComponentDAO().lock(c);
                c.removeComponentComponent(technologyProduct);
            }
            technologyProduct.clearComposedComponents();
            Set<TechnologicalRole> roles = technologyProduct.getTechnologicalRoles();
            for (TechnologicalRole tr : roles) {
                new TechnologicalRoleDAO().lock(tr);
                tr.removeTechnology(technologyProduct);
            }
            technologyProduct.clearRoles();
            this.setTechnologyAttributes(technologyProduct, name, desc, restrictionsMap, conditionsMap, valuesMap, composedComponents, techRoles, techProductName, false);
            dao.update(technologyProduct);
            TechnologyProduct oldParent = technologyProduct.getTechnologyProduct();
            if (oldParent != null) {
                dao.lock(oldParent);
            }
            TechnologyProduct parent = null;
            if (techProductName != null) {
                parent = this.getTechnologyProductFromName(techProductName);
            }
            if (oldParent != null || parent != null) {
                if (oldParent == null && parent != null || !oldParent.equals(parent)) {
                    if (oldParent != null) {
                        Model.getInstance().getTechnologyProducts().remove(oldParent);
                        oldParent = (TechnologyProduct)new TechnologyProductDAO().getById(oldParent.getId());
                        Model.getInstance().getTechnologyProducts().add(oldParent);
                        oldParent.removeTechnology(technologyProduct);
                        this.refreshAllParents(oldParent.getTechnologyProduct());
                    }
                    technologyProduct.setTechnologyProduct(parent);
                    if (parent != null) {
                        Model.getInstance().getTechnologyProducts().remove(parent);
                        parent = (TechnologyProduct)new TechnologyProductDAO().getById(parent.getId());
                        Model.getInstance().getTechnologyProducts().add(parent);
                        parent.addTechnology(technologyProduct);
                        this.refreshAllParents(parent.getTechnologyProduct());
                    }
                } else if (oldParent.equals(parent)) {
                    Model.getInstance().getTechnologyProducts().remove(oldParent);
                    oldParent = (TechnologyProduct)new TechnologyProductDAO().getById(oldParent.getId());
                    Model.getInstance().getTechnologyProducts().add(oldParent);
                    oldParent.removeTechnology(technologyProduct);
                    oldParent.addTechnology(technologyProduct);
                    this.refreshAllParents(oldParent);
                }
            }
            new TechnologyProductDAO().update(technologyProduct);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Technology cannot be updated!", he);
        }
    }

    public ArchitecturalStyle getArchitecturalStyleById(Long id) throws DomainException {
        try {
            ArchitecturalStyle as2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (ArchitecturalStyle as2 : Model.getInstance().getArchitecturalStyles()) {
                if (!as2.getId().equals(id)) continue;
                Model.getInstance().getArchitecturalStyles().remove(as2);
                break;
            }
            as2 = (ArchitecturalStyle)new ArchitecturalStyleDAO().getById(id);
            Model.getInstance().getArchitecturalStyles().add(as2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return as2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Style cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateArchitecturalStyle(ArchitecturalStyle archStyle, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ArchitecturalStyleDAO dao = new ArchitecturalStyleDAO();
            dao.lock(archStyle);
            this.removeConstraints(archStyle);
            this.removeValues(archStyle);
            dao.update(archStyle);
            HibernateController.commitTransaction();
            HibernateController.beginTransaction();
            this.setElementAttributes(archStyle, name, desc, restrictionsMap, conditionsMap, valuesMap);
            ArchitecturalStyle parent = archStyle.getParentStyle();
            if (parent != null) {
                dao.lock(parent);
            }
            if (parent != null) {
                Model.getInstance().getArchitecturalStyles().remove(parent);
                parent = (ArchitecturalStyle)dao.getById(parent.getId());
                Model.getInstance().getArchitecturalStyles().add(parent);
                parent.removeStyle(archStyle);
                parent.addChildStyle(archStyle);
                this.refreshAllParents(parent);
            }
            dao.update(archStyle);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Style cannot be updated!", he);
        }
    }

    private void refreshAllParents(ArchitecturalStyle actualParent) throws DomainException {
        if (actualParent != null) {
            Model.getInstance().getArchitecturalStyles().remove(actualParent);
            actualParent = (ArchitecturalStyle)new ArchitecturalStyleDAO().getById(actualParent.getId());
            Model.getInstance().getArchitecturalStyles().add(actualParent);
            this.refreshAllParents(actualParent.getParentStyle());
        }
    }

    public TechnologicalStyle getTechnologicalStyleById(Long id) throws DomainException {
        try {
            TechnologicalStyle ts2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (TechnologicalStyle ts2 : Model.getInstance().getTechnologicalStyles()) {
                if (!ts2.getId().equals(id)) continue;
                Model.getInstance().getTechnologicalStyles().remove(ts2);
                break;
            }
            ts2 = (TechnologicalStyle)new TechnologicalStyleDAO().getById(id);
            Model.getInstance().getTechnologicalStyles().add(ts2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return ts2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Style cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateTechnologicalStyle(TechnologicalStyle techStyle, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            TechnologicalStyleDAO dao = new TechnologicalStyleDAO();
            dao.lock(techStyle);
            this.removeConstraints(techStyle);
            this.removeValues(techStyle);
            dao.update(techStyle);
            HibernateController.commitTransaction();
            HibernateController.beginTransaction();
            this.setElementAttributes(techStyle, name, desc, restrictionsMap, conditionsMap, valuesMap);
            TechnologicalStyle parent = techStyle.getParentStyle();
            if (parent != null) {
                dao.lock(parent);
            }
            if (parent != null) {
                Model.getInstance().getTechnologicalStyles().remove(parent);
                parent = (TechnologicalStyle)new TechnologicalStyleDAO().getById(parent.getId());
                Model.getInstance().getTechnologicalStyles().add(parent);
                parent.removeStyle(techStyle);
                parent.addChildStyle(techStyle);
                this.refreshAllParents(parent);
            }
            dao.update(techStyle);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Style cannot be updated!", he);
        }
    }

    private void refreshAllParents(TechnologicalStyle actualParent) throws DomainException {
        if (actualParent != null) {
            Model.getInstance().getTechnologicalStyles().remove(actualParent);
            actualParent = (TechnologicalStyle)new TechnologicalStyleDAO().getById(actualParent.getId());
            Model.getInstance().getTechnologicalStyles().add(actualParent);
            this.refreshAllParents(actualParent.getParentStyle());
        }
    }

    public ArchitecturalUnit getArchitecturalUnitById(Long id) throws DomainException {
        try {
            ArchitecturalUnit au2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (ArchitecturalUnit au2 : Model.getInstance().getArchitecturalUnits()) {
                if (!au2.getId().equals(id)) continue;
                Model.getInstance().getArchitecturalUnits().remove(au2);
                break;
            }
            au2 = (ArchitecturalUnit)new ArchitecturalUnitDAO().getById(id);
            Model.getInstance().getArchitecturalUnits().add(au2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return au2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Unit cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateArchitecturalUnit(ArchitecturalUnit archUnit, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<ArchitecturalComponentType> types, String styleName) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ArchitecturalUnitDAO dao = new ArchitecturalUnitDAO();
            dao.lock(archUnit);
            this.removeConstraints(archUnit);
            this.removeValues(archUnit);
            dao.update(archUnit);
            HibernateController.commitTransaction();
            HibernateController.beginTransaction();
            Set<ArchitecturalComponentType> archTypes = archUnit.getArchitecturalComponentTypes();
            for (ArchitecturalComponentType act : archTypes) {
                new ArchitecturalComponentTypeDAO().lock(act);
                act.removeUnit(archUnit);
            }
            archUnit.clearTypes();
            this.setElementAttributes(archUnit, name, desc, restrictionsMap, conditionsMap, valuesMap);
            for (ArchitecturalComponentType act : types) {
                ArchitecturalComponentTypeDAO dao2 = new ArchitecturalComponentTypeDAO();
                act = (ArchitecturalComponentType)dao2.getById(act.getId());
                archUnit.addComponentType(act);
                dao2.update(act);
            }
            dao.update(archUnit);
            ArchitecturalStyle oldParent = archUnit.getArchitecturalStyle();
            ArchitecturalStyle parent = this.getArchitecturalStyleFromName(styleName);
            if (!oldParent.equals(parent)) {
                Model.getInstance().getArchitecturalStyles().remove(oldParent);
                oldParent = (ArchitecturalStyle)new ArchitecturalStyleDAO().getById(oldParent.getId());
                Model.getInstance().getArchitecturalStyles().add(oldParent);
                oldParent.removeUnit(archUnit);
                archUnit.setArchitecturalStyle(parent);
                Model.getInstance().getArchitecturalStyles().remove(parent);
                parent = (ArchitecturalStyle)new ArchitecturalStyleDAO().getById(parent.getId());
                Model.getInstance().getArchitecturalStyles().add(parent);
                parent.addUnit(archUnit);
            } else if (oldParent.equals(parent)) {
                Model.getInstance().getArchitecturalStyles().remove(oldParent);
                oldParent = (ArchitecturalStyle)new ArchitecturalStyleDAO().getById(oldParent.getId());
                Model.getInstance().getArchitecturalStyles().add(oldParent);
                oldParent.removeUnit(archUnit);
                oldParent.addUnit(archUnit);
                this.refreshAllParents(oldParent);
            }
            new ArchitecturalUnitDAO().update(archUnit);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Unit cannot be updated!", he);
        }
    }

    public TechnologicalUnit getTechnologicalUnitById(Long id) throws DomainException {
        try {
            TechnologicalUnit tu2;
            HibernateController.openSession();
            HibernateController.beginTransaction();
            for (TechnologicalUnit tu2 : Model.getInstance().getTechnologicalUnits()) {
                if (!tu2.getId().equals(id)) continue;
                Model.getInstance().getTechnologicalUnits().remove(tu2);
                break;
            }
            tu2 = (TechnologicalUnit)new TechnologicalUnitDAO().getById(id);
            Model.getInstance().getTechnologicalUnits().add(tu2);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return tu2;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Unit cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void updateTechnologicalUnit(TechnologicalUnit techUnit, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap, Map<String, String> valuesMap, HashSet<TechnologicalRole> roles, String styleName) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            TechnologicalUnitDAO dao = new TechnologicalUnitDAO();
            dao.lock(techUnit);
            this.removeConstraints(techUnit);
            this.removeValues(techUnit);
            dao.update(techUnit);
            HibernateController.commitTransaction();
            HibernateController.beginTransaction();
            Set<TechnologicalRole> techRoles = techUnit.getTechnologicalRoles();
            for (TechnologicalRole tr : techRoles) {
                new TechnologicalRoleDAO().lock(tr);
                tr.removeUnit(techUnit);
            }
            techUnit.clearRoles();
            this.setElementAttributes(techUnit, name, desc, restrictionsMap, conditionsMap, valuesMap);
            for (TechnologicalRole tr : roles) {
                TechnologicalRoleDAO dao2 = new TechnologicalRoleDAO();
                tr = (TechnologicalRole)dao2.getById(tr.getId());
                techUnit.addTechnologicalRole(tr);
                dao2.update(tr);
            }
            dao.update(techUnit);
            TechnologicalStyle oldParent = techUnit.getTechnologicalStyle();
            TechnologicalStyle parent = this.getTechnologicalStyleFromName(styleName);
            if (!oldParent.equals(parent)) {
                Model.getInstance().getTechnologicalStyles().remove(oldParent);
                oldParent = (TechnologicalStyle)new TechnologicalStyleDAO().getById(oldParent.getId());
                Model.getInstance().getTechnologicalStyles().add(oldParent);
                oldParent.removeUnit(techUnit);
                techUnit.setTechnologicalStyle(parent);
                Model.getInstance().getTechnologicalStyles().remove(parent);
                parent = (TechnologicalStyle)new TechnologicalStyleDAO().getById(parent.getId());
                Model.getInstance().getTechnologicalStyles().add(parent);
                parent.addUnit(techUnit);
            } else if (oldParent.equals(parent)) {
                Model.getInstance().getTechnologicalStyles().remove(oldParent);
                oldParent = (TechnologicalStyle)new TechnologicalStyleDAO().getById(oldParent.getId());
                Model.getInstance().getTechnologicalStyles().add(oldParent);
                oldParent.removeUnit(techUnit);
                oldParent.addUnit(techUnit);
                this.refreshAllParents(oldParent);
            }
            new TechnologicalUnitDAO().update(techUnit);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Unit cannot be updated!", he);
        }
    }

    private void newQuestionRules(Question q, HashMap<String, HashMap<String, String>> rules) {
        Set<String> ruleNames = rules.keySet();
        for (String rule : ruleNames) {
            QuestionRule qr = new QuestionRule();
            qr.setName(rule);
            q.addQuestionRule(qr);
            HashMap<String, String> restrictions = rules.get(rule);
            Set<String> restrictionTexts = restrictions.keySet();
            for (String qauxText : restrictionTexts) {
                Question qres = (Question)new QuestionDAO().getByAlternativeKey(qauxText);
                if (qres == null) continue;
                new qrQuestionRestriction(qres, qr, restrictions.get(qauxText));
            }
        }
    }

    private void newPropertyRules(ElementProperty p, HashMap<String, TuplePropertyRulesMap> rules) {
        Set<String> ruleNames = rules.keySet();
        for (String rule : ruleNames) {
            TuplePropertyRulesMap restrictions = rules.get(rule);
            PropertyRule pr = new PropertyRule();
            pr.setName(rule);
            pr.setPropertyCondition(restrictions.condition);
            p.addCondition(pr);
            Set<String> restictionTexts = restrictions.ifQuestions.keySet();
            for (String qText : restictionTexts) {
                Question qres = (Question)new QuestionDAO().getByAlternativeKey(qText);
                if (qres == null) continue;
                new prQuestionRestriction(qres, pr, restrictions.ifQuestions.get(qText));
            }
        }
    }

    private void removeQuestionRules(Question q) {
        Set<QuestionRule> qrules = q.getQuestionRules();
        for (QuestionRule qr : qrules) {
            qr.remove();
        }
        q.removeAllRules();
    }

    private void removePropertyRules(ElementProperty p) {
        Set<Condition> conditions = p.getConditions();
        for (Condition c : conditions) {
            if (!(c instanceof PropertyRule)) continue;
            ((PropertyRule)c).remove();
        }
        p.removeAllPropertyRules();
    }

    private void removeConstraints(Element e) {
        Set<Constraint> constraints = e.getConstraints();
        for (Constraint c : constraints) {
            c.remove();
        }
        e.removeAllConstraints();
    }

    private void removeValues(Element e) {
        Set<PropertyValue> values = e.getPropertyValues();
        for (PropertyValue pv : values) {
            pv.remove();
        }
        e.removeAllValues();
    }

    private void removeEffects(Decision d) {
        Set<DecisionEffect> effects = d.getDecisionEffects();
        for (DecisionEffect de : effects) {
            de.remove();
        }
        d.removeAllEffects();
    }

    public HashMap<String, HashMap<String, String>> getQuestionRulesInfo(Question q) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            new QuestionDAO().lock(q);
            HashMap<String, HashMap<String, String>> result = new HashMap<String, HashMap<String, String>>();
            for (QuestionRule qr : q.getQuestionRules()) {
                HashMap<String, String> res = new HashMap<String, String>();
                result.put(qr.getName(), res);
                for (qrQuestionRestriction qrq : qr.getQuestionRestrictions()) {
                    res.put(qrq.getQuestion().getText(), qrq.getRestriction());
                }
            }
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return result;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nRules Info cannot be retrieved!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public HashMap<String, TuplePropertyRulesMap> getPropertyRulesInfo(ElementProperty p) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            new ElementPropertyDAO().lock(p);
            HashMap<String, TuplePropertyRulesMap> result = new HashMap<String, TuplePropertyRulesMap>();
            for (Condition c : p.getConditions()) {
                if (!(c instanceof PropertyRule)) continue;
                PropertyRule pr = (PropertyRule)c;
                TuplePropertyRulesMap res = new TuplePropertyRulesMap();
                result.put(pr.getName(), res);
                res.condition = pr.getPropertyCondition();
                for (prQuestionRestriction prq : pr.getQuestionRestrictions()) {
                    res.ifQuestions.put(prq.getQuestion().getText(), prq.getRestriction());
                }
            }
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return result;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nRules Info cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void getElementConstraintsInfo(Element element, Map<String, TupleRestriction> restrictionsMap, Map<String, TupleCondition> conditionsMap) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            new ElementDAO().lock(element);
            for (Constraint c : element.getConstraints()) {
                Object res;
                if (c instanceof Restriction) {
                    Restriction restriction = (Restriction)c;
                    res = new TupleRestriction();
                    restrictionsMap.put(restriction.getName(), (TupleRestriction)res);
                    for (Decision d : restriction.getDecisions()) {
                        ((TupleRestriction)res).decisions.add(d);
                    }
                    continue;
                }
                if (!(c instanceof Condition)) continue;
                Condition condition = (Condition)c;
                res = new TupleCondition();
                conditionsMap.put(condition.getName(), (TupleCondition)res);
                ((TupleCondition)res).propertyCondition = condition.getPropertyCondition();
                ((TupleCondition)res).property = condition.getProperty().getName();
            }
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe information about the constraints cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void getElementValuesInfo(Element element, Map<String, String> values) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            new ElementDAO().lock(element);
            for (PropertyValue pv : element.getPropertyValues()) {
                values.put(pv.getProperty().getName(), pv.getValue());
            }
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe information about the values cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void getDecisionEffectsInfo(Decision decision, Map<String, String> values) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            new DecisionDAO().lock(decision);
            for (DecisionEffect de : decision.getDecisionEffects()) {
                values.put(de.getAttribute().getName(), de.getValue());
            }
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe information about the values cannot be retreived!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public Question getQuestionFromText(String text) throws DomainException {
        for (Question q : Model.getInstance().getQuestions()) {
            if (!q.getText().equals(text)) continue;
            return q;
        }
        return null;
    }

    public QualityAttribute getQualityAttributeFromName(String name) throws DomainException {
        for (QualityAttribute qp : Model.getInstance().getQualityAttributes()) {
            if (!qp.getName().equals(name)) continue;
            return qp;
        }
        return null;
    }

    public Decision getDecisionFromName(String name) throws DomainException {
        for (Decision d : Model.getInstance().getDecisions()) {
            if (!d.getName().equals(name)) continue;
            return d;
        }
        return null;
    }

    public DataType getTypeFromName(String name) throws DomainException {
        for (DataType d : Model.getInstance().getTypes()) {
            if (!d.getName().equals(name)) continue;
            return d;
        }
        return null;
    }

    public ElementProperty getElementPropertyFromName(String name) throws DomainException {
        for (ElementProperty p : Model.getInstance().getElementProperties()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public Element getElementFromName(String name) throws DomainException {
        for (Element e : Model.getInstance().getElements()) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public ArchitecturalComponentType getArchitecturalComponentTypeFromName(String name) throws DomainException {
        for (ArchitecturalComponentType act : Model.getInstance().getArchitecturalComponentTypes()) {
            if (!act.getName().equals(name)) continue;
            return act;
        }
        return null;
    }

    public ArchitecturalStyle getArchitecturalStyleFromName(String name) throws DomainException {
        for (ArchitecturalStyle as : Model.getInstance().getArchitecturalStyles()) {
            if (!as.getName().equals(name)) continue;
            return as;
        }
        return null;
    }

    public TechnologicalStyle getTechnologicalStyleFromName(String name) throws DomainException {
        for (TechnologicalStyle ts : Model.getInstance().getTechnologicalStyles()) {
            if (!ts.getName().equals(name)) continue;
            return ts;
        }
        return null;
    }

    public TechnologyProduct getTechnologyProductFromName(String name) throws DomainException {
        for (TechnologyProduct tp : Model.getInstance().getTechnologyProducts()) {
            if (!tp.getName().equals(name)) continue;
            return tp;
        }
        return null;
    }

    public boolean questionAlredyExists(String text, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Question q = (Question)new QuestionDAO().getByAlternativeKey(text);
            boolean b = q == null ? false : (isNew ? true : !q.getId().equals(id));
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return b;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\n", e);
        }
    }

    public boolean elementPropertyAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ElementProperty p = (ElementProperty)new ElementPropertyDAO().getByAlternativeKey(name);
            boolean b = p == null ? false : (isNew ? true : !p.getId().equals(id));
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return b;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\n", e);
        }
    }

    public boolean qualityAttributeAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            QualityAttribute qa = (QualityAttribute)new QualityAttributeDAO().getByAlternativeKey(name);
            boolean b = qa == null ? false : (isNew ? true : !qa.getId().equals(id));
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return b;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\n", e);
        }
    }

    public boolean decisionAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Decision d = (Decision)new DecisionDAO().getByAlternativeKey(name);
            boolean b = d == null ? false : (isNew ? true : !d.getId().equals(id));
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return b;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\n", e);
        }
    }

    public boolean elementAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Element e = (Element)new ElementDAO().getByAlternativeKey(name);
            boolean b = e == null ? false : (isNew ? true : !e.getId().equals(id));
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return b;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\n", e);
        }
    }

    public boolean typeAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            DataType d = (DataType)new DataTypeDAO().getByAlternativeKey(name);
            boolean b = d == null ? false : (isNew ? true : !d.getId().equals(id));
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return b;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\n", e);
        }
    }

    public boolean constraintAlredyExists(String newName, String oldName, Long actualElementId, boolean isNew) throws DomainException {
        try {
            HashSet<Constraint> constraints = Model.getInstance().getConstraints();
            HibernateController.openSession();
            HibernateController.beginTransaction();
            boolean b = false;
            if (isNew) {
                for (Constraint c : constraints) {
                    if (!c.getName().equals(newName)) continue;
                    b = true;
                    break;
                }
            } else {
                Element el = (Element)new ElementDAO().getById(actualElementId);
                for (Constraint c : el.getConstraints()) {
                    constraints.remove(c);
                }
                for (Constraint c : constraints) {
                    if (!c.getName().equals(newName) || c.getName().equals(oldName)) continue;
                    b = true;
                    break;
                }
            }
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            return b;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some trouble with the DataBase.\n", e);
        }
    }

    private void updateQuestionsOrder(HashSet<Question> updateQ, int orderChange) throws DomainException {
        for (Question qaux : updateQ) {
            int auxOrder = qaux.getOrder();
            Model.getInstance().getQuestions().remove(qaux);
            qaux = (Question)new QuestionDAO().getById(qaux.getId());
            Model.getInstance().getQuestions().add(qaux);
            qaux.setOrder(auxOrder + orderChange);
            new QuestionDAO().update(qaux);
        }
    }

    public void swapQuestionsOrder(Question qUp, Question qDown) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Model.getInstance().getQuestions().remove(qUp);
            qUp = (Question)new QuestionDAO().getById(qUp.getId());
            Model.getInstance().getQuestions().add(qUp);
            Model.getInstance().getQuestions().remove(qDown);
            qDown = (Question)new QuestionDAO().getById(qDown.getId());
            Model.getInstance().getQuestions().add(qDown);
            new QuestionDAO().lock(qUp);
            new QuestionDAO().lock(qDown);
            if (qUp.appearInRules(qDown)) {
                throw new DomainException("The upper question appears in some of the rules of the down one.\nCheck it and try again.");
            }
            int orderUp = qUp.getOrder();
            int orderDown = qDown.getOrder();
            qUp.setOrder(orderDown);
            qDown.setOrder(orderUp);
            new QuestionDAO().update(qUp);
            new QuestionDAO().update(qDown);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe Questions cannot swap their order!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    public void changeQualityAttributeParent(QualityAttribute qp, QualityAttribute newParent) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            QualityAttributeDAO dao = new QualityAttributeDAO();
            Model.getInstance().getQualityAttributes().remove(qp);
            qp = (QualityAttribute)dao.getById(qp.getId());
            Model.getInstance().getQualityAttributes().add(qp);
            if (newParent != null) {
                Model.getInstance().getQualityAttributes().remove(newParent);
                newParent = (QualityAttribute)dao.getById(newParent.getId());
                Model.getInstance().getQualityAttributes().add(newParent);
                dao.lock(newParent);
            }
            dao.lock(qp);
            QualityAttribute oldParent = qp.getParentAttribute();
            QualityAttribute parent = newParent;
            if (!(oldParent == null && parent == null || (oldParent != null || parent == null) && oldParent.equals(parent))) {
                if (oldParent != null) {
                    Model.getInstance().getQualityAttributes().remove(oldParent);
                    oldParent = (QualityAttribute)dao.getById(oldParent.getId());
                    Model.getInstance().getQualityAttributes().add(oldParent);
                    oldParent.removeChildAttribute(qp);
                    this.refreshAllParents(oldParent.getParentAttribute());
                }
                qp.setParentAttribute(parent);
                if (parent != null) {
                    Model.getInstance().getQualityAttributes().remove(parent);
                    parent = (QualityAttribute)dao.getById(parent.getId());
                    Model.getInstance().getQualityAttributes().add(parent);
                    parent.addChildAttribute(qp);
                    this.refreshAllParents(parent.getParentAttribute());
                }
            }
            dao.update(qp);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Technology cannot be updated!", he);
        }
    }

    public void changeConcreteTechnologyParent(ConcreteTechnology tech, TechnologyProduct newParent) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ConcreteTechnologyDAO daoConc = new ConcreteTechnologyDAO();
            TechnologyProductDAO daoTech = new TechnologyProductDAO();
            Model.getInstance().getConcreteTechnologies().remove(tech);
            tech = (ConcreteTechnology)daoConc.getById(tech.getId());
            Model.getInstance().getConcreteTechnologies().add(tech);
            if (!newParent.equals(this.notClassifiedProduct)) {
                Model.getInstance().getTechnologyProducts().remove(newParent);
                newParent = (TechnologyProduct)daoTech.getById(newParent.getId());
                Model.getInstance().getTechnologyProducts().add(newParent);
                daoTech.lock(newParent);
            }
            daoConc.lock(tech);
            TechnologyProduct oldParent = tech.getTechnologyProduct();
            TechnologyProduct parent = null;
            if (!newParent.equals(this.notClassifiedProduct)) {
                parent = newParent;
            }
            if (!(oldParent == null && parent == null || (oldParent != null || parent == null) && oldParent.equals(parent))) {
                if (oldParent != null) {
                    Model.getInstance().getTechnologyProducts().remove(oldParent);
                    oldParent = (TechnologyProduct)new TechnologyProductDAO().getById(oldParent.getId());
                    Model.getInstance().getTechnologyProducts().add(oldParent);
                    oldParent.removeTechnology(tech);
                    this.refreshAllParents(oldParent.getTechnologyProduct());
                } else {
                    this.notClassifiedProduct.removeTechnology(tech);
                }
                tech.setTechnologyProduct(parent);
                if (parent != null) {
                    Model.getInstance().getTechnologyProducts().remove(parent);
                    parent = (TechnologyProduct)new TechnologyProductDAO().getById(parent.getId());
                    Model.getInstance().getTechnologyProducts().add(parent);
                    parent.addTechnology(tech);
                    this.refreshAllParents(parent.getTechnologyProduct());
                } else {
                    this.notClassifiedProduct.getTechnologies().add(tech);
                }
            }
            daoConc.update(tech);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Technology cannot be updated!", he);
        }
    }

    public void changeTechnologyProductParent(TechnologyProduct tech, TechnologyProduct newParent) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            TechnologyProductDAO daoTech = new TechnologyProductDAO();
            Model.getInstance().getTechnologyProducts().remove(tech);
            tech = (TechnologyProduct)daoTech.getById(tech.getId());
            Model.getInstance().getTechnologyProducts().add(tech);
            if (newParent != null) {
                Model.getInstance().getTechnologyProducts().remove(newParent);
                newParent = (TechnologyProduct)daoTech.getById(newParent.getId());
                Model.getInstance().getTechnologyProducts().add(newParent);
                daoTech.lock(newParent);
            }
            daoTech.lock(tech);
            TechnologyProduct oldParent = tech.getTechnologyProduct();
            TechnologyProduct parent = newParent;
            if (!(oldParent == null && parent == null || (oldParent != null || parent == null) && oldParent.equals(parent))) {
                if (oldParent != null) {
                    Model.getInstance().getTechnologyProducts().remove(oldParent);
                    oldParent = (TechnologyProduct)new TechnologyProductDAO().getById(oldParent.getId());
                    Model.getInstance().getTechnologyProducts().add(oldParent);
                    oldParent.removeTechnology(tech);
                    this.refreshAllParents(oldParent.getTechnologyProduct());
                }
                tech.setTechnologyProduct(parent);
                if (parent != null) {
                    Model.getInstance().getTechnologyProducts().remove(parent);
                    parent = (TechnologyProduct)new TechnologyProductDAO().getById(parent.getId());
                    Model.getInstance().getTechnologyProducts().add(parent);
                    parent.addTechnology(tech);
                    this.refreshAllParents(parent.getTechnologyProduct());
                }
            }
            daoTech.update(tech);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Technology cannot be updated!", he);
        }
    }

    public void changeArchitecturalUnitParent(ArchitecturalUnit unit, ArchitecturalStyle style) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ArchitecturalUnitDAO daoUnit = new ArchitecturalUnitDAO();
            ArchitecturalStyleDAO daoStyle = new ArchitecturalStyleDAO();
            Model.getInstance().getArchitecturalUnits().remove(unit);
            unit = (ArchitecturalUnit)daoUnit.getById(unit.getId());
            Model.getInstance().getArchitecturalUnits().add(unit);
            Model.getInstance().getArchitecturalStyles().remove(style);
            style = (ArchitecturalStyle)daoStyle.getById(style.getId());
            Model.getInstance().getArchitecturalStyles().add(style);
            daoUnit.lock(unit);
            daoStyle.lock(style);
            ArchitecturalStyle oldParent = unit.getArchitecturalStyle();
            ArchitecturalStyle parent = style;
            if (!oldParent.equals(parent)) {
                Model.getInstance().getArchitecturalStyles().remove(oldParent);
                oldParent = (ArchitecturalStyle)daoStyle.getById(oldParent.getId());
                Model.getInstance().getArchitecturalStyles().add(oldParent);
                oldParent.removeUnit(unit);
                unit.setArchitecturalStyle(parent);
                Model.getInstance().getArchitecturalStyles().remove(parent);
                parent = (ArchitecturalStyle)daoStyle.getById(parent.getId());
                Model.getInstance().getArchitecturalStyles().add(parent);
                parent.addUnit(unit);
            }
            daoUnit.update(unit);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Technology cannot be updated!", he);
        }
    }

    public void changeTechnologicalUnitParent(TechnologicalUnit unit, TechnologicalStyle style) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            TechnologicalUnitDAO daoUnit = new TechnologicalUnitDAO();
            TechnologicalStyleDAO daoStyle = new TechnologicalStyleDAO();
            Model.getInstance().getTechnologicalUnits().remove(unit);
            unit = (TechnologicalUnit)daoUnit.getById(unit.getId());
            Model.getInstance().getTechnologicalUnits().add(unit);
            Model.getInstance().getTechnologicalStyles().remove(style);
            style = (TechnologicalStyle)daoStyle.getById(style.getId());
            Model.getInstance().getTechnologicalStyles().add(style);
            daoUnit.lock(unit);
            daoStyle.lock(style);
            TechnologicalStyle oldParent = unit.getTechnologicalStyle();
            TechnologicalStyle parent = style;
            if (!oldParent.equals(parent)) {
                Model.getInstance().getTechnologicalStyles().remove(oldParent);
                oldParent = (TechnologicalStyle)daoStyle.getById(oldParent.getId());
                Model.getInstance().getTechnologicalStyles().add(oldParent);
                oldParent.removeUnit(unit);
                this.refreshAllParents(oldParent.getParentStyle());
                unit.setTechnologicalStyle(parent);
                Model.getInstance().getTechnologicalStyles().remove(parent);
                parent = (TechnologicalStyle)daoStyle.getById(parent.getId());
                Model.getInstance().getTechnologicalStyles().add(parent);
                parent.addUnit(unit);
                this.refreshAllParents(parent.getParentStyle());
            }
            daoUnit.update(unit);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Technology cannot be updated!", he);
        }
    }

    public void changeTechnologicalStyleParent(TechnologicalStyle style, TechnologicalStyle newParent) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            TechnologicalStyleDAO daoStyle = new TechnologicalStyleDAO();
            Model.getInstance().getTechnologicalStyles().remove(style);
            style = (TechnologicalStyle)daoStyle.getById(style.getId());
            Model.getInstance().getTechnologicalStyles().add(style);
            if (newParent != null) {
                Model.getInstance().getTechnologicalStyles().remove(newParent);
                newParent = (TechnologicalStyle)daoStyle.getById(newParent.getId());
                Model.getInstance().getTechnologicalStyles().add(newParent);
                daoStyle.lock(newParent);
            }
            daoStyle.lock(style);
            TechnologicalStyle oldParent = style.getParentStyle();
            TechnologicalStyle parent = newParent;
            if (!(oldParent == null && parent == null || (oldParent != null || parent == null) && oldParent.equals(parent))) {
                if (oldParent != null) {
                    Model.getInstance().getTechnologicalStyles().remove(oldParent);
                    oldParent = (TechnologicalStyle)daoStyle.getById(oldParent.getId());
                    Model.getInstance().getTechnologicalStyles().add(oldParent);
                    oldParent.removeStyle(style);
                    this.refreshAllParents(oldParent.getParentStyle());
                }
                style.setParentStyle(parent);
                if (parent != null) {
                    Model.getInstance().getTechnologicalStyles().remove(parent);
                    parent = (TechnologicalStyle)daoStyle.getById(parent.getId());
                    Model.getInstance().getTechnologicalStyles().add(parent);
                    parent.addChildStyle(style);
                    this.refreshAllParents(parent.getParentStyle());
                }
            }
            daoStyle.update(style);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Technology cannot be updated!", he);
        }
    }

    public void changeArchitecturalStyleParent(ArchitecturalStyle style, ArchitecturalStyle newParent) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ArchitecturalStyleDAO daoStyle = new ArchitecturalStyleDAO();
            Model.getInstance().getArchitecturalStyles().remove(style);
            style = (ArchitecturalStyle)daoStyle.getById(style.getId());
            Model.getInstance().getArchitecturalStyles().add(style);
            if (newParent != null) {
                Model.getInstance().getArchitecturalStyles().remove(newParent);
                newParent = (ArchitecturalStyle)daoStyle.getById(newParent.getId());
                Model.getInstance().getArchitecturalStyles().add(newParent);
                daoStyle.lock(newParent);
            }
            daoStyle.lock(style);
            ArchitecturalStyle oldParent = style.getParentStyle();
            ArchitecturalStyle parent = newParent;
            if (!(oldParent == null && parent == null || (oldParent != null || parent == null) && oldParent.equals(parent))) {
                if (oldParent != null) {
                    Model.getInstance().getArchitecturalStyles().remove(oldParent);
                    oldParent = (ArchitecturalStyle)daoStyle.getById(oldParent.getId());
                    Model.getInstance().getArchitecturalStyles().add(oldParent);
                    oldParent.removeStyle(style);
                    this.refreshAllParents(oldParent.getParentStyle());
                }
                style.setParentStyle(parent);
                if (parent != null) {
                    Model.getInstance().getArchitecturalStyles().remove(parent);
                    parent = (ArchitecturalStyle)daoStyle.getById(parent.getId());
                    Model.getInstance().getArchitecturalStyles().add(parent);
                    parent.addChildStyle(style);
                    this.refreshAllParents(parent.getParentStyle());
                }
            }
            daoStyle.update(style);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some trouble with the DataBase.\nThe Technology cannot be updated!", he);
        }
    }

    public TechnologyProduct getNotClassifiedProduct() throws DomainException {
        try {
            if (this.notClassifiedProduct == null) {
                this.notClassifiedProduct = new TechnologyProduct();
                this.notClassifiedProduct.setId(new Long(-1L));
                this.notClassifiedProduct.setName("Not Classified");
                HibernateController.openSession();
                HibernateController.beginTransaction();
                HashSet<ConcreteTechnology> cTechs = Model.getInstance().getConcreteTechnologies();
                for (ConcreteTechnology ct : cTechs) {
                    if (ct.getTechnologyProduct() != null) continue;
                    this.notClassifiedProduct.getTechnologies().add(ct);
                }
                HibernateController.commitTransaction();
                HibernateController.closeSession();
            }
            return this.notClassifiedProduct;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some trouble with the DataBase.\nThe \"Not Classified\" Product cannot be initialized!", he);
        }
        catch (ConcurrentModificationException ce) {
            throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
        }
    }

    private void getChilds(HashSet<Technology> childs, Technology t) {
        childs.add(t);
        if (t instanceof TechnologyProduct) {
            Set<Technology> newChilds = ((TechnologyProduct)t).getTechnologies();
            for (Technology aux : newChilds) {
                this.getChilds(childs, aux);
            }
        }
    }

    public HashSet<TechnologyProduct> getNotChildTechnologies(Technology t) throws DomainException {
        HashSet<Technology> childs = new HashSet<Technology>();
        this.getChilds(childs, t);
        HashSet<TechnologyProduct> allProducts = Model.getInstance().getTechnologyProducts();
        HashSet<TechnologyProduct> result = new HashSet<TechnologyProduct>();
        result.addAll(allProducts);
        result.removeAll(childs);
        return result;
    }
}

