/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domain.domainModel.decision;

import java.util.HashSet;
import java.util.Set;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Restriction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decisionEffect.DecisionEffect;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;

public class Decision {
    private Long id;
    private String name;
    private String description;
    private Set<DecisionEffect> decisionEffects;
    private Set<Restriction> restrictedBy;
    private Element element;
    private Integer type;

    public Decision() {
        this.decisionEffects = new HashSet<DecisionEffect>();
        this.restrictedBy = new HashSet<Restriction>();
    }

    public Decision(String n) {
        this.name = n;
        this.decisionEffects = new HashSet<DecisionEffect>();
        this.restrictedBy = new HashSet<Restriction>();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public Set<DecisionEffect> getDecisionEffects() {
        return this.decisionEffects;
    }

    public void setDecisionEffects(Set<DecisionEffect> de) {
        this.decisionEffects = de;
    }

    public void addDecisionEffect(DecisionEffect de) {
        this.decisionEffects.add(de);
        de.setDecision(this);
    }

    public void removeDecisionEffect(DecisionEffect de) {
        this.decisionEffects.remove(de);
    }

    public void removeAllEffects() {
        this.decisionEffects.clear();
    }

    public Set<Restriction> getRestrictedBy() {
        return this.restrictedBy;
    }

    public void addRestriction(Restriction r) {
        this.restrictedBy.add(r);
    }

    public void setRestrictedBy(Set<Restriction> restrictedBy) {
        this.restrictedBy = restrictedBy;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element e) {
        this.element = e;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer t) {
        this.type = t;
    }

    public boolean equals(Object d) {
        if (!(d instanceof Decision)) {
            return false;
        }
        return this.id.equals(((Decision)d).getId());
    }

    public int hashCode() {
        return this.id == null ? System.identityHashCode(this) : this.id.hashCode();
    }

    public void remove() {
        this.element.removeDecision(this);
        for (DecisionEffect de : this.decisionEffects) {
            de.remove();
        }
        for (Restriction r : this.restrictedBy) {
            r.removeDecision(this);
        }
        this.restrictedBy.clear();
    }
}

