/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domain.domainModel.element;

import java.util.HashSet;
import java.util.Set;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Constraint;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.Decision;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.PropertyValue;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;

public abstract class Element {
    private Long id;
    private String name;
    private String description;
    private Set<Decision> decisions;
    private Set<Constraint> constraints;
    private Set<PropertyValue> propertyValues;

    public Element() {
        this.decisions = new HashSet<Decision>();
        this.constraints = new HashSet<Constraint>();
        this.propertyValues = new HashSet<PropertyValue>();
    }

    public Element(String n) {
        this.name = n;
        this.decisions = new HashSet<Decision>();
        this.constraints = new HashSet<Constraint>();
        this.propertyValues = new HashSet<PropertyValue>();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long i) {
        this.id = i;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public Set<Decision> getDecisions() {
        return this.decisions;
    }

    public void setDecisions(Set<Decision> d) {
        this.decisions = d;
    }

    public Set<Constraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Set<Constraint> constraints) {
        this.constraints = constraints;
    }

    public void addDecision(Decision d) {
        this.decisions.add(d);
        d.setElement(this);
    }

    public void removeDecision(Decision d) {
        this.decisions.remove(d);
    }

    public void addConstraint(Constraint c) {
        this.constraints.add(c);
    }

    public void removeConstraint(Constraint c) {
        this.constraints.remove(c);
    }

    public Set<PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    public void setPropertyValues(Set<PropertyValue> propertyValues) {
        this.propertyValues = propertyValues;
    }

    public void addPropertyValue(PropertyValue pv) {
        this.propertyValues.add(pv);
        pv.setElement(this);
    }

    public void removePropertyValue(PropertyValue pv) {
        this.propertyValues.remove(pv);
    }

    public void removeAllValues() {
        this.propertyValues.clear();
    }

    public boolean equals(Object e) {
        if (!(e instanceof Element)) {
            return false;
        }
        return this.id.equals(((Element)e).getId());
    }

    public int hashCode() {
        return this.id == null ? System.identityHashCode(this) : this.id.hashCode();
    }

    public void remove() throws DomainException {
        if (!this.decisions.isEmpty()) {
            throw new DomainException("This Element forms part of a Decision.\nIt can't be removed");
        }
        for (Constraint c : this.constraints) {
            c.remove();
        }
        this.constraints.clear();
        for (PropertyValue value : this.propertyValues) {
            value.remove();
        }
        this.propertyValues.clear();
        this.removeOther();
    }

    public void removeAllConstraints() {
        this.constraints.clear();
    }

    public abstract void removeOther() throws DomainException;

    public abstract String getIconPath();
}

