/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domain.domainModel.property;

import java.util.HashSet;
import java.util.Set;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decisionEffect.DecisionEffect;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;

public class QualityAttribute {
    private Long id;
    private String name;
    private String description;
    private Set<DecisionEffect> decisionEffects;
    private Set<QualityAttribute> childAttributes;
    private QualityAttribute parentAttributes;

    public QualityAttribute() {
        this.decisionEffects = new HashSet<DecisionEffect>();
        this.childAttributes = new HashSet<QualityAttribute>();
    }

    public QualityAttribute(String n, DataType t) {
        this.name = n;
        this.decisionEffects = new HashSet<DecisionEffect>();
        this.childAttributes = new HashSet<QualityAttribute>();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public Set<DecisionEffect> getDecisionEffects() {
        return this.decisionEffects;
    }

    public void setDecisionEffects(Set<DecisionEffect> de) {
        this.decisionEffects = de;
    }

    public void addDecisionEffect(DecisionEffect de) {
        this.decisionEffects.add(de);
        de.setAttribute(this);
    }

    public void removeDecisionEffect(DecisionEffect de) {
        this.decisionEffects.remove(de);
    }

    public Set<QualityAttribute> getChildAttributes() {
        return this.childAttributes;
    }

    public void setChildAttributes(Set<QualityAttribute> childAttributes) {
        this.childAttributes = childAttributes;
    }

    public void removeChildAttribute(QualityAttribute qa) {
        this.childAttributes.remove(qa);
    }

    public void addChildAttribute(QualityAttribute qa) {
        this.childAttributes.add(qa);
        qa.setParentAttribute(this);
    }

    public QualityAttribute getParentAttribute() {
        return this.parentAttributes;
    }

    public void setParentAttribute(QualityAttribute parentAttribute) {
        this.parentAttributes = parentAttribute;
    }

    public boolean equals(Object p) {
        if (!(p instanceof QualityAttribute)) {
            return false;
        }
        return this.id.equals(((QualityAttribute)p).getId());
    }

    public int hashCode() {
        return this.id == null ? System.identityHashCode(this) : this.id.hashCode();
    }

    public void remove() throws DomainException {
        for (DecisionEffect effect : this.decisionEffects) {
            effect.remove();
        }
    }
}

