/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.persistence;

import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.exception.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;

public class H2Dialect
extends Dialect {
    private String querySequenceString = "select sequence_name from information_schema.sequences";
    private static ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sqle) {
            String message;
            int idx;
            String constraintName = null;
            if (sqle.getSQLState().startsWith("23") && (idx = (message = sqle.getMessage()).indexOf("violation: ")) > 0) {
                constraintName = message.substring(idx + "violation: ".length());
            }
            return constraintName;
        }
    };

    public H2Dialect() {
        try {
            Class constants = ReflectHelper.classForName((String)"org.h2.engine.Constants");
            Integer build = (Integer)constants.getDeclaredField("BUILD_ID").get(null);
            int buildid = build;
            if (buildid < 32) {
                this.querySequenceString = "select name from information_schema.sequences";
            }
        }
        catch (Throwable throwable) {}
        this.registerColumnType(16, "boolean");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(-2, "binary");
        this.registerColumnType(-7, "boolean");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(8, "double");
        this.registerColumnType(6, "float");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-4, "longvarbinary");
        this.registerColumnType(-1, "longvarchar");
        this.registerColumnType(7, "real");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-3, "binary($l)");
        this.registerColumnType(2, "numeric");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction("acos", (Type)Hibernate.DOUBLE));
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction("asin", (Type)Hibernate.DOUBLE));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction("atan", (Type)Hibernate.DOUBLE));
        this.registerFunction("atan2", (SQLFunction)new StandardSQLFunction("atan2", (Type)Hibernate.DOUBLE));
        this.registerFunction("bitand", (SQLFunction)new StandardSQLFunction("bitand", (Type)Hibernate.INTEGER));
        this.registerFunction("bitor", (SQLFunction)new StandardSQLFunction("bitor", (Type)Hibernate.INTEGER));
        this.registerFunction("bitxor", (SQLFunction)new StandardSQLFunction("bitxor", (Type)Hibernate.INTEGER));
        this.registerFunction("ceiling", (SQLFunction)new StandardSQLFunction("ceiling", (Type)Hibernate.DOUBLE));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction("cos", (Type)Hibernate.DOUBLE));
        this.registerFunction("cot", (SQLFunction)new StandardSQLFunction("cot", (Type)Hibernate.DOUBLE));
        this.registerFunction("degrees", (SQLFunction)new StandardSQLFunction("degrees", (Type)Hibernate.DOUBLE));
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction("exp", (Type)Hibernate.DOUBLE));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction("floor", (Type)Hibernate.DOUBLE));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction("log", (Type)Hibernate.DOUBLE));
        this.registerFunction("log10", (SQLFunction)new StandardSQLFunction("log10", (Type)Hibernate.DOUBLE));
        this.registerFunction("pi", (SQLFunction)new NoArgSQLFunction("pi", (Type)Hibernate.DOUBLE));
        this.registerFunction("power", (SQLFunction)new StandardSQLFunction("power", (Type)Hibernate.DOUBLE));
        this.registerFunction("radians", (SQLFunction)new StandardSQLFunction("radians", (Type)Hibernate.DOUBLE));
        this.registerFunction("rand", (SQLFunction)new NoArgSQLFunction("rand", (Type)Hibernate.DOUBLE));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round", (Type)Hibernate.DOUBLE));
        this.registerFunction("roundmagic", (SQLFunction)new StandardSQLFunction("roundmagic", (Type)Hibernate.DOUBLE));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)Hibernate.INTEGER));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction("sin", (Type)Hibernate.DOUBLE));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction("tan", (Type)Hibernate.DOUBLE));
        this.registerFunction("truncate", (SQLFunction)new StandardSQLFunction("truncate", (Type)Hibernate.DOUBLE));
        this.registerFunction("compress", (SQLFunction)new StandardSQLFunction("compress", (Type)Hibernate.BINARY));
        this.registerFunction("expand", (SQLFunction)new StandardSQLFunction("compress", (Type)Hibernate.BINARY));
        this.registerFunction("decrypt", (SQLFunction)new StandardSQLFunction("decrypt", (Type)Hibernate.BINARY));
        this.registerFunction("encrypt", (SQLFunction)new StandardSQLFunction("encrypt", (Type)Hibernate.BINARY));
        this.registerFunction("hash", (SQLFunction)new StandardSQLFunction("hash", (Type)Hibernate.BINARY));
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction("ascii", (Type)Hibernate.INTEGER));
        this.registerFunction("char", (SQLFunction)new StandardSQLFunction("char", (Type)Hibernate.CHARACTER));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)Hibernate.STRING, "(", "||", ")"));
        this.registerFunction("difference", (SQLFunction)new StandardSQLFunction("difference", (Type)Hibernate.INTEGER));
        this.registerFunction("hextoraw", (SQLFunction)new StandardSQLFunction("hextoraw", (Type)Hibernate.STRING));
        this.registerFunction("lower", (SQLFunction)new StandardSQLFunction("lower", (Type)Hibernate.STRING));
        this.registerFunction("insert", (SQLFunction)new StandardSQLFunction("lower", (Type)Hibernate.STRING));
        this.registerFunction("left", (SQLFunction)new StandardSQLFunction("left", (Type)Hibernate.STRING));
        this.registerFunction("lcase", (SQLFunction)new StandardSQLFunction("lcase", (Type)Hibernate.STRING));
        this.registerFunction("ltrim", (SQLFunction)new StandardSQLFunction("ltrim", (Type)Hibernate.STRING));
        this.registerFunction("octet_length", (SQLFunction)new StandardSQLFunction("octet_length", (Type)Hibernate.INTEGER));
        this.registerFunction("position", (SQLFunction)new StandardSQLFunction("position", (Type)Hibernate.INTEGER));
        this.registerFunction("rawtohex", (SQLFunction)new StandardSQLFunction("rawtohex", (Type)Hibernate.STRING));
        this.registerFunction("repeat", (SQLFunction)new StandardSQLFunction("repeat", (Type)Hibernate.STRING));
        this.registerFunction("replace", (SQLFunction)new StandardSQLFunction("replace", (Type)Hibernate.STRING));
        this.registerFunction("right", (SQLFunction)new StandardSQLFunction("right", (Type)Hibernate.STRING));
        this.registerFunction("rtrim", (SQLFunction)new StandardSQLFunction("rtrim", (Type)Hibernate.STRING));
        this.registerFunction("soundex", (SQLFunction)new StandardSQLFunction("soundex", (Type)Hibernate.STRING));
        this.registerFunction("space", (SQLFunction)new StandardSQLFunction("space", (Type)Hibernate.STRING));
        this.registerFunction("stringencode", (SQLFunction)new StandardSQLFunction("stringencode", (Type)Hibernate.STRING));
        this.registerFunction("stringdecode", (SQLFunction)new StandardSQLFunction("stringdecode", (Type)Hibernate.STRING));
        this.registerFunction("ucase", (SQLFunction)new StandardSQLFunction("ucase", (Type)Hibernate.STRING));
        this.registerFunction("stringtoutf8", (SQLFunction)new StandardSQLFunction("stringtoutf8", (Type)Hibernate.BINARY));
        this.registerFunction("utf8tostring", (SQLFunction)new StandardSQLFunction("utf8tostring", (Type)Hibernate.STRING));
        this.registerFunction("current_date", (SQLFunction)new NoArgSQLFunction("current_date", (Type)Hibernate.DATE));
        this.registerFunction("current_time", (SQLFunction)new NoArgSQLFunction("current_time", (Type)Hibernate.TIME));
        this.registerFunction("current_timestamp", (SQLFunction)new NoArgSQLFunction("current_timestamp", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("datediff", (SQLFunction)new StandardSQLFunction("datediff", (Type)Hibernate.INTEGER));
        this.registerFunction("dayname", (SQLFunction)new StandardSQLFunction("dayname", (Type)Hibernate.STRING));
        this.registerFunction("dayofmonth", (SQLFunction)new StandardSQLFunction("dayofmonth", (Type)Hibernate.INTEGER));
        this.registerFunction("dayofweek", (SQLFunction)new StandardSQLFunction("dayofweek", (Type)Hibernate.INTEGER));
        this.registerFunction("dayofyear", (SQLFunction)new StandardSQLFunction("dayofyear", (Type)Hibernate.INTEGER));
        this.registerFunction("monthname", (SQLFunction)new StandardSQLFunction("monthname", (Type)Hibernate.STRING));
        this.registerFunction("quarter", (SQLFunction)new StandardSQLFunction("quarter", (Type)Hibernate.INTEGER));
        this.registerFunction("week", (SQLFunction)new StandardSQLFunction("week", (Type)Hibernate.INTEGER));
        this.registerFunction("curdate", (SQLFunction)new NoArgSQLFunction("curdate", (Type)Hibernate.DATE));
        this.registerFunction("curtime", (SQLFunction)new NoArgSQLFunction("curtime", (Type)Hibernate.TIME));
        this.registerFunction("curtimestamp", (SQLFunction)new NoArgSQLFunction("curtimestamp", (Type)Hibernate.TIME));
        this.registerFunction("now", (SQLFunction)new NoArgSQLFunction("now", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("database", (SQLFunction)new NoArgSQLFunction("database", (Type)Hibernate.STRING));
        this.registerFunction("user", (SQLFunction)new NoArgSQLFunction("user", (Type)Hibernate.STRING));
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentityColumnString() {
        return "generated by default as identity";
    }

    public String getIdentitySelectString() {
        return "call identity()";
    }

    public String getIdentityInsertString() {
        return "null";
    }

    public String getForUpdateString() {
        return " for update";
    }

    public boolean supportsUnique() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuffer(sql.length() + 20).append(sql).append(hasOffset ? " limit ? offset ?" : " limit ?").toString();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return true;
    }

    public boolean supportsPooledSequences() {
        return true;
    }

    protected String getCreateSequenceString(String sequenceName) throws MappingException {
        return "create sequence " + sequenceName;
    }

    protected String getDropSequenceString(String sequenceName) throws MappingException {
        return "drop sequence " + sequenceName;
    }

    public String getSelectSequenceNextValString(String sequenceName) {
        return "next value for " + sequenceName;
    }

    public String getSequenceNextValString(String sequenceName) {
        return "call next value for " + sequenceName;
    }

    public String getQuerySequencesString() {
        return this.querySequenceString;
    }

    public boolean supportsSequences() {
        return true;
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String getCreateTemporaryTableString() {
        return "create temporary table if not exists";
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "call current_timestamp()";
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }
}

