/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.persistence;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class HibernateController {
    public static String DATABASE_NAME = "db";
    private static Map<String, SessionFactory> sessionFactories = new HashMap<String, SessionFactory>();
    private static SessionFactory currentSessionFactory = null;

    public static void initialize(String location, String user, String pass, boolean create) {
        if (!sessionFactories.containsKey(location)) {
            HibernateController.buildSession(location, HibernateController.buildConfiguration(location, user, pass, create));
        }
        currentSessionFactory = sessionFactories.get(location);
    }

    private static Configuration buildConfiguration(String location, String user, String pass, boolean create) {
        Configuration cfg = new Configuration();
        cfg.configure("hibernate.cfg.xml");
        cfg.setProperty("hibernate.connection.url", "jdbc:h2:" + location + "/" + DATABASE_NAME);
        cfg.setProperty("hiberante.connection.username", user);
        cfg.setProperty("hibernate.connection.password", pass);
        if (create) {
            cfg.setProperty("hibernate.hbm2ddl.auto", "create");
        }
        return cfg;
    }

    private static void buildSession(String location, Configuration cfg) {
        sessionFactories.put(location, cfg.buildSessionFactory());
    }

    public static Session getSession() {
        return currentSessionFactory.getCurrentSession();
    }

    public static void openSession() {
        currentSessionFactory.openSession();
    }

    public static void closeSession() {
        Session s = HibernateController.getSession();
        if (s != null && s.isOpen()) {
            s.close();
        }
    }

    public static void beginTransaction() {
        HibernateController.getSession().beginTransaction();
    }

    public static void commitTransaction() {
        HibernateController.getSession().getTransaction().commit();
    }

    public static void rollback() {
        try {
            HibernateController.getSession().getTransaction().rollback();
        }
        catch (HibernateException e) {
            e.printStackTrace();
        }
    }
}

