/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.persistence.daos;

import java.io.Serializable;
import java.util.HashSet;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.Query;
import upc.gessi.architech.hibernatehelper.persistence.HibernateController;

public abstract class GenericDAO<E> {
    public HashSet<E> getAll() {
        String q = this.getAllQueryString();
        HashSet obs = new HashSet();
        obs.addAll(HibernateController.getSession().createQuery(q).list());
        return obs;
    }

    public void delete(E o) {
        HibernateController.getSession().delete(o);
    }

    public E getByAlternativeKey(String ak) {
        String q = this.getByAlternativeKeyQueryString();
        String var = this.getAlternativeKeyVar();
        Query query = HibernateController.getSession().createQuery(q);
        query.setString(var, ak);
        return (E)query.uniqueResult();
    }

    public E getById(Long id) {
        return (E)HibernateController.getSession().get(this.getPersistClass(), (Serializable)id);
    }

    public void save(E o) {
        HibernateController.getSession().save(o);
    }

    public void update(E o) {
        try {
            HibernateController.getSession().update(o);
        }
        catch (NonUniqueObjectException nonUniqueObjectException) {
            Object o2 = HibernateController.getSession().merge(o);
            HibernateController.getSession().update(o2);
        }
    }

    public void lock(E o) {
        try {
            HibernateController.getSession().lock(o, LockMode.NONE);
        }
        catch (NonUniqueObjectException nonUniqueObjectException) {
            Object o2 = HibernateController.getSession().merge(o);
            HibernateController.getSession().lock(o2, LockMode.NONE);
        }
    }

    public abstract String getAllQueryString();

    public abstract String getByAlternativeKeyQueryString();

    public abstract String getAlternativeKeyVar();

    public abstract Class getPersistClass();
}

