/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domain.controller;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.controller.ModelChangeListener;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Condition;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Constraint;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Restriction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.Decision;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.DecisionAction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decisionEffect.DecisionEffect;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalFramework;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalView;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Component;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Implementation;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.PropertyValue;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Style;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.StyleVariation;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.ElementProperty;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.QualityAttribute;
import upc.gessi.architech.hibernatehelper.domain.domainModel.propertyRule.PropertyRule;
import upc.gessi.architech.hibernatehelper.domain.domainModel.propertyRule.prQuestionRestriction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.question.Question;
import upc.gessi.architech.hibernatehelper.domain.domainModel.questionRule.QuestionRule;
import upc.gessi.architech.hibernatehelper.domain.domainModel.questionRule.qrQuestionRestriction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.EnumerateType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.IntegerType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.RealType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.StringType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.persistence.HibernateController;
import upc.gessi.architech.hibernatehelper.persistence.daos.constraint.ConditionDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.constraint.ConstraintDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.constraint.RestrictionDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.decision.DecisionDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.ArchitecturalFrameworkDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.ArchitecturalViewDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.ComponentDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.ElementDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.ImplementationDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.PropertyValueDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.StyleDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.element.StyleVariationDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.property.ElementPropertyDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.property.QualityAttributeDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.question.QuestionDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.type.DataTypeDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.type.EnumerateTypeDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.type.IntegerTypeDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.type.RealTypeDAO;
import upc.gessi.architech.hibernatehelper.persistence.daos.type.StringTypeDAO;
import upc.gessi.architech.hibernatehelper.utils.TuplePropertyRulesMap;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;

public class DomainController {
    private static DomainController controller = null;
    private List<ModelChangeListener> modelListeners = new LinkedList<ModelChangeListener>();

    private DomainController() {
    }

    public static DomainController getInstance() {
        if (controller == null) {
            controller = new DomainController();
        }
        return controller;
    }

    public void createInitialData() throws DomainException {
        this.newIntegerType("Integer", "Any Integer value", 0, false, 0, false);
        this.newIntegerType("Natural", "Any Integer value greater or equal than 0", 0, true, 0, false);
        this.newRealType("Float", "Any Real value", 0.0f, false, 0.0f, false);
        this.newRealType("Positive Float", "Any Real value greater or equal than 0", 0.0f, true, 0.0f, false);
        this.newEnumerateType("Boolean", "A Boolean value", new HashSet<String>(Arrays.asList("YES", "NO")));
        this.newEnumerateType("Quality", "A value defining the quality, from very bad to very good", new HashSet<String>(Arrays.asList("VERY BAD", "BAD", "AVERAGE", "GOOD", "VERY GOOD")));
        this.newStringType("String", "Any String value");
        this.newArchitecturalFramework("ArchiTech Framework");
        this.newArchitecturalView("Logical View", "ArchiTech Framework");
        this.newArchitecturalView("Deployment View", "ArchiTech Framework");
        this.newArchitecturalView("Platform View", "ArchiTech Framework");
        this.newArchitecturalView("Development View", "ArchiTech Framework");
    }

    public Set<Question> getAllQuestions() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Question> qs = new QuestionDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<Question> hashSet = qs;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<IntegerType> getIntegerTypes() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<IntegerType> itypes = new IntegerTypeDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<IntegerType> hashSet = itypes;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<RealType> getRealTypes() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<RealType> rtypes = new RealTypeDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<RealType> hashSet = rtypes;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<EnumerateType> getEnumerateTypes() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<EnumerateType> etypes = new EnumerateTypeDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<EnumerateType> hashSet = etypes;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<StringType> getStringTypes() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<StringType> stypes = new StringTypeDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<StringType> hashSet = stypes;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<QualityAttribute> getAllQualityAttributes() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<QualityAttribute> props = new QualityAttributeDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<QualityAttribute> hashSet = props;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<ElementProperty> getAllElementProperties() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<ElementProperty> props = new ElementPropertyDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<ElementProperty> hashSet = props;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<Decision> getAllDecisions() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Decision> ds = new DecisionDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<Decision> hashSet = ds;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<Restriction> getAllRestrictions() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Restriction> rs = new RestrictionDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<Restriction> hashSet = rs;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<Condition> getAllConditions() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Condition> cs = new ConditionDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<Condition> hashSet = cs;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<Component> getAllComponents() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Component> comps = new ComponentDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<Component> hashSet = comps;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<Style> getAllStyles() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Style> styles = new StyleDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<Style> hashSet = styles;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<StyleVariation> getAllStyleVariations() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<StyleVariation> svs = new StyleVariationDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<StyleVariation> hashSet = svs;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<Implementation> getAllImplementations() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<Implementation> implementations = new ImplementationDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<Implementation> hashSet = implementations;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<PropertyValue> getAllPropertyValues() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<PropertyValue> pvs = new PropertyValueDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<PropertyValue> hashSet = pvs;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Set<ArchitecturalView> getAllViews() throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            HashSet<ArchitecturalView> views = new ArchitecturalViewDAO().getAll();
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HashSet<ArchitecturalView> hashSet = views;
            return hashSet;
        }
        catch (HibernateException e) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void remove(Question q) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                HibernateController.beginTransaction();
                q = (Question)new QuestionDAO().getById(q.getId());
                HibernateController.commitTransaction();
                q.remove();
                int qOrder = q.getOrder();
                Set<Question> auxqs = Model.getInstance().getQuestions();
                HashSet<Question> updateQ = new HashSet<Question>();
                for (Question qaux : auxqs) {
                    int auxOrder = qaux.getOrder();
                    if (auxOrder <= qOrder) continue;
                    updateQ.add(qaux);
                }
                this.updateQuestionsOrder(updateQ, -1);
                HibernateController.beginTransaction();
                HibernateController.delete(q);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getQuestions().remove(q);
                this.notifyModelChange();
            }
            catch (HibernateException e) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Question cannot be removed.\n Try restarting eclipse, this should fix the problem", e);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    private void removeAllChildren(QualityAttribute qAttribute) throws DomainException {
        Set<QualityAttribute> childAttributes = qAttribute.getChildAttributes();
        for (QualityAttribute qp : childAttributes) {
            this.removeAllChildren(qp);
        }
        for (QualityAttribute qp : childAttributes) {
            qp.remove();
            HibernateController.beginTransaction();
            HibernateController.delete(qp);
            HibernateController.commitTransaction();
            Model.getInstance().getQualityAttributes().remove(qp);
        }
    }

    public void remove(ElementProperty ep) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                HibernateController.beginTransaction();
                ep = (ElementProperty)new ElementPropertyDAO().getById(ep.getId());
                HibernateController.commitTransaction();
                ep.remove();
                HibernateController.beginTransaction();
                HibernateController.delete(ep);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getElementProperties().remove(ep);
                this.notifyModelChange();
            }
            catch (HibernateException e) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Element Property cannot be removed.\n Try restarting eclipse, this should fix the problem", e);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void remove(QualityAttribute qa) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                QualityAttributeDAO qaDAO = new QualityAttributeDAO();
                HibernateController.beginTransaction();
                qa = (QualityAttribute)qaDAO.getById(qa.getId());
                HibernateController.commitTransaction();
                qa.remove();
                this.removeAllChildren(qa);
                HibernateController.beginTransaction();
                HibernateController.delete(qa);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                HibernateController.openSession();
                QualityAttribute parent = qa.getParentAttribute();
                if (parent != null) {
                    Model.getInstance().getQualityAttributes().remove(parent);
                    HibernateController.beginTransaction();
                    parent = (QualityAttribute)qaDAO.getById(parent.getId());
                    HibernateController.commitTransaction();
                    Model.getInstance().getQualityAttributes().add(parent);
                    parent.removeChildAttribute(qa);
                    this.refreshAllParents(parent.getParentAttribute());
                    HibernateController.beginTransaction();
                    HibernateController.update(parent);
                    HibernateController.commitTransaction();
                }
                HibernateController.closeSession();
                Model.getInstance().getQualityAttributes().remove(qa);
                this.notifyModelChange();
            }
            catch (HibernateException e) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Quality Attribute cannot be removed.\n Try restarting eclipse, this should fix the problem", e);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void remove(Decision d) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                HibernateController.beginTransaction();
                d = (Decision)new DecisionDAO().getById(d.getId());
                HibernateController.commitTransaction();
                d.remove();
                HibernateController.beginTransaction();
                HibernateController.delete(d);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getDecisions().remove(d);
                this.notifyModelChange();
            }
            catch (HibernateException e) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Decision cannot be removed.\n Try restarting eclipse, this should fix the problem", e);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void remove(DataType dt) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                HibernateController.beginTransaction();
                dt = (DataType)new DataTypeDAO().getById(dt.getId());
                HibernateController.commitTransaction();
                dt.remove();
                HibernateController.beginTransaction();
                HibernateController.delete(dt);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                if (dt instanceof IntegerType) {
                    Model.getInstance().getIntegerTypes().remove((IntegerType)dt);
                } else if (dt instanceof RealType) {
                    Model.getInstance().getRealTypes().remove((RealType)dt);
                } else if (dt instanceof EnumerateType) {
                    Model.getInstance().getEnumerateTypes().remove((EnumerateType)dt);
                } else if (dt instanceof StringType) {
                    Model.getInstance().getStringTypes().remove((StringType)dt);
                }
                this.notifyModelChange();
            }
            catch (HibernateException e) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Data Type cannot be removed.\n Try restarting eclipse, this should fix the problem", e);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    private void removeAllChildren(Element element, Set<Decision> emptyDecisions, Set<StyleVariation> varsToDelete) throws DomainException {
        Set<Element> children = element.getChildElements();
        for (Element child : children) {
            this.removeAllChildren(child, emptyDecisions, varsToDelete);
        }
        for (Element child : children) {
            if (child instanceof Style) {
                varsToDelete.addAll(((Style)child).getStyleVariations());
            }
            child.remove(emptyDecisions);
            HibernateController.beginTransaction();
            HibernateController.delete(child);
            HibernateController.commitTransaction();
            Model.getInstance().getMappingElements().get(child.getClass()).remove(child);
        }
    }

    public Set<StyleVariation> remove(Element e, Set<Decision> emptyDecisions) throws DomainException {
        try {
            HibernateController.openSession();
            ElementDAO eDAO = new ElementDAO();
            HashSet<StyleVariation> varsToDelete = new HashSet<StyleVariation>();
            HibernateController.beginTransaction();
            e = (Element)eDAO.getById(e.getId());
            HibernateController.commitTransaction();
            this.removeAllChildren(e, emptyDecisions, varsToDelete);
            if (e instanceof Style) {
                varsToDelete.addAll(((Style)e).getStyleVariations());
            }
            e.remove(emptyDecisions);
            HibernateController.beginTransaction();
            HibernateController.delete(e);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            HibernateController.openSession();
            Element parent = e.getParentElement();
            if (parent != null) {
                Model.getInstance().getMappingElements().get(parent.getClass()).remove(parent);
                HibernateController.beginTransaction();
                parent = (Element)eDAO.getById(parent.getId());
                HibernateController.commitTransaction();
                Model.getInstance().getMappingElements().get(parent.getClass()).add(parent);
                parent.removeChildElement(e);
                this.refreshAllParents(parent.getParentElement());
                HibernateController.beginTransaction();
                HibernateController.update(parent);
                HibernateController.commitTransaction();
            }
            HibernateController.closeSession();
            Model.getInstance().getMappingElements().get(e.getClass()).remove(e);
            HashSet<StyleVariation> hashSet = varsToDelete;
            return hashSet;
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence and the Element cannot be removed.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void remove(Constraint c) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                HibernateController.beginTransaction();
                c = (Constraint)new ConstraintDAO().getById(c.getId());
                HibernateController.commitTransaction();
                c.remove();
                HibernateController.beginTransaction();
                HibernateController.delete(c);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                if (c instanceof Restriction) {
                    Model.getInstance().getRestrictions().remove((Restriction)c);
                } else if (c instanceof Condition) {
                    Model.getInstance().getConditions().remove((Condition)c);
                }
                this.notifyModelChange();
            }
            catch (HibernateException e) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Constraint cannot be removed.\n Try restarting eclipse, this should fix the problem", e);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void newQuestion(DataType type, String qText, int qOrder, Map<String, Map<Question, String>> rules) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                Question q = new Question();
                type.addQuestion(q);
                q.setText(qText);
                q.setOrder(qOrder);
                Set<Question> auxqs = Model.getInstance().getQuestions();
                HashSet<Question> updateQ = new HashSet<Question>();
                for (Question qaux : auxqs) {
                    int auxOrder = qaux.getOrder();
                    if (auxOrder < qOrder) continue;
                    updateQ.add(qaux);
                }
                this.updateQuestionsOrder(updateQ, 1);
                this.newQuestionRules(q, rules);
                HibernateController.beginTransaction();
                HibernateController.save(q);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getQuestions().add(q);
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Question cannot be created.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void newQualityAttribute(String name, String description, QualityAttribute parent) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                QualityAttribute p = new QualityAttribute();
                p.setName(name);
                if (description != null) {
                    p.setDescription(description);
                }
                HibernateController.beginTransaction();
                HibernateController.save(p);
                HibernateController.commitTransaction();
                if (parent != null) {
                    parent.addChildAttribute(p);
                    this.refreshAllParents(parent);
                }
                HibernateController.beginTransaction();
                HibernateController.update(p);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getQualityAttributes().add(p);
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Quality Attribute cannot be created.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void newElementProperty(DataType type, String name, String description, Map<String, TuplePropertyRulesMap> rules) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                ElementProperty p = new ElementProperty();
                p.setName(name);
                if (description != null) {
                    p.setDescription(description);
                }
                type.addProperty(p);
                this.newPropertyRules(p, rules);
                HibernateController.beginTransaction();
                HibernateController.save(p);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getElementProperties().add(p);
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Element Property cannot be created.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void newDecision(String name, String desc, Map<QualityAttribute, Integer> effectsMap, Map<Element, Integer> actionsMap) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                Decision d = new Decision();
                d.setName(name);
                if (desc != null) {
                    d.setDescription(desc);
                }
                HibernateController.beginTransaction();
                HibernateController.save(d);
                HibernateController.commitTransaction();
                Set<QualityAttribute> attributes = effectsMap.keySet();
                for (QualityAttribute attr : attributes) {
                    Integer value = effectsMap.get(attr);
                    if (value == null) continue;
                    DecisionEffect de = new DecisionEffect();
                    de.setValue(value);
                    d.addDecisionEffect(de);
                    attr.addDecisionEffect(de);
                    HibernateController.beginTransaction();
                    HibernateController.update(attr);
                    HibernateController.commitTransaction();
                }
                Set<Element> elements = actionsMap.keySet();
                for (Element element : elements) {
                    Integer val = actionsMap.get(element);
                    if (val == null) continue;
                    DecisionAction da = new DecisionAction();
                    da.setAction(val);
                    d.addAction(da);
                    element.addDecisionAction(da);
                    HibernateController.beginTransaction();
                    HibernateController.update(element);
                    HibernateController.commitTransaction();
                }
                HibernateController.beginTransaction();
                HibernateController.update(d);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getDecisions().add(d);
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Decision cannot be created.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void newIntegerType(String name, String desc, int min, boolean hasMin, int max, boolean hasMax) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                IntegerType type = new IntegerType();
                this.setIntegerTypeValues(type, name, desc, min, hasMin, max, hasMax);
                HibernateController.beginTransaction();
                HibernateController.save(type);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getIntegerTypes().add(type);
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Data Type cannot be created.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void newRealType(String name, String desc, float min, boolean hasMin, float max, boolean hasMax) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                RealType type = new RealType();
                this.setRealTypeValues(type, name, desc, min, hasMin, max, hasMax);
                HibernateController.beginTransaction();
                HibernateController.save(type);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getRealTypes().add(type);
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Data Type cannot be created.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void newEnumerateType(String name, String desc, Set<String> values) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                EnumerateType type = new EnumerateType();
                type.setName(name);
                type.setDescription(desc);
                for (String value : values) {
                    type.addValue(value);
                }
                HibernateController.beginTransaction();
                HibernateController.save(type);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getEnumerateTypes().add(type);
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Data Type cannot be created.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void newStringType(String name, String desc) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                StringType type = new StringType();
                type.setName(name);
                type.setDescription(desc);
                HibernateController.beginTransaction();
                HibernateController.save(type);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getStringTypes().add(type);
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Data Type cannot be created.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    private void setIntegerTypeValues(IntegerType type, String name, String desc, int min, boolean hasMin, int max, boolean hasMax) {
        type.setName(name);
        type.setDescription(desc);
        if (hasMin) {
            type.setMin(new Integer(min));
        } else {
            type.setMin(null);
        }
        if (hasMax) {
            type.setMax(new Integer(max));
        } else {
            type.setMax(null);
        }
    }

    private void setRealTypeValues(RealType type, String name, String desc, float min, boolean hasMin, float max, boolean hasMax) {
        type.setName(name);
        type.setDescription(desc);
        if (hasMin) {
            type.setMin(new Float(min));
        } else {
            type.setMin(null);
        }
        if (hasMax) {
            type.setMax(new Float(max));
        } else {
            type.setMax(null);
        }
    }

    public void setElementAttributes(Element e, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<ElementProperty, String> valuesMap, Set<Element> relatedElements, Element parent, ArchitecturalView view) throws DomainException {
        e.setName(name);
        if (desc != null) {
            e.setDescription(desc);
        }
        view.addElement(e);
        HibernateController.beginTransaction();
        HibernateController.save(e);
        HibernateController.commitTransaction();
        Set<String> restrictionNames = restrictionsMap.keySet();
        Set<ElementProperty> properties = valuesMap.keySet();
        for (String rest : restrictionNames) {
            TupleRestriction restriction = restrictionsMap.get(rest);
            Restriction r = new Restriction();
            r.setName(rest);
            e.addRestriction(r);
            for (Decision d : restriction.decisions) {
                if (d == null) continue;
                r.addDecision(d);
            }
        }
        for (ElementProperty prop : properties) {
            String value = valuesMap.get(prop);
            if (value.equals("")) continue;
            PropertyValue pv = new PropertyValue();
            pv.setValue(value);
            e.addPropertyValue(pv);
            prop.addPropertyValue(pv);
        }
        for (Element el : relatedElements) {
            e.addRelatedElement(el);
        }
        if (parent != null) {
            parent.addChildElement(e);
            this.refreshAllParents(parent);
        }
    }

    public void newComponent(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<ElementProperty, String> valuesMap, Set<Element> relatedElements, Element parent, ArchitecturalView view, Set<Component> composableWith, Set<Component> connectableWith, Set<StyleVariation> applyTo, Set<Implementation> implementableWith, Set<Style> applyToStyles, boolean selfComposable, boolean selfConnectable) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                Component comp = new Component();
                this.setElementAttributes(comp, name, desc, restrictionsMap, valuesMap, relatedElements, parent, view);
                for (Component c : composableWith) {
                    comp.addComposableWith(c);
                }
                if (selfComposable) {
                    comp.addComposableWith(comp);
                }
                for (Component c : connectableWith) {
                    comp.addConnectedTo(c);
                }
                if (selfConnectable) {
                    comp.addConnectedTo(comp);
                }
                for (StyleVariation sv : applyTo) {
                    comp.addStyleVariation(sv);
                }
                for (Style s : applyToStyles) {
                    comp.addStyle(s);
                }
                for (Implementation impl : implementableWith) {
                    comp.addImplementation(impl);
                }
                HibernateController.beginTransaction();
                HibernateController.update(comp);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getComponents().add(comp);
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Component cannot be created.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void newStyle(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<ElementProperty, String> valuesMap, Set<Element> relatedElements, Element parent, ArchitecturalView view) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                Style style = new Style();
                this.setElementAttributes(style, name, desc, restrictionsMap, valuesMap, relatedElements, parent, view);
                HibernateController.beginTransaction();
                HibernateController.update(style);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getStyles().add(style);
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Style cannot be created.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void newStyleVariation(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<ElementProperty, String> valuesMap, Set<Element> relatedElements, Element parent, ArchitecturalView view, Style style, Set<StyleVariation> incompatibleVariations) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                StyleVariation styleVariation = new StyleVariation();
                style.addStyleVariation(styleVariation);
                this.setElementAttributes(styleVariation, name, desc, restrictionsMap, valuesMap, relatedElements, parent, view);
                StyleVariationDAO dao = new StyleVariationDAO();
                for (StyleVariation sv : incompatibleVariations) {
                    sv = (StyleVariation)dao.getById(sv.getId());
                    styleVariation.addIncompatibleWith(sv);
                    sv.addIncompatibleWith(styleVariation);
                    HibernateController.beginTransaction();
                    HibernateController.update(sv);
                    HibernateController.commitTransaction();
                }
                HibernateController.beginTransaction();
                HibernateController.update(styleVariation);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getStyleVariations().add(styleVariation);
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Style Variation cannot be created.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void newImplementation(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<ElementProperty, String> valuesMap, Set<Element> relatedElements, Element parent, ArchitecturalView view, Set<Component> components) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                Implementation impl = new Implementation();
                this.setElementAttributes(impl, name, desc, restrictionsMap, valuesMap, relatedElements, parent, view);
                ComponentDAO dao = new ComponentDAO();
                for (Component c : components) {
                    c = (Component)dao.getById(c.getId());
                    c.addImplementation(impl);
                    HibernateController.beginTransaction();
                    HibernateController.update(c);
                    HibernateController.commitTransaction();
                }
                HibernateController.beginTransaction();
                HibernateController.update(impl);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getImplementations().add(impl);
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Implementation cannot be created.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void newArchitecturalFramework(String name) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                ArchitecturalFramework framework = new ArchitecturalFramework();
                framework.setName(name);
                HibernateController.beginTransaction();
                HibernateController.save(framework);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Architectural Framework cannot be created.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void newArchitecturalView(String name, String frameworkName) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                ArchitecturalView view = new ArchitecturalView();
                view.setName(name);
                ArchitecturalFramework framework = this.getArchitecturalFrameworkFromName(frameworkName);
                framework.addView(view);
                HibernateController.beginTransaction();
                HibernateController.save(view);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                Model.getInstance().getViews().add(view);
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Architectural View cannot be created.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Question getQuestionById(Question q, boolean updateModel) throws DomainException {
        try {
            HibernateController.openSession();
            if (updateModel) {
                Model.getInstance().getQuestions().remove(q);
            }
            HibernateController.beginTransaction();
            Question qNew = (Question)new QuestionDAO().getById(q.getId());
            HibernateController.commitTransaction();
            if (updateModel) {
                Model.getInstance().getQuestions().add(qNew);
            }
            HibernateController.closeSession();
            Question question = qNew;
            return question;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void updateQuestion(Question q, DataType type, String qText, int qOrder, Map<String, Map<Question, String>> rules) throws DomainException {
        try {
            try {
                int auxOrder;
                HibernateController.openSession();
                q.setText(qText);
                int orderChange = 0;
                int oldOrder = q.getOrder();
                HashSet<Question> updateQ = new HashSet<Question>();
                Set<Question> auxqs = Model.getInstance().getQuestions();
                if (oldOrder > qOrder) {
                    orderChange = 1;
                    for (Question qaux : auxqs) {
                        auxOrder = qaux.getOrder();
                        if (auxOrder < qOrder || auxOrder >= oldOrder) continue;
                        updateQ.add(qaux);
                    }
                } else if (oldOrder < qOrder) {
                    --qOrder;
                    orderChange = -1;
                    for (Question qaux : auxqs) {
                        auxOrder = qaux.getOrder();
                        if (auxOrder <= oldOrder || auxOrder > qOrder) continue;
                        updateQ.add(qaux);
                    }
                }
                this.updateQuestionsOrder(updateQ, orderChange);
                q.setOrder(qOrder);
                DataType oldType = q.getQuestionType();
                if (!oldType.equals(type)) {
                    boolean delRule;
                    oldType.removeQuestion(q);
                    type.addQuestion(q);
                    for (qrQuestionRestriction qrq : q.getQuestionRestrictions()) {
                        delRule = false;
                        qrq.removeRestriction();
                        QuestionRule qr = qrq.getQuestionRule();
                        if (qr.getQuestionRestrictions().isEmpty()) {
                            delRule = true;
                        }
                        HibernateController.beginTransaction();
                        HibernateController.delete(qrq);
                        if (delRule) {
                            HibernateController.delete(qr);
                        }
                        HibernateController.commitTransaction();
                    }
                    for (prQuestionRestriction prq : q.getPropertyRestrictions()) {
                        delRule = false;
                        prq.removeRestriction();
                        PropertyRule pr = prq.getPropertyRule();
                        if (pr.getQuestionRestrictions().isEmpty()) {
                            delRule = true;
                        }
                        HibernateController.beginTransaction();
                        HibernateController.delete(prq);
                        if (delRule) {
                            HibernateController.delete(pr);
                        }
                        HibernateController.commitTransaction();
                    }
                    q.clearAllRestrictions();
                }
                this.removeQuestionRules(q);
                HibernateController.beginTransaction();
                HibernateController.update(q);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                HibernateController.openSession();
                this.newQuestionRules(q, rules);
                HibernateController.beginTransaction();
                HibernateController.update(q);
                HibernateController.commitTransaction();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Question cannot be updated.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    private void refreshAllParents(QualityAttribute actualParent) throws DomainException {
        if (actualParent != null) {
            Model.getInstance().getQualityAttributes().remove(actualParent);
            HibernateController.beginTransaction();
            actualParent = (QualityAttribute)new QualityAttributeDAO().getById(actualParent.getId());
            HibernateController.commitTransaction();
            Model.getInstance().getQualityAttributes().add(actualParent);
            this.refreshAllParents(actualParent.getParentAttribute());
        }
    }

    public QualityAttribute getQualityAttributeById(QualityAttribute qa, boolean updateModel) throws DomainException {
        try {
            HibernateController.openSession();
            if (updateModel) {
                Model.getInstance().getQualityAttributes().remove(qa);
            }
            HibernateController.beginTransaction();
            QualityAttribute p = (QualityAttribute)new QualityAttributeDAO().getById(qa.getId());
            HibernateController.commitTransaction();
            if (updateModel) {
                Model.getInstance().getQualityAttributes().add(p);
            }
            HibernateController.closeSession();
            QualityAttribute qualityAttribute = p;
            return qualityAttribute;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void updateQualityAttribute(QualityAttribute qa, String name, String description) throws DomainException {
        try {
            try {
                QualityAttribute parent;
                HibernateController.openSession();
                QualityAttributeDAO dao = new QualityAttributeDAO();
                qa.setName(name);
                if (description != null) {
                    qa.setDescription(description);
                }
                if ((parent = qa.getParentAttribute()) != null) {
                    Model.getInstance().getQualityAttributes().remove(parent);
                    HibernateController.beginTransaction();
                    parent = (QualityAttribute)dao.getById(parent.getId());
                    HibernateController.commitTransaction();
                    Model.getInstance().getQualityAttributes().add(parent);
                    parent.removeChildAttribute(qa);
                    parent.addChildAttribute(qa);
                    this.refreshAllParents(parent);
                }
                HibernateController.beginTransaction();
                HibernateController.update(qa);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Quality Attribute cannot be updated.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public ElementProperty getElementPropertyById(ElementProperty prop, boolean updateModel) throws DomainException {
        try {
            HibernateController.openSession();
            if (updateModel) {
                Model.getInstance().getElementProperties().remove(prop);
            }
            HibernateController.beginTransaction();
            ElementProperty p = (ElementProperty)new ElementPropertyDAO().getById(prop.getId());
            HibernateController.commitTransaction();
            if (updateModel) {
                Model.getInstance().getElementProperties().add(p);
            }
            HibernateController.closeSession();
            ElementProperty elementProperty = p;
            return elementProperty;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void updateElementProperty(ElementProperty p, DataType type, String name, String description, Map<String, TuplePropertyRulesMap> rules) throws DomainException {
        try {
            try {
                DataType oldType;
                HibernateController.openSession();
                p.setName(name);
                if (description != null) {
                    p.setDescription(description);
                }
                if (!(oldType = p.getType()).equals(type)) {
                    oldType.removeProperty(p);
                    type.addProperty(p);
                    p.removeValues();
                }
                this.removePropertyRules(p);
                HibernateController.beginTransaction();
                HibernateController.update(p);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                HibernateController.openSession();
                this.newPropertyRules(p, rules);
                HibernateController.beginTransaction();
                HibernateController.update(p);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Property cannot be updated.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Decision getDecisionById(Decision dec, boolean updateModel) throws DomainException {
        try {
            HibernateController.openSession();
            if (updateModel) {
                Model.getInstance().getDecisions().remove(dec);
            }
            HibernateController.beginTransaction();
            Decision d = (Decision)new DecisionDAO().getById(dec.getId());
            HibernateController.commitTransaction();
            if (updateModel) {
                Model.getInstance().getDecisions().add(d);
            }
            HibernateController.closeSession();
            Decision decision = d;
            return decision;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void removeUnusedEffects(Decision d, Set<QualityAttribute> usedAttributes) {
        HibernateController.openSession();
        HashSet<DecisionEffect> toRemove = new HashSet<DecisionEffect>();
        for (DecisionEffect effect : d.getDecisionEffects()) {
            if (usedAttributes.contains(effect.getAttribute())) continue;
            effect.remove();
            toRemove.add(effect);
        }
        for (DecisionEffect effect : toRemove) {
            d.removeDecisionEffect(effect);
        }
        HibernateController.beginTransaction();
        HibernateController.update(d);
        HibernateController.commitTransaction();
        HibernateController.closeSession();
    }

    public void updateDecision(Decision d, String name, String desc, Map<QualityAttribute, Integer> effectsMap, Map<Element, Integer> actionsMap) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                d.setName(name);
                if (desc != null) {
                    d.setDescription(desc);
                }
                this.removeEffects(d);
                this.removeActions(d);
                HibernateController.beginTransaction();
                HibernateController.update(d);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                HibernateController.openSession();
                Set<QualityAttribute> attributes = effectsMap.keySet();
                for (QualityAttribute attr : attributes) {
                    Integer value = effectsMap.get(attr);
                    if (value == null) continue;
                    DecisionEffect de = new DecisionEffect();
                    de.setValue(value);
                    d.addDecisionEffect(de);
                    attr.addDecisionEffect(de);
                    HibernateController.beginTransaction();
                    HibernateController.update(attr);
                    HibernateController.commitTransaction();
                }
                Set<Element> elements = actionsMap.keySet();
                for (Element element : elements) {
                    Integer val = actionsMap.get(element);
                    if (val == null) continue;
                    DecisionAction da = new DecisionAction();
                    da.setAction(val);
                    d.addAction(da);
                    element.addDecisionAction(da);
                    HibernateController.beginTransaction();
                    HibernateController.update(element);
                    HibernateController.commitTransaction();
                }
                HibernateController.beginTransaction();
                HibernateController.update(d);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Decision cannot be updated.\n Try restarting eclipse, this should fix the problem", he);
            }
            catch (ConcurrentModificationException ce) {
                throw new DomainException("There is some trouble with the code.\nKick the programmer and then show him this", ce);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public DataType getTypeById(Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            DataType t = (DataType)new DataTypeDAO().getById(id);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            DataType dataType = t;
            return dataType;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public IntegerType getIntegerTypeById(IntegerType type, boolean updateModel) throws DomainException {
        try {
            HibernateController.openSession();
            if (updateModel) {
                Model.getInstance().getIntegerTypes().remove(type);
            }
            HibernateController.beginTransaction();
            IntegerType t = (IntegerType)new IntegerTypeDAO().getById(type.getId());
            HibernateController.commitTransaction();
            if (updateModel) {
                Model.getInstance().getIntegerTypes().add(t);
            }
            HibernateController.closeSession();
            IntegerType integerType = t;
            return integerType;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void updateIntegerType(IntegerType type, String name, String desc, int min, boolean hasMin, int max, boolean hasMax) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                this.setIntegerTypeValues(type, name, desc, min, hasMin, max, hasMax);
                HibernateController.beginTransaction();
                HibernateController.update(type);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Data Type cannot be updated.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public RealType getRealTypeById(RealType type, boolean updateModel) throws DomainException {
        try {
            HibernateController.openSession();
            if (updateModel) {
                Model.getInstance().getRealTypes().remove(type);
            }
            HibernateController.beginTransaction();
            RealType t = (RealType)new RealTypeDAO().getById(type.getId());
            HibernateController.commitTransaction();
            if (updateModel) {
                Model.getInstance().getRealTypes().add(t);
            }
            HibernateController.closeSession();
            RealType realType = t;
            return realType;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void updateRealType(RealType type, String name, String desc, float min, boolean hasMin, float max, boolean hasMax) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                this.setRealTypeValues(type, name, desc, min, hasMin, max, hasMax);
                HibernateController.beginTransaction();
                HibernateController.update(type);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Data Type cannot be updated.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public EnumerateType getEnumerateTypeById(EnumerateType type, boolean updateModel) throws DomainException {
        try {
            HibernateController.openSession();
            if (updateModel) {
                Model.getInstance().getEnumerateTypes().remove(type);
            }
            HibernateController.beginTransaction();
            EnumerateType t = (EnumerateType)new EnumerateTypeDAO().getById(type.getId());
            HibernateController.commitTransaction();
            if (updateModel) {
                Model.getInstance().getEnumerateTypes().add(t);
            }
            HibernateController.closeSession();
            EnumerateType enumerateType = t;
            return enumerateType;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void updateEnumerateType(EnumerateType type, String name, String desc, Set<String> values) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                type.setName(name);
                type.setDescription(desc);
                type.clearValues();
                for (String value : values) {
                    type.addValue(value);
                }
                HibernateController.beginTransaction();
                HibernateController.update(type);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Data Type cannot be updated.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public StringType getStringTypeById(StringType type, boolean updateModel) throws DomainException {
        try {
            HibernateController.openSession();
            if (updateModel) {
                Model.getInstance().getStringTypes().remove(type);
            }
            HibernateController.beginTransaction();
            StringType t = (StringType)new StringTypeDAO().getById(type.getId());
            HibernateController.commitTransaction();
            if (updateModel) {
                Model.getInstance().getStringTypes().add(t);
            }
            HibernateController.closeSession();
            StringType stringType = t;
            return stringType;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void updateStringType(StringType type, String name, String desc) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                type.setName(name);
                type.setDescription(desc);
                HibernateController.beginTransaction();
                HibernateController.update(type);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Data Type cannot be updated.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Constraint getConstraintById(Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Constraint c = (Constraint)new ConstraintDAO().getById(id);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Constraint constraint = c;
            return constraint;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Restriction getRestrictionById(Restriction r, boolean updateModel) throws DomainException {
        try {
            HibernateController.openSession();
            if (updateModel) {
                Model.getInstance().getRestrictions().remove(r);
            }
            HibernateController.beginTransaction();
            Restriction res = (Restriction)new RestrictionDAO().getById(r.getId());
            HibernateController.commitTransaction();
            if (updateModel) {
                Model.getInstance().getRestrictions().add(res);
            }
            HibernateController.closeSession();
            Restriction restriction = r;
            return restriction;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Condition getConditionById(Condition c, boolean updateModel) throws DomainException {
        try {
            HibernateController.openSession();
            if (updateModel) {
                Model.getInstance().getConditions().remove(c);
            }
            HibernateController.beginTransaction();
            Condition res = (Condition)new ConditionDAO().getById(c.getId());
            HibernateController.commitTransaction();
            if (updateModel) {
                Model.getInstance().getConditions().add(res);
            }
            HibernateController.closeSession();
            Condition condition = c;
            return condition;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Element getElementById(Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Element e = (Element)new ElementDAO().getById(id);
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            Element element = e;
            return element;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Component getComponentById(Component c, boolean updateModel) throws DomainException {
        try {
            HibernateController.openSession();
            if (updateModel) {
                Model.getInstance().getComponents().remove(c);
            }
            HibernateController.beginTransaction();
            Component comp = (Component)new ComponentDAO().getById(c.getId());
            HibernateController.commitTransaction();
            if (updateModel) {
                Model.getInstance().getComponents().add(comp);
            }
            HibernateController.closeSession();
            Component component = comp;
            return component;
        }
        catch (HibernateException he) {
            HibernateController.rollback();
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    private void refreshAllParents(Element actualParent) throws DomainException {
        if (actualParent != null) {
            Model.getInstance().getMappingElements().get(actualParent.getClass()).remove(actualParent);
            HibernateController.beginTransaction();
            actualParent = (Element)new ElementDAO().getById(actualParent.getId());
            HibernateController.commitTransaction();
            Model.getInstance().getMappingElements().get(actualParent.getClass()).add(actualParent);
            this.refreshAllParents(actualParent.getParentElement());
        }
    }

    private Element getRootElement(Element el) {
        if (el.getParentElement() == null) {
            return el;
        }
        return this.getRootElement(el.getParentElement());
    }

    private void updateSpecializedElementsViews(Element root, ArchitecturalView view, Element notToUpdate, boolean isStyle, Set<StyleVariation> varsToUpdate) throws DomainException {
        boolean updated = this.updateView(root, view);
        if (updated) {
            if (root.equals(notToUpdate)) {
                root.updateOnViewChange();
            } else {
                root.updateOnViewChangeHard();
            }
        }
        if (isStyle) {
            varsToUpdate.addAll(((Style)root).getStyleVariations());
        }
        if (!root.equals(notToUpdate) && updated) {
            HibernateController.beginTransaction();
            HibernateController.update(root);
            HibernateController.commitTransaction();
            Model.getInstance().getMappingElements().get(root.getClass()).remove(root);
            HibernateController.beginTransaction();
            root = (Element)new ElementDAO().getById(root.getId());
            HibernateController.commitTransaction();
            Model.getInstance().getMappingElements().get(root.getClass()).add(root);
        }
        for (Element el : root.getChildElements()) {
            this.updateSpecializedElementsViews(el, view, notToUpdate, isStyle, varsToUpdate);
        }
    }

    public boolean updateView(Element el, ArchitecturalView view) throws DomainException {
        boolean updated = false;
        ArchitecturalView oldView = el.getArchitecturalView();
        if (!oldView.equals(view)) {
            oldView.removeElement(el);
            view.addElement(el);
            updated = true;
        }
        return updated;
    }

    public void updateElementCommon(Element el, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<ElementProperty, String> valuesMap, Set<Element> relatedElements, ArchitecturalView view) {
        el.setName(name);
        if (desc != null) {
            el.setDescription(desc);
        }
        Set<String> restrictionNames = restrictionsMap.keySet();
        Set<ElementProperty> properties = valuesMap.keySet();
        for (String rest : restrictionNames) {
            TupleRestriction restriction = restrictionsMap.get(rest);
            Restriction r = new Restriction();
            r.setName(rest);
            el.addRestriction(r);
            for (Decision d : restriction.decisions) {
                if (d == null) continue;
                r.addDecision(d);
            }
        }
        for (ElementProperty prop : properties) {
            String value = valuesMap.get(prop);
            if (value.equals("")) continue;
            PropertyValue pv = new PropertyValue();
            pv.setValue(value);
            el.addPropertyValue(pv);
            prop.addPropertyValue(pv);
        }
        for (Element e : relatedElements) {
            el.addRelatedElement(e);
        }
        boolean updatedView = false;
        try {
            ArchitecturalView oldView = el.getArchitecturalView();
            if (!oldView.equals(view)) {
                updatedView = true;
                HashSet<StyleVariation> varsToUpdate = new HashSet<StyleVariation>();
                Element root = this.getRootElement(el);
                this.updateSpecializedElementsViews(root, view, el, root instanceof Style, varsToUpdate);
                for (StyleVariation sv : varsToUpdate) {
                    Element rootSv = this.getRootElement(sv);
                    this.updateSpecializedElementsViews(rootSv, view, el, false, varsToUpdate);
                }
            }
            if (!updatedView) {
                Element parent = el.getParentElement();
                ElementDAO dao = new ElementDAO();
                if (parent != null) {
                    Model.getInstance().getMappingElements().get(parent.getClass()).remove(parent);
                    HibernateController.beginTransaction();
                    parent = (Element)dao.getById(parent.getId());
                    HibernateController.commitTransaction();
                    Model.getInstance().getMappingElements().get(parent.getClass()).add(parent);
                    parent.removeChildElement(el);
                    parent.addChildElement(el);
                    this.refreshAllParents(parent);
                }
            }
        }
        catch (Exception exception) {}
    }

    public void updateComponent(Component comp, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<ElementProperty, String> valuesMap, Set<Element> relatedElements, ArchitecturalView view, Set<Component> composableWith, Set<Component> connectableWith, Set<StyleVariation> applyTo, Set<Implementation> implementableWith, Set<Style> applyToStyles, boolean selfComposable, boolean selfConnectable) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                this.removeRestrictions(comp);
                this.removeValues(comp);
                Set<Element> els = comp.getRelatedElements();
                for (Element ele : els) {
                    ele.removeRelatedWith(comp);
                }
                comp.clearRelatedElements();
                Set<Component> composibleComps = comp.getComposableWith();
                for (Component c : composibleComps) {
                    c.removeComposableWithInverse(comp);
                }
                comp.clearComposablewith();
                Set<Component> connectedComps = comp.getConnectedTo();
                for (Component c : connectedComps) {
                    c.removeConnectedToInverse(comp);
                }
                comp.clearConnectedTo();
                Set<StyleVariation> styleVariations = comp.getApplyTo();
                for (StyleVariation sv : styleVariations) {
                    sv.removeComponent(comp);
                }
                comp.clearApplyTo();
                Set<Style> styles = comp.getApplyToStyle();
                for (Style s : styles) {
                    s.removeComponent(comp);
                }
                comp.clearApplyToStyle();
                Set<Implementation> implementations = comp.getImplementableWith();
                for (Implementation impl : implementations) {
                    impl.removeComponent(comp);
                }
                comp.clearImplementableWith();
                HibernateController.beginTransaction();
                HibernateController.update(comp);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                HibernateController.openSession();
                this.updateElementCommon(comp, name, desc, restrictionsMap, valuesMap, relatedElements, view);
                ComponentDAO compDAO = new ComponentDAO();
                StyleVariationDAO svDAO = new StyleVariationDAO();
                StyleDAO styleDAO = new StyleDAO();
                ImplementationDAO implDAO = new ImplementationDAO();
                for (Component c : composableWith) {
                    c = (Component)compDAO.getById(c.getId());
                    comp.addComposableWith(c);
                    HibernateController.update(c);
                }
                if (selfComposable) {
                    comp.addComposableWith(comp);
                }
                for (Component c : connectableWith) {
                    c = (Component)compDAO.getById(c.getId());
                    comp.addConnectedTo(c);
                    HibernateController.update(c);
                }
                if (selfConnectable) {
                    comp.addConnectedTo(comp);
                }
                for (StyleVariation sv : applyTo) {
                    sv = (StyleVariation)svDAO.getById(sv.getId());
                    comp.addStyleVariation(sv);
                    HibernateController.update(sv);
                }
                for (Style s : applyToStyles) {
                    s = (Style)styleDAO.getById(s.getId());
                    comp.addStyle(s);
                    HibernateController.update(s);
                }
                for (Implementation impl : implementableWith) {
                    impl = (Implementation)implDAO.getById(impl.getId());
                    comp.addImplementation(impl);
                    HibernateController.update(impl);
                }
                HibernateController.beginTransaction();
                HibernateController.update(comp);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Component cannot be updated.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Style getStyleById(Style s, boolean updateModel) throws DomainException {
        try {
            HibernateController.openSession();
            if (updateModel) {
                Model.getInstance().getStyles().remove(s);
            }
            HibernateController.beginTransaction();
            Style st = (Style)new StyleDAO().getById(s.getId());
            HibernateController.commitTransaction();
            if (updateModel) {
                Model.getInstance().getStyles().add(st);
            }
            HibernateController.closeSession();
            Style style = st;
            return style;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void updateStyle(Style style, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<ElementProperty, String> valuesMap, Set<Element> relatedElements, ArchitecturalView view) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                this.removeRestrictions(style);
                this.removeValues(style);
                Set<Element> els = style.getRelatedElements();
                for (Element ele : els) {
                    ele.removeRelatedWith(style);
                }
                style.clearRelatedElements();
                HibernateController.beginTransaction();
                HibernateController.update(style);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                HibernateController.openSession();
                this.updateElementCommon(style, name, desc, restrictionsMap, valuesMap, relatedElements, view);
                HibernateController.beginTransaction();
                HibernateController.update(style);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Style cannot be updated.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public StyleVariation getStyleVariationById(StyleVariation sv, boolean updateModel) throws DomainException {
        try {
            HibernateController.openSession();
            if (updateModel) {
                Model.getInstance().getStyleVariations().remove(sv);
            }
            HibernateController.beginTransaction();
            StyleVariation stv = (StyleVariation)new StyleVariationDAO().getById(sv.getId());
            HibernateController.commitTransaction();
            if (updateModel) {
                Model.getInstance().getStyleVariations().add(stv);
            }
            HibernateController.closeSession();
            StyleVariation styleVariation = stv;
            return styleVariation;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void updateStyleVariation(StyleVariation styleVariation, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<ElementProperty, String> valuesMap, Set<Element> relatedElements, ArchitecturalView view, Style style, Set<StyleVariation> incompatibleVariations) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                StyleVariationDAO svDAO = new StyleVariationDAO();
                this.removeRestrictions(styleVariation);
                this.removeValues(styleVariation);
                Set<StyleVariation> variations = styleVariation.getIncompatibleWith();
                for (StyleVariation sv : variations) {
                    sv = (StyleVariation)svDAO.getById(sv.getId());
                    sv.removeIncompatibleWith(styleVariation);
                    HibernateController.beginTransaction();
                    HibernateController.update(sv);
                    HibernateController.commitTransaction();
                }
                styleVariation.clearIncompatibleWith();
                Set<Element> els = styleVariation.getRelatedElements();
                for (Element ele : els) {
                    ele.removeRelatedWith(styleVariation);
                }
                styleVariation.clearRelatedElements();
                HibernateController.beginTransaction();
                HibernateController.update(styleVariation);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                HibernateController.openSession();
                this.updateElementCommon(styleVariation, name, desc, restrictionsMap, valuesMap, relatedElements, view);
                for (StyleVariation sv : incompatibleVariations) {
                    sv = (StyleVariation)svDAO.getById(sv.getId());
                    sv.addIncompatibleWith(styleVariation);
                    styleVariation.addIncompatibleWith(sv);
                    HibernateController.beginTransaction();
                    HibernateController.update(sv);
                    HibernateController.commitTransaction();
                }
                Style oldStyle = styleVariation.getVariationFor();
                if (!oldStyle.equals(style)) {
                    oldStyle.removeStyleVariation(styleVariation);
                    style.addStyleVariation(styleVariation);
                }
                HibernateController.beginTransaction();
                HibernateController.update(styleVariation);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Style Variation cannot be updated.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public Implementation getImplementationById(Implementation i, boolean updateModel) throws DomainException {
        try {
            HibernateController.openSession();
            if (updateModel) {
                Model.getInstance().getImplementations().remove(i);
            }
            HibernateController.beginTransaction();
            Implementation impl = (Implementation)new ImplementationDAO().getById(i.getId());
            HibernateController.commitTransaction();
            if (updateModel) {
                Model.getInstance().getImplementations().add(impl);
            }
            HibernateController.closeSession();
            Implementation implementation = impl;
            return implementation;
        }
        catch (HibernateException he) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", he);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void updateImplementation(Implementation implementation, String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<ElementProperty, String> valuesMap, Set<Element> relatedElements, ArchitecturalView view, Set<Component> components) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                ComponentDAO compDAO = new ComponentDAO();
                this.removeRestrictions(implementation);
                this.removeValues(implementation);
                Set<Component> comps = implementation.getComponents();
                for (Component c : comps) {
                    c = (Component)compDAO.getById(c.getId());
                    c.removeImplementableWith(implementation);
                    HibernateController.beginTransaction();
                    HibernateController.update(c);
                    HibernateController.commitTransaction();
                }
                implementation.clearComponents();
                Set<Element> els = implementation.getRelatedElements();
                for (Element ele : els) {
                    ele.removeRelatedWith(implementation);
                }
                implementation.clearRelatedElements();
                HibernateController.beginTransaction();
                HibernateController.update(implementation);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                HibernateController.openSession();
                this.updateElementCommon(implementation, name, desc, restrictionsMap, valuesMap, relatedElements, view);
                for (Component c : components) {
                    c = (Component)compDAO.getById(c.getId());
                    c.addImplementation(implementation);
                    HibernateController.beginTransaction();
                    HibernateController.update(c);
                    HibernateController.commitTransaction();
                }
                HibernateController.beginTransaction();
                HibernateController.update(implementation);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the Implementation cannot be updated.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    private void newQuestionRules(Question q, Map<String, Map<Question, String>> rules) {
        Set<String> ruleNames = rules.keySet();
        for (String rule : ruleNames) {
            QuestionRule qr = new QuestionRule();
            qr.setName(rule);
            q.addQuestionRule(qr);
            Map<Question, String> restrictions = rules.get(rule);
            Set<Question> questions = restrictions.keySet();
            for (Question qaux : questions) {
                if (qaux == null) continue;
                new qrQuestionRestriction(qaux, qr, restrictions.get(qaux));
            }
        }
    }

    private void newPropertyRules(ElementProperty p, Map<String, TuplePropertyRulesMap> rules) {
        Set<String> ruleNames = rules.keySet();
        for (String rule : ruleNames) {
            TuplePropertyRulesMap restrictions = rules.get(rule);
            PropertyRule pr = new PropertyRule();
            pr.setName(rule);
            pr.setPropertyCondition(restrictions.condition);
            p.addCondition(pr);
            Set<Question> questions = restrictions.ifQuestions.keySet();
            for (Question q : questions) {
                if (q == null) continue;
                new prQuestionRestriction(q, pr, restrictions.ifQuestions.get(q));
            }
        }
    }

    private void removeQuestionRules(Question q) {
        Set<QuestionRule> qrules = q.getQuestionRules();
        for (QuestionRule qr : qrules) {
            qr.remove();
        }
        q.removeAllRules();
    }

    private void removePropertyRules(ElementProperty p) {
        Set<Condition> conditions = p.getConditions();
        for (Condition c : conditions) {
            if (!(c instanceof PropertyRule)) continue;
            ((PropertyRule)c).remove();
        }
        p.removeAllPropertyRules();
    }

    private void removeRestrictions(Element e) {
        Set<Restriction> restrictions = e.getRestrictions();
        for (Restriction r : restrictions) {
            r.remove();
        }
        e.removeAllRestrictions();
    }

    private void removeValues(Element e) {
        Set<PropertyValue> values = e.getPropertyValues();
        for (PropertyValue pv : values) {
            pv.removeToProperty();
        }
        e.removeAllValues();
    }

    private void removeEffects(Decision d) {
        Set<DecisionEffect> effects = d.getDecisionEffects();
        for (DecisionEffect de : effects) {
            de.remove();
        }
        d.removeAllEffects();
    }

    private void removeActions(Decision d) {
        Set<DecisionAction> actions = d.getActions();
        for (DecisionAction da : actions) {
            da.remove();
        }
        d.removeAllActions();
    }

    public Question getQuestionFromText(String text) throws DomainException {
        for (Question q : Model.getInstance().getQuestions()) {
            if (!q.getText().equalsIgnoreCase(text)) continue;
            return q;
        }
        return null;
    }

    public QualityAttribute getQualityAttributeFromName(String name) throws DomainException {
        for (QualityAttribute qp : Model.getInstance().getQualityAttributes()) {
            if (!qp.getName().equalsIgnoreCase(name)) continue;
            return qp;
        }
        return null;
    }

    public Decision getDecisionFromName(String name) throws DomainException {
        for (Decision d : Model.getInstance().getDecisions()) {
            if (!d.getName().equalsIgnoreCase(name)) continue;
            return d;
        }
        return null;
    }

    public DataType getTypeFromName(String name) throws DomainException {
        for (DataType d : Model.getInstance().getTypes()) {
            if (!d.getName().equalsIgnoreCase(name)) continue;
            return d;
        }
        return null;
    }

    public ElementProperty getElementPropertyFromName(String name) throws DomainException {
        for (ElementProperty p : Model.getInstance().getElementProperties()) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    public Element getElementFromName(String name) throws DomainException {
        for (Element e : Model.getInstance().getElements()) {
            if (!e.getName().equalsIgnoreCase(name)) continue;
            return e;
        }
        return null;
    }

    public Component getComponentFromName(String name) throws DomainException {
        for (Component comp : Model.getInstance().getComponents()) {
            if (!comp.getName().equalsIgnoreCase(name)) continue;
            return comp;
        }
        return null;
    }

    public Style getStyleFromName(String name) throws DomainException {
        for (Style s : Model.getInstance().getStyles()) {
            if (!s.getName().equalsIgnoreCase(name)) continue;
            return s;
        }
        return null;
    }

    public StyleVariation getStyleVariationFromName(String name) throws DomainException {
        for (StyleVariation sv : Model.getInstance().getStyleVariations()) {
            if (!sv.getName().equalsIgnoreCase(name)) continue;
            return sv;
        }
        return null;
    }

    public Implementation getImplementationFromName(String name) throws DomainException {
        for (Implementation impl : Model.getInstance().getImplementations()) {
            if (!impl.getName().equalsIgnoreCase(name)) continue;
            return impl;
        }
        return null;
    }

    public ArchitecturalView getArchitecturalViewFromName(String name) throws DomainException {
        for (ArchitecturalView view : Model.getInstance().getViews()) {
            if (!view.getName().equalsIgnoreCase(name)) continue;
            return view;
        }
        return null;
    }

    public ArchitecturalFramework getArchitecturalFrameworkFromName(String name) throws DomainException {
        return (ArchitecturalFramework)new ArchitecturalFrameworkDAO().getByAlternativeKey(name);
    }

    public boolean questionAlredyExists(String text, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Question q = (Question)new QuestionDAO().getByAlternativeKey(text);
            boolean b = q == null ? false : (isNew ? true : !q.getId().equals(id));
            HibernateController.commitTransaction();
            HibernateController.closeSession();
            boolean bl = b;
            return bl;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public boolean elementPropertyAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            ElementProperty p = (ElementProperty)new ElementPropertyDAO().getByAlternativeKey(name);
            HibernateController.commitTransaction();
            boolean b = p == null ? false : (isNew ? true : !p.getId().equals(id));
            HibernateController.closeSession();
            boolean bl = b;
            return bl;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public boolean qualityAttributeAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            QualityAttribute qa = (QualityAttribute)new QualityAttributeDAO().getByAlternativeKey(name);
            HibernateController.commitTransaction();
            boolean b = qa == null ? false : (isNew ? true : !qa.getId().equals(id));
            HibernateController.closeSession();
            boolean bl = b;
            return bl;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public boolean decisionAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Decision d = (Decision)new DecisionDAO().getByAlternativeKey(name);
            HibernateController.commitTransaction();
            boolean b = d == null ? false : (isNew ? true : !d.getId().equals(id));
            HibernateController.closeSession();
            boolean bl = b;
            return bl;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public boolean elementAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            Element e = (Element)new ElementDAO().getByAlternativeKey(name);
            HibernateController.commitTransaction();
            boolean b = e == null ? false : (isNew ? true : !e.getId().equals(id));
            HibernateController.closeSession();
            boolean bl = b;
            return bl;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public boolean typeAlredyExists(String name, boolean isNew, Long id) throws DomainException {
        try {
            HibernateController.openSession();
            HibernateController.beginTransaction();
            DataType d = (DataType)new DataTypeDAO().getByAlternativeKey(name);
            HibernateController.commitTransaction();
            boolean b = d == null ? false : (isNew ? true : !d.getId().equals(id));
            HibernateController.closeSession();
            boolean bl = b;
            return bl;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public boolean constraintAlredyExists(String newName, String oldName, Long actualElementId, boolean isNew) throws DomainException {
        try {
            Set<Constraint> constraints = Model.getInstance().getConstraints();
            HibernateController.beginTransaction();
            boolean b = false;
            if (isNew) {
                for (Constraint c : constraints) {
                    if (!c.getName().equalsIgnoreCase(newName)) continue;
                    b = true;
                    break;
                }
            } else {
                Element el = (Element)new ElementDAO().getById(actualElementId);
                for (Restriction r : el.getRestrictions()) {
                    constraints.remove(r);
                }
                for (Constraint c : constraints) {
                    if (!c.getName().equalsIgnoreCase(newName) || c.getName().equalsIgnoreCase(oldName)) continue;
                    b = true;
                    break;
                }
            }
            HibernateController.commitTransaction();
            boolean bl = b;
            return bl;
        }
        catch (HibernateException e) {
            throw new DomainException("There is some problem with the persistence.\n Try restarting eclipse, this should fix the problem", e);
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    private void updateQuestionsOrder(Set<Question> updateQ, int orderChange) throws DomainException {
        QuestionDAO qDAO = new QuestionDAO();
        for (Question qaux : updateQ) {
            int auxOrder = qaux.getOrder();
            Model.getInstance().getQuestions().remove(qaux);
            HibernateController.beginTransaction();
            qaux = (Question)qDAO.getById(qaux.getId());
            HibernateController.commitTransaction();
            Model.getInstance().getQuestions().add(qaux);
            qaux.setOrder(auxOrder + orderChange);
            HibernateController.beginTransaction();
            HibernateController.update(qaux);
            HibernateController.commitTransaction();
        }
    }

    public void swapQuestionsOrder(Question qUp, Question qDown) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                QuestionDAO qDAO = new QuestionDAO();
                Model.getInstance().getQuestions().remove(qUp);
                HibernateController.beginTransaction();
                qUp = (Question)qDAO.getById(qUp.getId());
                HibernateController.commitTransaction();
                Model.getInstance().getQuestions().add(qUp);
                Model.getInstance().getQuestions().remove(qDown);
                HibernateController.beginTransaction();
                qDown = (Question)qDAO.getById(qDown.getId());
                HibernateController.commitTransaction();
                Model.getInstance().getQuestions().add(qDown);
                if (qUp.appearInRules(qDown)) {
                    throw new DomainException("The upper question appears in some of the rules of the down one.\nCheck this and try again.");
                }
                int orderUp = qUp.getOrder();
                int orderDown = qDown.getOrder();
                qUp.setOrder(orderDown);
                qDown.setOrder(orderUp);
                HibernateController.beginTransaction();
                HibernateController.update(qUp);
                HibernateController.commitTransaction();
                HibernateController.beginTransaction();
                HibernateController.update(qDown);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the order of the questions cannot be changed.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void changeQualityAttributeParent(QualityAttribute qp, QualityAttribute newParent) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                QualityAttributeDAO dao = new QualityAttributeDAO();
                Model.getInstance().getQualityAttributes().remove(qp);
                HibernateController.beginTransaction();
                qp = (QualityAttribute)dao.getById(qp.getId());
                HibernateController.commitTransaction();
                Model.getInstance().getQualityAttributes().add(qp);
                if (newParent != null) {
                    Model.getInstance().getQualityAttributes().remove(newParent);
                    HibernateController.beginTransaction();
                    newParent = (QualityAttribute)dao.getById(newParent.getId());
                    HibernateController.commitTransaction();
                    Model.getInstance().getQualityAttributes().add(newParent);
                }
                QualityAttribute oldParent = qp.getParentAttribute();
                QualityAttribute parent = newParent;
                if (!(oldParent == null && parent == null || (oldParent != null || parent == null) && oldParent.equals(parent))) {
                    if (oldParent != null) {
                        Model.getInstance().getQualityAttributes().remove(oldParent);
                        HibernateController.beginTransaction();
                        oldParent = (QualityAttribute)dao.getById(oldParent.getId());
                        HibernateController.commitTransaction();
                        Model.getInstance().getQualityAttributes().add(oldParent);
                        oldParent.removeChildAttribute(qp);
                        this.refreshAllParents(oldParent.getParentAttribute());
                    }
                    qp.setParentAttribute(parent);
                    if (parent != null) {
                        Model.getInstance().getQualityAttributes().remove(parent);
                        HibernateController.beginTransaction();
                        parent = (QualityAttribute)dao.getById(parent.getId());
                        HibernateController.commitTransaction();
                        Model.getInstance().getQualityAttributes().add(parent);
                        parent.addChildAttribute(qp);
                        this.refreshAllParents(parent.getParentAttribute());
                    }
                }
                HibernateController.beginTransaction();
                HibernateController.update(qp);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the specialization hierarchy cannot be modified.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void changeElementParent(Element element, Element newParent) throws DomainException {
        try {
            try {
                HibernateController.openSession();
                ElementDAO dao = new ElementDAO();
                Model.getInstance().getMappingElements().get(element.getClass()).remove(element);
                HibernateController.beginTransaction();
                element = (Element)dao.getById(element.getId());
                HibernateController.commitTransaction();
                Model.getInstance().getMappingElements().get(element.getClass()).add(element);
                if (newParent != null) {
                    Model.getInstance().getMappingElements().get(newParent.getClass()).remove(newParent);
                    HibernateController.beginTransaction();
                    newParent = (Element)dao.getById(newParent.getId());
                    HibernateController.commitTransaction();
                    Model.getInstance().getMappingElements().get(newParent.getClass()).add(newParent);
                }
                Element oldParent = element.getParentElement();
                Element parent = newParent;
                if (!(oldParent == null && parent == null || (oldParent != null || parent == null) && oldParent.equals(parent))) {
                    if (oldParent != null) {
                        Model.getInstance().getMappingElements().get(oldParent.getClass()).remove(oldParent);
                        HibernateController.beginTransaction();
                        oldParent = (Element)dao.getById(oldParent.getId());
                        HibernateController.commitTransaction();
                        Model.getInstance().getMappingElements().get(oldParent.getClass()).add(oldParent);
                        oldParent.removeChildElement(element);
                        this.refreshAllParents(oldParent.getParentElement());
                    }
                    element.setParentElement(parent);
                    if (parent != null) {
                        Model.getInstance().getMappingElements().get(parent.getClass()).remove(parent);
                        HibernateController.beginTransaction();
                        parent = (Element)dao.getById(parent.getId());
                        HibernateController.commitTransaction();
                        Model.getInstance().getMappingElements().get(parent.getClass()).add(parent);
                        parent.addChildElement(element);
                        this.refreshAllParents(parent.getParentElement());
                    }
                }
                HibernateController.beginTransaction();
                HibernateController.update(element);
                HibernateController.commitTransaction();
                HibernateController.closeSession();
                this.notifyModelChange();
            }
            catch (HibernateException he) {
                HibernateController.rollback();
                throw new DomainException("There is some problem with the persistence and the specialization hierarchy cannot be modified.\n Try restarting eclipse, this should fix the problem", he);
            }
        }
        finally {
            HibernateController.commitTransaction();
            HibernateController.closeSession();
        }
    }

    public void registerListener(ModelChangeListener listener) {
        this.modelListeners.add(listener);
    }

    public void unregisterListener(ModelChangeListener listener) {
        this.modelListeners.remove(listener);
    }

    public void notifyModelChange() {
        for (ModelChangeListener listener : this.modelListeners) {
            listener.modelChanged();
        }
    }
}

