/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domain.controller;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Condition;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Constraint;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Restriction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.Decision;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalView;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Component;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Implementation;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.PropertyValue;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Style;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.StyleVariation;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.ElementProperty;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.QualityAttribute;
import upc.gessi.architech.hibernatehelper.domain.domainModel.question.Question;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.EnumerateType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.IntegerType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.RealType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.StringType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;

public class Model {
    private Set<Question> questions;
    private Set<QualityAttribute> qualityAttributes;
    private Set<ElementProperty> elementProperties;
    private Set<Decision> decisions;
    private Set<IntegerType> integerTypes;
    private Set<RealType> realTypes;
    private Set<EnumerateType> enumerateTypes;
    private Set<StringType> stringTypes;
    private Set<DataType> types = new HashSet<DataType>();
    private Set<Restriction> restrictions;
    private Set<Condition> conditions;
    private Set<Constraint> constraints = new HashSet<Constraint>();
    private Set<PropertyValue> propertyValues = new HashSet<PropertyValue>();
    private Set<Component> components;
    private Set<Style> styles;
    private Set<StyleVariation> styleVariations;
    private Set<Implementation> implementations;
    private Set<Element> elements = new HashSet<Element>();
    private Set<ArchitecturalView> views;
    private Map<Class, Set> mappingElementSets;
    private static Model instance;

    public static Model getInstance() {
        if (instance == null) {
            instance = new Model();
        }
        return instance;
    }

    public Map<Class, Set> getMappingElements() throws DomainException {
        if (this.mappingElementSets == null) {
            this.mappingElementSets = new HashMap<Class, Set>();
            this.mappingElementSets.put(Component.class, this.getComponents());
            this.mappingElementSets.put(Style.class, this.getStyles());
            this.mappingElementSets.put(StyleVariation.class, this.getStyleVariations());
            this.mappingElementSets.put(Implementation.class, this.getImplementations());
        }
        return this.mappingElementSets;
    }

    public Set<Question> getQuestions() throws DomainException {
        if (this.questions == null) {
            this.questions = DomainController.getInstance().getAllQuestions();
        }
        return this.questions;
    }

    public Set<QualityAttribute> getQualityAttributes() throws DomainException {
        if (this.qualityAttributes == null) {
            this.qualityAttributes = DomainController.getInstance().getAllQualityAttributes();
        }
        return this.qualityAttributes;
    }

    public Set<ElementProperty> getElementProperties() throws DomainException {
        if (this.elementProperties == null) {
            this.elementProperties = DomainController.getInstance().getAllElementProperties();
        }
        return this.elementProperties;
    }

    public Set<Decision> getDecisions() throws DomainException {
        if (this.decisions == null) {
            this.decisions = DomainController.getInstance().getAllDecisions();
        }
        return this.decisions;
    }

    public Set<IntegerType> getIntegerTypes() throws DomainException {
        if (this.integerTypes == null) {
            this.integerTypes = DomainController.getInstance().getIntegerTypes();
        }
        return this.integerTypes;
    }

    public Set<RealType> getRealTypes() throws DomainException {
        if (this.realTypes == null) {
            this.realTypes = DomainController.getInstance().getRealTypes();
        }
        return this.realTypes;
    }

    public Set<EnumerateType> getEnumerateTypes() throws DomainException {
        if (this.enumerateTypes == null) {
            this.enumerateTypes = DomainController.getInstance().getEnumerateTypes();
        }
        return this.enumerateTypes;
    }

    public Set<StringType> getStringTypes() throws DomainException {
        if (this.stringTypes == null) {
            this.stringTypes = DomainController.getInstance().getStringTypes();
        }
        return this.stringTypes;
    }

    public Set<DataType> getTypes() throws DomainException {
        this.types.clear();
        this.types.addAll(this.getIntegerTypes());
        this.types.addAll(this.getRealTypes());
        this.types.addAll(this.getEnumerateTypes());
        this.types.addAll(this.getStringTypes());
        return this.types;
    }

    public Set<Restriction> getRestrictions() throws DomainException {
        if (this.restrictions == null) {
            this.restrictions = DomainController.getInstance().getAllRestrictions();
        }
        return this.restrictions;
    }

    public Set<Condition> getConditions() throws DomainException {
        if (this.conditions == null) {
            this.conditions = DomainController.getInstance().getAllConditions();
        }
        return this.conditions;
    }

    public Set<Constraint> getConstraints() throws DomainException {
        this.constraints.clear();
        this.constraints.addAll(this.getRestrictions());
        this.constraints.addAll(this.getConditions());
        return this.constraints;
    }

    public Set<PropertyValue> getPropertyValues() throws DomainException {
        if (this.propertyValues == null) {
            this.propertyValues = DomainController.getInstance().getAllPropertyValues();
        }
        return this.propertyValues;
    }

    public Set<Component> getComponents() throws DomainException {
        if (this.components == null) {
            this.components = DomainController.getInstance().getAllComponents();
            if (this.elementProperties == null) {
                this.elementProperties = DomainController.getInstance().getAllElementProperties();
            }
        }
        return this.components;
    }

    public Set<Style> getStyles() throws DomainException {
        if (this.styles == null) {
            this.styles = DomainController.getInstance().getAllStyles();
            if (this.elementProperties == null) {
                this.elementProperties = DomainController.getInstance().getAllElementProperties();
            }
        }
        return this.styles;
    }

    public Set<StyleVariation> getStyleVariations() throws DomainException {
        if (this.styleVariations == null) {
            this.styleVariations = DomainController.getInstance().getAllStyleVariations();
            if (this.elementProperties == null) {
                this.elementProperties = DomainController.getInstance().getAllElementProperties();
            }
        }
        return this.styleVariations;
    }

    public Set<Implementation> getImplementations() throws DomainException {
        if (this.implementations == null) {
            this.implementations = DomainController.getInstance().getAllImplementations();
            if (this.elementProperties == null) {
                this.elementProperties = DomainController.getInstance().getAllElementProperties();
            }
        }
        return this.implementations;
    }

    public Set<Element> getElements() throws DomainException {
        this.elements.clear();
        this.elements.addAll(this.getComponents());
        this.elements.addAll(this.getStyles());
        this.elements.addAll(this.getStyleVariations());
        this.elements.addAll(this.getImplementations());
        return this.elements;
    }

    public void resetModel() {
        this.questions = null;
        this.decisions = null;
        this.integerTypes = null;
        this.restrictions = null;
        this.conditions = null;
        this.components = null;
        this.styles = null;
        this.styleVariations = null;
        this.implementations = null;
        this.views = null;
    }

    public Set<ArchitecturalView> getViews() throws DomainException {
        if (this.views == null) {
            this.views = DomainController.getInstance().getAllViews();
        }
        return this.views;
    }

    public boolean existsVariation(StyleVariation var) {
        return this.styleVariations.contains(var);
    }
}

