/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domain.domainModel.decision;

import java.util.HashSet;
import java.util.Set;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Restriction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.DecisionAction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decisionEffect.DecisionEffect;

public class Decision {
    private Long id;
    private String name;
    private String description;
    private Set<DecisionEffect> decisionEffects;
    private Set<Restriction> restrictedBy;
    private Set<DecisionAction> actions;

    public Decision() {
        this.decisionEffects = new HashSet<DecisionEffect>();
        this.restrictedBy = new HashSet<Restriction>();
        this.actions = new HashSet<DecisionAction>();
    }

    public Decision(String n) {
        this.name = n;
        this.decisionEffects = new HashSet<DecisionEffect>();
        this.restrictedBy = new HashSet<Restriction>();
        this.actions = new HashSet<DecisionAction>();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public Set<DecisionEffect> getDecisionEffects() {
        return this.decisionEffects;
    }

    public void setDecisionEffects(Set<DecisionEffect> de) {
        this.decisionEffects = de;
    }

    public void addDecisionEffect(DecisionEffect de) {
        this.decisionEffects.add(de);
        de.setDecision(this);
    }

    public void removeDecisionEffect(DecisionEffect de) {
        this.decisionEffects.remove(de);
    }

    public void removeAllEffects() {
        this.decisionEffects.clear();
    }

    public Set<Restriction> getRestrictedBy() {
        return this.restrictedBy;
    }

    public void addRestriction(Restriction r) {
        this.restrictedBy.add(r);
    }

    public void setRestrictedBy(Set<Restriction> restrictedBy) {
        this.restrictedBy = restrictedBy;
    }

    public Set<DecisionAction> getActions() {
        return this.actions;
    }

    public void setActions(Set<DecisionAction> actions) {
        this.actions = actions;
    }

    public void addAction(DecisionAction act) {
        this.actions.add(act);
        act.setDecision(this);
    }

    public void removeDecisionAction(DecisionAction decAction) {
        this.actions.remove(decAction);
    }

    public void removeAllActions() {
        this.actions.clear();
    }

    public boolean equals(Object d) {
        if (!(d instanceof Decision)) {
            return false;
        }
        return this.id.equals(((Decision)d).getId());
    }

    public int hashCode() {
        return this.id == null ? System.identityHashCode(this) : this.id.hashCode();
    }

    public void remove() {
        for (DecisionAction da : this.actions) {
            da.remove();
        }
        for (DecisionEffect de : this.decisionEffects) {
            de.remove();
        }
        for (Restriction r : this.restrictedBy) {
            r.removeDecision(this);
        }
        this.restrictedBy.clear();
    }
}

