/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domain.domainModel.element;

import java.util.HashSet;
import java.util.Set;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Restriction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.Decision;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.DecisionAction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalView;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.PropertyValue;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.persistence.HibernateController;

public abstract class Element {
    private Long id;
    private String name;
    private String description;
    private Set<Restriction> restrictions;
    private Set<PropertyValue> propertyValues;
    private Set<DecisionAction> decisionActions;
    private Set<Element> relatedElements;
    private Set<Element> isRelatedWith;
    private Set<Element> childElements;
    private Element parentElement;
    private ArchitecturalView architecturalView;

    public Element() {
        this.decisionActions = new HashSet<DecisionAction>();
        this.restrictions = new HashSet<Restriction>();
        this.propertyValues = new HashSet<PropertyValue>();
        this.relatedElements = new HashSet<Element>();
        this.isRelatedWith = new HashSet<Element>();
        this.childElements = new HashSet<Element>();
    }

    public Element(String n) {
        this.name = n;
        this.decisionActions = new HashSet<DecisionAction>();
        this.restrictions = new HashSet<Restriction>();
        this.propertyValues = new HashSet<PropertyValue>();
        this.relatedElements = new HashSet<Element>();
        this.isRelatedWith = new HashSet<Element>();
        this.childElements = new HashSet<Element>();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long i) {
        this.id = i;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public Set<DecisionAction> getDecisionActions() {
        return this.decisionActions;
    }

    public void setDecisionActions(Set<DecisionAction> d) {
        this.decisionActions = d;
    }

    public Set<Restriction> getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(Set<Restriction> restrictions) {
        this.restrictions = restrictions;
    }

    public void addDecisionAction(DecisionAction d) {
        this.decisionActions.add(d);
        d.setElement(this);
    }

    public void removeDecisionAction(DecisionAction d) {
        this.decisionActions.remove(d);
    }

    public void addRestriction(Restriction r) {
        this.restrictions.add(r);
    }

    public void removeRestriction(Restriction r) {
        this.restrictions.remove(r);
    }

    public Set<PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    public void setPropertyValues(Set<PropertyValue> propertyValues) {
        this.propertyValues = propertyValues;
    }

    public void addPropertyValue(PropertyValue pv) {
        this.propertyValues.add(pv);
        pv.setElement(this);
    }

    public void removePropertyValue(PropertyValue pv) {
        this.propertyValues.remove(pv);
    }

    public void removeAllValues() {
        this.propertyValues.clear();
    }

    public Set<Element> getRelatedElements() {
        return this.relatedElements;
    }

    public void setRelatedElements(Set<Element> relatedElements) {
        this.relatedElements = relatedElements;
    }

    public void addRelatedElement(Element el) {
        this.relatedElements.add(el);
        el.addRelatedWith(this);
    }

    public void removeRelatedElement(Element el) {
        this.relatedElements.remove(el);
    }

    public void clearRelatedElements() {
        this.relatedElements.clear();
    }

    public Set<Element> getIsRelatedWith() {
        return this.isRelatedWith;
    }

    public void setIsRelatedWith(Set<Element> isRelatedWith) {
        this.isRelatedWith = isRelatedWith;
    }

    public void addRelatedWith(Element el) {
        this.isRelatedWith.add(el);
    }

    public void removeRelatedWith(Element el) {
        this.isRelatedWith.remove(el);
    }

    public Set<Element> getChildElements() {
        return this.childElements;
    }

    public void setChildElements(Set<Element> childElements) {
        this.childElements = childElements;
    }

    public void addChildElement(Element el) {
        this.childElements.add(el);
        el.setParentElement(this);
    }

    public void removeChildElement(Element el) {
        this.childElements.remove(el);
    }

    public boolean hasChildren() {
        return !this.childElements.isEmpty();
    }

    public Element getParentElement() {
        return this.parentElement;
    }

    public void setParentElement(Element parentElement) {
        this.parentElement = parentElement;
    }

    public ArchitecturalView getArchitecturalView() {
        return this.architecturalView;
    }

    public void setArchitecturalView(ArchitecturalView architecturalView) {
        this.architecturalView = architecturalView;
    }

    public boolean equals(Object e) {
        if (!(e instanceof Element)) {
            return false;
        }
        return this.id.equals(((Element)e).getId());
    }

    public int hashCode() {
        return this.id == null ? System.identityHashCode(this) : this.id.hashCode();
    }

    public void remove(Set<Decision> emptyDecisions) throws DomainException {
        for (DecisionAction decAction : this.decisionActions) {
            decAction.removeToDecision(emptyDecisions);
        }
        for (Element el : this.isRelatedWith) {
            el.removeRelatedElement(this);
        }
        this.isRelatedWith.clear();
        for (Restriction r : this.restrictions) {
            r.remove();
        }
        this.restrictions.clear();
        for (PropertyValue value : this.propertyValues) {
            value.removeToProperty();
        }
        this.propertyValues.clear();
        for (Element el : this.relatedElements) {
            el.removeRelatedWith(this);
        }
        this.relatedElements.clear();
        this.removeOther();
    }

    public void updateOnViewChange() {
        HashSet<Element> toRemoveRelatedWith = new HashSet<Element>();
        for (Element el : this.isRelatedWith) {
            if (!el.getArchitecturalView().equals(this.architecturalView)) continue;
            toRemoveRelatedWith.add(el);
            el.removeRelatedElement(this);
            HibernateController.beginTransaction();
            HibernateController.update(el);
            HibernateController.commitTransaction();
        }
        for (Element el : toRemoveRelatedWith) {
            this.isRelatedWith.remove(el);
        }
        this.updateOnViewChangeSpecific();
    }

    public void updateOnViewChangeHard() {
        this.updateOnViewChange();
        HashSet<Element> toRemoveRelated = new HashSet<Element>();
        for (Element el : this.relatedElements) {
            if (!el.getArchitecturalView().equals(this.architecturalView)) continue;
            toRemoveRelated.add(el);
            el.removeRelatedWith(this);
        }
        for (Element el : toRemoveRelated) {
            this.relatedElements.remove(el);
        }
        this.updateOnViewChangeHardSpecific();
    }

    public void removeAllRestrictions() {
        this.restrictions.clear();
    }

    public boolean cyclesOnRelatedElements(Set<Element> relatedElements) {
        HashSet<Element> visitedElements = new HashSet<Element>();
        HashSet<Element> onStackElements = new HashSet<Element>();
        return this.cyclesOnRelatedElementsRecursive(this, visitedElements, onStackElements, relatedElements);
    }

    public boolean cyclesOnRelatedElementsRecursive(Element current, Set<Element> visitedElements, Set<Element> onStackElements, Set<Element> children) {
        visitedElements.add(current);
        onStackElements.add(current);
        for (Element e : children) {
            if (!(!visitedElements.contains(e) ? this.cyclesOnRelatedElementsRecursive(e, visitedElements, onStackElements, e.getRelatedElements()) : onStackElements.contains(e))) continue;
            return true;
        }
        onStackElements.remove(current);
        return false;
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.getType() + ")";
    }

    public abstract void removeOther() throws DomainException;

    public abstract String getIconPath();

    public abstract void updateOnViewChangeSpecific();

    public abstract void updateOnViewChangeHardSpecific();

    public abstract String getType();
}

