/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domain.domainModel.element;

import java.util.HashSet;
import java.util.Set;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Component;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.persistence.HibernateController;

public class Implementation
extends Element {
    public static String ICON_PATH = "implementationIcon_16x16.png";
    private Set<Component> components = new HashSet<Component>();

    public Set<Component> getComponents() {
        return this.components;
    }

    public void setComponents(Set<Component> components) {
        this.components = components;
    }

    public void removeComponent(Component c) {
        this.components.remove(c);
    }

    public void addComponent(Component c) {
        this.components.add(c);
    }

    public void clearComponents() {
        this.components.clear();
    }

    @Override
    public void removeOther() throws DomainException {
        for (Component c : this.components) {
            c.removeImplementableWith(this);
        }
        this.components.clear();
    }

    @Override
    public String getIconPath() {
        return ICON_PATH;
    }

    @Override
    public void updateOnViewChangeSpecific() {
        for (Component c : this.components) {
            c.removeImplementableWith(this);
            HibernateController.beginTransaction();
            HibernateController.update(c);
            HibernateController.commitTransaction();
        }
        this.components.clear();
    }

    @Override
    public void updateOnViewChangeHardSpecific() {
    }

    @Override
    public String getType() {
        return "Implementation";
    }
}

