/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domain.domainModel.element;

import java.util.HashSet;
import java.util.Set;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Component;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.StyleVariation;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.persistence.HibernateController;

public class Style
extends Element {
    public static String ICON_PATH = "styleIcon_16x16.png";
    private Set<StyleVariation> styleVariations = new HashSet<StyleVariation>();
    private Set<Component> components = new HashSet<Component>();

    public Set<StyleVariation> getStyleVariations() {
        return this.styleVariations;
    }

    public void setStyleVariations(Set<StyleVariation> styleVariations) {
        this.styleVariations = styleVariations;
    }

    public void addStyleVariation(StyleVariation sv) {
        this.styleVariations.add(sv);
        sv.setVariationFor(this);
    }

    public void removeStyleVariation(StyleVariation sv) {
        this.styleVariations.remove(sv);
    }

    public Set<Component> getComponents() {
        return this.components;
    }

    public void setComponents(Set<Component> components) {
        this.components = components;
    }

    public void addComponent(Component c) {
        this.components.add(c);
    }

    public void removeComponent(Component c) {
        this.components.remove(c);
    }

    @Override
    public void removeOther() throws DomainException {
        for (StyleVariation var : this.styleVariations) {
            var.removeStyle();
        }
        this.styleVariations.clear();
        for (Component comp : this.components) {
            comp.removeStyle(this);
        }
        this.components.clear();
    }

    @Override
    public String getIconPath() {
        return ICON_PATH;
    }

    @Override
    public void updateOnViewChangeSpecific() {
        for (Component comp : this.components) {
            comp.removeStyle(this);
            HibernateController.beginTransaction();
            HibernateController.update(comp);
            HibernateController.commitTransaction();
        }
        this.components.clear();
    }

    @Override
    public void updateOnViewChangeHardSpecific() {
    }

    @Override
    public String getType() {
        return "Style";
    }
}

