/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.domain.domainModel.property;

import java.util.HashSet;
import java.util.Set;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Condition;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.PropertyValue;
import upc.gessi.architech.hibernatehelper.domain.domainModel.propertyRule.PropertyRule;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;

public class ElementProperty {
    private Long id;
    private String name;
    private String description;
    private DataType type;
    private Set<Condition> conditions;
    private Set<PropertyValue> propertyValues;

    public ElementProperty() {
        this.conditions = new HashSet<Condition>();
        this.propertyValues = new HashSet<PropertyValue>();
    }

    public ElementProperty(String n, DataType t) {
        this.name = n;
        this.type = t;
        this.conditions = new HashSet<Condition>();
        this.propertyValues = new HashSet<PropertyValue>();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType t) {
        this.type = t;
    }

    public Set<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(Set<Condition> c) {
        this.conditions = c;
    }

    public void addCondition(Condition c) {
        this.conditions.add(c);
        c.setProperty(this);
    }

    public void removeCondition(Condition c) {
        this.conditions.remove(c);
    }

    public Set<PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    public void setPropertyValues(Set<PropertyValue> propertyValues) {
        this.propertyValues = propertyValues;
    }

    public void addPropertyValue(PropertyValue value) {
        this.propertyValues.add(value);
        value.setProperty(this);
    }

    public void removePropertyValue(PropertyValue pv) {
        this.propertyValues.remove(pv);
    }

    public boolean equals(Object p) {
        if (!(p instanceof ElementProperty)) {
            return false;
        }
        return this.id.equals(((ElementProperty)p).getId());
    }

    public int hashCode() {
        return this.id == null ? System.identityHashCode(this) : this.id.hashCode();
    }

    public void remove() throws DomainException {
        this.type.removeProperty(this);
        for (Condition c : this.conditions) {
            c.remove();
        }
        this.conditions.clear();
        for (PropertyValue value : this.propertyValues) {
            value.removeToElement();
        }
        this.propertyValues.clear();
    }

    public void removeValues() {
        for (PropertyValue value : this.propertyValues) {
            value.removeToElement();
        }
        this.propertyValues.clear();
    }

    public void removeAllPropertyRules() {
        HashSet<Condition> propertyRules = new HashSet<Condition>();
        for (Condition c : this.conditions) {
            if (!(c instanceof PropertyRule)) continue;
            propertyRules.add(c);
        }
        for (Condition pr : propertyRules) {
            this.conditions.remove(pr);
        }
    }
}

