/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.hibernatehelper.persistence;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;

public class HibernateController {
    public static String DATABASE_NAME = "db";
    private static Map<String, SessionFactory> sessionFactories = new HashMap<String, SessionFactory>();
    private static SessionFactory currentSessionFactory = null;
    private static Session session;
    private static Transaction tx;

    public static void initialize(String location, String user, String pass, boolean create) {
        if (!sessionFactories.containsKey(location)) {
            HibernateController.buildSession(location, HibernateController.buildConfiguration(location, user, pass, create));
        }
        currentSessionFactory = sessionFactories.get(location);
    }

    private static Configuration buildConfiguration(String location, String user, String pass, boolean create) {
        Configuration cfg = new Configuration();
        cfg.configure("hibernate.cfg.xml");
        cfg.setProperty("hibernate.connection.url", "jdbc:h2:" + location + "/" + DATABASE_NAME);
        cfg.setProperty("hiberante.connection.username", user);
        cfg.setProperty("hibernate.connection.password", pass);
        if (create) {
            cfg.setProperty("hibernate.hbm2ddl.auto", "create");
        }
        return cfg;
    }

    private static void buildSession(String location, Configuration cfg) {
        sessionFactories.put(location, cfg.buildSessionFactory());
    }

    public static Session getSession() {
        if (session == null) {
            HibernateController.openSession();
        }
        return session;
    }

    public static void openSession() {
        session = currentSessionFactory.openSession();
    }

    public static void closeSession() {
        if (session != null) {
            session.close();
            session = null;
        }
    }

    public static void beginTransaction() {
        if (tx == null) {
            tx = HibernateController.getSession().beginTransaction();
        }
    }

    public static void commitTransaction() {
        if (tx != null) {
            tx.commit();
            tx = null;
        }
    }

    public static void rollback() {
        try {
            if (tx != null) {
                tx.rollback();
            }
        }
        catch (HibernateException hibernateException) {}
    }

    public static void flush() {
        HibernateController.getSession().flush();
    }

    public static void closeConnection(String location) {
        SessionFactory sessionToClose = sessionFactories.remove(location);
        if (sessionToClose != null) {
            sessionToClose.getCurrentSession().close();
            sessionToClose.close();
        }
    }

    public static void save(Object o) {
        HibernateController.getSession().save(o);
    }

    public static void update(Object o) {
        try {
            HibernateController.getSession().update(o);
        }
        catch (NonUniqueObjectException nonUniqueObjectException) {
            Object o2 = HibernateController.getSession().merge(o);
            HibernateController.getSession().update(o2);
        }
    }

    public static void delete(Object o) {
        HibernateController.getSession().delete(o);
    }
}

