/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.PlugInManagement;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ArchiTechProjectSupport {
    public static final String CONNECTION_FILE_NAME = "DB_connection.xml";

    public static IProject createProject(String projectName, URI location, String dbLocation, String dbUser, String dbPass) {
        Assert.isNotNull((Object)projectName);
        Assert.isTrue((projectName.trim().length() > 0 ? 1 : 0) != 0);
        IProject project = ArchiTechProjectSupport.createBaseProject(projectName, location);
        try {
            ArchiTechProjectSupport.addNature(project);
            ArchiTechProjectSupport.createStructrue(project, dbLocation, dbUser, dbPass);
        }
        catch (CoreException e) {
            e.printStackTrace();
            project = null;
        }
        return project;
    }

    private static IProject createBaseProject(String projectName, URI location) {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!newProject.exists()) {
            URI projectLocation = location;
            IProjectDescription desc = newProject.getWorkspace().newProjectDescription(newProject.getName());
            if (location != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(location)) {
                projectLocation = null;
            }
            desc.setLocationURI(projectLocation);
            try {
                newProject.create(desc, null);
                if (!newProject.isOpen()) {
                    newProject.open(null);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return newProject;
    }

    private static void addNature(IProject project) throws CoreException {
        if (!project.hasNature("architech.ProjectNature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "architech.ProjectNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
    }

    private static void createStructrue(IProject project, String location, String user, String pass) {
        IFile databaseFile = project.getFile((IPath)new Path(CONNECTION_FILE_NAME));
        if (!databaseFile.exists()) {
            try {
                databaseFile.create(ArchiTechProjectSupport.getDataBaseFileInitialContents(location, user, pass), false, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        try {
            File f = new File(location);
            f.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static InputStream getDataBaseFileInitialContents(String location, String user, String pass) {
        String xmlTemplate = "<?xml version='1.0' encoding='utf-8'?>\n\n<database-connection>\n<path>" + location + "</path>\n" + "<user>" + user + "</user>\n" + "<pass>" + pass + "</pass>\n" + "</database-connection>\n";
        return new ByteArrayInputStream(xmlTemplate.getBytes());
    }
}

