/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.PlugInManagement.newWizard;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import upc.gessi.architech.PlugInManagement.newWizard.NewProjectWizard;

public class DatabaseConnectionPageNewWizard
extends WizardPage {
    private final String DEFAULT_USER = "test";
    private final String DEFAULT_PASS = "test";
    private Text locationText;
    private Text userText;
    private Text passText;
    private Button defaultCheck;
    private Button createCheck;
    private Button browseButton;
    private IPath projectPath;
    private Listener fieldModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = DatabaseConnectionPageNewWizard.this.validPage();
            DatabaseConnectionPageNewWizard.this.setPageComplete(valid);
        }
    };
    String location = "";
    String user = "";
    String pass = "";

    public DatabaseConnectionPageNewWizard(String pageName) {
        super(pageName);
    }

    public DatabaseConnectionPageNewWizard(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        this.projectPath = ((NewProjectWizard)this.getWizard()).getProjectPath();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.defaultCheck = new Button(composite, 32);
        this.defaultCheck.setText("Use default connection");
        this.defaultCheck.setSelection(true);
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 3;
        this.defaultCheck.setLayoutData((Object)gd1);
        this.defaultCheck.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                boolean selected = DatabaseConnectionPageNewWizard.this.defaultCheck.getSelection();
                DatabaseConnectionPageNewWizard.this.enableWidgets(!selected);
                if (selected) {
                    DatabaseConnectionPageNewWizard.this.setDefaults();
                } else {
                    DatabaseConnectionPageNewWizard.this.setCustom();
                    DatabaseConnectionPageNewWizard.this.setPageComplete(DatabaseConnectionPageNewWizard.this.validPage());
                }
            }
        });
        Label locationLabel = new Label(composite, 0);
        locationLabel.setText("Database location:");
        this.locationText = new Text(composite, 2048);
        this.locationText.setText(this.getDefaultLocationPath());
        this.locationText.addListener(24, this.fieldModifyListener);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        this.locationText.setLayoutData((Object)gd2);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dd = new DirectoryDialog(DatabaseConnectionPageNewWizard.this.locationText.getShell(), 0x10000000);
                dd.setText("Database directory");
                dd.setMessage("Select the location to store the DataBase files");
                String db_path = dd.open();
                if (db_path != null) {
                    DatabaseConnectionPageNewWizard.this.locationText.setText(TextProcessor.process((String)db_path));
                }
            }
        });
        Label userLabel = new Label(composite, 0);
        userLabel.setText("User:");
        this.userText = new Text(composite, 2048);
        GridData gd3 = new GridData(4, 0x1000000, true, false);
        this.userText.setText("test");
        this.userText.addListener(24, this.fieldModifyListener);
        gd3.horizontalSpan = 2;
        this.userText.setLayoutData((Object)gd3);
        Label passLabel = new Label(composite, 0);
        passLabel.setText("Password:");
        this.passText = new Text(composite, 2048);
        GridData gd4 = new GridData(4, 0x1000000, true, false);
        this.passText.setText("test");
        this.passText.addListener(24, this.fieldModifyListener);
        this.passText.setEchoChar('*');
        gd4.horizontalSpan = 2;
        this.passText.setLayoutData((Object)gd4);
        this.createCheck = new Button(composite, 32);
        GridData gd5 = new GridData(0x1000000, 0x1000000, false, false);
        gd5.horizontalSpan = 3;
        this.createCheck.setLayoutData((Object)gd5);
        this.createCheck.setText("Create a new Database on the specified location");
        this.createCheck.setSelection(true);
        this.enableWidgets(false);
        this.setControl((Control)composite);
        this.setPageComplete(this.validPage());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.projectPath = ((NewProjectWizard)this.getWizard()).getProjectPath();
            if (this.isUsingDefaults()) {
                this.locationText.setText(this.getDefaultLocationPath());
            }
        }
        super.setVisible(visible);
    }

    public String getLocation() {
        return this.locationText.getText();
    }

    public String getUser() {
        return this.userText.getText();
    }

    public String getPass() {
        return this.passText.getText();
    }

    public boolean isCreate() {
        return this.createCheck.getSelection();
    }

    private boolean validPage() {
        return this.isNotEmpty(this.locationText) && this.isNotEmpty(this.userText) && this.isNotEmpty(this.passText);
    }

    private boolean isNotEmpty(Text text) {
        String content = text.getText();
        return content != null && !content.equals("");
    }

    public boolean isUsingDefaults() {
        return this.defaultCheck.getSelection();
    }

    private void enableWidgets(boolean enabled) {
        this.locationText.setEnabled(enabled);
        this.userText.setEnabled(enabled);
        this.passText.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    private void setDefaults() {
        this.location = this.locationText.getText();
        this.locationText.setText(this.getDefaultLocationPath());
        this.user = this.userText.getText();
        this.userText.setText("test");
        this.pass = this.passText.getText();
        this.passText.setText("test");
    }

    private void setCustom() {
        this.locationText.setText(this.location);
        this.userText.setText(this.user);
        this.passText.setText(this.pass);
    }

    public String getDefaultLocationPath() {
        return this.projectPath.append("database").toOSString();
    }
}

