/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.PlugInManagement.newWizard;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import upc.gessi.architech.Activator;
import upc.gessi.architech.PlugInManagement.ArchiTechProjectSupport;
import upc.gessi.architech.PlugInManagement.newWizard.DatabaseConnectionPageNewWizard;

public class NewProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    Wizard Pages;
    private WizardNewProjectCreationPage mainPage;
    private DatabaseConnectionPageNewWizard connectionPage;
    private IConfigurationElement configurationElement;

    public NewProjectWizard() {
        this.setWindowTitle("New ArchiTech Project");
        this.setDefaultPageImageDescriptor(Activator.getImageDescriptor("newWizardIcon.png"));
    }

    public boolean performFinish() {
        boolean result = true;
        try {
            String name = this.mainPage.getProjectName();
            URI location = null;
            String dbLocation = this.connectionPage.getLocation();
            String dbUser = this.connectionPage.getUser();
            String dbPass = this.connectionPage.getPass();
            if (!this.mainPage.useDefaults()) {
                location = this.mainPage.getLocationURI();
            }
            if (this.connectionPage.isUsingDefaults() && !this.connectionPage.getLocation().contains(name)) {
                dbLocation = this.getProjectPath().append("database").toOSString();
            }
            IProject p = ArchiTechProjectSupport.createProject(name, location, dbLocation, dbUser, dbPass);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
            Activator.connectToDatabase(p.getName(), this.connectionPage.isCreate());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("Main Information Page");
        this.mainPage.setTitle("Basic Information");
        this.mainPage.setDescription("Complete the information required to create the project");
        this.addPage((IWizardPage)this.mainPage);
        this.connectionPage = new DatabaseConnectionPageNewWizard("Database Connection");
        this.connectionPage.setTitle("Database Connection Settings");
        this.connectionPage.setDescription("Complete the information required to access the database");
        this.addPage((IWizardPage)this.connectionPage);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configurationElement = config;
    }

    public String getProjectName() {
        return this.mainPage.getProjectName();
    }

    public IPath getProjectPath() {
        IPath path = this.mainPage.getLocationPath();
        if (this.mainPage.useDefaults()) {
            path = path.append(this.mainPage.getProjectName());
        }
        return path;
    }
}

