/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.dnd;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import upc.gessi.architech.dnd.ElementTransfer;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.views.elements.ElementsView;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public class ElementsTreeDropAdapter
extends ViewerDropAdapter {
    TreeViewer viewer;
    ElementsView view;

    public ElementsTreeDropAdapter(TreeViewer viewer, ElementsView view) {
        super((Viewer)viewer);
        this.viewer = viewer;
        this.view = view;
    }

    public boolean performDrop(Object data) {
        Element toDrop;
        Element target;
        block8: {
            block9: {
                block7: {
                    target = (Element)this.getCurrentTarget();
                    toDrop = (Element)data;
                    TreeViewer viewer = (TreeViewer)this.getViewer();
                    try {
                        if (target == null || !target.equals((Object)toDrop) && this.validDrop(target, toDrop)) break block7;
                        this.setErrorMessage("An element cannot be specialized into one of its specialized elements. It neither can be specialized into itself");
                        return false;
                    }
                    catch (DomainException e) {
                        if (e.getCause() == null) {
                            this.showError("Error", e.getMessage());
                        } else {
                            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, viewer.getControl().getShell());
                            dd.open();
                        }
                        return false;
                    }
                }
                if (target == null) break block8;
                if (toDrop.getClass().equals(target.getClass())) break block9;
                this.setErrorMessage("An element can only be specialized into an element of the same type");
                return false;
            }
            if (toDrop.getArchitecturalView().equals((Object)target.getArchitecturalView())) break block8;
            this.setErrorMessage("An element can only be specialized into an element of the same view");
            return false;
        }
        DomainController.getInstance().changeElementParent(toDrop, target);
        this.view.refresh();
        return true;
    }

    public boolean validateDrop(Object target, int op, TransferData type) {
        return ElementTransfer.getInstance().isSupportedType(type);
    }

    public boolean validDrop(Element target, Element actual) {
        for (Element child : actual.getChildElements()) {
            if (this.validDrop(target, child)) continue;
            return false;
        }
        return !target.equals((Object)actual);
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.viewer.getControl().getShell(), (String)title, (String)message);
    }

    private void setErrorMessage(String message) {
        this.view.setStatusError(message);
        Thread th = new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Display display = ElementsTreeDropAdapter.this.viewer.getControl().getDisplay();
                if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).ElementsTreeDropAdapter.this.view.removeStatusError();
                        }
                    });
                }
            }
        };
        th.start();
    }
}

