/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.dnd;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import upc.gessi.architech.dnd.QualityAttributeTransfer;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.QualityAttribute;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public class QualityAttributeTreeDropAdapter
extends ViewerDropAdapter {
    TreeViewer viewer;

    public QualityAttributeTreeDropAdapter(TreeViewer viewer) {
        super((Viewer)viewer);
        this.viewer = viewer;
    }

    public boolean performDrop(Object data) {
        TreeViewer viewer;
        QualityAttribute toDrop;
        QualityAttribute target;
        block5: {
            target = (QualityAttribute)this.getCurrentTarget();
            toDrop = (QualityAttribute)data;
            viewer = (TreeViewer)this.getViewer();
            try {
                if (target == null || !target.equals((Object)toDrop) && this.validDrop(target, toDrop)) break block5;
                return false;
            }
            catch (DomainException e) {
                if (e.getCause() == null) {
                    this.showError("Error", e.getMessage());
                } else {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, viewer.getControl().getShell());
                    dd.open();
                }
                return false;
            }
        }
        DomainController.getInstance().changeQualityAttributeParent(toDrop, target);
        viewer.refresh();
        return true;
    }

    public boolean validateDrop(Object target, int op, TransferData type) {
        return QualityAttributeTransfer.getInstance().isSupportedType(type) && (target instanceof QualityAttribute || target == null);
    }

    public boolean validDrop(QualityAttribute target, QualityAttribute actual) {
        for (QualityAttribute child : actual.getChildAttributes()) {
            if (this.validDrop(target, child)) continue;
            return false;
        }
        return !target.equals((Object)actual);
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.viewer.getControl().getShell(), (String)title, (String)message);
    }
}

