/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import upc.gessi.architech.Activator;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.ExploreDialogRefresher;
import upc.gessi.architech.gui.dialogs.element.ComponentDialog;
import upc.gessi.architech.gui.dialogs.element.ImplementationDialog;
import upc.gessi.architech.gui.dialogs.element.StyleDialog;
import upc.gessi.architech.gui.dialogs.element.StyleVariationDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.ModelChangeListener;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.DecisionAction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Component;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Implementation;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.PropertyValue;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Style;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.StyleVariation;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.Constants;
import upc.gessi.architech.utils.StackTraceUtil;
import upc.gessi.architech.utils.TupleColumnDescriptor;

public class ExploreDialog
extends TitleAreaDialog
implements ModelChangeListener {
    public static final int NO_MENU = -1;
    public static final int GENERIC_ELEMENT_MENU = 0;
    public static final int COMPONENT_MENU = 1;
    public static final int STYLE_MENU = 2;
    public static final int STYLE_VARIATION_MENU = 3;
    public static final int IMPLEMENTATION_MENU = 4;
    private TableViewer viewer;
    private String title;
    private String message;
    private String iconPath;
    private Object[] input;
    private int width;
    private ViewerSorter sorter;
    private List<TupleColumnDescriptor> columns;
    private ExploreDialogRefresher refresher;
    private int popUpMenuType;
    private boolean canEdit;
    private Action exploreValues;
    private Action exploreActions;
    private Action exploreRelated;
    private Action exploreRelatedInverse;
    private Action exploreComposible;
    private Action exploreComposibleInverse;
    private Action exploreConnectible;
    private Action exploreConnectibleInverse;
    private Action exploreApplyToStyle;
    private Action exploreApplyToStyleVariation;
    private Action exploreImplementableWith;
    private Action exploreImplementableWithInverse;
    private Action exploreApplyToStyleInverse;
    private Action exploreVariationForInverse;
    private Action exploreApplyToStyleVariationInverse;
    private Action exploreIncompatibleWith;
    private Shell shell;

    public ExploreDialog(Shell parentShell, String title, String message, String iconPath, List<TupleColumnDescriptor> columns, int width) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.iconPath = iconPath;
        this.columns = columns;
        this.width = width;
        this.popUpMenuType = -1;
        this.canEdit = false;
        this.setShellStyle(2160);
        this.setBlockOnOpen(false);
        DomainController.getInstance().registerListener((ModelChangeListener)this);
        this.createActions();
    }

    public void setInput(Object[] input) {
        this.input = input;
    }

    public void setSorter(ViewerSorter sorter) {
        this.sorter = sorter;
    }

    public void setRefresher(ExploreDialogRefresher refresher) {
        this.refresher = refresher;
    }

    public void setMenuType(int menuType) {
        this.popUpMenuType = menuType;
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    protected Point getInitialSize() {
        Point p = new Point(this.width + 35, 400);
        return p;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.canEdit) {
            Button editButton = new Button(parent, 8);
            GridData gd2 = new GridData(131072, 0x1000000, false, false);
            gd2.widthHint = 90;
            editButton.setText("Edit");
            editButton.setLayoutData((Object)gd2);
            editButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                }

                public void widgetSelected(SelectionEvent event) {
                    if (!ExploreDialog.this.viewer.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)ExploreDialog.this.viewer.getSelection();
                        Element selectedElement = (Element)sel.getFirstElement();
                        try {
                            if (selectedElement instanceof Component) {
                                ComponentDialog cd = new ComponentDialog(ExploreDialog.this.shell, (Component)selectedElement);
                                cd.open();
                            } else if (selectedElement instanceof Style) {
                                StyleDialog sd = new StyleDialog(ExploreDialog.this.shell, (Style)selectedElement);
                                sd.open();
                            } else if (selectedElement instanceof StyleVariation) {
                                StyleVariationDialog svd = new StyleVariationDialog(ExploreDialog.this.shell, (StyleVariation)selectedElement);
                                svd.open();
                            } else if (selectedElement instanceof Implementation) {
                                ImplementationDialog id = new ImplementationDialog(ExploreDialog.this.shell, (Implementation)selectedElement);
                                id.open();
                            }
                            ExploreDialog.this.refresh();
                            Activator.refreshElementsViewer();
                        }
                        catch (DomainException e) {
                            if (e.getCause() == null) {
                                ExploreDialog.this.showError("Error", e.getMessage());
                            } else {
                                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                                dd.open();
                            }
                        }
                        catch (Exception e) {
                            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                            dd.open();
                        }
                    }
                }
            });
        }
        this.createButton(parent, 1, "Close", true);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.shell = this.getShell();
        this.shell.setText(this.title);
        this.setTitle(this.title);
        this.setMessage(this.message);
        if (this.iconPath != null) {
            this.setTitleImage(Activator.getImageDescriptor(this.iconPath).createImage());
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createViewer(contents);
        return contents;
    }

    private void createViewer(Composite content) {
        try {
            content.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            content.setLayout((Layout)layout);
            this.viewer = new TableViewer(content, 68352);
            this.createColumns(content);
            this.viewer.getTable().setHeaderVisible(true);
            this.viewer.getTable().setLinesVisible(true);
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.viewer.setSorter(this.sorter);
            this.viewer.setInput((Object)this.input);
            GridData gd = new GridData(4, 4, true, true);
            this.viewer.getTable().setLayoutData((Object)gd);
            if (this.popUpMenuType == 0) {
                this.setGenericElementPopUpMenu();
            } else if (this.popUpMenuType == 1) {
                this.setComponentPopUpMenu();
            } else if (this.popUpMenuType == 2) {
                this.setStylePopUpMenu();
            } else if (this.popUpMenuType == 3) {
                this.setStyleVariationPopUpMenu();
            } else if (this.popUpMenuType == 4) {
                this.setImplementationPopUpMenu();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createColumns(Composite parent) {
        for (TupleColumnDescriptor column : this.columns) {
            TableViewerColumn col = this.createTableViewerColumn(column.name, column.index, column.width);
            col.setLabelProvider((CellLabelProvider)column.labelProvider);
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int colNumber, int width) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(width);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public boolean close() {
        DomainController.getInstance().unregisterListener((ModelChangeListener)this);
        return super.close();
    }

    public void modelChanged() {
        this.refresh();
    }

    private void refresh() {
        try {
            this.input = this.refresher.refresh();
            if (this.input == null) {
                this.setErrorMessage("The element you were exploring has been removed!!");
                this.viewer.getTable().setEnabled(false);
            }
            this.viewer.setInput((Object)this.input);
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.getShell());
            dd.open();
        }
    }

    public void setGenericElementPopUpMenu() {
        MenuManager popUpMenu = new MenuManager();
        popUpMenu.setRemoveAllWhenShown(true);
        popUpMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                if (!ExploreDialog.this.viewer.getSelection().isEmpty()) {
                    ExploreDialog.this.addExploreActionsGeneric(mgr);
                }
            }
        });
        Menu menu = popUpMenu.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    public void setComponentPopUpMenu() {
        MenuManager popUpMenu = new MenuManager();
        popUpMenu.setRemoveAllWhenShown(true);
        popUpMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                if (!ExploreDialog.this.viewer.getSelection().isEmpty()) {
                    ExploreDialog.this.addExploreActionsComponent(mgr);
                }
            }
        });
        Menu menu = popUpMenu.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    public void setStylePopUpMenu() {
        MenuManager popUpMenu = new MenuManager();
        popUpMenu.setRemoveAllWhenShown(true);
        popUpMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                if (!ExploreDialog.this.viewer.getSelection().isEmpty()) {
                    ExploreDialog.this.addExploreActionsStyle(mgr);
                }
            }
        });
        Menu menu = popUpMenu.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    public void setStyleVariationPopUpMenu() {
        MenuManager popUpMenu = new MenuManager();
        popUpMenu.setRemoveAllWhenShown(true);
        popUpMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                if (!ExploreDialog.this.viewer.getSelection().isEmpty()) {
                    ExploreDialog.this.addExploreActionsStyleVariation(mgr);
                }
            }
        });
        Menu menu = popUpMenu.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    public void setImplementationPopUpMenu() {
        MenuManager popUpMenu = new MenuManager();
        popUpMenu.setRemoveAllWhenShown(true);
        popUpMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                if (!ExploreDialog.this.viewer.getSelection().isEmpty()) {
                    ExploreDialog.this.addExploreActionsImplementation(mgr);
                }
            }
        });
        Menu menu = popUpMenu.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    public MenuManager addExploreActionsGeneric(IMenuManager mgr) {
        MenuManager g = new MenuManager("Explore");
        mgr.add((IContributionItem)g);
        g.add((IAction)this.exploreValues);
        g.add((IAction)this.exploreActions);
        g.add((IAction)this.exploreRelated);
        g.add((IAction)this.exploreRelatedInverse);
        return g;
    }

    public void addExploreActionsComponent(IMenuManager mgr) {
        MenuManager g = this.addExploreActionsGeneric(mgr);
        g.add((IAction)this.exploreComposible);
        g.add((IAction)this.exploreComposibleInverse);
        g.add((IAction)this.exploreConnectible);
        g.add((IAction)this.exploreConnectibleInverse);
        g.add((IAction)this.exploreApplyToStyle);
        g.add((IAction)this.exploreApplyToStyleVariation);
        g.add((IAction)this.exploreImplementableWith);
    }

    private void addExploreActionsImplementation(IMenuManager mgr) {
        MenuManager g = this.addExploreActionsGeneric(mgr);
        g.add((IAction)this.exploreImplementableWithInverse);
    }

    private void addExploreActionsStyle(IMenuManager mgr) {
        MenuManager g = this.addExploreActionsGeneric(mgr);
        g.add((IAction)this.exploreApplyToStyleInverse);
        g.add((IAction)this.exploreVariationForInverse);
    }

    private void addExploreActionsStyleVariation(IMenuManager mgr) {
        MenuManager g = this.addExploreActionsGeneric(mgr);
        g.add((IAction)this.exploreApplyToStyleVariationInverse);
        g.add((IAction)this.exploreIncompatibleWith);
    }

    public ExploreDialog showExploreDialogGenericElement(boolean showtype, boolean showView, Set<?> input, String title, String description) {
        LinkedList<TupleColumnDescriptor> columns = new LinkedList<TupleColumnDescriptor>();
        columns.add(new TupleColumnDescriptor("Element", 0, 120, new ColumnLabelProvider(){

            public String getText(Object element) {
                Element el = (Element)element;
                if (showtype) {
                    return el.toString();
                }
                return el.getName();
            }
        }));
        columns.add(new TupleColumnDescriptor("Description", 1, 600, new ColumnLabelProvider(){

            public String getText(Object element) {
                Element el = (Element)element;
                return el.getDescription();
            }
        }));
        if (showView) {
            columns.add(new TupleColumnDescriptor("View", 2, 120, new ColumnLabelProvider(){

                public String getText(Object element) {
                    Element el = (Element)element;
                    return el.getArchitecturalView().getName();
                }
            }));
        }
        ExploreDialog dialog = new ExploreDialog(this.getShell(), title, description, null, columns, showView ? 840 : 720);
        dialog.setInput(input.toArray());
        dialog.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                Element e1 = (Element)o1;
                Element e2 = (Element)o2;
                return e1.getName().compareToIgnoreCase(e2.getName());
            }
        });
        return dialog;
    }

    public ExploreDialog showExploreDialogStyleVariation(Set<?> input, String title, String description) {
        LinkedList<TupleColumnDescriptor> columns = new LinkedList<TupleColumnDescriptor>();
        columns.add(new TupleColumnDescriptor("Element", 0, 120, new ColumnLabelProvider(){

            public String getText(Object element) {
                StyleVariation el = (StyleVariation)element;
                return el.getName();
            }
        }));
        columns.add(new TupleColumnDescriptor("Description", 1, 600, new ColumnLabelProvider(){

            public String getText(Object element) {
                StyleVariation el = (StyleVariation)element;
                return el.getDescription();
            }
        }));
        columns.add(new TupleColumnDescriptor("Variation for", 2, 120, new ColumnLabelProvider(){

            public String getText(Object element) {
                StyleVariation el = (StyleVariation)element;
                return el.getVariationFor().getName();
            }
        }));
        ExploreDialog dialog = new ExploreDialog(this.getShell(), title, description, null, columns, 840);
        dialog.setInput(input.toArray());
        dialog.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                Element e1 = (Element)o1;
                Element e2 = (Element)o2;
                return e1.getName().compareToIgnoreCase(e2.getName());
            }
        });
        return dialog;
    }

    public void createActions() {
        this.exploreRelatedInverse = new Action("Element related with this"){

            public void run() {
                try {
                    Element selElement = (Element)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getElementById(selElement.getId());
                    ExploreDialog dialog = ExploreDialog.this.showExploreDialogGenericElement(true, true, selElement.getIsRelatedWith(), "Explore elements related with this", "these are the elements that have the selected element as a related one");
                    final Element element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Element aux = DomainController.getInstance().getElementById(element.getId());
                            if (aux == null) {
                                return null;
                            }
                            return aux.getIsRelatedWith().toArray();
                        }
                    });
                    dialog.setMenuType(0);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreRelated = new Action("Related elements"){

            public void run() {
                try {
                    Element selElement = (Element)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    final Element element = selElement = DomainController.getInstance().getElementById(selElement.getId());
                    ExploreDialog dialog = ExploreDialog.this.showExploreDialogGenericElement(true, true, selElement.getRelatedElements(), "Explore related elements", "these are the elements related to the selected element");
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Element aux = DomainController.getInstance().getElementById(element.getId());
                            if (aux == null) {
                                return null;
                            }
                            return aux.getRelatedElements().toArray();
                        }
                    });
                    dialog.setMenuType(0);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreActions = new Action("Decision actions"){

            public void run() {
                try {
                    LinkedList<TupleColumnDescriptor> columns = new LinkedList<TupleColumnDescriptor>();
                    columns.add(new TupleColumnDescriptor("Decision", 0, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            DecisionAction da = (DecisionAction)element;
                            return da.getDecision().getName();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Decision Description", 1, 600, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            DecisionAction da = (DecisionAction)element;
                            return da.getDecision().getDescription();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Action", 2, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            DecisionAction da = (DecisionAction)element;
                            return Constants.ACTION_NAMES[da.getAction()];
                        }
                    }));
                    Element selElement = (Element)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    final Element element = selElement = DomainController.getInstance().getElementById(selElement.getId());
                    ExploreDialog dialog = new ExploreDialog(ExploreDialog.this.getShell(), "Explore decision actions", "These are the actions that decisions will do over this element", null, columns, 840);
                    dialog.setInput(selElement.getDecisionActions().toArray());
                    dialog.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object o1, Object o2) {
                            DecisionAction da1 = (DecisionAction)o1;
                            DecisionAction da2 = (DecisionAction)o2;
                            return da1.getDecision().getName().compareToIgnoreCase(da2.getDecision().getName());
                        }
                    });
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Element aux = DomainController.getInstance().getElementById(element.getId());
                            if (aux == null) {
                                return null;
                            }
                            return aux.getDecisionActions().toArray();
                        }
                    });
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreValues = new Action("Property values"){

            public void run() {
                try {
                    LinkedList<TupleColumnDescriptor> columns = new LinkedList<TupleColumnDescriptor>();
                    columns.add(new TupleColumnDescriptor("Property", 0, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            PropertyValue pv = (PropertyValue)element;
                            return pv.getProperty().getName();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Property Description", 1, 600, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            PropertyValue pv = (PropertyValue)element;
                            return pv.getProperty().getDescription();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Property Type", 2, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            PropertyValue pv = (PropertyValue)element;
                            return pv.getProperty().getType().toString();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Value", 3, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            PropertyValue pv = (PropertyValue)element;
                            return pv.getValue();
                        }
                    }));
                    Element selElement = (Element)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    final Element element = selElement = DomainController.getInstance().getElementById(selElement.getId());
                    ExploreDialog dialog = new ExploreDialog(ExploreDialog.this.getShell(), "Explore property values", "These are the values that the element puts over element properties", null, columns, 960);
                    dialog.setInput(selElement.getPropertyValues().toArray());
                    dialog.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object o1, Object o2) {
                            PropertyValue pv1 = (PropertyValue)o1;
                            PropertyValue pv2 = (PropertyValue)o2;
                            return pv1.getProperty().getName().compareToIgnoreCase(pv2.getProperty().getName());
                        }
                    });
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Element aux = DomainController.getInstance().getElementById(element.getId());
                            if (aux == null) {
                                return null;
                            }
                            return aux.getPropertyValues().toArray();
                        }
                    });
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreComposible = new Action("Composible components"){

            public void run() {
                try {
                    Component selElement = (Component)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getComponentById(selElement, false);
                    ExploreDialog dialog = ExploreDialog.this.showExploreDialogGenericElement(false, false, selElement.getComposableWith(), "Explore composible components", "the selected component can be composed with the following components");
                    final Component element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Component aux = DomainController.getInstance().getComponentById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getComposableWith().toArray();
                        }
                    });
                    dialog.setMenuType(1);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreConnectible = new Action("Connectible components"){

            public void run() {
                try {
                    Component selElement = (Component)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getComponentById(selElement, false);
                    ExploreDialog dialog = ExploreDialog.this.showExploreDialogGenericElement(false, false, selElement.getConnectedTo(), "Explore connectable components", "the selected component can be connected to the following components");
                    final Component element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Component aux = DomainController.getInstance().getComponentById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getConnectedTo().toArray();
                        }
                    });
                    dialog.setMenuType(1);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreComposibleInverse = new Action("Components composable with this"){

            public void run() {
                try {
                    Component selElement = (Component)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    final Component element = selElement = DomainController.getInstance().getComponentById(selElement, false);
                    ExploreDialog dialog = ExploreDialog.this.showExploreDialogGenericElement(false, false, selElement.getComposableWithInverse(), "Explore components composable with this", "the following components can be composed with the selected one");
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Component aux = DomainController.getInstance().getComponentById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getComposableWithInverse().toArray();
                        }
                    });
                    dialog.setMenuType(1);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreConnectibleInverse = new Action("Components connectable to this"){

            public void run() {
                try {
                    Component selElement = (Component)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getComponentById(selElement, false);
                    ExploreDialog dialog = ExploreDialog.this.showExploreDialogGenericElement(false, false, selElement.getConnectedToInverse(), "Explore components connectable to this", "the following components can be connected to the selected one");
                    final Component element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Component aux = DomainController.getInstance().getComponentById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getConnectedToInverse().toArray();
                        }
                    });
                    dialog.setMenuType(1);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreApplyToStyleVariation = new Action("Style variations to which apply"){

            public void run() {
                try {
                    Component selElement = (Component)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getComponentById(selElement, false);
                    ExploreDialog dialog = ExploreDialog.this.showExploreDialogStyleVariation(selElement.getApplyTo(), "Explore style variations to which apply", "the selected component applies to the following style variations");
                    final Component element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Component aux = DomainController.getInstance().getComponentById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getApplyTo().toArray();
                        }
                    });
                    dialog.setMenuType(3);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreApplyToStyle = new Action("Styles to which apply"){

            public void run() {
                try {
                    Component selElement = (Component)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getComponentById(selElement, false);
                    ExploreDialog dialog = ExploreDialog.this.showExploreDialogGenericElement(false, false, selElement.getApplyToStyle(), "Explore styles to which apply", "the selected component applies to the following styles");
                    final Component element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Component aux = DomainController.getInstance().getComponentById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getApplyToStyle().toArray();
                        }
                    });
                    dialog.setMenuType(2);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreImplementableWith = new Action("Implementations with which can be implemented"){

            public void run() {
                try {
                    Component selElement = (Component)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getComponentById(selElement, false);
                    ExploreDialog dialog = ExploreDialog.this.showExploreDialogGenericElement(false, false, selElement.getImplementableWith(), "Explore implementations with which can be implemented", "the selected component can be implemented using the following implementations");
                    final Component element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Component aux = DomainController.getInstance().getComponentById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getImplementableWith().toArray();
                        }
                    });
                    dialog.setMenuType(4);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreImplementableWithInverse = new Action("Components implementable"){

            public void run() {
                try {
                    Implementation selElement = (Implementation)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getImplementationById(selElement, false);
                    ExploreDialog dialog = ExploreDialog.this.showExploreDialogGenericElement(false, false, selElement.getComponents(), "Explore components implementable", "these are the components which can be implemented using the selected implementation");
                    final Implementation element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Implementation aux = DomainController.getInstance().getImplementationById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getComponents().toArray();
                        }
                    });
                    dialog.setMenuType(1);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreApplyToStyleInverse = new Action("Components that apply"){

            public void run() {
                try {
                    Style selElement = (Style)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getStyleById(selElement, false);
                    ExploreDialog dialog = ExploreDialog.this.showExploreDialogGenericElement(false, false, selElement.getComponents(), "Explore components that apply", "these are the components which apply to the selected style");
                    final Style element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Style aux = DomainController.getInstance().getStyleById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getComponents().toArray();
                        }
                    });
                    dialog.setMenuType(1);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreVariationForInverse = new Action("Style variations"){

            public void run() {
                try {
                    Style selElement = (Style)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getStyleById(selElement, false);
                    ExploreDialog dialog = ExploreDialog.this.showExploreDialogGenericElement(false, false, selElement.getStyleVariations(), "Explore style variations", "the selected style has the following variations");
                    final Style element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Style aux = DomainController.getInstance().getStyleById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getStyleVariations().toArray();
                        }
                    });
                    dialog.setMenuType(3);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreApplyToStyleVariationInverse = new Action("Components that apply"){

            public void run() {
                try {
                    StyleVariation selElement = (StyleVariation)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getStyleVariationById(selElement, false);
                    ExploreDialog dialog = ExploreDialog.this.showExploreDialogGenericElement(false, false, selElement.getComponents(), "Explore components that apply", "these are the components which apply to the selected style variation");
                    final StyleVariation element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            StyleVariation aux = DomainController.getInstance().getStyleVariationById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getComponents().toArray();
                        }
                    });
                    dialog.setMenuType(1);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreIncompatibleWith = new Action("Incompatible style variations"){

            public void run() {
                try {
                    StyleVariation selElement = (StyleVariation)((IStructuredSelection)ExploreDialog.this.viewer.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getStyleVariationById(selElement, false);
                    ExploreDialog dialog = ExploreDialog.this.showExploreDialogStyleVariation(selElement.getIncompatibleWith(), "Explore incompatible style variations", "the following style variations are incompatible with the selected one");
                    final StyleVariation element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            StyleVariation aux = DomainController.getInstance().getStyleVariationById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getIncompatibleWith().toArray();
                        }
                    });
                    dialog.setMenuType(3);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ExploreDialog.this.shell);
                    dd.open();
                }
            }
        };
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }
}

