/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.constraint;

import java.util.Set;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.constraint.GenericConstraintDialog;
import upc.gessi.architech.gui.dialogs.element.GenericElementDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.ElementProperty;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleCondition;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public class ConditionDialog
extends GenericConstraintDialog {
    private Text conditionText;
    private List propertiesList;
    private TupleCondition result;
    private String nameResult;
    private static final int NUM_ERRORS_SPECIFIC = 1;
    private static final int NO_PROPERTY = 0;
    private ErrorInfo[] errorsSpecific = new ErrorInfo[1];

    public ConditionDialog(Shell parentShell, GenericElementDialog dialog) {
        super(parentShell, dialog);
        this.result = new TupleCondition();
    }

    public TupleCondition getResult() {
        return this.result;
    }

    public String getNameResult() {
        return this.nameResult;
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Condition");
        this.setTitle("Condition");
        this.setMessage("Enter the data fot this Condition");
    }

    @Override
    public void createOtherTabs(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Attributes");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Condition on the property: ");
        this.conditionText = new Text(content, 2048);
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        this.conditionText.setLayoutData((Object)gd1);
        Label label2 = new Label(content, 0);
        label2.setText("Element Property: ");
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 2;
        label2.setLayoutData((Object)gd2);
        this.propertiesList = new List(content, 2820);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.heightHint = 50;
        gd3.widthHint = 250;
        gd3.horizontalSpan = 2;
        this.propertiesList.setLayoutData((Object)gd3);
        try {
            Set properties = Model.getInstance().getElementProperties();
            for (ElementProperty p : properties) {
                this.propertiesList.add(p.getName());
            }
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.getShell());
            dd.open();
        }
        this.propertiesList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                boolean newErr;
                boolean oldErr = ((ConditionDialog)ConditionDialog.this).errorsSpecific[0].isError;
                boolean bl = newErr = ConditionDialog.this.propertiesList.getSelection().length == 0;
                if (oldErr != newErr) {
                    ((ConditionDialog)ConditionDialog.this).errorsSpecific[0].isError = newErr;
                    ConditionDialog.this.validate();
                }
            }
        });
    }

    @Override
    public void fillValuesSpecific() {
        if (this.result.propertyCondition != null) {
            this.conditionText.setText(this.result.propertyCondition);
        }
        String[] selProperty = new String[]{this.result.property};
        this.propertiesList.setSelection(selProperty);
    }

    @Override
    public void doOk(String name, boolean isNew) throws DomainException {
        String cond = this.conditionText.getText();
        String propertyName = this.propertiesList.getSelection()[0];
        this.result.propertyCondition = cond;
        this.result.property = propertyName;
        this.nameResult = name;
    }

    @Override
    public void initErrorsSpecific() {
        this.errorsSpecific[0] = new ErrorInfo("You have to select a Property", 3, this.isNew());
    }

    @Override
    public ErrorInfo[] getErrorsSpecific() {
        return this.errorsSpecific;
    }
}

