/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.dataType;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public abstract class GenericTypeDialog
extends TitleAreaDialog {
    private Text nameText;
    private Text descriptionText;
    private boolean isNew;
    private String name;
    private String desc;
    private Shell shell;
    private static final int NUM_ERRORS = 2;
    private static final int EMPTY_NAME = 0;
    private static final int ALREADY_EXISTS = 1;
    private ErrorInfo[] errors = new ErrorInfo[2];

    public GenericTypeDialog(Shell parentShell) {
        super(parentShell);
        this.isNew = true;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public GenericTypeDialog(Shell parentShell, String name, String desc) {
        super(parentShell);
        this.isNew = false;
        this.name = name;
        this.desc = desc;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point p = new Point(400, 400);
        return p;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.shell = this.getShell();
        if (this.isNew) {
            this.shell.setText("New ");
        } else {
            this.shell.setText("Edit ");
        }
        this.createContentsSpecific(this.shell);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        TabFolder tabs = new TabFolder(contents, 128);
        tabs.setLayoutData((Object)new GridData(4, 4, true, true));
        tabs.setLayout((Layout)new GridLayout());
        this.createInformationTab(tabs);
        this.createAttributesTab(tabs);
        this.initErrors();
        if (!this.isNew) {
            this.fillValues();
        }
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    private void createInformationTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Information");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Name: ");
        this.nameText = new Text(content, 2048);
        GridData gd1 = new GridData(4, 1, true, false);
        this.nameText.setLayoutData((Object)gd1);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                try {
                    boolean oldErr1 = ((GenericTypeDialog)GenericTypeDialog.this).errors[0].isError;
                    boolean newErr1 = GenericTypeDialog.this.nameText.getText().length() == 0;
                    boolean oldErr2 = ((GenericTypeDialog)GenericTypeDialog.this).errors[1].isError;
                    Long id = null;
                    if (!GenericTypeDialog.this.isNew) {
                        id = GenericTypeDialog.this.getTypeId();
                    }
                    boolean newErr2 = DomainController.getInstance().typeAlredyExists(GenericTypeDialog.this.nameText.getText(), GenericTypeDialog.this.isNew, id);
                    if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                        ((GenericTypeDialog)GenericTypeDialog.this).errors[0].isError = newErr1;
                        ((GenericTypeDialog)GenericTypeDialog.this).errors[1].isError = newErr2;
                        GenericTypeDialog.this.validate();
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, GenericTypeDialog.this.getShell());
                    dd.open();
                }
            }
        });
        Label label2 = new Label(content, 0);
        label2.setText("Description: ");
        this.descriptionText = new Text(content, 2626);
        GridData gd2 = new GridData(4, 4, true, true);
        this.descriptionText.setLayoutData((Object)gd2);
    }

    private void fillValues() {
        this.nameText.setText(this.name);
        if (this.desc != null) {
            this.descriptionText.setText(this.desc);
        }
        this.fillValuesSpecific();
    }

    protected void okPressed() {
        try {
            String tName = this.nameText.getText();
            String tDescription = this.descriptionText.getText();
            this.doOk(tName, tDescription, this.isNew);
            super.okPressed();
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.setErrorMessage(e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknow Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void initErrors() {
        this.errors[0] = new ErrorInfo("The name can't be empty", 3, this.isNew);
        this.errors[1] = new ErrorInfo("A type with the same name alredy exists", 3, false);
        this.initErrorsSpecific();
    }

    public void validate() {
        ErrorInfo[] allErrors;
        boolean error = false;
        ErrorInfo[] errorsSpecific = this.getErrorsSpecific();
        if (errorsSpecific != null) {
            int numErrorsSpecific = errorsSpecific.length;
            allErrors = new ErrorInfo[2 + numErrorsSpecific];
            System.arraycopy(this.errors, 0, allErrors, 0, 2);
            System.arraycopy(errorsSpecific, 0, allErrors, 2, numErrorsSpecific);
        } else {
            allErrors = this.errors;
        }
        ErrorInfo[] errorInfoArray = allErrors;
        int n = allErrors.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorInfo err = errorInfoArray[n2];
            if (err.isError) {
                this.setErrorMessage(err.message);
                error = true;
                break;
            }
            ++n2;
        }
        if (!error) {
            this.setErrorMessage(null);
        }
        this.getButton(0).setEnabled(!error);
    }

    public boolean isNew() {
        return this.isNew;
    }

    public abstract void createContentsSpecific(Shell var1);

    public abstract void createAttributesTab(TabFolder var1);

    public abstract void fillValuesSpecific();

    public abstract void doOk(String var1, String var2, boolean var3) throws DomainException;

    public abstract Long getTypeId();

    public abstract void initErrorsSpecific();

    public abstract ErrorInfo[] getErrorsSpecific();
}

