/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.dataType;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import upc.gessi.architech.Activator;
import upc.gessi.architech.gui.dialogs.dataType.GenericTypeDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.RealType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.ErrorInfo;

public class RealTypeDialog
extends GenericTypeDialog {
    Text minText;
    Text maxText;
    RealType type;
    private static final int NUM_ERRORS_SPECIFIC = 2;
    private static final int FORMAT_INCORRECT = 0;
    private static final int MIN_MAX = 1;
    private ErrorInfo[] errorsSpecific = new ErrorInfo[2];

    public RealTypeDialog(Shell parentShell) {
        super(parentShell);
    }

    public RealTypeDialog(Shell parentShell, RealType type) throws DomainException {
        super(parentShell, type.getName(), type.getDescription());
        this.type = type = DomainController.getInstance().getRealTypeById(type, true);
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Real Type");
        this.setTitle("Real Type");
        this.setMessage("Enter the data fot this Real Type");
        this.setTitleImage(Activator.getImageDescriptor("realTypeIcon_48x48.png").createImage());
    }

    @Override
    public void createAttributesTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Attributes");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Min: ");
        this.minText = new Text(content, 2048);
        this.minText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                boolean oldErr1 = ((RealTypeDialog)RealTypeDialog.this).errorsSpecific[0].isError;
                boolean newErr1 = false;
                try {
                    if (RealTypeDialog.this.minText.getText().length() > 0) {
                        Float.parseFloat(RealTypeDialog.this.minText.getText());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    newErr1 = true;
                }
                boolean oldErr2 = ((RealTypeDialog)RealTypeDialog.this).errorsSpecific[1].isError;
                boolean newErr2 = false;
                try {
                    float max;
                    float min;
                    if (RealTypeDialog.this.minText.getText().length() > 0 && RealTypeDialog.this.maxText.getText().length() > 0 && (min = Float.parseFloat(RealTypeDialog.this.minText.getText())) > (max = Float.parseFloat(RealTypeDialog.this.maxText.getText()))) {
                        newErr2 = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                    ((RealTypeDialog)RealTypeDialog.this).errorsSpecific[0].isError = newErr1;
                    ((RealTypeDialog)RealTypeDialog.this).errorsSpecific[1].isError = newErr2;
                    RealTypeDialog.this.validate();
                }
            }
        });
        Label label2 = new Label(content, 0);
        label2.setText("Max: ");
        this.maxText = new Text(content, 2048);
        this.maxText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                boolean oldErr1 = ((RealTypeDialog)RealTypeDialog.this).errorsSpecific[0].isError;
                boolean newErr1 = false;
                try {
                    if (RealTypeDialog.this.maxText.getText().length() > 0) {
                        Float.parseFloat(RealTypeDialog.this.maxText.getText());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    newErr1 = true;
                }
                boolean oldErr2 = ((RealTypeDialog)RealTypeDialog.this).errorsSpecific[1].isError;
                boolean newErr2 = false;
                try {
                    float max;
                    float min;
                    if (RealTypeDialog.this.minText.getText().length() > 0 && RealTypeDialog.this.maxText.getText().length() > 0 && (min = Float.parseFloat(RealTypeDialog.this.minText.getText())) > (max = Float.parseFloat(RealTypeDialog.this.maxText.getText()))) {
                        newErr2 = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                    ((RealTypeDialog)RealTypeDialog.this).errorsSpecific[0].isError = newErr1;
                    ((RealTypeDialog)RealTypeDialog.this).errorsSpecific[1].isError = newErr2;
                    RealTypeDialog.this.validate();
                }
            }
        });
    }

    @Override
    public void fillValuesSpecific() {
        Float min = this.type.getMin();
        Float max = this.type.getMax();
        if (min != null) {
            this.minText.setText(String.valueOf(min));
        }
        if (max != null) {
            this.maxText.setText(String.valueOf(max));
        }
    }

    @Override
    public void doOk(String name, String desc, boolean isNew) throws DomainException {
        String tMin = this.minText.getText();
        String tMax = this.maxText.getText();
        boolean hasMin = !tMin.equals("");
        boolean hasMax = !tMax.equals("");
        float parsedMin = 0.0f;
        float parsedMax = 0.0f;
        if (hasMin) {
            parsedMin = Float.parseFloat(tMin);
        }
        if (hasMax) {
            parsedMax = Float.parseFloat(tMax);
        }
        if (hasMin && hasMax && parsedMin > parsedMax) {
            throw new DomainException("Min has to be lesser or equal than Max");
        }
        if (isNew) {
            DomainController.getInstance().newRealType(name, desc, parsedMin, hasMin, parsedMax, hasMax);
        } else {
            DomainController.getInstance().updateRealType(this.type, name, desc, parsedMin, hasMin, parsedMax, hasMax);
        }
    }

    @Override
    public Long getTypeId() {
        return this.type.getId();
    }

    @Override
    public void initErrorsSpecific() {
        this.errorsSpecific[0] = new ErrorInfo("Numbers are not in the correct format", 3, false);
        this.errorsSpecific[1] = new ErrorInfo("The min has to be lesser or equal than the max", 3, false);
    }

    @Override
    public ErrorInfo[] getErrorsSpecific() {
        return this.errorsSpecific;
    }
}

