/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.decision;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.elements.ElementContentProvider;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.controller.elements.ElementsSorter;
import upc.gessi.architech.controller.properties.QualityAttributesContentProvider;
import upc.gessi.architech.controller.properties.QualityAttributesLabelProvider;
import upc.gessi.architech.controller.properties.QualityAttributesSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.property.QualityAttributeSelectionDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.Decision;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.DecisionAction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decisionEffect.DecisionEffect;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.QualityAttribute;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public class DecisionDialog
extends TitleAreaDialog {
    private Text nameText;
    private Text descriptionText;
    private Combo effectCombo;
    private TableViewer attributesList;
    private Combo actionCombo;
    private TableViewer elementsList;
    private Button delAttributeButton;
    private Button delElementButton;
    private boolean isNew;
    private Decision decision;
    private Map<QualityAttribute, Integer> effectsMap;
    private Map<Element, Integer> actionsMap;
    private Shell shell;
    private static final int NUM_ERRORS = 2;
    private static final int EMPTY_NAME = 0;
    private static final int ALREADY_EXISTS = 1;
    private ErrorInfo[] errors = new ErrorInfo[2];

    public DecisionDialog(Shell parentShell) {
        super(parentShell);
        this.isNew = true;
        this.effectsMap = new HashMap<QualityAttribute, Integer>();
        this.actionsMap = new HashMap<Element, Integer>();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public DecisionDialog(Shell parentShell, Decision d) throws DomainException {
        super(parentShell);
        this.decision = DomainController.getInstance().getDecisionById(d, true);
        this.isNew = false;
        this.effectsMap = new HashMap<QualityAttribute, Integer>();
        this.getDecisionEffectsInfo();
        this.actionsMap = new HashMap<Element, Integer>();
        this.getDecisionActionInfo();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point p = new Point(350, 450);
        return p;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.shell = this.getShell();
        if (this.isNew) {
            this.shell.setText("New Decision");
        } else {
            this.shell.setText("Edit Decision");
        }
        this.setTitle("Decision");
        this.setMessage("Enter the data for this decision");
        this.setTitleImage(Activator.getImageDescriptor("decisionsIcon_48x48.png").createImage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        TabFolder tabs = new TabFolder(contents, 128);
        tabs.setLayoutData((Object)new GridData(4, 4, true, true));
        tabs.setLayout((Layout)new GridLayout());
        this.createInformationTab(tabs);
        this.createActionsTab(tabs);
        this.createEffectsTab(tabs);
        this.initErrors();
        if (!this.isNew) {
            this.fillValues();
        }
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    private void createInformationTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Information");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        GridData gd0 = new GridData(16384, 0x1000000, false, false);
        gd0.horizontalSpan = 2;
        label1.setText("Name: ");
        label1.setLayoutData((Object)gd0);
        this.nameText = new Text(content, 2048);
        GridData gd1 = new GridData(4, 16384, true, false);
        this.nameText.setLayoutData((Object)gd1);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                try {
                    boolean oldErr1 = ((DecisionDialog)DecisionDialog.this).errors[0].isError;
                    boolean newErr1 = DecisionDialog.this.nameText.getText().length() == 0;
                    boolean oldErr2 = ((DecisionDialog)DecisionDialog.this).errors[1].isError;
                    Long id = null;
                    if (!DecisionDialog.this.isNew) {
                        id = DecisionDialog.this.decision.getId();
                    }
                    boolean newErr2 = DomainController.getInstance().decisionAlredyExists(DecisionDialog.this.nameText.getText(), DecisionDialog.this.isNew, id);
                    if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                        ((DecisionDialog)DecisionDialog.this).errors[0].isError = newErr1;
                        ((DecisionDialog)DecisionDialog.this).errors[1].isError = newErr2;
                        DecisionDialog.this.validate();
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DecisionDialog.this.getShell());
                    dd.open();
                }
            }
        });
        Label label2 = new Label(content, 0);
        label2.setText("Description: ");
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.horizontalSpan = 2;
        label2.setLayoutData((Object)gd2);
        this.descriptionText = new Text(content, 2626);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.horizontalSpan = 2;
        this.descriptionText.setLayoutData((Object)gd3);
    }

    private void createActionsTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Decision Actions");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Elements:");
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalSpan = 3;
        label1.setLayoutData((Object)gd);
        this.elementsList = new TableViewer(content, 2820);
        this.elementsList.setContentProvider((IContentProvider)new ElementContentProvider());
        this.elementsList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.elementsList.setSorter((ViewerSorter)new ElementsSorter());
        this.elementsList.setInput(this.actionsMap.keySet());
        GridData gd1 = new GridData(4, 4, true, true);
        gd1.heightHint = 50;
        gd1.widthHint = 250;
        gd1.horizontalSpan = 2;
        gd1.verticalSpan = 2;
        this.elementsList.getTable().setLayoutData((Object)gd1);
        this.elementsList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                Element selElement = DecisionDialog.this.getSelectedElement();
                Integer val = (Integer)DecisionDialog.this.actionsMap.get(selElement);
                if (val.equals(-1)) {
                    DecisionDialog.this.actionCombo.deselectAll();
                } else {
                    DecisionDialog.this.actionCombo.select(val.intValue());
                }
                DecisionDialog.this.delElementButton.setEnabled(true);
            }
        });
        Label label2 = new Label(content, 0);
        label2.setText("Action: ");
        GridData gd0 = new GridData(16384, 0x1000000, false, false);
        label2.setLayoutData((Object)gd0);
        this.actionCombo = new Combo(content, 12);
        this.fillActionComboValues();
        GridData gd2 = new GridData(4, 128, true, false);
        gd2.widthHint = 300;
        this.actionCombo.setLayoutData((Object)gd2);
        this.actionCombo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (DecisionDialog.this.elementsList.getSelection().isEmpty()) {
                    DecisionDialog.this.elementsList.getTable().setFocus();
                }
            }

            public void focusLost(FocusEvent e) {
                if (!DecisionDialog.this.elementsList.getSelection().isEmpty()) {
                    DecisionDialog.this.actionsMap.put(DecisionDialog.this.getSelectedElement(), DecisionDialog.this.actionCombo.getSelectionIndex());
                }
            }
        });
        Button addElementButton = new Button(content, 8);
        addElementButton.setText("Add...");
        addElementButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    Set allElements = Model.getInstance().getElements();
                    HashSet<Element> usedElements = new HashSet<Element>();
                    Object[] items = DecisionDialog.this.getElementNames().toArray();
                    block3: for (Element el : allElements) {
                        int i = 0;
                        while (i < items.length) {
                            if (el.getName().equalsIgnoreCase((String)items[i])) {
                                usedElements.add(el);
                                continue block3;
                            }
                            ++i;
                        }
                    }
                    allElements.removeAll(usedElements);
                    ElementListSelectionDialog dialog = new ElementListSelectionDialog(DecisionDialog.this.shell, (ILabelProvider)new ElementLabelProvider());
                    dialog.setElements(allElements.toArray());
                    dialog.setTitle("Browse Element");
                    dialog.setMessage("Select an Element:");
                    if (dialog.open() == 0) {
                        Element result = (Element)dialog.getFirstResult();
                        DecisionDialog.this.actionsMap.put(result, -1);
                        DecisionDialog.this.elementsList.refresh();
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DecisionDialog.this.shell);
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, DecisionDialog.this.shell);
                    dd.open();
                }
            }
        });
        this.delElementButton = new Button(content, 8);
        this.delElementButton.setText("Delete...");
        this.delElementButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                Element selElement = DecisionDialog.this.getSelectedElement();
                DecisionDialog.this.actionsMap.remove(selElement);
                DecisionDialog.this.elementsList.refresh();
                DecisionDialog.this.delElementButton.setEnabled(false);
                DecisionDialog.this.actionCombo.deselectAll();
            }
        });
        this.delElementButton.setEnabled(false);
    }

    private void createEffectsTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Decision Effects");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Quality Attributes:");
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalSpan = 3;
        label1.setLayoutData((Object)gd);
        this.attributesList = new TableViewer(content, 2820);
        GridData gd1 = new GridData(4, 4, true, true);
        this.attributesList.setContentProvider((IContentProvider)new QualityAttributesContentProvider());
        this.attributesList.setLabelProvider((IBaseLabelProvider)new QualityAttributesLabelProvider());
        this.attributesList.setSorter((ViewerSorter)new QualityAttributesSorter());
        this.attributesList.setInput(this.effectsMap.keySet());
        gd1.heightHint = 50;
        gd1.widthHint = 250;
        gd1.horizontalSpan = 2;
        gd1.verticalSpan = 2;
        this.attributesList.getTable().setLayoutData((Object)gd1);
        this.attributesList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                QualityAttribute selAttribute = DecisionDialog.this.getSelectedQualityAttribute();
                Integer val = (Integer)DecisionDialog.this.effectsMap.get(selAttribute);
                if (val.equals(-1)) {
                    DecisionDialog.this.effectCombo.deselectAll();
                } else {
                    DecisionDialog.this.effectCombo.select(val.intValue());
                }
                DecisionDialog.this.delAttributeButton.setEnabled(true);
            }
        });
        Label label2 = new Label(content, 0);
        label2.setText("Effect: ");
        GridData gd0 = new GridData(16384, 0x1000000, false, false);
        label2.setLayoutData((Object)gd0);
        this.effectCombo = new Combo(content, 12);
        this.fillEffectComboValues();
        GridData gd2 = new GridData(4, 128, true, false);
        gd2.widthHint = 300;
        this.effectCombo.setLayoutData((Object)gd2);
        this.effectCombo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (DecisionDialog.this.attributesList.getSelection().isEmpty()) {
                    DecisionDialog.this.attributesList.getTable().setFocus();
                }
            }

            public void focusLost(FocusEvent e) {
                if (!DecisionDialog.this.attributesList.getSelection().isEmpty()) {
                    DecisionDialog.this.effectsMap.put(DecisionDialog.this.getSelectedQualityAttribute(), DecisionDialog.this.effectCombo.getSelectionIndex());
                }
            }
        });
        Button addAttributeButton = new Button(content, 8);
        addAttributeButton.setText("Add...");
        addAttributeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    Set allAttributes = Model.getInstance().getQualityAttributes();
                    HashSet<QualityAttribute> usedAttributes = new HashSet<QualityAttribute>();
                    Object[] items = DecisionDialog.this.getQualityAttributeNames().toArray();
                    block3: for (QualityAttribute a : allAttributes) {
                        int i = 0;
                        while (i < items.length) {
                            if (a.getName().equalsIgnoreCase((String)items[i])) {
                                usedAttributes.add(a);
                                continue block3;
                            }
                            ++i;
                        }
                    }
                    if (!DecisionDialog.this.isNew) {
                        DomainController.getInstance().removeUnusedEffects(DecisionDialog.this.decision, usedAttributes);
                    }
                    QualityAttributeSelectionDialog dialog = new QualityAttributeSelectionDialog(DecisionDialog.this.shell, usedAttributes);
                    dialog.setTitle("Browse Quality Attribute");
                    dialog.setMessage("Here you can create, edit and delete Quality Attributes. Take into acount that:\n\t- When an attribute is selected, the attributes will be created as specializations of it.\n\t- You can \"drag & drop\" to manage the attributes hierarhcy.\n\nSelect a Quality Attribute:");
                    if (dialog.open() == 0) {
                        QualityAttribute result = (QualityAttribute)dialog.getFirstResult();
                        DecisionDialog.this.effectsMap.put(result, -1);
                        DecisionDialog.this.attributesList.refresh();
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DecisionDialog.this.shell);
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, DecisionDialog.this.shell);
                    dd.open();
                }
            }
        });
        this.delAttributeButton = new Button(content, 8);
        this.delAttributeButton.setText("Delete...");
        this.delAttributeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                QualityAttribute selAttribute = DecisionDialog.this.getSelectedQualityAttribute();
                DecisionDialog.this.effectsMap.remove(selAttribute);
                DecisionDialog.this.attributesList.refresh();
                DecisionDialog.this.delAttributeButton.setEnabled(false);
                DecisionDialog.this.effectCombo.deselectAll();
            }
        });
        this.delAttributeButton.setEnabled(false);
    }

    public void getDecisionEffectsInfo() throws DomainException {
        for (DecisionEffect de : this.decision.getDecisionEffects()) {
            this.effectsMap.put(de.getAttribute(), de.getValue());
        }
    }

    public void getDecisionActionInfo() throws DomainException {
        for (DecisionAction da : this.decision.getActions()) {
            this.actionsMap.put(da.getElement(), da.getAction());
        }
    }

    private void fillValues() {
        this.nameText.setText(this.decision.getName());
        String pDescription = this.decision.getDescription();
        if (pDescription != null) {
            this.descriptionText.setText(pDescription);
        }
        this.elementsList.refresh();
        this.attributesList.refresh();
    }

    private void fillActionComboValues() {
        this.actionCombo.add("Needs", 0);
        this.actionCombo.add("Disallows", 1);
    }

    private void fillEffectComboValues() {
        this.effectCombo.add("Denies", 0);
        this.effectCombo.add("Weekly harms", 1);
        this.effectCombo.add("Weekly helps", 2);
        this.effectCombo.add("Makes", 3);
    }

    private boolean validEffects() {
        for (QualityAttribute key : this.effectsMap.keySet()) {
            Integer value = this.effectsMap.get(key);
            if (!value.equals(-1)) continue;
            return false;
        }
        return true;
    }

    private boolean validActions() {
        for (Element key : this.actionsMap.keySet()) {
            Integer value = this.actionsMap.get(key);
            if (!value.equals(-1)) continue;
            return false;
        }
        return true;
    }

    protected void okPressed() {
        try {
            String dName = this.nameText.getText();
            String dDescription = this.descriptionText.getText();
            if (!this.validEffects()) {
                this.setErrorMessage("There is some problem with the effects");
            } else if (!this.validActions()) {
                this.setErrorMessage("There is some problem with the actions");
            } else {
                if (this.isNew) {
                    DomainController.getInstance().newDecision(dName, dDescription, this.effectsMap, this.actionsMap);
                } else {
                    DomainController.getInstance().updateDecision(this.decision, dName, dDescription, this.effectsMap, this.actionsMap);
                }
                super.okPressed();
            }
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.setErrorMessage(e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void initErrors() {
        this.errors[0] = new ErrorInfo("The name can't be empty", 3, this.isNew);
        this.errors[1] = new ErrorInfo("A decision with the same name alredy exists", 3, false);
    }

    private void validate() {
        boolean error = false;
        ErrorInfo[] errorInfoArray = this.errors;
        int n = this.errors.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorInfo err = errorInfoArray[n2];
            if (err.isError) {
                this.setErrorMessage(err.message);
                error = true;
                break;
            }
            ++n2;
        }
        if (!error) {
            this.setErrorMessage(null);
        }
        this.getButton(0).setEnabled(!error);
    }

    private Element getSelectedElement() {
        IStructuredSelection sel = (IStructuredSelection)this.elementsList.getSelection();
        return (Element)sel.getFirstElement();
    }

    private Set<String> getElementNames() {
        HashSet<String> names = new HashSet<String>();
        for (Element e : this.actionsMap.keySet()) {
            names.add(e.getName());
        }
        return names;
    }

    private QualityAttribute getSelectedQualityAttribute() {
        IStructuredSelection sel = (IStructuredSelection)this.attributesList.getSelection();
        return (QualityAttribute)sel.getFirstElement();
    }

    private Set<String> getQualityAttributeNames() {
        HashSet<String> names = new HashSet<String>();
        for (QualityAttribute qa : this.effectsMap.keySet()) {
            names.add(qa.getName());
        }
        return names;
    }
}

