/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.element;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.elements.ElementContentProvider;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.controller.elements.ElementsSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.element.GenericElementDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalView;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Component;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Implementation;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Style;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.StyleVariation;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.ElementProperty;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public class ComponentDialog
extends GenericElementDialog {
    private TableViewer composibleComponentsList;
    private Button delComposibleComponent;
    private Button selfComposable;
    private TableViewer connectableComponentsList;
    private Button delConnectableComponent;
    private Button selfConnectable;
    private TableViewer styleVariationsList;
    private Button delStyleVariation;
    private TableViewer stylesList;
    private Button delStyle;
    private TableViewer implementationsList;
    private Button delImplementation;
    private Set<Component> composableComponents;
    private Set<Component> connectableComponents;
    private Set<StyleVariation> styleVariations;
    private Set<Style> styles;
    private Set<Implementation> implementations;
    private Component component;
    private static final int NUM_ERRORS_SPECIFIC = 6;
    private static final int BAD_STYLE_VARIATION = 0;
    private static final int BAD_IMPLEMENTATION = 1;
    private static final int BAD_COMPOSABLE = 2;
    private static final int BAD_CONNECTABLE = 3;
    private static final int BAD_STYLE = 4;
    private static final int NO_STYLE = 5;
    private ErrorInfo[] errors = new ErrorInfo[6];

    public ComponentDialog(Element parent, Shell parentShell) throws DomainException {
        super(parent, parentShell);
        this.composableComponents = new HashSet<Component>();
        this.connectableComponents = new HashSet<Component>();
        this.styleVariations = new HashSet<StyleVariation>();
        this.styles = new HashSet<Style>();
        this.implementations = new HashSet<Implementation>();
    }

    public ComponentDialog(Shell parentShell, Component component) throws DomainException {
        super(parentShell, component.getName(), component.getDescription());
        this.composableComponents = new HashSet<Component>();
        this.connectableComponents = new HashSet<Component>();
        this.styleVariations = new HashSet<StyleVariation>();
        this.styles = new HashSet<Style>();
        this.implementations = new HashSet<Implementation>();
        this.component = component = DomainController.getInstance().getComponentById(component, true);
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Component");
        this.setTitle("Component");
        this.setMessage("Enter the data for this Component");
        this.setTitleImage(Activator.getImageDescriptor("componentIcon_48x48.png").createImage());
    }

    @Override
    public void createOtherTabs(TabFolder tabs) {
        this.createComponentsTab(tabs);
        this.createOtherTab(tabs);
    }

    private void createComponentsTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Related Components");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label3 = new Label(content, 0);
        label3.setText("Composable components:");
        GridData gd7 = new GridData(4, 0x1000000, true, false);
        gd7.horizontalSpan = 2;
        label3.setLayoutData((Object)gd7);
        Label label4 = new Label(content, 0);
        label4.setText("Connectable components:");
        GridData gd8 = new GridData(131072, 0x1000000, false, false);
        gd8.horizontalSpan = 2;
        label4.setLayoutData((Object)gd8);
        this.composibleComponentsList = new TableViewer(content, 2048);
        this.composibleComponentsList.setContentProvider((IContentProvider)new ElementContentProvider());
        this.composibleComponentsList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.composibleComponentsList.setSorter((ViewerSorter)new ElementsSorter());
        this.composibleComponentsList.setInput(this.composableComponents);
        GridData gd5 = new GridData(4, 4, true, true);
        gd5.verticalSpan = 2;
        this.composibleComponentsList.getTable().setLayoutData((Object)gd5);
        this.composibleComponentsList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ComponentDialog.this.delComposibleComponent.setEnabled(true);
            }
        });
        Button butt3 = new Button(content, 8);
        butt3.setText("Add");
        butt3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(ComponentDialog.this.getShell(), (ILabelProvider)new ElementLabelProvider());
                    Set allComponents = Model.getInstance().getComponents();
                    HashSet<Component> validComponents = new HashSet<Component>();
                    Object[] items = ComponentDialog.this.getComposableNames().toArray();
                    for (Component el : allComponents) {
                        boolean add;
                        boolean bl = add = ComponentDialog.this.component == null || !el.getName().equalsIgnoreCase(ComponentDialog.this.component.getName());
                        if (add) {
                            int i = 0;
                            while (i < items.length) {
                                if (el.getName().equalsIgnoreCase((String)items[i])) {
                                    add = false;
                                }
                                ++i;
                            }
                        }
                        if (!add) continue;
                        validComponents.add(el);
                    }
                    dg.setElements(validComponents.toArray());
                    dg.setTitle("Browse Component");
                    dg.setMessage("Select a component that can be composed");
                    if (dg.open() == 0) {
                        boolean newErr;
                        Object[] objectArray = dg.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object e = objectArray[n2];
                            ComponentDialog.this.composableComponents.add((Component)e);
                            ComponentDialog.this.composibleComponentsList.refresh();
                            ++n2;
                        }
                        boolean oldErr = ((ComponentDialog)ComponentDialog.this).errors[2].isError;
                        boolean bl = newErr = !ComponentDialog.this.validComposables(ComponentDialog.this.getSelectedViewName());
                        if (oldErr != newErr) {
                            ((ComponentDialog)ComponentDialog.this).errors[2].isError = newErr;
                            ComponentDialog.this.validate();
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ComponentDialog.this.getShell());
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ComponentDialog.this.getShell());
                    dd.open();
                }
            }
        });
        Button butt4 = new Button(content, 8);
        butt4.setText("Add");
        GridData gd9 = new GridData(131072, 0x1000000, false, false);
        butt4.setLayoutData((Object)gd9);
        butt4.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(ComponentDialog.this.getShell(), (ILabelProvider)new ElementLabelProvider());
                    Set allComponents = Model.getInstance().getComponents();
                    HashSet<Component> validComponents = new HashSet<Component>();
                    Object[] items = ComponentDialog.this.getConnectableNames().toArray();
                    for (Component el : allComponents) {
                        boolean add;
                        boolean bl = add = ComponentDialog.this.component == null || !el.getName().equalsIgnoreCase(ComponentDialog.this.component.getName());
                        if (add) {
                            int i = 0;
                            while (i < items.length) {
                                if (el.getName().equalsIgnoreCase((String)items[i])) {
                                    add = false;
                                }
                                ++i;
                            }
                        }
                        if (!add) continue;
                        validComponents.add(el);
                    }
                    dg.setElements(validComponents.toArray());
                    dg.setTitle("Browse Component");
                    dg.setMessage("Select a component that can be connected");
                    if (dg.open() == 0) {
                        boolean newErr;
                        Object[] objectArray = dg.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object e = objectArray[n2];
                            ComponentDialog.this.connectableComponents.add((Component)e);
                            ComponentDialog.this.connectableComponentsList.refresh();
                            ++n2;
                        }
                        boolean oldErr = ((ComponentDialog)ComponentDialog.this).errors[3].isError;
                        boolean bl = newErr = !ComponentDialog.this.validConnectables(ComponentDialog.this.getSelectedViewName());
                        if (oldErr != newErr) {
                            ((ComponentDialog)ComponentDialog.this).errors[3].isError = newErr;
                            ComponentDialog.this.validate();
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ComponentDialog.this.getShell());
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ComponentDialog.this.getShell());
                    dd.open();
                }
            }
        });
        this.connectableComponentsList = new TableViewer(content, 2048);
        this.connectableComponentsList.setContentProvider((IContentProvider)new ElementContentProvider());
        this.connectableComponentsList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.connectableComponentsList.setSorter((ViewerSorter)new ElementsSorter());
        this.connectableComponentsList.setInput(this.connectableComponents);
        GridData gd6 = new GridData(4, 4, true, true);
        gd6.verticalSpan = 2;
        this.connectableComponentsList.getTable().setLayoutData((Object)gd6);
        this.connectableComponentsList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ComponentDialog.this.delConnectableComponent.setEnabled(true);
            }
        });
        this.delComposibleComponent = new Button(content, 8);
        this.delComposibleComponent.setText("Delete");
        this.delComposibleComponent.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!ComponentDialog.this.composibleComponentsList.getSelection().isEmpty()) {
                    boolean newErr;
                    IStructuredSelection sel = (IStructuredSelection)ComponentDialog.this.composibleComponentsList.getSelection();
                    Component selElement = (Component)sel.getFirstElement();
                    ComponentDialog.this.composableComponents.remove(selElement);
                    ComponentDialog.this.composibleComponentsList.refresh();
                    ComponentDialog.this.delComposibleComponent.setEnabled(false);
                    boolean oldErr = ((ComponentDialog)ComponentDialog.this).errors[2].isError;
                    boolean bl = newErr = !ComponentDialog.this.validComposables(ComponentDialog.this.getSelectedViewName());
                    if (oldErr != newErr) {
                        ((ComponentDialog)ComponentDialog.this).errors[2].isError = newErr;
                        ComponentDialog.this.validate();
                    }
                }
            }
        });
        this.delComposibleComponent.setEnabled(false);
        this.delConnectableComponent = new Button(content, 8);
        this.delConnectableComponent.setText("Delete");
        GridData gd10 = new GridData(131072, 0x1000000, false, false);
        this.delConnectableComponent.setLayoutData((Object)gd10);
        this.delConnectableComponent.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!ComponentDialog.this.connectableComponentsList.getSelection().isEmpty()) {
                    boolean newErr;
                    IStructuredSelection sel = (IStructuredSelection)ComponentDialog.this.connectableComponentsList.getSelection();
                    Component selElement = (Component)sel.getFirstElement();
                    ComponentDialog.this.connectableComponents.remove(selElement);
                    ComponentDialog.this.connectableComponentsList.refresh();
                    ComponentDialog.this.delConnectableComponent.setEnabled(false);
                    boolean oldErr = ((ComponentDialog)ComponentDialog.this).errors[3].isError;
                    boolean bl = newErr = !ComponentDialog.this.validConnectables(ComponentDialog.this.getSelectedViewName());
                    if (oldErr != newErr) {
                        ((ComponentDialog)ComponentDialog.this).errors[3].isError = newErr;
                        ComponentDialog.this.validate();
                    }
                }
            }
        });
        this.delConnectableComponent.setEnabled(false);
        this.selfComposable = new Button(content, 32);
        this.selfComposable.setText("Is self-composable?");
        GridData gd11 = new GridData(16384, 0x1000000, false, false);
        gd11.horizontalSpan = 2;
        this.selfComposable.setLayoutData((Object)gd11);
        this.selfConnectable = new Button(content, 32);
        this.selfConnectable.setText("Is self-connectable?");
        GridData gd12 = new GridData(131072, 0x1000000, false, false);
        gd12.horizontalSpan = 2;
        this.selfConnectable.setLayoutData((Object)gd12);
    }

    private void createOtherTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Other Attributes");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label = new Label(content, 0);
        label.setText("Applies to the style variations...:");
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Label label2 = new Label(content, 0);
        label2.setText("Implementable with:");
        GridData gd2 = new GridData(131072, 0x1000000, false, false);
        gd2.horizontalSpan = 2;
        label2.setLayoutData((Object)gd2);
        this.styleVariationsList = new TableViewer(content, 2048);
        this.styleVariationsList.setContentProvider((IContentProvider)new ElementContentProvider());
        this.styleVariationsList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.styleVariationsList.setSorter((ViewerSorter)new ElementsSorter());
        this.styleVariationsList.setInput(this.styleVariations);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.verticalSpan = 2;
        this.styleVariationsList.getTable().setLayoutData((Object)gd3);
        this.styleVariationsList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ComponentDialog.this.delStyleVariation.setEnabled(true);
            }
        });
        Button butt = new Button(content, 8);
        butt.setText("Add");
        butt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(ComponentDialog.this.getShell(), (ILabelProvider)new ElementLabelProvider());
                    Set allStyleVariations = Model.getInstance().getStyleVariations();
                    HashSet<StyleVariation> validStyleVariations = new HashSet<StyleVariation>();
                    Object[] items = ComponentDialog.this.getStyleVariationNames().toArray();
                    for (StyleVariation el : allStyleVariations) {
                        boolean add = true;
                        if (add) {
                            int i = 0;
                            while (i < items.length) {
                                if (el.getName().equalsIgnoreCase((String)items[i])) {
                                    add = false;
                                }
                                ++i;
                            }
                        }
                        if (!add) continue;
                        validStyleVariations.add(el);
                    }
                    dg.setElements(validStyleVariations.toArray());
                    dg.setTitle("Browse Style Variation");
                    dg.setMessage("Select one or more Style Variations to which the component applies");
                    if (dg.open() == 0) {
                        boolean newErr;
                        Object[] objectArray = dg.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object e = objectArray[n2];
                            ComponentDialog.this.styleVariations.add((StyleVariation)e);
                            ComponentDialog.this.styleVariationsList.refresh();
                            ++n2;
                        }
                        boolean oldErr = ((ComponentDialog)ComponentDialog.this).errors[0].isError;
                        boolean bl = newErr = !ComponentDialog.this.validStyleVariations(ComponentDialog.this.getSelectedViewName());
                        if (oldErr != newErr) {
                            ((ComponentDialog)ComponentDialog.this).errors[0].isError = newErr;
                            ComponentDialog.this.validate();
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ComponentDialog.this.getShell());
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ComponentDialog.this.getShell());
                    dd.open();
                }
            }
        });
        Button butt2 = new Button(content, 8);
        butt2.setText("Add");
        GridData gd7 = new GridData(131072, 0x1000000, false, false);
        butt2.setLayoutData((Object)gd7);
        butt2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(ComponentDialog.this.getShell(), (ILabelProvider)new ElementLabelProvider());
                    Set allImplementations = Model.getInstance().getImplementations();
                    HashSet<Implementation> validImplementations = new HashSet<Implementation>();
                    Object[] items = ComponentDialog.this.getImplementationNames().toArray();
                    for (Implementation el : allImplementations) {
                        boolean add = true;
                        if (add) {
                            int i = 0;
                            while (i < items.length) {
                                if (el.getName().equalsIgnoreCase((String)items[i])) {
                                    add = false;
                                }
                                ++i;
                            }
                        }
                        if (!add) continue;
                        validImplementations.add(el);
                    }
                    dg.setElements(validImplementations.toArray());
                    dg.setTitle("Browse Implementation");
                    dg.setMessage("Select one or more Implementations which can implement the component");
                    if (dg.open() == 0) {
                        boolean newErr;
                        Object[] objectArray = dg.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object e = objectArray[n2];
                            ComponentDialog.this.implementations.add((Implementation)e);
                            ComponentDialog.this.implementationsList.refresh();
                            ++n2;
                        }
                        boolean oldErr = ((ComponentDialog)ComponentDialog.this).errors[1].isError;
                        boolean bl = newErr = !ComponentDialog.this.validImplementations(ComponentDialog.this.getSelectedViewName());
                        if (oldErr != newErr) {
                            ((ComponentDialog)ComponentDialog.this).errors[1].isError = newErr;
                            ComponentDialog.this.validate();
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ComponentDialog.this.getShell());
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ComponentDialog.this.getShell());
                    dd.open();
                }
            }
        });
        this.implementationsList = new TableViewer(content, 2048);
        this.implementationsList.setContentProvider((IContentProvider)new ElementContentProvider());
        this.implementationsList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.implementationsList.setSorter((ViewerSorter)new ElementsSorter());
        this.implementationsList.setInput(this.implementations);
        GridData gd4 = new GridData(4, 4, true, true);
        gd4.verticalSpan = 2;
        this.implementationsList.getTable().setLayoutData((Object)gd4);
        this.implementationsList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ComponentDialog.this.delImplementation.setEnabled(true);
            }
        });
        this.delStyleVariation = new Button(content, 8);
        this.delStyleVariation.setText("Delete");
        this.delStyleVariation.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!ComponentDialog.this.styleVariationsList.getSelection().isEmpty()) {
                    boolean newErr;
                    IStructuredSelection sel = (IStructuredSelection)ComponentDialog.this.styleVariationsList.getSelection();
                    StyleVariation selElement = (StyleVariation)sel.getFirstElement();
                    ComponentDialog.this.styleVariations.remove(selElement);
                    ComponentDialog.this.styleVariationsList.refresh();
                    ComponentDialog.this.delStyleVariation.setEnabled(false);
                    boolean oldErr = ((ComponentDialog)ComponentDialog.this).errors[0].isError;
                    boolean bl = newErr = !ComponentDialog.this.validStyleVariations(ComponentDialog.this.getSelectedViewName());
                    if (oldErr != newErr) {
                        ((ComponentDialog)ComponentDialog.this).errors[0].isError = newErr;
                        ComponentDialog.this.validate();
                    }
                }
            }
        });
        this.delStyleVariation.setEnabled(false);
        this.delImplementation = new Button(content, 8);
        this.delImplementation.setText("Delete");
        GridData gd8 = new GridData(131072, 0x1000000, false, false);
        this.delImplementation.setLayoutData((Object)gd8);
        this.delImplementation.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!ComponentDialog.this.implementationsList.getSelection().isEmpty()) {
                    boolean newErr;
                    IStructuredSelection sel = (IStructuredSelection)ComponentDialog.this.implementationsList.getSelection();
                    Implementation selElement = (Implementation)sel.getFirstElement();
                    ComponentDialog.this.implementations.remove(selElement);
                    ComponentDialog.this.implementationsList.refresh();
                    ComponentDialog.this.delImplementation.setEnabled(false);
                    boolean oldErr = ((ComponentDialog)ComponentDialog.this).errors[1].isError;
                    boolean bl = newErr = !ComponentDialog.this.validImplementations(ComponentDialog.this.getSelectedViewName());
                    if (oldErr != newErr) {
                        ((ComponentDialog)ComponentDialog.this).errors[1].isError = newErr;
                        ComponentDialog.this.validate();
                    }
                }
            }
        });
        this.delImplementation.setEnabled(false);
        Label label3 = new Label(content, 0);
        label3.setText("Applies To the Styles...:");
        GridData gd5 = new GridData(4, 0x1000000, true, false);
        gd5.horizontalSpan = 4;
        label3.setLayoutData((Object)gd5);
        this.stylesList = new TableViewer(content, 2048);
        this.stylesList.setContentProvider((IContentProvider)new ElementContentProvider());
        this.stylesList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.stylesList.setSorter((ViewerSorter)new ElementsSorter());
        this.stylesList.setInput(this.styles);
        GridData gd6 = new GridData(4, 4, true, true);
        gd6.verticalSpan = 2;
        gd6.horizontalSpan = 1;
        this.stylesList.getTable().setLayoutData((Object)gd6);
        this.stylesList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ComponentDialog.this.delStyle.setEnabled(true);
            }
        });
        Button butt3 = new Button(content, 8);
        butt3.setText("Add");
        GridData gd9 = new GridData(16384, 0x1000000, false, false);
        gd9.horizontalSpan = 3;
        butt3.setLayoutData((Object)gd9);
        butt3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    int add;
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(ComponentDialog.this.getShell(), (ILabelProvider)new ElementLabelProvider());
                    Set allStyles = Model.getInstance().getStyles();
                    HashSet<Style> validStyles = new HashSet<Style>();
                    Object[] items = ComponentDialog.this.getStyleNames().toArray();
                    for (Style el : allStyles) {
                        add = 1;
                        if (add != 0) {
                            int i = 0;
                            while (i < items.length) {
                                if (el.getName().equalsIgnoreCase((String)items[i])) {
                                    add = 0;
                                }
                                ++i;
                            }
                        }
                        if (add == 0) continue;
                        validStyles.add(el);
                    }
                    dg.setElements(validStyles.toArray());
                    dg.setTitle("Browse Styles");
                    dg.setMessage("Select one or more Styles to which the component applies");
                    if (dg.open() == 0) {
                        Object[] i = dg.getResult();
                        add = i.length;
                        int n = 0;
                        while (n < add) {
                            Object e = i[n];
                            ComponentDialog.this.styles.add((Style)e);
                            ComponentDialog.this.stylesList.refresh();
                            ++n;
                        }
                        boolean oldErr1 = ((ComponentDialog)ComponentDialog.this).errors[4].isError;
                        boolean newErr1 = !ComponentDialog.this.validStyles(ComponentDialog.this.getSelectedViewName());
                        boolean oldErr2 = ((ComponentDialog)ComponentDialog.this).errors[5].isError;
                        boolean newErr2 = false;
                        if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                            ((ComponentDialog)ComponentDialog.this).errors[4].isError = newErr1;
                            ((ComponentDialog)ComponentDialog.this).errors[5].isError = newErr2;
                            ComponentDialog.this.validate();
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ComponentDialog.this.getShell());
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ComponentDialog.this.getShell());
                    dd.open();
                }
            }
        });
        this.delStyle = new Button(content, 8);
        this.delStyle.setText("Delete");
        GridData gd10 = new GridData(16384, 0x1000000, false, false);
        gd10.horizontalSpan = 3;
        this.delStyle.setLayoutData((Object)gd10);
        this.delStyle.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!ComponentDialog.this.stylesList.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)ComponentDialog.this.stylesList.getSelection();
                    Style selElement = (Style)sel.getFirstElement();
                    ComponentDialog.this.styles.remove(selElement);
                    ComponentDialog.this.stylesList.refresh();
                    ComponentDialog.this.delStyle.setEnabled(false);
                    boolean oldErr1 = ((ComponentDialog)ComponentDialog.this).errors[4].isError;
                    boolean newErr1 = !ComponentDialog.this.validStyles(ComponentDialog.this.getSelectedViewName());
                    boolean oldErr2 = ((ComponentDialog)ComponentDialog.this).errors[5].isError;
                    boolean newErr2 = ComponentDialog.this.styles.isEmpty();
                    if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                        ((ComponentDialog)ComponentDialog.this).errors[4].isError = newErr1;
                        ((ComponentDialog)ComponentDialog.this).errors[5].isError = newErr2;
                        ComponentDialog.this.validate();
                    }
                }
            }
        });
        this.delStyle.setEnabled(false);
    }

    @Override
    protected Point getInitialSize() {
        Point p = new Point(500, 600);
        return p;
    }

    @Override
    public void doOk(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<ElementProperty, String> valuesMap, Set<Element> relatedElements, Element parent, ArchitecturalView view, boolean isNew) throws DomainException {
        boolean selfComposable = this.selfComposable.getSelection();
        boolean selfConnectable = this.selfConnectable.getSelection();
        if (isNew) {
            DomainController.getInstance().newComponent(name, desc, restrictionsMap, valuesMap, relatedElements, parent, view, this.composableComponents, this.connectableComponents, this.styleVariations, this.implementations, this.styles, selfComposable, selfConnectable);
        } else {
            DomainController.getInstance().updateComponent(this.component, name, desc, restrictionsMap, valuesMap, relatedElements, view, this.composableComponents, this.connectableComponents, this.styleVariations, this.implementations, this.styles, selfComposable, selfConnectable);
        }
    }

    @Override
    public void fillValuesSpecific() throws DomainException {
        super.fillConstraintsAndValues((Element)this.component);
        for (StyleVariation e : this.component.getApplyTo()) {
            this.styleVariations.add(e);
        }
        this.styleVariationsList.refresh();
        for (StyleVariation e : this.component.getApplyToStyle()) {
            this.styles.add((Style)e);
        }
        this.stylesList.refresh();
        for (StyleVariation e : this.component.getImplementableWith()) {
            this.implementations.add((Implementation)e);
        }
        this.implementationsList.refresh();
        for (StyleVariation e : this.component.getComposableWith()) {
            if (e.equals((Object)this.component)) {
                this.selfComposable.setSelection(true);
                continue;
            }
            this.composableComponents.add((Component)e);
        }
        this.composibleComponentsList.refresh();
        for (StyleVariation e : this.component.getConnectedTo()) {
            if (e.equals((Object)this.component)) {
                this.selfConnectable.setSelection(true);
                continue;
            }
            this.connectableComponents.add((Component)e);
        }
        this.connectableComponentsList.refresh();
    }

    @Override
    public void setViewErrorsSpecific(String selViewName) {
        boolean newErr5;
        boolean oldErr1 = this.errors[2].isError;
        boolean newErr1 = !this.validComposables(selViewName);
        boolean oldErr2 = this.errors[3].isError;
        boolean newErr2 = !this.validConnectables(selViewName);
        boolean oldErr3 = this.errors[0].isError;
        boolean newErr3 = !this.validStyleVariations(selViewName);
        boolean oldErr4 = this.errors[1].isError;
        boolean newErr4 = !this.validImplementations(selViewName);
        boolean oldErr5 = this.errors[4].isError;
        boolean bl = newErr5 = !this.validStyles(selViewName);
        if (oldErr1 != newErr1 || oldErr2 != newErr2 || oldErr3 != newErr3 || oldErr4 != newErr4 || oldErr5 != newErr5) {
            this.errors[2].isError = newErr1;
            this.errors[3].isError = newErr2;
            this.errors[0].isError = newErr3;
            this.errors[1].isError = newErr4;
            this.errors[4].isError = newErr5;
        }
    }

    public boolean validComposables(String selViewName) {
        if (selViewName == null) {
            return true;
        }
        for (Element element : this.composableComponents) {
            if (element.getArchitecturalView().getName().equalsIgnoreCase(selViewName)) continue;
            return false;
        }
        return true;
    }

    public boolean validConnectables(String selViewName) {
        if (selViewName == null) {
            return true;
        }
        for (Element element : this.connectableComponents) {
            if (element.getArchitecturalView().getName().equalsIgnoreCase(selViewName)) continue;
            return false;
        }
        return true;
    }

    public boolean validStyleVariations(String selViewName) {
        if (selViewName == null) {
            return true;
        }
        for (Element element : this.styleVariations) {
            if (element.getArchitecturalView().getName().equalsIgnoreCase(selViewName)) continue;
            return false;
        }
        return true;
    }

    public boolean validStyles(String selViewName) {
        if (selViewName == null) {
            return true;
        }
        for (Element element : this.styles) {
            if (element.getArchitecturalView().getName().equalsIgnoreCase(selViewName)) continue;
            return false;
        }
        return true;
    }

    public boolean validImplementations(String selViewName) {
        if (selViewName == null) {
            return true;
        }
        for (Element element : this.implementations) {
            if (element.getArchitecturalView().getName().equalsIgnoreCase(selViewName)) continue;
            return false;
        }
        return true;
    }

    private Set<String> getComposableNames() {
        HashSet<String> names = new HashSet<String>();
        for (Element element : this.composableComponents) {
            names.add(element.getName());
        }
        return names;
    }

    private Set<String> getConnectableNames() {
        HashSet<String> names = new HashSet<String>();
        for (Element element : this.connectableComponents) {
            names.add(element.getName());
        }
        return names;
    }

    private Set<String> getStyleVariationNames() {
        HashSet<String> names = new HashSet<String>();
        for (Element element : this.styleVariations) {
            names.add(element.getName());
        }
        return names;
    }

    private Set<String> getStyleNames() {
        HashSet<String> names = new HashSet<String>();
        for (Element element : this.styles) {
            names.add(element.getName());
        }
        return names;
    }

    private Set<String> getImplementationNames() {
        HashSet<String> names = new HashSet<String>();
        for (Element element : this.implementations) {
            names.add(element.getName());
        }
        return names;
    }

    @Override
    public Long getElementId() {
        return this.component.getId();
    }

    @Override
    public void initErrorsSpecific() {
        this.errors[3] = new ErrorInfo("The connectable components must be from the same view", 3, false);
        this.errors[2] = new ErrorInfo("The composable componenst must be from the same view", 3, false);
        this.errors[0] = new ErrorInfo("The style variations must be from the same view", 3, false);
        this.errors[4] = new ErrorInfo("The styles must be from the same view", 3, false);
        this.errors[1] = new ErrorInfo("The implementations must be from the same view", 3, false);
        this.errors[5] = new ErrorInfo("The component must apply to at least 1 style", 3, this.isNew());
    }

    @Override
    public ErrorInfo[] getErrorsSpecific() {
        return this.errors;
    }

    @Override
    public boolean hasParentOrChildren() {
        return this.component.getParentElement() != null || !this.component.getChildElements().isEmpty();
    }

    @Override
    public Element getElement() {
        return this.component;
    }
}

