/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.element;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.controller.archViews.ArchitecturalViewContentProvider;
import upc.gessi.architech.controller.archViews.ArchitecturalViewLabelProvider;
import upc.gessi.architech.controller.archViews.ArchitecturalViewSorter;
import upc.gessi.architech.controller.elements.ElementContentProvider;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.controller.elements.ElementsSorter;
import upc.gessi.architech.controller.properties.ElementPropertiesContentProvider;
import upc.gessi.architech.controller.properties.ElementPropertiesLabelProvider;
import upc.gessi.architech.controller.properties.ElementPropertiesSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.constraint.RestrictionDialog;
import upc.gessi.architech.gui.dialogs.property.ElementPropertySelectionDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Restriction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.Decision;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalView;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.PropertyValue;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.ElementProperty;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public abstract class GenericElementDialog
extends TitleAreaDialog {
    private Text nameText;
    private Text valueText;
    private Text descriptionText;
    private List restrictionsList;
    private TableViewer propertiesList;
    private Button delPropertyButton;
    private Label infoLabel;
    private TableViewer relatedElementsViewer;
    private Button delRelatedElement;
    private TableViewer viewsList;
    private boolean isNew;
    private String name;
    private String desc;
    private ArchitecturalView view;
    private Map<String, TupleRestriction> restrictionsMap;
    private Map<ElementProperty, String> valuesMap;
    private Set<Element> relatedElements;
    private Element parent;
    private Shell shell;
    private static final int NUM_ERRORS = 5;
    private static final int EMPTY_NAME = 0;
    private static final int ALREADY_EXISTS = 1;
    private static final int BAD_RELATED_ELEMENT = 2;
    private static final int NO_VIEW = 3;
    private static final int CYCLES_ON_RELATED = 4;
    private ErrorInfo[] errors = new ErrorInfo[5];

    public GenericElementDialog(Element parent, Shell parentShell) throws DomainException {
        super(parentShell);
        this.isNew = true;
        this.restrictionsMap = new HashMap<String, TupleRestriction>();
        this.valuesMap = new HashMap<ElementProperty, String>();
        this.relatedElements = new HashSet<Element>();
        this.parent = parent != null ? (parent = DomainController.getInstance().getElementById(parent.getId())) : null;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public GenericElementDialog(Shell parentShell, String name, String desc) {
        super(parentShell);
        this.isNew = false;
        this.name = name;
        this.desc = desc;
        this.restrictionsMap = new HashMap<String, TupleRestriction>();
        this.valuesMap = new HashMap<ElementProperty, String>();
        this.relatedElements = new HashSet<Element>();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point p = new Point(400, 400);
        return p;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.shell = this.getShell();
        if (this.isNew) {
            this.shell.setText("New ");
        } else {
            this.shell.setText("Edit ");
        }
        this.createContentsSpecific(this.shell);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        try {
            TabFolder tabs = new TabFolder(contents, 128);
            tabs.setLayoutData((Object)new GridData(4, 4, true, true));
            tabs.setLayout((Layout)new GridLayout());
            this.createInformationTab(tabs);
            this.createConstrainTabs(tabs);
            this.createValuesTab(tabs);
            this.createOtherTabs(tabs);
            this.initErrors();
            if (!this.isNew) {
                this.fillValues();
            } else {
                this.fillValuesWhenNew();
            }
            return contents;
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
            return contents;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    private void createInformationTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Information");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Name: ");
        this.nameText = new Text(content, 2048);
        GridData gd1 = new GridData(4, 1, true, false);
        gd1.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd1);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                try {
                    boolean oldErr1 = ((GenericElementDialog)GenericElementDialog.this).errors[0].isError;
                    boolean newErr1 = GenericElementDialog.this.nameText.getText().length() == 0;
                    boolean oldErr2 = ((GenericElementDialog)GenericElementDialog.this).errors[1].isError;
                    Long id = null;
                    if (!GenericElementDialog.this.isNew) {
                        id = GenericElementDialog.this.getElementId();
                    }
                    boolean newErr2 = DomainController.getInstance().elementAlredyExists(GenericElementDialog.this.nameText.getText(), GenericElementDialog.this.isNew, id);
                    if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                        ((GenericElementDialog)GenericElementDialog.this).errors[0].isError = newErr1;
                        ((GenericElementDialog)GenericElementDialog.this).errors[1].isError = newErr2;
                        GenericElementDialog.this.validate();
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, GenericElementDialog.this.getShell());
                    dd.open();
                }
            }
        });
        Label label2 = new Label(content, 0);
        label2.setText("Description: ");
        GridData gd0 = new GridData(4, 0x1000000, true, false);
        gd0.horizontalSpan = 3;
        label2.setLayoutData((Object)gd0);
        this.descriptionText = new Text(content, 2626);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = 3;
        this.descriptionText.setLayoutData((Object)gd2);
        Label label6 = new Label(content, 0);
        label6.setText("Architectural View: ");
        GridData gd13 = new GridData(4, 0x1000000, true, false);
        label6.setLayoutData((Object)gd13);
        Label label5 = new Label(content, 0);
        label5.setText("Related Elements (from other views): ");
        GridData gd11 = new GridData(4, 0x1000000, true, false);
        gd11.horizontalSpan = 2;
        label5.setLayoutData((Object)gd11);
        this.viewsList = new TableViewer(content, 2052);
        this.viewsList.setContentProvider((IContentProvider)new ArchitecturalViewContentProvider());
        this.viewsList.setLabelProvider((IBaseLabelProvider)new ArchitecturalViewLabelProvider());
        this.viewsList.setSorter((ViewerSorter)new ArchitecturalViewSorter());
        GridData gd14 = new GridData(0x1000000, 4, false, true);
        gd14.verticalSpan = 2;
        gd14.heightHint = 50;
        gd14.widthHint = 150;
        this.viewsList.getTable().setLayoutData((Object)gd14);
        try {
            this.viewsList.setInput((Object)Model.getInstance().getViews());
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
        this.viewsList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                boolean newErr2;
                boolean oldErr1 = ((GenericElementDialog)GenericElementDialog.this).errors[3].isError;
                boolean newErr1 = GenericElementDialog.this.viewsList.getTable().getSelectionCount() == 0;
                boolean oldErr2 = ((GenericElementDialog)GenericElementDialog.this).errors[2].isError;
                boolean bl = newErr2 = !GenericElementDialog.this.validRelatedElements();
                if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                    ((GenericElementDialog)GenericElementDialog.this).errors[3].isError = newErr1;
                    ((GenericElementDialog)GenericElementDialog.this).errors[2].isError = newErr2;
                }
                if (GenericElementDialog.this.viewsList.getTable().getSelectionCount() != 0) {
                    GenericElementDialog.this.setViewErrorsSpecific(((ArchitecturalView)((IStructuredSelection)GenericElementDialog.this.viewsList.getSelection()).getFirstElement()).getName());
                }
                GenericElementDialog.this.validate();
            }
        });
        if (this.parent != null) {
            this.viewsList.setSelection((ISelection)new StructuredSelection((Object)this.parent.getArchitecturalView()), true);
            this.viewsList.getTable().setEnabled(false);
        }
        this.relatedElementsViewer = new TableViewer(content, 2048);
        this.relatedElementsViewer.setContentProvider((IContentProvider)new ElementContentProvider());
        this.relatedElementsViewer.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.relatedElementsViewer.setSorter((ViewerSorter)new ElementsSorter());
        this.relatedElementsViewer.setInput(this.relatedElements);
        GridData gd12 = new GridData(4, 4, true, true);
        gd12.verticalSpan = 2;
        gd12.heightHint = 120;
        gd12.widthHint = 200;
        this.relatedElementsViewer.getTable().setLayoutData((Object)gd12);
        this.relatedElementsViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                GenericElementDialog.this.delRelatedElement.setEnabled(true);
            }
        });
        Button butt5 = new Button(content, 8);
        butt5.setText("Add");
        butt5.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    int add;
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(GenericElementDialog.this.getShell(), (ILabelProvider)new ElementLabelProvider());
                    Set allElements = Model.getInstance().getElements();
                    HashSet<Element> validElements = new HashSet<Element>();
                    Object[] items = GenericElementDialog.this.getRelatedElementNames().toArray();
                    for (Element el : allElements) {
                        int n = add = GenericElementDialog.this.name != null && el.getName().equalsIgnoreCase(GenericElementDialog.this.name) ? 0 : 1;
                        if (add != 0) {
                            int i = 0;
                            while (i < items.length) {
                                if (el.getName().equalsIgnoreCase((String)items[i])) {
                                    add = 0;
                                }
                                ++i;
                            }
                        }
                        if (add == 0) continue;
                        validElements.add(el);
                    }
                    dg.setElements(validElements.toArray());
                    dg.setTitle("Browse Element");
                    dg.setMessage("Select one or more related elements");
                    if (dg.open() == 0) {
                        Object[] i = dg.getResult();
                        add = i.length;
                        int n = 0;
                        while (n < add) {
                            Object e = i[n];
                            GenericElementDialog.this.relatedElements.add(DomainController.getInstance().getElementById(((Element)e).getId()));
                            GenericElementDialog.this.relatedElementsViewer.refresh();
                            ++n;
                        }
                        boolean oldErr1 = ((GenericElementDialog)GenericElementDialog.this).errors[2].isError;
                        boolean newErr1 = !GenericElementDialog.this.validRelatedElements();
                        boolean oldErr2 = ((GenericElementDialog)GenericElementDialog.this).errors[4].isError;
                        boolean newErr2 = GenericElementDialog.this.noCyclesRelatedElements();
                        if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                            ((GenericElementDialog)GenericElementDialog.this).errors[2].isError = newErr1;
                            ((GenericElementDialog)GenericElementDialog.this).errors[4].isError = newErr2;
                            GenericElementDialog.this.validate();
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, GenericElementDialog.this.getShell());
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, GenericElementDialog.this.getShell());
                    dd.open();
                }
            }
        });
        this.delRelatedElement = new Button(content, 8);
        this.delRelatedElement.setText("Delete");
        this.delRelatedElement.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!GenericElementDialog.this.relatedElementsViewer.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)GenericElementDialog.this.relatedElementsViewer.getSelection();
                    Element selElement = (Element)sel.getFirstElement();
                    GenericElementDialog.this.relatedElements.remove(selElement);
                    GenericElementDialog.this.relatedElementsViewer.refresh();
                    GenericElementDialog.this.delRelatedElement.setEnabled(false);
                    boolean oldErr1 = ((GenericElementDialog)GenericElementDialog.this).errors[2].isError;
                    boolean newErr1 = !GenericElementDialog.this.validRelatedElements();
                    boolean oldErr2 = ((GenericElementDialog)GenericElementDialog.this).errors[4].isError;
                    boolean newErr2 = GenericElementDialog.this.noCyclesRelatedElements();
                    if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                        ((GenericElementDialog)GenericElementDialog.this).errors[2].isError = newErr1;
                        ((GenericElementDialog)GenericElementDialog.this).errors[4].isError = newErr2;
                        GenericElementDialog.this.validate();
                    }
                }
            }
        });
        this.delRelatedElement.setEnabled(false);
    }

    private void createConstrainTabs(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Restrictions");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label3 = new Label(content, 0);
        label3.setText("Restrictions: ");
        GridData gd3 = new GridData(4, 0x1000000, true, false);
        gd3.horizontalSpan = 2;
        label3.setLayoutData((Object)gd3);
        this.restrictionsList = new List(content, 2816);
        GridData gd5 = new GridData(4, 4, true, true);
        gd5.verticalSpan = 2;
        this.restrictionsList.setLayoutData((Object)gd5);
        GenericElementDialog me = this;
        this.restrictionsList.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                String selRestriction = GenericElementDialog.this.restrictionsList.getSelection()[0];
                int selIndex = GenericElementDialog.this.restrictionsList.getSelectionIndex();
                try {
                    RestrictionDialog dialog = new RestrictionDialog(GenericElementDialog.this.shell, selRestriction, (TupleRestriction)GenericElementDialog.this.restrictionsMap.get(selRestriction), me, GenericElementDialog.this.name);
                    if (dialog.open() == 0) {
                        TupleRestriction res = dialog.getResult();
                        GenericElementDialog.this.restrictionsMap.remove(selRestriction);
                        GenericElementDialog.this.restrictionsList.remove(selRestriction);
                        String restrictionName = dialog.getNameResult();
                        GenericElementDialog.this.restrictionsMap.put(restrictionName, res);
                        GenericElementDialog.this.restrictionsList.add(restrictionName, selIndex);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Button butt = new Button(content, 8);
        butt.setText("Add Restriction");
        GridData gd7 = new GridData(16384, 0x1000000, false, false);
        butt.setLayoutData((Object)gd7);
        butt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    RestrictionDialog dialog = new RestrictionDialog(GenericElementDialog.this.shell, me, GenericElementDialog.this.name);
                    if (dialog.open() == 0) {
                        TupleRestriction res = dialog.getResult();
                        String restrictionName = dialog.getNameResult();
                        GenericElementDialog.this.restrictionsMap.put(restrictionName, res);
                        GenericElementDialog.this.restrictionsList.add(restrictionName);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Button butt2 = new Button(content, 8);
        butt2.setText("Delete Restriction");
        GridData gd9 = new GridData(16384, 0x1000000, false, false);
        butt2.setLayoutData((Object)gd9);
        butt2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                String rName = GenericElementDialog.this.restrictionsList.getSelection()[0];
                GenericElementDialog.this.restrictionsList.remove(rName);
                GenericElementDialog.this.restrictionsMap.remove(rName);
            }
        });
    }

    private void createValuesTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Property Values");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Properties:");
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalSpan = 3;
        label1.setLayoutData((Object)gd);
        this.propertiesList = new TableViewer(content, 2820);
        GridData gd1 = new GridData(4, 4, true, true);
        this.propertiesList.setContentProvider((IContentProvider)new ElementPropertiesContentProvider());
        this.propertiesList.setLabelProvider((IBaseLabelProvider)new ElementPropertiesLabelProvider());
        this.propertiesList.setSorter((ViewerSorter)new ElementPropertiesSorter());
        this.propertiesList.setInput(this.valuesMap.keySet());
        gd1.heightHint = 50;
        gd1.widthHint = 250;
        gd1.horizontalSpan = 2;
        gd1.verticalSpan = 3;
        this.propertiesList.getTable().setLayoutData((Object)gd1);
        this.propertiesList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ElementProperty selProperty = GenericElementDialog.this.getSelectedProperty();
                    GenericElementDialog.this.valueText.setText((String)GenericElementDialog.this.valuesMap.get(selProperty));
                    GenericElementDialog.this.delPropertyButton.setEnabled(true);
                    GenericElementDialog.this.setLabelInfo(selProperty);
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, GenericElementDialog.this.shell);
                    dd.open();
                }
            }
        });
        Label label2 = new Label(content, 0);
        label2.setText("Value: ");
        GridData gd0 = new GridData(16384, 0x1000000, false, false);
        label2.setLayoutData((Object)gd0);
        this.valueText = new Text(content, 2048);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.widthHint = 300;
        this.valueText.setLayoutData((Object)gd2);
        this.valueText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (GenericElementDialog.this.propertiesList.getSelection().isEmpty()) {
                    GenericElementDialog.this.propertiesList.getTable().setFocus();
                }
            }

            public void focusLost(FocusEvent e) {
                if (!GenericElementDialog.this.propertiesList.getSelection().isEmpty()) {
                    GenericElementDialog.this.valuesMap.put(GenericElementDialog.this.getSelectedProperty(), GenericElementDialog.this.valueText.getText());
                }
            }
        });
        this.infoLabel = new Label(content, 64);
        GridData gd3 = new GridData(4, 0x1000000, true, false);
        this.infoLabel.setLayoutData((Object)gd3);
        Button addPropertyButton = new Button(content, 8);
        addPropertyButton.setText("Add...");
        addPropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    Set allProperties = Model.getInstance().getElementProperties();
                    HashSet<ElementProperty> usedProperties = new HashSet<ElementProperty>();
                    Object[] items = GenericElementDialog.this.getPropertiesNames().toArray();
                    block3: for (ElementProperty p : allProperties) {
                        int i = 0;
                        while (i < items.length) {
                            if (p.getName().equalsIgnoreCase((String)items[i])) {
                                usedProperties.add(p);
                                continue block3;
                            }
                            ++i;
                        }
                    }
                    ElementPropertySelectionDialog dialog = new ElementPropertySelectionDialog(GenericElementDialog.this.shell, usedProperties);
                    dialog.setTitle("Browse Element Property");
                    dialog.setMessage("Here you can create, edit and delete Element Properties.\n\nSelect an Element Property:");
                    if (dialog.open() == 0) {
                        ElementProperty result = (ElementProperty)dialog.getFirstResult();
                        GenericElementDialog.this.valuesMap.put(result, "");
                        GenericElementDialog.this.propertiesList.refresh();
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, GenericElementDialog.this.shell);
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, GenericElementDialog.this.shell);
                    dd.open();
                }
            }
        });
        this.delPropertyButton = new Button(content, 8);
        this.delPropertyButton.setText("Delete...");
        this.delPropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ElementProperty selProperty = GenericElementDialog.this.getSelectedProperty();
                GenericElementDialog.this.valuesMap.remove(selProperty);
                GenericElementDialog.this.propertiesList.refresh();
                GenericElementDialog.this.delPropertyButton.setEnabled(false);
                GenericElementDialog.this.valueText.setText("");
                GenericElementDialog.this.infoLabel.setText("");
            }
        });
        this.delPropertyButton.setEnabled(false);
    }

    private void fillValues() throws DomainException {
        this.nameText.setText(this.name);
        if (this.desc != null) {
            this.descriptionText.setText(this.desc);
        }
        this.fillValuesSpecific();
    }

    public void fillConstraintsAndValues(Element element) throws DomainException {
        this.getElementRestrictionsInfo(element);
        this.getElementValuesInfo(element);
        this.propertiesList.refresh();
        for (String c : this.restrictionsMap.keySet()) {
            this.restrictionsList.add(c);
        }
        for (Element e : element.getRelatedElements()) {
            this.relatedElements.add(e);
        }
        this.relatedElementsViewer.refresh();
        this.view = element.getArchitecturalView();
        this.viewsList.setSelection((ISelection)new StructuredSelection((Object)this.view), true);
    }

    public void getElementRestrictionsInfo(Element element) {
        for (Restriction r : element.getRestrictions()) {
            TupleRestriction res = new TupleRestriction();
            this.restrictionsMap.put(r.getName(), res);
            for (Decision d : r.getDecisions()) {
                res.decisions.add(d);
            }
        }
    }

    public void getElementValuesInfo(Element element) throws DomainException {
        for (PropertyValue pv : element.getPropertyValues()) {
            this.valuesMap.put(pv.getProperty(), pv.getValue());
        }
    }

    public boolean alredyHaveRestriction(String newName, String oldName) {
        String[] rests = this.restrictionsList.getItems();
        if (oldName == null) {
            String[] stringArray = rests;
            int n = rests.length;
            int n2 = 0;
            while (n2 < n) {
                String r = stringArray[n2];
                if (r.equalsIgnoreCase(newName)) {
                    return true;
                }
                ++n2;
            }
        } else {
            String[] stringArray = rests;
            int n = rests.length;
            int n3 = 0;
            while (n3 < n) {
                String r = stringArray[n3];
                if (r.equalsIgnoreCase(newName) && !r.equalsIgnoreCase(oldName)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean validRelatedElements() {
        if (this.viewsList.getTable().getSelectionCount() == 0) {
            return true;
        }
        String selViewName = ((ArchitecturalView)((IStructuredSelection)this.viewsList.getSelection()).getFirstElement()).getName();
        for (Element el : this.relatedElements) {
            if (!el.getArchitecturalView().getName().equalsIgnoreCase(selViewName)) continue;
            return false;
        }
        return true;
    }

    private boolean validValues() {
        for (ElementProperty key : this.valuesMap.keySet()) {
            String value = this.valuesMap.get(key);
            if (!value.equals("") && key.getType().isTypeOf(value)) continue;
            return false;
        }
        return true;
    }

    public boolean noCyclesRelatedElements() {
        if (this.isNew) {
            return false;
        }
        return this.getElement().cyclesOnRelatedElements(this.relatedElements);
    }

    protected void okPressed() {
        try {
            boolean canceled = false;
            ArchitecturalView archView = (ArchitecturalView)((IStructuredSelection)this.viewsList.getSelection()).getFirstElement();
            String eName = this.nameText.getText();
            String eDescription = this.descriptionText.getText();
            if (!this.validValues()) {
                this.setErrorMessage("Some of the property values are not correct");
            } else {
                boolean ok = true;
                if (!this.isNew && !archView.equals((Object)this.view)) {
                    String message = "You want to change the view of the element, but there may be some other elements that are counting on this not to change its view. This may affect these elements.";
                    boolean parent = false;
                    if (this.hasParentOrChildren()) {
                        message = String.valueOf(message) + " Specially note that:\n\t- The specialized or parent elements will change the view accordingly.";
                        parent = true;
                    }
                    if (this.isStyle()) {
                        if (!parent) {
                            message = String.valueOf(message) + " Specially note that:";
                        }
                        message = String.valueOf(message) + "\n\t- The style variations for this style ";
                        if (parent) {
                            message = String.valueOf(message) + "(and its specialized and parent styles)";
                        }
                        message = String.valueOf(message) + " will change the view accordingly.";
                    }
                    ok = MessageDialog.openConfirm((Shell)this.shell, (String)"Update Property", (String)(String.valueOf(message) + "\n\nDo yo want to continue?"));
                }
                if (ok) {
                    this.doOk(eName, eDescription, this.restrictionsMap, this.valuesMap, this.relatedElements, this.parent, archView, this.isNew);
                } else {
                    canceled = true;
                }
                if (!canceled) {
                    super.okPressed();
                }
            }
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.setErrorMessage(e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknow Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void initErrors() {
        this.errors[0] = new ErrorInfo("The name can't be empty", 3, this.isNew);
        this.errors[1] = new ErrorInfo("An element with the same name alredy exists", 3, false);
        this.errors[2] = new ErrorInfo("The related elements must be from different views", 3, false);
        this.errors[3] = new ErrorInfo("A view needs to be selected", 3, this.isNew && this.parent == null);
        this.errors[4] = new ErrorInfo("One of the related elements is producing a \"related-elements cycle\"", 3, false);
        this.initErrorsSpecific();
    }

    private void setLabelInfo(ElementProperty selProperty) throws DomainException {
        this.infoLabel.setText(selProperty.getType().toString());
    }

    public void validate() {
        ErrorInfo[] allErrors;
        boolean error = false;
        ErrorInfo[] errorsSpecific = this.getErrorsSpecific();
        if (errorsSpecific != null) {
            int numErrorsSpecific = errorsSpecific.length;
            allErrors = new ErrorInfo[5 + numErrorsSpecific];
            System.arraycopy(this.errors, 0, allErrors, 0, 5);
            System.arraycopy(errorsSpecific, 0, allErrors, 5, numErrorsSpecific);
        } else {
            allErrors = this.errors;
        }
        ErrorInfo[] errorInfoArray = allErrors;
        int n = allErrors.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorInfo err = errorInfoArray[n2];
            if (err.isError) {
                this.setErrorMessage(err.message);
                error = true;
                break;
            }
            ++n2;
        }
        if (!error) {
            this.setErrorMessage(null);
        }
        this.getButton(0).setEnabled(!error);
    }

    private Set<String> getRelatedElementNames() {
        HashSet<String> elementNames = new HashSet<String>();
        for (Element el : this.relatedElements) {
            elementNames.add(el.getName());
        }
        return elementNames;
    }

    public String getSelectedViewName() {
        if (this.viewsList.getTable().getSelectionCount() != 0) {
            return ((ArchitecturalView)((IStructuredSelection)this.viewsList.getSelection()).getFirstElement()).getName();
        }
        return null;
    }

    private ElementProperty getSelectedProperty() {
        IStructuredSelection sel = (IStructuredSelection)this.propertiesList.getSelection();
        return (ElementProperty)sel.getFirstElement();
    }

    private Set<String> getPropertiesNames() {
        HashSet<String> names = new HashSet<String>();
        for (ElementProperty ep : this.valuesMap.keySet()) {
            names.add(ep.getName());
        }
        return names;
    }

    public void fillValuesWhenNew() {
    }

    public boolean isStyle() {
        return false;
    }

    public abstract void createContentsSpecific(Shell var1);

    public abstract void createOtherTabs(TabFolder var1);

    public abstract void fillValuesSpecific() throws DomainException;

    public abstract void doOk(String var1, String var2, Map<String, TupleRestriction> var3, Map<ElementProperty, String> var4, Set<Element> var5, Element var6, ArchitecturalView var7, boolean var8) throws DomainException;

    public abstract Long getElementId();

    public abstract void initErrorsSpecific();

    public abstract ErrorInfo[] getErrorsSpecific();

    public abstract void setViewErrorsSpecific(String var1);

    public abstract boolean hasParentOrChildren();

    public abstract Element getElement();
}

