/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.element;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.elements.ElementContentProvider;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.controller.elements.ElementsSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.element.GenericElementDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalView;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Component;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Implementation;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.ElementProperty;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public class ImplementationDialog
extends GenericElementDialog {
    private TableViewer componentsList;
    private Button delComponent;
    private Set<Component> components;
    private Implementation implementation;
    private static final int NUM_ERRORS_SPECIFIC = 1;
    private static final int BAD_COMPONENT = 0;
    private ErrorInfo[] errors = new ErrorInfo[1];

    public ImplementationDialog(Element parent, Shell parentShell) throws DomainException {
        super(parent, parentShell);
        this.components = new HashSet<Component>();
    }

    public ImplementationDialog(Shell parentShell, Implementation implementation) throws DomainException {
        super(parentShell, implementation.getName(), implementation.getDescription());
        this.components = new HashSet<Component>();
        this.implementation = implementation = DomainController.getInstance().getImplementationById(implementation, true);
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Implementation");
        this.setTitle("Implementation");
        this.setMessage("Enter the data for this Implementation");
        this.setTitleImage(Activator.getImageDescriptor("implementationIcon_48x48.png").createImage());
    }

    @Override
    public void createOtherTabs(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Components");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("This implementation may implement the following components...:");
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 2;
        label1.setLayoutData((Object)gd1);
        this.componentsList = new TableViewer(content, 2048);
        this.componentsList.setContentProvider((IContentProvider)new ElementContentProvider());
        this.componentsList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.componentsList.setSorter((ViewerSorter)new ElementsSorter());
        this.componentsList.setInput(this.components);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.verticalSpan = 2;
        this.componentsList.getTable().setLayoutData((Object)gd2);
        this.componentsList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ImplementationDialog.this.delComponent.setEnabled(true);
            }
        });
        Button butt1 = new Button(content, 8);
        butt1.setText("Add");
        butt1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(ImplementationDialog.this.getShell(), (ILabelProvider)new ElementLabelProvider());
                    Set allComponents = Model.getInstance().getComponents();
                    HashSet<Component> validComponents = new HashSet<Component>();
                    Object[] items = ImplementationDialog.this.getComponentNames().toArray();
                    for (Component el : allComponents) {
                        boolean add = true;
                        if (add) {
                            int i = 0;
                            while (i < items.length) {
                                if (el.getName().equalsIgnoreCase((String)items[i])) {
                                    add = false;
                                }
                                ++i;
                            }
                        }
                        if (!add) continue;
                        validComponents.add(el);
                    }
                    dg.setElements(validComponents.toArray());
                    dg.setTitle("Browse Component");
                    dg.setMessage("Select a component that can be implemented with this implementation");
                    if (dg.open() == 0) {
                        boolean newErr;
                        Object[] objectArray = dg.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object e = objectArray[n2];
                            ImplementationDialog.this.components.add((Component)e);
                            ImplementationDialog.this.componentsList.refresh();
                            ++n2;
                        }
                        boolean oldErr = ((ImplementationDialog)ImplementationDialog.this).errors[0].isError;
                        boolean bl = newErr = !ImplementationDialog.this.validComponents(ImplementationDialog.this.getSelectedViewName());
                        if (oldErr != newErr) {
                            ((ImplementationDialog)ImplementationDialog.this).errors[0].isError = newErr;
                            ImplementationDialog.this.validate();
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ImplementationDialog.this.getShell());
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ImplementationDialog.this.getShell());
                    dd.open();
                }
            }
        });
        this.delComponent = new Button(content, 8);
        this.delComponent.setText("Delete");
        this.delComponent.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!ImplementationDialog.this.componentsList.getSelection().isEmpty()) {
                    boolean newErr;
                    IStructuredSelection sel = (IStructuredSelection)ImplementationDialog.this.componentsList.getSelection();
                    Component selElement = (Component)sel.getFirstElement();
                    ImplementationDialog.this.components.remove(selElement);
                    ImplementationDialog.this.componentsList.refresh();
                    ImplementationDialog.this.delComponent.setEnabled(false);
                    boolean oldErr = ((ImplementationDialog)ImplementationDialog.this).errors[0].isError;
                    boolean bl = newErr = !ImplementationDialog.this.validComponents(ImplementationDialog.this.getSelectedViewName());
                    if (oldErr != newErr) {
                        ((ImplementationDialog)ImplementationDialog.this).errors[0].isError = newErr;
                        ImplementationDialog.this.validate();
                    }
                }
            }
        });
        this.delComponent.setEnabled(false);
    }

    @Override
    protected Point getInitialSize() {
        Point p = new Point(500, 600);
        return p;
    }

    @Override
    public void doOk(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<ElementProperty, String> valuesMap, Set<Element> relatedElements, Element parent, ArchitecturalView view, boolean isNew) throws DomainException {
        if (isNew) {
            DomainController.getInstance().newImplementation(name, desc, restrictionsMap, valuesMap, relatedElements, parent, view, this.components);
        } else {
            DomainController.getInstance().updateImplementation(this.implementation, name, desc, restrictionsMap, valuesMap, relatedElements, view, this.components);
        }
    }

    @Override
    public void fillValuesSpecific() throws DomainException {
        super.fillConstraintsAndValues((Element)this.implementation);
        for (Component e : this.implementation.getComponents()) {
            this.components.add(e);
        }
        this.componentsList.refresh();
    }

    @Override
    public void setViewErrorsSpecific(String selViewName) {
        boolean newErr;
        boolean oldErr = this.errors[0].isError;
        boolean bl = newErr = !this.validComponents(selViewName);
        if (oldErr != newErr) {
            this.errors[0].isError = newErr;
        }
    }

    public boolean validComponents(String selViewName) {
        if (selViewName == null) {
            return true;
        }
        for (Element element : this.components) {
            if (element.getArchitecturalView().getName().equalsIgnoreCase(selViewName)) continue;
            return false;
        }
        return true;
    }

    private Set<String> getComponentNames() {
        HashSet<String> names = new HashSet<String>();
        for (Element element : this.components) {
            names.add(element.getName());
        }
        return names;
    }

    @Override
    public Long getElementId() {
        return this.implementation.getId();
    }

    @Override
    public void initErrorsSpecific() {
        this.errors[0] = new ErrorInfo("The implementable components must be from the same view", 3, false);
    }

    @Override
    public ErrorInfo[] getErrorsSpecific() {
        return this.errors;
    }

    @Override
    public boolean hasParentOrChildren() {
        return this.implementation.getParentElement() != null || !this.implementation.getChildElements().isEmpty();
    }

    @Override
    public Element getElement() {
        return this.implementation;
    }
}

