/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.element;

import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import upc.gessi.architech.Activator;
import upc.gessi.architech.gui.dialogs.element.GenericElementDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalView;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Style;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.ElementProperty;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.ErrorInfo;

public class StyleDialog
extends GenericElementDialog {
    private Style style;

    public StyleDialog(Element parent, Shell parentShell) throws DomainException {
        super(parent, parentShell);
    }

    public StyleDialog(Shell parentShell, Style style) throws DomainException {
        super(parentShell, style.getName(), style.getDescription());
        this.style = style = DomainController.getInstance().getStyleById(style, true);
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Style");
        this.setTitle("Style");
        this.setMessage("Enter the data for this Style");
        this.setTitleImage(Activator.getImageDescriptor("styleIcon_48x48.png").createImage());
    }

    @Override
    public void createOtherTabs(TabFolder tabs) {
    }

    @Override
    protected Point getInitialSize() {
        Point p = new Point(500, 600);
        return p;
    }

    @Override
    public void doOk(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<ElementProperty, String> valuesMap, Set<Element> relatedElements, Element parent, ArchitecturalView view, boolean isNew) throws DomainException {
        if (isNew) {
            DomainController.getInstance().newStyle(name, desc, restrictionsMap, valuesMap, relatedElements, parent, view);
        } else {
            DomainController.getInstance().updateStyle(this.style, name, desc, restrictionsMap, valuesMap, relatedElements, view);
        }
    }

    @Override
    public void fillValuesSpecific() throws DomainException {
        super.fillConstraintsAndValues((Element)this.style);
    }

    @Override
    public void setViewErrorsSpecific(String selViewName) {
    }

    @Override
    public Long getElementId() {
        return this.style.getId();
    }

    @Override
    public void initErrorsSpecific() {
    }

    @Override
    public ErrorInfo[] getErrorsSpecific() {
        return null;
    }

    @Override
    public boolean hasParentOrChildren() {
        return this.style.getParentElement() != null || !this.style.getChildElements().isEmpty();
    }

    @Override
    public boolean isStyle() {
        return true;
    }

    @Override
    public Element getElement() {
        return this.style;
    }
}

