/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.element;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.elements.ElementContentProvider;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.controller.elements.ElementsSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.element.GenericElementDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.ArchitecturalView;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Style;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.StyleVariation;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.ElementProperty;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TupleRestriction;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public class StyleVariationDialog
extends GenericElementDialog {
    private StyleVariation styleVariation;
    private TableViewer stylesList;
    private TableViewer incompatibleVariationsList;
    private Button delIncompatibleVariation;
    private Style style;
    private Set<StyleVariation> incompatibleVariations;
    private static final int NUM_ERRORS = 4;
    private static final int NO_STYLE = 0;
    private static final int BAD_INCOMPATIBLE = 1;
    private static final int BAD_STYLE = 2;
    private static final int CANNOT_CHANGE_VIEW = 3;
    private ErrorInfo[] errors = new ErrorInfo[4];

    public StyleVariationDialog(Element parent, Shell parentShell) throws DomainException {
        super(parent, parentShell);
        this.incompatibleVariations = new HashSet<StyleVariation>();
    }

    public StyleVariationDialog(Shell parentShell, StyleVariation styleVariation) throws DomainException {
        super(parentShell, styleVariation.getName(), styleVariation.getDescription());
        styleVariation = DomainController.getInstance().getStyleVariationById(styleVariation, true);
        this.style = styleVariation.getVariationFor();
        this.styleVariation = styleVariation;
        this.incompatibleVariations = new HashSet<StyleVariation>();
    }

    @Override
    public void createContentsSpecific(Shell shell) {
        shell.setText(String.valueOf(shell.getText()) + "Style Variation");
        this.setTitle("Style Variation");
        this.setMessage("Enter the data for this Style Variation");
        this.setTitleImage(Activator.getImageDescriptor("styleVariationIcon_48x48.png").createImage());
    }

    @Override
    public void createOtherTabs(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Variation Attributes");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label = new Label(content, 0);
        label.setText("Variation for...: ");
        GridData g = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)g);
        Label label3 = new Label(content, 0);
        label3.setText("Incompatible variations: ");
        GridData g4 = new GridData(4, 0x1000000, true, false);
        g4.horizontalSpan = 2;
        label3.setLayoutData((Object)g4);
        this.stylesList = new TableViewer(content, 2052);
        this.stylesList.setContentProvider((IContentProvider)new ElementContentProvider());
        this.stylesList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.stylesList.setSorter((ViewerSorter)new ElementsSorter());
        GridData gd2 = new GridData(4, 4, false, true);
        gd2.verticalSpan = 2;
        this.stylesList.getTable().setLayoutData((Object)gd2);
        try {
            this.stylesList.setInput((Object)Model.getInstance().getStyles());
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.getShell());
            dd.open();
        }
        this.stylesList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                boolean newErr2;
                boolean oldErr1 = ((StyleVariationDialog)StyleVariationDialog.this).errors[0].isError;
                boolean newErr1 = StyleVariationDialog.this.stylesList.getTable().getSelectionCount() == 0;
                boolean oldErr2 = ((StyleVariationDialog)StyleVariationDialog.this).errors[2].isError;
                boolean bl = newErr2 = !StyleVariationDialog.this.validStyle(StyleVariationDialog.this.getSelectedViewName());
                if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                    ((StyleVariationDialog)StyleVariationDialog.this).errors[0].isError = newErr1;
                    ((StyleVariationDialog)StyleVariationDialog.this).errors[2].isError = newErr2;
                    StyleVariationDialog.this.validate();
                }
            }
        });
        this.incompatibleVariationsList = new TableViewer(content, 2048);
        this.incompatibleVariationsList.setContentProvider((IContentProvider)new ElementContentProvider());
        this.incompatibleVariationsList.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
        this.incompatibleVariationsList.setSorter((ViewerSorter)new ElementsSorter());
        this.incompatibleVariationsList.setInput(this.incompatibleVariations);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.verticalSpan = 2;
        this.incompatibleVariationsList.getTable().setLayoutData((Object)gd3);
        this.incompatibleVariationsList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                StyleVariationDialog.this.delIncompatibleVariation.setEnabled(true);
            }
        });
        Button butt3 = new Button(content, 8);
        butt3.setText("Add");
        butt3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    ElementListSelectionDialog dg = new ElementListSelectionDialog(StyleVariationDialog.this.getShell(), (ILabelProvider)new ElementLabelProvider());
                    Set allVariations = Model.getInstance().getStyleVariations();
                    HashSet<StyleVariation> validVariations = new HashSet<StyleVariation>();
                    Object[] items = StyleVariationDialog.this.getVariationNames().toArray();
                    for (StyleVariation sv : allVariations) {
                        boolean add;
                        boolean bl = add = StyleVariationDialog.this.styleVariation == null || !sv.getName().equalsIgnoreCase(StyleVariationDialog.this.styleVariation.getName());
                        if (add) {
                            int i = 0;
                            while (i < items.length) {
                                if (sv.getName().equalsIgnoreCase((String)items[i])) {
                                    add = false;
                                }
                                ++i;
                            }
                        }
                        if (!add) continue;
                        validVariations.add(sv);
                    }
                    dg.setElements(validVariations.toArray());
                    dg.setTitle("Browse Style Variation");
                    dg.setMessage("Select one or more incompatible style variations");
                    if (dg.open() == 0) {
                        boolean newErr;
                        Object[] objectArray = dg.getResult();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object e = objectArray[n2];
                            StyleVariationDialog.this.incompatibleVariations.add((StyleVariation)e);
                            StyleVariationDialog.this.incompatibleVariationsList.refresh();
                            ++n2;
                        }
                        boolean oldErr = ((StyleVariationDialog)StyleVariationDialog.this).errors[1].isError;
                        boolean bl = newErr = !StyleVariationDialog.this.validIncompatibles(StyleVariationDialog.this.getSelectedViewName());
                        if (oldErr != newErr) {
                            ((StyleVariationDialog)StyleVariationDialog.this).errors[1].isError = newErr;
                            StyleVariationDialog.this.validate();
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, StyleVariationDialog.this.getShell());
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, StyleVariationDialog.this.getShell());
                    dd.open();
                }
            }
        });
        this.delIncompatibleVariation = new Button(content, 8);
        this.delIncompatibleVariation.setText("Delete");
        this.delIncompatibleVariation.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (!StyleVariationDialog.this.incompatibleVariationsList.getSelection().isEmpty()) {
                    boolean newErr;
                    IStructuredSelection sel = (IStructuredSelection)StyleVariationDialog.this.incompatibleVariationsList.getSelection();
                    StyleVariation selElement = (StyleVariation)sel.getFirstElement();
                    StyleVariationDialog.this.incompatibleVariations.remove(selElement);
                    StyleVariationDialog.this.incompatibleVariationsList.refresh();
                    StyleVariationDialog.this.delIncompatibleVariation.setEnabled(false);
                    boolean oldErr = ((StyleVariationDialog)StyleVariationDialog.this).errors[1].isError;
                    boolean bl = newErr = !StyleVariationDialog.this.validIncompatibles(StyleVariationDialog.this.getSelectedViewName());
                    if (oldErr != newErr) {
                        ((StyleVariationDialog)StyleVariationDialog.this).errors[1].isError = newErr;
                        StyleVariationDialog.this.validate();
                    }
                }
            }
        });
        this.delIncompatibleVariation.setEnabled(false);
    }

    @Override
    protected Point getInitialSize() {
        Point p = new Point(500, 600);
        return p;
    }

    @Override
    public void doOk(String name, String desc, Map<String, TupleRestriction> restrictionsMap, Map<ElementProperty, String> valuesMap, Set<Element> relatedElements, Element parent, ArchitecturalView view, boolean isNew) throws DomainException {
        Style style = (Style)((IStructuredSelection)this.stylesList.getSelection()).getFirstElement();
        if (isNew) {
            DomainController.getInstance().newStyleVariation(name, desc, restrictionsMap, valuesMap, relatedElements, parent, view, style, this.incompatibleVariations);
        } else {
            DomainController.getInstance().updateStyleVariation(this.styleVariation, name, desc, restrictionsMap, valuesMap, relatedElements, view, style, this.incompatibleVariations);
        }
    }

    @Override
    public void fillValuesSpecific() throws DomainException {
        super.fillConstraintsAndValues((Element)this.styleVariation);
        this.stylesList.setSelection((ISelection)new StructuredSelection((Object)this.style), true);
        for (StyleVariation e : this.styleVariation.getIncompatibleWith()) {
            this.incompatibleVariations.add(e);
        }
        this.incompatibleVariationsList.refresh();
    }

    @Override
    public void setViewErrorsSpecific(String selViewName) {
        boolean newErr3;
        boolean oldErr1 = this.errors[1].isError;
        boolean newErr1 = !this.validIncompatibles(selViewName);
        boolean oldErr2 = this.errors[2].isError;
        boolean newErr2 = !this.validStyle(selViewName);
        boolean oldErr3 = this.errors[3].isError;
        boolean bl = this.isNew() ? false : (newErr3 = !this.styleVariation.getArchitecturalView().getName().equals(selViewName));
        if (oldErr1 != newErr1 || oldErr2 != newErr2 || oldErr3 != newErr3) {
            this.errors[1].isError = newErr1;
            this.errors[2].isError = newErr2;
            this.errors[3].isError = newErr3;
        }
    }

    public boolean validIncompatibles(String selViewName) {
        if (selViewName == null) {
            return true;
        }
        for (Element element : this.incompatibleVariations) {
            if (element.getArchitecturalView().getName().equalsIgnoreCase(selViewName)) continue;
            return false;
        }
        return true;
    }

    public boolean validStyle(String selViewName) {
        if (selViewName == null || this.stylesList.getSelection().isEmpty()) {
            return true;
        }
        Style selectedStyle = (Style)((IStructuredSelection)this.stylesList.getSelection()).getFirstElement();
        return selectedStyle.getArchitecturalView().getName().equalsIgnoreCase(selViewName);
    }

    private Set<String> getVariationNames() {
        HashSet<String> names = new HashSet<String>();
        for (Element element : this.incompatibleVariations) {
            names.add(element.getName());
        }
        return names;
    }

    @Override
    public Long getElementId() {
        return this.styleVariation.getId();
    }

    @Override
    public void initErrorsSpecific() {
        this.errors[0] = new ErrorInfo("A style needs to be selected", 3, this.isNew());
        this.errors[1] = new ErrorInfo("The incompatible variations must be from the same view", 3, false);
        this.errors[2] = new ErrorInfo("The style must be from the same view", 3, false);
        this.errors[3] = new ErrorInfo("It is not possible to change the view of an style variation, such this is dependant on the view of its style.\n\nIf you want to change the view of this variation, it will be done automatically by changing the view of the style", 3, false);
    }

    @Override
    public ErrorInfo[] getErrorsSpecific() {
        return this.errors;
    }

    @Override
    public boolean hasParentOrChildren() {
        return this.styleVariation.getParentElement() != null || !this.styleVariation.getChildElements().isEmpty();
    }

    @Override
    public Element getElement() {
        return this.styleVariation;
    }
}

