/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.property;

import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import upc.gessi.architech.controller.questions.QuestionContentProvider;
import upc.gessi.architech.controller.questions.QuestionLabelProvider;
import upc.gessi.architech.controller.questions.QuestionSorter;
import upc.gessi.architech.controller.types.TypeContentProvider;
import upc.gessi.architech.controller.types.TypeLabelProvider;
import upc.gessi.architech.controller.types.TypeSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.constraint.Condition;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.ElementProperty;
import upc.gessi.architech.hibernatehelper.domain.domainModel.propertyRule.PropertyRule;
import upc.gessi.architech.hibernatehelper.domain.domainModel.propertyRule.prQuestionRestriction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.question.Question;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.hibernatehelper.utils.TuplePropertyRulesMap;
import upc.gessi.architech.parser.ConditionParser;
import upc.gessi.architech.parser.ParseException;
import upc.gessi.architech.parser.QuestionsValueCondition;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public class ElementPropertyDialog
extends TitleAreaDialog {
    private Text nameText;
    private Text descriptionText;
    private Text restrictionText;
    private Text conditionText;
    private List rulesList;
    private TableViewer questionsList;
    private TableViewer typesList;
    private boolean isNew;
    private ElementProperty property;
    private Map<String, TuplePropertyRulesMap> rulesMap;
    private Shell shell;
    private static final int NUM_ERRORS = 3;
    private static final int EMPTY_NAME = 0;
    private static final int NO_TYPE = 1;
    private static final int ALREADY_EXISTS = 2;
    private ErrorInfo[] errors = new ErrorInfo[3];
    private static final int NO_ERROR = -1;
    private static final int PARSING_RESTRICTION_ERROR = 0;
    private static final int PARSING_CONDITION_ERROR = 1;
    private static final int ERROR = 2;

    public ElementPropertyDialog(Shell parentShell) throws DomainException {
        super(parentShell);
        this.isNew = true;
        this.rulesMap = new HashMap<String, TuplePropertyRulesMap>();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public ElementPropertyDialog(Shell parentShell, ElementProperty ep) throws DomainException {
        super(parentShell);
        this.property = DomainController.getInstance().getElementPropertyById(ep, true);
        this.isNew = false;
        this.rulesMap = new HashMap<String, TuplePropertyRulesMap>();
        this.getPropertyRulesInfo();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point p = new Point(500, 650);
        return p;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.shell = this.getShell();
        if (this.isNew) {
            this.shell.setText("New Element Property");
        } else {
            this.shell.setText("Edit Element Property");
        }
        this.setTitle("Element Property");
        this.setMessage("Enter the data for this element property");
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        try {
            TabFolder tabs = new TabFolder(contents, 128);
            tabs.setLayoutData((Object)new GridData(4, 4, true, true));
            tabs.setLayout((Layout)new GridLayout());
            this.createInformationTab(tabs);
            this.createRulesTab(tabs);
            this.initErrors();
            this.fillValues();
            return contents;
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
            return contents;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    private void createInformationTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Information");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Name: ");
        this.nameText = new Text(content, 2048);
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd1);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                try {
                    boolean oldErr1 = ((ElementPropertyDialog)ElementPropertyDialog.this).errors[0].isError;
                    boolean newErr1 = ElementPropertyDialog.this.nameText.getText().length() == 0;
                    boolean oldErr2 = ((ElementPropertyDialog)ElementPropertyDialog.this).errors[2].isError;
                    Long id = null;
                    if (!ElementPropertyDialog.this.isNew) {
                        id = ElementPropertyDialog.this.property.getId();
                    }
                    boolean newErr2 = DomainController.getInstance().elementPropertyAlredyExists(ElementPropertyDialog.this.nameText.getText(), ElementPropertyDialog.this.isNew, id);
                    if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                        ((ElementPropertyDialog)ElementPropertyDialog.this).errors[0].isError = newErr1;
                        ((ElementPropertyDialog)ElementPropertyDialog.this).errors[2].isError = newErr2;
                        ElementPropertyDialog.this.validate();
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ElementPropertyDialog.this.getShell());
                    dd.open();
                }
            }
        });
        Label label4 = new Label(content, 0);
        label4.setText("Description: ");
        GridData gd6 = new GridData(4, 0x1000000, true, false);
        gd6.horizontalSpan = 3;
        label4.setLayoutData((Object)gd6);
        this.descriptionText = new Text(content, 2626);
        GridData gd7 = new GridData(4, 4, true, true);
        gd7.horizontalSpan = 3;
        this.descriptionText.setLayoutData((Object)gd7);
        Label label2 = new Label(content, 0);
        label2.setText("Type: ");
        GridData gd2 = new GridData(0x1000000, 0x1000000, false, false);
        gd2.horizontalSpan = 3;
        label2.setLayoutData((Object)gd2);
        this.typesList = new TableViewer(content, 2052);
        this.typesList.setContentProvider((IContentProvider)new TypeContentProvider());
        this.typesList.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        this.typesList.setSorter((ViewerSorter)new TypeSorter());
        GridData gd4 = new GridData(0x1000000, 4, false, true);
        gd4.heightHint = 50;
        gd4.widthHint = 150;
        gd4.horizontalSpan = 3;
        this.typesList.getTable().setLayoutData((Object)gd4);
        try {
            this.typesList.setInput((Object)Model.getInstance().getTypes());
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
        this.typesList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                boolean newErr;
                boolean oldErr = ((ElementPropertyDialog)ElementPropertyDialog.this).errors[1].isError;
                boolean bl = newErr = ElementPropertyDialog.this.typesList.getTable().getSelectionCount() == 0;
                if (oldErr != newErr) {
                    ((ElementPropertyDialog)ElementPropertyDialog.this).errors[1].isError = newErr;
                    ElementPropertyDialog.this.validate();
                }
            }
        });
    }

    private void createRulesTab(TabFolder tabs) {
        TabItem tabitem = new TabItem(tabs, 0);
        tabitem.setText("Rules");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabitem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Rules:");
        Label label2 = new Label(content, 0);
        label2.setText("IF:");
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 2;
        label2.setLayoutData((Object)gd1);
        this.rulesList = new List(content, 2820);
        GridData gd2 = new GridData(0x1000000, 4, false, true);
        gd2.verticalSpan = 6;
        gd2.heightHint = 125;
        gd2.widthHint = 70;
        this.rulesList.setLayoutData((Object)gd2);
        this.rulesList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (ElementPropertyDialog.this.rulesList.getSelection().length != 0) {
                    ElementPropertyDialog.this.questionsList.setInput((Object)ElementPropertyDialog.this.getCurrentQuestions());
                    ElementPropertyDialog.this.restrictionText.setText("");
                    TuplePropertyRulesMap res = (TuplePropertyRulesMap)ElementPropertyDialog.this.rulesMap.get(ElementPropertyDialog.this.rulesList.getSelection()[0]);
                    ElementPropertyDialog.this.conditionText.setText(res.condition);
                }
            }
        });
        this.questionsList = new TableViewer(content, 2820);
        GridData gd3 = new GridData(0x1000000, 0x1000000, false, false);
        this.questionsList.setContentProvider((IContentProvider)new QuestionContentProvider());
        this.questionsList.setLabelProvider((IBaseLabelProvider)new QuestionLabelProvider());
        this.questionsList.setSorter((ViewerSorter)new QuestionSorter());
        this.questionsList.setInput(null);
        gd3.verticalSpan = 2;
        gd3.heightHint = 120;
        gd3.widthHint = 200;
        this.questionsList.getTable().setLayoutData((Object)gd3);
        this.questionsList.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (ElementPropertyDialog.this.rulesList.getSelection().length != 0) {
                    TuplePropertyRulesMap res = (TuplePropertyRulesMap)ElementPropertyDialog.this.rulesMap.get(ElementPropertyDialog.this.rulesList.getSelection()[0]);
                    Question selectedQuestion = ElementPropertyDialog.this.getSelectedQuestion();
                    ElementPropertyDialog.this.restrictionText.setText((String)res.ifQuestions.get(selectedQuestion));
                }
            }
        });
        Button addQuestionButton = new Button(content, 8);
        addQuestionButton.setText("Add");
        addQuestionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                try {
                    if (ElementPropertyDialog.this.rulesList.getSelection().length != 0) {
                        ElementListSelectionDialog dg = new ElementListSelectionDialog(ElementPropertyDialog.this.shell, (ILabelProvider)new QuestionLabelProvider());
                        Set allQuestions = Model.getInstance().getQuestions();
                        HashSet<Question> validQuestions = new HashSet<Question>();
                        Object[] items = ElementPropertyDialog.this.getQuestionNames().toArray();
                        for (Question q : allQuestions) {
                            boolean add = true;
                            int i = 0;
                            while (i < items.length) {
                                if (q.getText().equalsIgnoreCase((String)items[i])) {
                                    add = false;
                                }
                                ++i;
                            }
                            if (!add) continue;
                            validQuestions.add(q);
                        }
                        dg.setElements(validQuestions.toArray());
                        dg.setTitle("Browse Question");
                        dg.setMessage("Select a Question:");
                        dg.setMultipleSelection(false);
                        if (dg.open() == 0) {
                            Question result = (Question)dg.getFirstResult();
                            TuplePropertyRulesMap res = (TuplePropertyRulesMap)ElementPropertyDialog.this.rulesMap.get(ElementPropertyDialog.this.rulesList.getSelection()[0]);
                            res.ifQuestions.put(result, "");
                            ElementPropertyDialog.this.questionsList.refresh();
                        }
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ElementPropertyDialog.this.shell);
                    dd.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementPropertyDialog.this.shell);
                    dd.open();
                }
            }
        });
        Button delQuestionButton = new Button(content, 8);
        delQuestionButton.setText("Delete");
        delQuestionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (ElementPropertyDialog.this.rulesList.getSelection().length != 0) {
                    TuplePropertyRulesMap res = (TuplePropertyRulesMap)ElementPropertyDialog.this.rulesMap.get(ElementPropertyDialog.this.rulesList.getSelection()[0]);
                    Question selQuestion = ElementPropertyDialog.this.getSelectedQuestion();
                    res.ifQuestions.remove(selQuestion);
                    ElementPropertyDialog.this.restrictionText.setText("");
                    ElementPropertyDialog.this.questionsList.refresh();
                }
            }
        });
        Label label3 = new Label(content, 0);
        label3.setText("Restriction on the answer: ");
        GridData gd4 = new GridData(4, 0x1000000, true, false);
        gd4.horizontalSpan = 2;
        label3.setLayoutData((Object)gd4);
        this.restrictionText = new Text(content, 2818);
        GridData gd5 = new GridData(4, 4, true, true);
        gd5.horizontalSpan = 2;
        this.restrictionText.setLayoutData((Object)gd5);
        this.restrictionText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (ElementPropertyDialog.this.questionsList.getSelection().isEmpty()) {
                    ElementPropertyDialog.this.questionsList.getTable().setFocus();
                }
            }

            public void focusLost(FocusEvent e) {
                if (!ElementPropertyDialog.this.questionsList.getSelection().isEmpty()) {
                    TuplePropertyRulesMap selRes = (TuplePropertyRulesMap)ElementPropertyDialog.this.rulesMap.get(ElementPropertyDialog.this.rulesList.getSelection()[0]);
                    selRes.ifQuestions.put(ElementPropertyDialog.this.getSelectedQuestion(), ElementPropertyDialog.this.restrictionText.getText());
                }
            }
        });
        Label label4 = new Label(content, 0);
        label4.setText("THEN: ");
        GridData gd8 = new GridData(4, 0x1000000, true, false);
        gd8.horizontalSpan = 2;
        label4.setLayoutData((Object)gd8);
        this.conditionText = new Text(content, 2818);
        GridData gd9 = new GridData(4, 4, true, true);
        gd9.horizontalSpan = 2;
        this.conditionText.setLayoutData((Object)gd5);
        this.conditionText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (ElementPropertyDialog.this.rulesList.getSelection().length == 0) {
                    ElementPropertyDialog.this.rulesList.setFocus();
                }
            }

            public void focusLost(FocusEvent e) {
                if (ElementPropertyDialog.this.rulesList.getSelection().length != 0) {
                    String selRule = ElementPropertyDialog.this.rulesList.getSelection()[0];
                    TuplePropertyRulesMap selRes = (TuplePropertyRulesMap)ElementPropertyDialog.this.rulesMap.get(selRule);
                    selRes.condition = ElementPropertyDialog.this.conditionText.getText();
                }
            }
        });
        Button addRule = new Button(content, 8);
        addRule.setText("New Rule");
        GridData gd6 = new GridData(1, 0x1000000, false, false);
        gd6.horizontalSpan = 3;
        addRule.setLayoutData((Object)gd6);
        addRule.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                InputDialog dg = new InputDialog(ElementPropertyDialog.this.shell, "New Rule", "Introduce a name for the rule: ", "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText == null || newText.equals("")) {
                            return "Introdue a Name";
                        }
                        if (ElementPropertyDialog.this.rulesMap.containsKey(newText)) {
                            return "There is already a rule with the same name";
                        }
                        return null;
                    }
                });
                if (dg.open() == 0) {
                    String rName = dg.getValue();
                    ElementPropertyDialog.this.rulesList.add(rName);
                    ElementPropertyDialog.this.rulesMap.put(rName, new TuplePropertyRulesMap());
                }
            }
        });
        Button delRule = new Button(content, 8);
        delRule.setText("Delete Rule");
        GridData gd7 = new GridData(1, 0x1000000, false, false);
        gd7.horizontalSpan = 3;
        delRule.setLayoutData((Object)gd7);
        delRule.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                String rName = ElementPropertyDialog.this.rulesList.getSelection()[0];
                ElementPropertyDialog.this.rulesList.remove(rName);
                ElementPropertyDialog.this.questionsList.setInput(null);
                ElementPropertyDialog.this.restrictionText.setText("");
                ElementPropertyDialog.this.conditionText.setText("");
                ElementPropertyDialog.this.rulesMap.remove(rName);
            }
        });
    }

    public void getPropertyRulesInfo() throws DomainException {
        for (Condition c : this.property.getConditions()) {
            if (!(c instanceof PropertyRule)) continue;
            PropertyRule pr = (PropertyRule)c;
            TuplePropertyRulesMap res = new TuplePropertyRulesMap();
            this.rulesMap.put(pr.getName(), res);
            res.condition = pr.getPropertyCondition();
            for (prQuestionRestriction prq : pr.getQuestionRestrictions()) {
                res.ifQuestions.put(prq.getQuestion(), prq.getRestriction());
            }
        }
    }

    private void fillValues() throws DomainException {
        if (!this.isNew) {
            this.nameText.setText(this.property.getName());
            String pDescription = this.property.getDescription();
            if (pDescription != null) {
                this.descriptionText.setText(pDescription);
            }
            this.typesList.setSelection((ISelection)new StructuredSelection((Object)this.property.getType()), true);
            for (String qr : this.rulesMap.keySet()) {
                this.rulesList.add(qr);
            }
        }
    }

    private int validRules() {
        for (String rule : this.rulesMap.keySet()) {
            TuplePropertyRulesMap res = this.rulesMap.get(rule);
            if (res.ifQuestions.isEmpty()) {
                return 2;
            }
            String condition = res.condition;
            if (condition.equals("")) {
                return 2;
            }
            try {
                if (!this.typesList.getSelection().isEmpty()) {
                    DataType pType = (DataType)((IStructuredSelection)this.typesList.getSelection()).getFirstElement();
                    ConditionParser cp = new ConditionParser(new StringReader(String.valueOf(condition) + ";"));
                    cp.setDataType(pType);
                    cp.Start();
                }
            }
            catch (ParseException parseException) {
                return 1;
            }
            for (Question q : res.ifQuestions.keySet()) {
                if (((String)res.ifQuestions.get(q)).equals("")) {
                    return 2;
                }
                String rest = (String)res.ifQuestions.get(q);
                try {
                    DataType qType = q.getQuestionType();
                    QuestionsValueCondition cv = new QuestionsValueCondition(new StringReader(String.valueOf(rest) + ";"));
                    cv.setDataType(qType);
                    cv.Start();
                }
                catch (ParseException parseException) {
                    return 0;
                }
            }
        }
        return -1;
    }

    protected void okPressed() {
        try {
            boolean canceled = false;
            DataType type = (DataType)((IStructuredSelection)this.typesList.getSelection()).getFirstElement();
            String pName = this.nameText.getText();
            String pDescription = this.descriptionText.getText();
            int err = this.validRules();
            if (err >= 0) {
                if (err == 0) {
                    this.setErrorMessage("Error parsing the restriction over a question's answer");
                } else if (err == 1) {
                    this.setErrorMessage("Error parsing the condition over the property established by a rule");
                } else {
                    this.setErrorMessage("There is some problem with the rules");
                }
            } else {
                if (this.isNew) {
                    DomainController.getInstance().newElementProperty(type, pName, pDescription, this.rulesMap);
                } else {
                    boolean ok = true;
                    if (!type.equals((Object)this.property.getType())) {
                        ok = MessageDialog.openConfirm((Shell)this.shell, (String)"Update Property", (String)"You want to change the type of this property, but there may be some elements that put values over this property. This may affect these elements by deleting the affected values.\n\nDo yo want to continue?");
                    }
                    if (ok) {
                        DomainController.getInstance().updateElementProperty(this.property, type, pName, pDescription, this.rulesMap);
                    } else {
                        canceled = true;
                    }
                }
                if (!canceled) {
                    super.okPressed();
                }
            }
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.setErrorMessage(e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void initErrors() {
        this.errors[0] = new ErrorInfo("The name can't be empty", 3, this.isNew);
        this.errors[1] = new ErrorInfo("You have to select a type", 3, this.isNew);
        this.errors[2] = new ErrorInfo("A Property with the same name alredy exists", 3, false);
    }

    private void validate() {
        boolean error = false;
        ErrorInfo[] errorInfoArray = this.errors;
        int n = this.errors.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorInfo err = errorInfoArray[n2];
            if (err.isError) {
                this.setErrorMessage(err.message);
                error = true;
                break;
            }
            ++n2;
        }
        if (!error) {
            this.setErrorMessage(null);
        }
        this.getButton(0).setEnabled(!error);
    }

    private Set<String> getQuestionNames() {
        HashSet<String> names = new HashSet<String>();
        for (Question q : this.getCurrentQuestions()) {
            names.add(q.getText());
        }
        return names;
    }

    private Set<Question> getCurrentQuestions() {
        return this.rulesMap.get((Object)this.rulesList.getSelection()[0]).ifQuestions.keySet();
    }

    private Question getSelectedQuestion() {
        IStructuredSelection sel = (IStructuredSelection)this.questionsList.getSelection();
        return (Question)sel.getFirstElement();
    }
}

