/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.property;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.QualityAttribute;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.ErrorInfo;
import upc.gessi.architech.utils.StackTraceUtil;

public class QualityAttributeDialog
extends TitleAreaDialog {
    private Text nameText;
    private Text descriptionText;
    private boolean isNew;
    private QualityAttribute attribute;
    private QualityAttribute parent;
    private Shell shell;
    private static final int NUM_ERRORS = 2;
    private static final int EMPTY_NAME = 0;
    private static final int ALREADY_EXISTS = 1;
    private ErrorInfo[] errors = new ErrorInfo[2];

    public QualityAttributeDialog(QualityAttribute parent, Shell parentShell) throws DomainException {
        super(parentShell);
        this.isNew = true;
        this.parent = parent != null ? (parent = DomainController.getInstance().getQualityAttributeById(parent, true)) : null;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public QualityAttributeDialog(Shell parentShell, QualityAttribute qAttribute) throws DomainException {
        super(parentShell);
        this.attribute = qAttribute = DomainController.getInstance().getQualityAttributeById(qAttribute, true);
        this.isNew = false;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Point getInitialSize() {
        Point p = new Point(400, 450);
        return p;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.shell = this.getShell();
        if (this.isNew) {
            this.shell.setText("New Quality Attribute");
        } else {
            this.shell.setText("Edit Quality Attribute");
        }
        this.setTitle("Quality Attribute");
        this.setMessage("Enter the data for this quality attribute");
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        try {
            TabFolder tabs = new TabFolder(contents, 128);
            tabs.setLayoutData((Object)new GridData(4, 4, true, true));
            tabs.setLayout((Layout)new GridLayout());
            this.createInformationTab(tabs);
            this.initErrors();
            this.fillValues();
            return contents;
        }
        catch (DomainException e) {
            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
            return contents;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    private void createInformationTab(TabFolder tabs) {
        TabItem tabItem = new TabItem(tabs, 0);
        tabItem.setText("Information");
        Composite content = new Composite((Composite)tabs, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        tabItem.setControl((Control)content);
        Label label1 = new Label(content, 0);
        label1.setText("Name: ");
        this.nameText = new Text(content, 2048);
        GridData gd1 = new GridData(4, 0x1000000, true, false);
        gd1.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd1);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                try {
                    boolean oldErr1 = ((QualityAttributeDialog)QualityAttributeDialog.this).errors[0].isError;
                    boolean newErr1 = QualityAttributeDialog.this.nameText.getText().length() == 0;
                    boolean oldErr2 = ((QualityAttributeDialog)QualityAttributeDialog.this).errors[1].isError;
                    Long id = null;
                    if (!QualityAttributeDialog.this.isNew) {
                        id = QualityAttributeDialog.this.attribute.getId();
                    }
                    boolean newErr2 = DomainController.getInstance().qualityAttributeAlredyExists(QualityAttributeDialog.this.nameText.getText(), QualityAttributeDialog.this.isNew, id);
                    if (oldErr1 != newErr1 || oldErr2 != newErr2) {
                        ((QualityAttributeDialog)QualityAttributeDialog.this).errors[0].isError = newErr1;
                        ((QualityAttributeDialog)QualityAttributeDialog.this).errors[1].isError = newErr2;
                        QualityAttributeDialog.this.validate();
                    }
                }
                catch (DomainException e) {
                    DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, QualityAttributeDialog.this.getShell());
                    dd.open();
                }
            }
        });
        Label label4 = new Label(content, 0);
        label4.setText("Description: ");
        GridData gd6 = new GridData(4, 0x1000000, true, false);
        gd6.horizontalSpan = 3;
        label4.setLayoutData((Object)gd6);
        this.descriptionText = new Text(content, 2626);
        GridData gd7 = new GridData(4, 4, true, true);
        gd7.horizontalSpan = 3;
        this.descriptionText.setLayoutData((Object)gd7);
    }

    private void fillValues() throws DomainException {
        if (!this.isNew) {
            this.nameText.setText(this.attribute.getName());
            String pDescription = this.attribute.getDescription();
            if (pDescription != null) {
                this.descriptionText.setText(pDescription);
            }
        }
    }

    protected void okPressed() {
        try {
            String pName = this.nameText.getText();
            String pDescription = this.descriptionText.getText();
            if (this.isNew) {
                DomainController.getInstance().newQualityAttribute(pName, pDescription, this.parent);
            } else {
                DomainController.getInstance().updateQualityAttribute(this.attribute, pName, pDescription);
            }
            super.okPressed();
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.setErrorMessage(e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void initErrors() {
        this.errors[0] = new ErrorInfo("The name can't be empty", 3, this.isNew);
        this.errors[1] = new ErrorInfo("A quality attribute with the same name alredy exists", 3, false);
    }

    private void validate() {
        boolean error = false;
        ErrorInfo[] errorInfoArray = this.errors;
        int n = this.errors.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorInfo err = errorInfoArray[n2];
            if (err.isError) {
                this.setErrorMessage(err.message);
                error = true;
                break;
            }
            ++n2;
        }
        if (!error) {
            this.setErrorMessage(null);
        }
        this.getButton(0).setEnabled(!error);
    }
}

