/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.dialogs.property;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import upc.gessi.architech.controller.properties.QualityAttributesLabelProvider;
import upc.gessi.architech.controller.properties.QualityAttributesTreeContentProvider;
import upc.gessi.architech.dnd.QualityAttributeDragListener;
import upc.gessi.architech.dnd.QualityAttributeTransfer;
import upc.gessi.architech.dnd.QualityAttributeTreeDropAdapter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.property.QualityAttributeDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.QualityAttribute;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;

public class QualityAttributeSelectionDialog
extends SelectionStatusDialog {
    private TreeViewer attributesTree;
    private Action newQualityAttribute;
    private Action specializeQualityAttribute;
    private Action delQualityAttribute;
    private Action editQualityAttribute;
    private Set<QualityAttribute> usedAttributes;
    private ISelectionStatusValidator validator;

    public QualityAttributeSelectionDialog(Shell parent, Set<QualityAttribute> usedAttributes) {
        super(parent);
        this.usedAttributes = usedAttributes;
        this.setResult(new ArrayList(0));
        this.setStatusLineAboveButtons(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite res = (Composite)super.createDialogArea(parent);
        this.createMessageArea(res);
        this.createWidgets(parent);
        this.createMenu();
        this.createValidator();
        this.updateOkStatus();
        return res;
    }

    private void createWidgets(Composite parent) {
        try {
            this.attributesTree = new TreeViewer(parent, 2052);
            this.attributesTree.setContentProvider((IContentProvider)new QualityAttributesTreeContentProvider());
            this.attributesTree.setLabelProvider((IBaseLabelProvider)new QualityAttributesLabelProvider());
            this.attributesTree.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    QualityAttributeSelectionDialog.this.setResult(((IStructuredSelection)event.getSelection()).toList());
                    QualityAttributeSelectionDialog.this.updateOkStatus();
                }
            });
            this.attributesTree.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (QualityAttributeSelectionDialog.this.editQualityAttribute.isEnabled()) {
                        QualityAttributeSelectionDialog.this.editQualityAttribute.run();
                    }
                }
            });
            Set allProperties = Model.getInstance().getQualityAttributes();
            this.attributesTree.setInput((Object)allProperties);
            GridData data = new GridData(1808);
            data.widthHint = this.convertWidthInCharsToPixels(60);
            data.heightHint = this.convertHeightInCharsToPixels(18);
            this.attributesTree.getTree().setLayoutData((Object)data);
            Transfer[] transfers = new Transfer[]{QualityAttributeTransfer.getInstance()};
            this.attributesTree.addDragSupport(2, transfers, (DragSourceListener)new QualityAttributeDragListener((StructuredViewer)this.attributesTree));
            this.attributesTree.addDropSupport(2, transfers, (DropTargetListener)new QualityAttributeTreeDropAdapter(this.attributesTree));
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.getShell());
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.getShell());
            dd.open();
        }
    }

    private void createValidator() {
        this.validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length > 0) {
                    QualityAttribute selAttribute = (QualityAttribute)selection[0];
                    if (QualityAttributeSelectionDialog.this.usedAttributes.contains(selAttribute)) {
                        return new Status(4, "upc.gessi.ArchiTech", 4, "This Attribute is already being used", null);
                    }
                    if (QualityAttributeSelectionDialog.this.hasUsedChildren(selAttribute)) {
                        return new Status(2, "upc.gessi.ArchiTech", 2, "An specialization of this attribute is being used", null);
                    }
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void createMenu() {
        this.newQualityAttribute = new Action("New Quality Attribute"){

            public void run() {
                try {
                    QualityAttributeDialog qpd = new QualityAttributeDialog(null, QualityAttributeSelectionDialog.this.getShell());
                    if (qpd.open() == 0) {
                        QualityAttributeSelectionDialog.this.attributesTree.refresh();
                        QualityAttributeSelectionDialog.this.updateOkStatus();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, QualityAttributeSelectionDialog.this.getShell());
                    dd.open();
                }
            }
        };
        this.specializeQualityAttribute = new Action("Speciailze Quality Attribute"){

            public void run() {
                try {
                    IStructuredSelection sel = (IStructuredSelection)QualityAttributeSelectionDialog.this.attributesTree.getSelection();
                    QualityAttribute selAttribute = (QualityAttribute)sel.getFirstElement();
                    QualityAttributeDialog qpd = new QualityAttributeDialog(selAttribute, QualityAttributeSelectionDialog.this.getShell());
                    if (qpd.open() == 0) {
                        QualityAttributeSelectionDialog.this.attributesTree.refresh();
                        QualityAttributeSelectionDialog.this.updateOkStatus();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, QualityAttributeSelectionDialog.this.getShell());
                    dd.open();
                }
            }
        };
        this.delQualityAttribute = new Action("Delete Quality Attribute"){

            public void run() {
                try {
                    if (!QualityAttributeSelectionDialog.this.attributesTree.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)QualityAttributeSelectionDialog.this.attributesTree.getSelection();
                        QualityAttribute selAttribute = (QualityAttribute)sel.getFirstElement();
                        selAttribute = DomainController.getInstance().getQualityAttributeById(selAttribute, true);
                        boolean war = true;
                        if (!selAttribute.getDecisionEffects().isEmpty()) {
                            war = MessageDialog.openConfirm((Shell)QualityAttributeSelectionDialog.this.getShell(), (String)"WARNING", (String)"This quality attribute is being affected by some decisions. Deleting the attribute will cause the update of this decisions, removing these effects\n\nDo you want to continue?");
                        }
                        if (war) {
                            boolean del = true;
                            if (!selAttribute.getChildAttributes().isEmpty()) {
                                del = MessageDialog.openConfirm((Shell)QualityAttributeSelectionDialog.this.getShell(), (String)"Delete Quality Attribute", (String)"All the specialized attributes will be also deleted.\nDo yo want to continue?");
                            }
                            if (del) {
                                DomainController.getInstance().remove(selAttribute);
                                QualityAttributeSelectionDialog.this.attributesTree.refresh();
                                QualityAttributeSelectionDialog.this.updateOkStatus();
                            }
                        }
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        QualityAttributeSelectionDialog.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, QualityAttributeSelectionDialog.this.getShell());
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, QualityAttributeSelectionDialog.this.getShell());
                    dd.open();
                }
            }
        };
        this.editQualityAttribute = new Action("Edit Quality Attribute"){

            public void run() {
                if (!QualityAttributeSelectionDialog.this.attributesTree.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)QualityAttributeSelectionDialog.this.attributesTree.getSelection();
                    QualityAttribute selectedAttribute = (QualityAttribute)sel.getFirstElement();
                    try {
                        QualityAttributeDialog qpd = new QualityAttributeDialog(QualityAttributeSelectionDialog.this.getShell(), selectedAttribute);
                        qpd.open();
                        QualityAttributeSelectionDialog.this.attributesTree.refresh();
                    }
                    catch (DomainException e) {
                        if (e.getCause() == null) {
                            QualityAttributeSelectionDialog.this.showError("Error", e.getMessage());
                        } else {
                            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, QualityAttributeSelectionDialog.this.getShell());
                            dd.open();
                        }
                    }
                    catch (Exception e) {
                        DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, QualityAttributeSelectionDialog.this.getShell());
                        dd.open();
                    }
                }
            }
        };
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                if (!QualityAttributeSelectionDialog.this.attributesTree.getSelection().isEmpty()) {
                    mgr.add((IAction)QualityAttributeSelectionDialog.this.specializeQualityAttribute);
                    mgr.add((IContributionItem)new Separator());
                }
                mgr.add((IAction)QualityAttributeSelectionDialog.this.newQualityAttribute);
                mgr.add((IAction)QualityAttributeSelectionDialog.this.delQualityAttribute);
                mgr.add((IAction)QualityAttributeSelectionDialog.this.editQualityAttribute);
                mgr.add((IContributionItem)new Separator());
            }
        });
        Menu menu = menuMgr.createContextMenu(this.attributesTree.getControl());
        this.attributesTree.getControl().setMenu(menu);
    }

    protected void updateOkStatus() {
        Object currentStatus = this.attributesTree.getSelection().isEmpty() ? new Status(4, "upc.gessi.ArchiTech", 4, "Select an attribute", null) : this.validator.validate(this.getResult());
        this.updateStatus((IStatus)currentStatus);
        this.setEnabledActions();
    }

    private void setEnabledActions() {
        boolean enabledED = true;
        if (!this.attributesTree.getSelection().isEmpty()) {
            IStructuredSelection sel = (IStructuredSelection)this.attributesTree.getSelection();
            QualityAttribute selProperty = (QualityAttribute)sel.getFirstElement();
            if (this.hasUsedChildren(selProperty)) {
                enabledED = false;
            }
        } else {
            enabledED = false;
        }
        this.editQualityAttribute.setEnabled(enabledED);
        this.delQualityAttribute.setEnabled(enabledED);
    }

    private boolean hasUsedChildren(QualityAttribute attribute) {
        for (QualityAttribute child : attribute.getChildAttributes()) {
            if (!this.hasUsedChildren(child)) continue;
            return true;
        }
        return this.usedAttributes.contains(attribute);
    }

    protected void computeResult() {
        this.setResult(((IStructuredSelection)this.attributesTree.getSelection()).toList());
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }
}

