/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.views.dataTypes;

import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.types.TypeContentProvider;
import upc.gessi.architech.controller.types.TypeLabelProvider;
import upc.gessi.architech.controller.types.TypeViewSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.ExploreDialog;
import upc.gessi.architech.gui.dialogs.ExploreDialogRefresher;
import upc.gessi.architech.gui.dialogs.dataType.EnumerateTypeDialog;
import upc.gessi.architech.gui.dialogs.dataType.GenericTypeDialog;
import upc.gessi.architech.gui.dialogs.dataType.IntegerTypeDialog;
import upc.gessi.architech.gui.dialogs.dataType.RealTypeDialog;
import upc.gessi.architech.gui.dialogs.dataType.StringTypeDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.property.ElementProperty;
import upc.gessi.architech.hibernatehelper.domain.domainModel.question.Question;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.DataType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.EnumerateType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.IntegerType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.RealType;
import upc.gessi.architech.hibernatehelper.domain.domainModel.type.StringType;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;
import upc.gessi.architech.utils.TupleColumnDescriptor;

public class DataTypesView
extends ViewPart
implements IResourceChangeListener {
    public static final int COL_TEXT_WIDTH = 450;
    public static final int COL_ORDER_WIDTH = 50;
    public static final int TOTAL_WIDTH_QUESTIONS = 500;
    public static final int COL_NAME_WIDTH = 120;
    public static final int COL_DESCRIPTION_WIDTH = 600;
    public static final int TOTAL_WIDTH_PROPERTIES = 720;
    private static final int INTEGER_TYPE_SELECTION = 0;
    private static final int REAL_TYPE_SELECTION = 1;
    private static final int ENUMERATE_TYPE_SELECTION = 2;
    private static final int STRING_TYPE_SELECTION = 3;
    private Action newTypeAction;
    private Action editTypeAction;
    private Action deleteTypeAction;
    private Action exploreQuestions;
    private Action exploreProperties;
    Composite owner;
    Combo typeSelectorCombo;
    ListViewer typesList;
    private Set selectedTypes = null;
    int selIndex;
    Shell shell;
    private boolean connected = Activator.isConnected();

    public DataTypesView() {
        Activator.registerAsListener(this);
    }

    public void createPartControl(Composite parent) {
        this.owner = parent;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        this.typeSelectorCombo = new Combo(parent, 12);
        this.initComboEntrys();
        this.typeSelectorCombo.select(0);
        this.selIndex = 0;
        this.typeSelectorCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                int i = DataTypesView.this.typeSelectorCombo.getSelectionIndex();
                if (i != DataTypesView.this.selIndex) {
                    switch (i) {
                        case 0: {
                            DataTypesView.this.setIntegerTypes();
                            break;
                        }
                        case 1: {
                            DataTypesView.this.setRealTypes();
                            break;
                        }
                        case 2: {
                            DataTypesView.this.setEnumerateTypes();
                            break;
                        }
                        case 3: {
                            DataTypesView.this.setStringTypes();
                        }
                    }
                    DataTypesView.this.setEnabledActions();
                }
                DataTypesView.this.selIndex = i;
            }
        });
        this.typesList = new ListViewer(parent);
        this.typesList.setContentProvider((IContentProvider)new TypeContentProvider());
        this.typesList.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        this.typesList.setSorter((ViewerSorter)new TypeViewSorter());
        GridData gd = new GridData(4, 4, true, true);
        this.typesList.getList().setLayoutData((Object)gd);
        if (this.connected) {
            this.setIntegerTypes();
        } else {
            this.typesList.setInput(null);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.typesList);
        this.shell = this.typesList.getControl().getShell();
        this.createActions();
        this.createExploreActions();
        this.createMenu();
        this.addListeners();
        this.setEnabledActions();
        this.setEnabled(this.connected);
    }

    public void setFocus() {
        if (this.connected) {
            this.typesList.getControl().setFocus();
            switch (this.selIndex) {
                case 0: {
                    this.setIntegerTypes();
                    break;
                }
                case 1: {
                    this.setRealTypes();
                    break;
                }
                case 2: {
                    this.setEnumerateTypes();
                    break;
                }
                case 3: {
                    this.setStringTypes();
                }
            }
        }
    }

    private void createActions() {
        this.newTypeAction = new Action("New Type", Activator.getImageDescriptor("add_16x16.png")){

            public void run() {
                try {
                    GenericTypeDialog td = null;
                    switch (DataTypesView.this.selIndex) {
                        case 0: {
                            td = new IntegerTypeDialog(DataTypesView.this.owner.getShell());
                            break;
                        }
                        case 1: {
                            td = new RealTypeDialog(DataTypesView.this.owner.getShell());
                            break;
                        }
                        case 2: {
                            td = new EnumerateTypeDialog(DataTypesView.this.owner.getShell());
                            break;
                        }
                        case 3: {
                            td = new StringTypeDialog(DataTypesView.this.owner.getShell());
                        }
                    }
                    if (td.open() == 0) {
                        DataTypesView.this.typesList.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, DataTypesView.this.shell);
                    dd.open();
                }
            }
        };
        this.editTypeAction = new Action("Edit Type", Activator.getImageDescriptor("editIcon_16x16.png")){

            public void run() {
                if (!DataTypesView.this.typesList.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)DataTypesView.this.typesList.getSelection();
                    try {
                        GenericTypeDialog td = null;
                        switch (DataTypesView.this.selIndex) {
                            case 0: {
                                IntegerType selectedType = (IntegerType)sel.getFirstElement();
                                td = new IntegerTypeDialog(DataTypesView.this.owner.getShell(), selectedType);
                                break;
                            }
                            case 1: {
                                RealType selectedType2 = (RealType)sel.getFirstElement();
                                td = new RealTypeDialog(DataTypesView.this.owner.getShell(), selectedType2);
                                break;
                            }
                            case 2: {
                                EnumerateType selectedType3 = (EnumerateType)sel.getFirstElement();
                                td = new EnumerateTypeDialog(DataTypesView.this.owner.getShell(), selectedType3);
                                break;
                            }
                            case 3: {
                                StringType selectedType4 = (StringType)sel.getFirstElement();
                                td = new StringTypeDialog(DataTypesView.this.owner.getShell(), selectedType4);
                            }
                        }
                        td.open();
                    }
                    catch (DomainException e) {
                        if (e.getCause() == null) {
                            DataTypesView.this.showError("Error", e.getMessage());
                        } else {
                            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DataTypesView.this.shell);
                            dd.open();
                        }
                    }
                    catch (Exception e) {
                        DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, DataTypesView.this.shell);
                        dd.open();
                    }
                    DataTypesView.this.typesList.refresh();
                }
            }
        };
        this.deleteTypeAction = new Action("Delete Type", Activator.getImageDescriptor("remove_16x16.png")){

            public void run() {
                if (!DataTypesView.this.typesList.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)DataTypesView.this.typesList.getSelection();
                    DataType selectedType = (DataType)sel.getFirstElement();
                    try {
                        DomainController.getInstance().remove(selectedType);
                        DataTypesView.this.typesList.refresh();
                    }
                    catch (DomainException e) {
                        if (e.getCause() == null) {
                            DataTypesView.this.showError("Error", e.getMessage());
                        } else {
                            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DataTypesView.this.shell);
                            dd.open();
                        }
                    }
                    catch (Exception e) {
                        DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, DataTypesView.this.shell);
                        dd.open();
                    }
                }
            }
        };
    }

    private void createExploreActions() {
        this.exploreQuestions = new Action("Questions"){

            public void run() {
                try {
                    LinkedList<TupleColumnDescriptor> columns = new LinkedList<TupleColumnDescriptor>();
                    columns.add(new TupleColumnDescriptor("Order", 0, 50, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            Question q = (Question)element;
                            return String.valueOf(q.getOrder());
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Question text", 1, 450, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            Question q = (Question)element;
                            return q.getText();
                        }
                    }));
                    ExploreDialog dialog = new ExploreDialog(DataTypesView.this.owner.getShell(), "Explore questions", "These are the questions which are of this type", null, columns, 500);
                    DataType selType = (DataType)((IStructuredSelection)DataTypesView.this.typesList.getSelection()).getFirstElement();
                    selType = DomainController.getInstance().getTypeById(selType.getId());
                    dialog.setInput(selType.getQuestions().toArray());
                    dialog.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object o1, Object o2) {
                            Question q1 = (Question)o1;
                            Question q2 = (Question)o2;
                            return q1.getOrder() - q2.getOrder();
                        }
                    });
                    final DataType type = selType;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            DataType aux = DomainController.getInstance().getTypeById(type.getId());
                            if (aux == null) {
                                return null;
                            }
                            return aux.getQuestions().toArray();
                        }
                    });
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, DataTypesView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreProperties = new Action("Properties"){

            public void run() {
                try {
                    LinkedList<TupleColumnDescriptor> columns = new LinkedList<TupleColumnDescriptor>();
                    columns.add(new TupleColumnDescriptor("Property name", 0, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            ElementProperty p = (ElementProperty)element;
                            return p.getName();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Description", 1, 600, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            ElementProperty p = (ElementProperty)element;
                            return p.getDescription();
                        }
                    }));
                    ExploreDialog dialog = new ExploreDialog(DataTypesView.this.owner.getShell(), "Explore properties", "These are the element properties which are of this type", null, columns, 720);
                    DataType selType = (DataType)((IStructuredSelection)DataTypesView.this.typesList.getSelection()).getFirstElement();
                    selType = DomainController.getInstance().getTypeById(selType.getId());
                    dialog.setInput(selType.getProperties().toArray());
                    dialog.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object o1, Object o2) {
                            ElementProperty p1 = (ElementProperty)o1;
                            ElementProperty p2 = (ElementProperty)o2;
                            return p1.getName().compareToIgnoreCase(p2.getName());
                        }
                    });
                    final DataType type = selType;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            DataType aux = DomainController.getInstance().getTypeById(type.getId());
                            if (aux == null) {
                                return null;
                            }
                            return aux.getProperties().toArray();
                        }
                    });
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, DataTypesView.this.shell);
                    dd.open();
                }
            }
        };
    }

    private void createMenu() {
        IToolBarManager tmgr = this.getViewSite().getActionBars().getToolBarManager();
        tmgr.add((IAction)this.newTypeAction);
        tmgr.add((IAction)this.deleteTypeAction);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)DataTypesView.this.newTypeAction);
                if (!DataTypesView.this.typesList.getSelection().isEmpty()) {
                    mgr.add((IAction)DataTypesView.this.editTypeAction);
                    mgr.add((IAction)DataTypesView.this.deleteTypeAction);
                    DataTypesView.this.addExploreActions(mgr);
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.typesList.getControl());
        this.typesList.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.typesList);
    }

    private void addExploreActions(IMenuManager mgr) {
        MenuManager g = new MenuManager("Explore");
        mgr.add((IContributionItem)g);
        g.add((IAction)this.exploreQuestions);
        g.add((IAction)this.exploreProperties);
    }

    private void addListeners() {
        this.typesList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DataTypesView.this.editTypeAction.run();
            }
        });
        this.typesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataTypesView.this.setEnabledActions();
            }
        });
    }

    private void setEnabledActions() {
        boolean enabledED = true;
        if (this.typesList.getSelection().isEmpty()) {
            enabledED = false;
        }
        this.editTypeAction.setEnabled(enabledED);
        this.deleteTypeAction.setEnabled(enabledED);
    }

    private void initComboEntrys() {
        this.typeSelectorCombo.add("Integer Types", 0);
        this.typeSelectorCombo.add("Real Types", 1);
        this.typeSelectorCombo.add("Enumerate Types", 2);
        this.typeSelectorCombo.add("String Types", 3);
    }

    private void setIntegerTypes() {
        try {
            this.selectedTypes = Model.getInstance().getIntegerTypes();
            this.typesList.setInput((Object)this.selectedTypes);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void setRealTypes() {
        try {
            this.selectedTypes = Model.getInstance().getRealTypes();
            this.typesList.setInput((Object)this.selectedTypes);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void setEnumerateTypes() {
        try {
            this.selectedTypes = Model.getInstance().getEnumerateTypes();
            this.typesList.setInput((Object)this.selectedTypes);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void setStringTypes() {
        try {
            this.selectedTypes = Model.getInstance().getStringTypes();
            this.typesList.setInput((Object)this.selectedTypes);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }

    public void refresh() {
        this.typesList.refresh();
    }

    public void refreshFromDbChange() {
        this.setIntegerTypes();
        if (!this.connected) {
            this.connected = true;
            this.setEnabled(true);
        }
    }

    public void disconnect() {
        if (this.connected) {
            this.typesList.setInput(null);
            this.connected = false;
            this.setEnabled(false);
        }
    }

    private void setEnabled(boolean enabled) {
        this.typesList.getList().setEnabled(enabled);
        this.typeSelectorCombo.setEnabled(enabled);
        this.newTypeAction.setEnabled(enabled);
        this.editTypeAction.setEnabled(enabled);
        this.deleteTypeAction.setEnabled(enabled);
        if (enabled) {
            this.setEnabledActions();
        }
    }

    public void dispose() {
        super.dispose();
        Activator.unregisterAsListener(this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 4 && event.getResource() instanceof IProject) {
            try {
                if (((IProject)event.getResource()).hasNature("architech.ProjectNature")) {
                    String location = Activator.getLocation((IProject)event.getResource());
                    Display display = this.typesList.getControl().getDisplay();
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (DataTypesView.this.typesList.getControl().isDisposed()) {
                                    return;
                                }
                                if (Activator.getCurrentLocation().equals(location)) {
                                    DataTypesView.this.disconnect();
                                }
                            }
                        });
                    }
                }
            }
            catch (CoreException coreException) {}
        }
    }
}

