/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.views.decisions;

import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.decisions.DecisionContentProvider;
import upc.gessi.architech.controller.decisions.DecisionLabelProvider;
import upc.gessi.architech.controller.decisions.DecisionSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.ExploreDialog;
import upc.gessi.architech.gui.dialogs.ExploreDialogRefresher;
import upc.gessi.architech.gui.dialogs.decision.DecisionDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.Decision;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.DecisionAction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decisionEffect.DecisionEffect;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.Constants;
import upc.gessi.architech.utils.StackTraceUtil;
import upc.gessi.architech.utils.TupleColumnDescriptor;

public class DecisionsView
extends ViewPart
implements IResourceChangeListener {
    public static final int COL_NAME_WIDTH = 120;
    public static final int COL_DESCRIPTION_WIDTH = 600;
    public static final int COL_VALUE_WIDTH = 120;
    public static final int TOTAL_WIDTH_EFFECTS = 840;
    public static final int COL_VIEW_WIDTH = 120;
    public static final int COL_ELEMENT_TYPE_WIDTH = 120;
    public static final int TOTAL_WIDTH_ACTIONS = 960;
    private Action newDecisionAction;
    private Action editDecisionAction;
    private Action deleteDecisionAction;
    private Action exploreEffects;
    private Action exploreActions;
    private ListViewer decisionsList;
    private Composite owner;
    private Set<Decision> allDecisions = null;
    Shell shell;
    private boolean connected = Activator.isConnected();

    public DecisionsView() {
        Activator.registerAsListener(this);
    }

    public void createPartControl(Composite parent) {
        try {
            this.owner = parent;
            this.decisionsList = new ListViewer(parent);
            this.decisionsList.setContentProvider((IContentProvider)new DecisionContentProvider());
            this.decisionsList.setLabelProvider((IBaseLabelProvider)new DecisionLabelProvider());
            this.decisionsList.setSorter((ViewerSorter)new DecisionSorter());
            this.allDecisions = this.connected && this.allDecisions == null ? Model.getInstance().getDecisions() : null;
            this.decisionsList.setInput(this.allDecisions);
            this.getSite().setSelectionProvider((ISelectionProvider)this.decisionsList);
            this.shell = this.decisionsList.getControl().getShell();
            this.createActions();
            this.createExploreActions();
            this.createMenu();
            this.addListeners();
            this.setEnabledActions();
            this.setEnabled(this.connected);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private void createActions() {
        this.newDecisionAction = new Action("New Decision", Activator.getImageDescriptor("add_16x16.png")){

            public void run() {
                try {
                    DecisionDialog dd = new DecisionDialog(DecisionsView.this.owner.getShell());
                    if (dd.open() == 0) {
                        DecisionsView.this.decisionsList.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, DecisionsView.this.shell);
                    dd.open();
                }
            }
        };
        this.editDecisionAction = new Action("Edit Decision", Activator.getImageDescriptor("editIcon_16x16.png")){

            public void run() {
                try {
                    if (!DecisionsView.this.decisionsList.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)DecisionsView.this.decisionsList.getSelection();
                        Decision selectedDecision = (Decision)sel.getFirstElement();
                        DecisionDialog dd = new DecisionDialog(DecisionsView.this.owner.getShell(), selectedDecision);
                        dd.open();
                        DecisionsView.this.decisionsList.refresh();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        DecisionsView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DecisionsView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, DecisionsView.this.shell);
                    dd.open();
                }
            }
        };
        this.deleteDecisionAction = new Action("Delete Decision", Activator.getImageDescriptor("remove_16x16.png")){

            public void run() {
                if (!DecisionsView.this.decisionsList.getSelection().isEmpty()) {
                    try {
                        IStructuredSelection sel = (IStructuredSelection)DecisionsView.this.decisionsList.getSelection();
                        Decision selectedDecision = (Decision)sel.getFirstElement();
                        boolean del = true;
                        if (!selectedDecision.getRestrictedBy().isEmpty()) {
                            del = MessageDialog.openConfirm((Shell)DecisionsView.this.shell, (String)"Delete Decision", (String)"This decision is being used in some restriction. The deletion of this question will modify these restrictions.\nDo yo want to continue?");
                        }
                        if (del) {
                            DomainController.getInstance().remove(selectedDecision);
                        }
                        DecisionsView.this.decisionsList.refresh();
                    }
                    catch (DomainException e) {
                        if (e.getCause() == null) {
                            DecisionsView.this.showError("Error", e.getMessage());
                        } else {
                            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, DecisionsView.this.shell);
                            dd.open();
                        }
                    }
                    catch (Exception e) {
                        DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", e.getStackTrace().toString(), 0, DecisionsView.this.shell);
                        dd.open();
                    }
                }
            }
        };
    }

    private void createExploreActions() {
        this.exploreEffects = new Action("Quality attribute effects"){

            public void run() {
                try {
                    LinkedList<TupleColumnDescriptor> columns = new LinkedList<TupleColumnDescriptor>();
                    columns.add(new TupleColumnDescriptor("Quality Attribute", 0, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            DecisionEffect de = (DecisionEffect)element;
                            return de.getAttribute().getName();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Description", 1, 600, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            DecisionEffect de = (DecisionEffect)element;
                            return de.getAttribute().getDescription();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Effect", 2, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            DecisionEffect de = (DecisionEffect)element;
                            return Constants.EFFECT_NAMES[de.getValue()];
                        }
                    }));
                    ExploreDialog dialog = new ExploreDialog(DecisionsView.this.owner.getShell(), "Explore quality attribute effects", "These are effects that the decision produces over quality attributes", null, columns, 840);
                    Decision selDecision = (Decision)((IStructuredSelection)DecisionsView.this.decisionsList.getSelection()).getFirstElement();
                    selDecision = DomainController.getInstance().getDecisionById(selDecision, false);
                    dialog.setInput(selDecision.getDecisionEffects().toArray());
                    dialog.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object o1, Object o2) {
                            DecisionEffect e1 = (DecisionEffect)o1;
                            DecisionEffect e2 = (DecisionEffect)o2;
                            return e1.getAttribute().getName().compareToIgnoreCase(e2.getAttribute().getName());
                        }
                    });
                    final Decision decision = selDecision;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Decision aux = DomainController.getInstance().getDecisionById(decision, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getDecisionEffects().toArray();
                        }
                    });
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, DecisionsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreActions = new Action("Element actions"){

            public void run() {
                try {
                    LinkedList<TupleColumnDescriptor> columns = new LinkedList<TupleColumnDescriptor>();
                    columns.add(new TupleColumnDescriptor("Element", 0, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            DecisionAction da = (DecisionAction)element;
                            return da.getElement().toString();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Description", 1, 600, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            DecisionAction da = (DecisionAction)element;
                            return da.getElement().getDescription();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("View", 2, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            DecisionAction da = (DecisionAction)element;
                            return da.getElement().getArchitecturalView().getName();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Action", 3, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            DecisionAction da = (DecisionAction)element;
                            return Constants.ACTION_NAMES[da.getAction()];
                        }
                    }));
                    ExploreDialog dialog = new ExploreDialog(DecisionsView.this.owner.getShell(), "Explore element actions", "These are actions that of the decision over elements", null, columns, 960);
                    Decision selDecision = (Decision)((IStructuredSelection)DecisionsView.this.decisionsList.getSelection()).getFirstElement();
                    selDecision = DomainController.getInstance().getDecisionById(selDecision, false);
                    dialog.setInput(selDecision.getActions().toArray());
                    dialog.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object o1, Object o2) {
                            DecisionAction a1 = (DecisionAction)o1;
                            DecisionAction a2 = (DecisionAction)o2;
                            String s1 = a1.getElement().getClass().toString().concat(a1.getElement().getName());
                            String s2 = a2.getElement().getClass().toString().concat(a2.getElement().getName());
                            return s1.compareToIgnoreCase(s2);
                        }
                    });
                    final Decision decision = selDecision;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Decision aux = DomainController.getInstance().getDecisionById(decision, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getActions().toArray();
                        }
                    });
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, DecisionsView.this.shell);
                    dd.open();
                }
            }
        };
    }

    private void createMenu() {
        IToolBarManager tmgr = this.getViewSite().getActionBars().getToolBarManager();
        tmgr.add((IAction)this.newDecisionAction);
        tmgr.add((IAction)this.deleteDecisionAction);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)DecisionsView.this.newDecisionAction);
                if (!DecisionsView.this.decisionsList.getSelection().isEmpty()) {
                    mgr.add((IAction)DecisionsView.this.editDecisionAction);
                    mgr.add((IAction)DecisionsView.this.deleteDecisionAction);
                    DecisionsView.this.addExploreActions(mgr);
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.decisionsList.getControl());
        this.decisionsList.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.decisionsList);
    }

    private void addExploreActions(IMenuManager mgr) {
        MenuManager g = new MenuManager("Explore");
        mgr.add((IContributionItem)g);
        g.add((IAction)this.exploreEffects);
        g.add((IAction)this.exploreActions);
    }

    private void addListeners() {
        this.decisionsList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DecisionsView.this.editDecisionAction.run();
            }
        });
        this.decisionsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DecisionsView.this.setEnabledActions();
            }
        });
    }

    private void setEnabledActions() {
        boolean enabledED = true;
        if (this.decisionsList.getSelection().isEmpty()) {
            enabledED = false;
        }
        this.editDecisionAction.setEnabled(enabledED);
        this.deleteDecisionAction.setEnabled(enabledED);
    }

    public ListViewer getDecisionsList() {
        return this.decisionsList;
    }

    public void setFocus() {
        if (this.connected) {
            this.decisionsList.getControl().setFocus();
        }
    }

    public void refresh() {
        this.decisionsList.refresh();
    }

    public void refreshFromDbChange() {
        try {
            this.allDecisions = Model.getInstance().getDecisions();
            this.decisionsList.setInput(this.allDecisions);
            if (!this.connected) {
                this.connected = true;
                this.setEnabled(true);
            }
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    public void disconnect() {
        if (this.connected) {
            this.decisionsList.setInput(null);
            this.connected = false;
            this.setEnabled(false);
        }
    }

    private void setEnabled(boolean enabled) {
        this.decisionsList.getList().setEnabled(enabled);
        this.newDecisionAction.setEnabled(enabled);
        this.editDecisionAction.setEnabled(enabled);
        this.deleteDecisionAction.setEnabled(enabled);
        if (enabled) {
            this.setEnabledActions();
        }
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }

    public void dispose() {
        super.dispose();
        Activator.unregisterAsListener(this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 4 && event.getResource() instanceof IProject) {
            try {
                if (((IProject)event.getResource()).hasNature("architech.ProjectNature")) {
                    String location = Activator.getLocation((IProject)event.getResource());
                    Display display = this.decisionsList.getControl().getDisplay();
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (DecisionsView.this.decisionsList.getControl().isDisposed()) {
                                    return;
                                }
                                if (Activator.getCurrentLocation().equals(location)) {
                                    DecisionsView.this.disconnect();
                                }
                            }
                        });
                    }
                }
            }
            catch (CoreException coreException) {}
        }
    }
}

