/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.views.elements;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.elements.ElementLabelProvider;
import upc.gessi.architech.controller.elements.ElementsSorter;
import upc.gessi.architech.controller.elements.ElementsTreeContentProvider;
import upc.gessi.architech.controller.elements.ElementsTreeTypeFilter;
import upc.gessi.architech.controller.elements.ElementsTreeViewFilter;
import upc.gessi.architech.dnd.ElementDragListener;
import upc.gessi.architech.dnd.ElementTransfer;
import upc.gessi.architech.dnd.ElementsTreeDropAdapter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.ExploreDialog;
import upc.gessi.architech.gui.dialogs.ExploreDialogRefresher;
import upc.gessi.architech.gui.dialogs.element.ComponentDialog;
import upc.gessi.architech.gui.dialogs.element.ImplementationDialog;
import upc.gessi.architech.gui.dialogs.element.StyleDialog;
import upc.gessi.architech.gui.dialogs.element.StyleVariationDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.Decision;
import upc.gessi.architech.hibernatehelper.domain.domainModel.decision.DecisionAction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Component;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Element;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Implementation;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.PropertyValue;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.Style;
import upc.gessi.architech.hibernatehelper.domain.domainModel.element.StyleVariation;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.Constants;
import upc.gessi.architech.utils.StackTraceUtil;
import upc.gessi.architech.utils.TupleColumnDescriptor;

public class ElementsView
extends ViewPart
implements IResourceChangeListener {
    public static final int COL_NAME_WIDTH = 120;
    public static final int COL_DESCRIPTION_WIDTH = 600;
    public static final int COL_DATATYPE_WIDTH = 120;
    public static final int COL_VALUE_WIDTH = 120;
    public static final int TOTAL_WIDTH_PROPERTY_VALUES = 960;
    public static final int TOTAL_WIDTH_DECISION_ACTIONS = 840;
    public static final int COL_VIEW_WIDTH = 120;
    public static final int TOTAL_WIDTH_RELATED = 840;
    public static final int TOTAL_WIDTH_ELEMENT = 720;
    public static final int TOTAL_WIDTH_STYLE_VARIATION = 840;
    public static final int COMPONENT_TYPE = 0;
    public static final int STYLE_TYPE = 1;
    public static final int STYLE_VARIATION_TYPE = 2;
    public static final int IMPLEMENTATION_TYPE = 3;
    private Action newComponentAction;
    private Action newStyleAction;
    private Action newStyleVariationAction;
    private Action newImplementationAction;
    private Action specializeComponentAction;
    private Action specializeStyleAction;
    private Action specializeStyleVariationAction;
    private Action specializeImplementationAction;
    private Action editElementAction;
    private Action deleteElementAction;
    private Action exploreValues;
    private Action exploreActions;
    private Action exploreRelated;
    private Action exploreRelatedInverse;
    private Action exploreComposible;
    private Action exploreComposibleInverse;
    private Action exploreConnectible;
    private Action exploreConnectibleInverse;
    private Action exploreApplyToStyle;
    private Action exploreApplyToStyleVariation;
    private Action exploreImplementableWith;
    private Action exploreImplementableWithInverse;
    private Action exploreApplyToStyleInverse;
    private Action exploreVariationForInverse;
    private Action exploreApplyToStyleVariationInverse;
    private Action exploreIncompatibleWith;
    private Composite owner;
    private Button[] typeCheckboxes;
    private Button[] viewCheckboxes;
    private TreeViewer elementsTree;
    private Map<Integer, String> viewNames;
    private Set<?> selectedElements = null;
    private MenuManager popUpMenu;
    Shell shell;
    private boolean connected = Activator.isConnected();

    public ElementsView() {
        this.viewNames = new HashMap<Integer, String>();
        Activator.registerAsListener(this);
    }

    public void createPartControl(Composite parent) {
        try {
            this.owner = parent;
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            parent.setLayout((Layout)layout);
            Composite typesComposite = new Composite(parent, 0);
            typesComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            GridLayout layoutTypesComposite = new GridLayout();
            layout.numColumns = 2;
            typesComposite.setLayout((Layout)layoutTypesComposite);
            Label label = new Label(typesComposite, 0);
            label.setText("Type of Element: ");
            GridData gd0 = new GridData(16384, 0x1000000, false, false);
            gd0.horizontalSpan = 2;
            label.setLayoutData((Object)gd0);
            this.typeCheckboxes = new Button[4];
            this.typeCheckboxes[0] = this.createCheckbox(typesComposite, "Component");
            this.typeCheckboxes[1] = this.createCheckbox(typesComposite, "Style");
            this.typeCheckboxes[2] = this.createCheckbox(typesComposite, "Style Variation");
            this.typeCheckboxes[3] = this.createCheckbox(typesComposite, "Implementation");
            new Separator();
            Composite viewsComposite = new Composite(parent, 0);
            viewsComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            GridLayout layoutViewsComposite = new GridLayout();
            layout.numColumns = 2;
            viewsComposite.setLayout((Layout)layoutViewsComposite);
            Label label2 = new Label(viewsComposite, 0);
            label2.setText("View: ");
            GridData gd1 = new GridData(16384, 0x1000000, false, false);
            gd1.horizontalSpan = 2;
            label2.setLayoutData((Object)gd1);
            this.viewCheckboxes = new Button[4];
            this.viewCheckboxes[0] = this.createCheckbox(viewsComposite, "Logical View");
            this.viewNames.put(0, "Logical View");
            this.viewCheckboxes[1] = this.createCheckbox(viewsComposite, "Deployment View");
            this.viewNames.put(1, "Deployment View");
            this.viewCheckboxes[2] = this.createCheckbox(viewsComposite, "Development View");
            this.viewNames.put(2, "Development View");
            this.viewCheckboxes[3] = this.createCheckbox(viewsComposite, "Platform View");
            this.viewNames.put(3, "Platform View");
            this.elementsTree = new TreeViewer(parent);
            this.elementsTree.setContentProvider((IContentProvider)new ElementsTreeContentProvider());
            this.elementsTree.setLabelProvider((IBaseLabelProvider)new ElementLabelProvider());
            this.elementsTree.setSorter((ViewerSorter)new ElementsSorter());
            this.elementsTree.addFilter((ViewerFilter)new ElementsTreeTypeFilter(this));
            this.elementsTree.addFilter((ViewerFilter)new ElementsTreeViewFilter(this));
            GridData gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 2;
            this.elementsTree.getTree().setLayoutData((Object)gd);
            Transfer[] transfers = new Transfer[]{ElementTransfer.getInstance()};
            this.elementsTree.addDragSupport(2, transfers, (DragSourceListener)new ElementDragListener((StructuredViewer)this.elementsTree));
            this.elementsTree.addDropSupport(2, transfers, (DropTargetListener)new ElementsTreeDropAdapter(this.elementsTree, this));
            if (this.connected) {
                this.setElements();
            } else {
                this.elementsTree.setInput(null);
            }
            this.getSite().setSelectionProvider((ISelectionProvider)this.elementsTree);
            this.shell = this.elementsTree.getControl().getShell();
            this.createActions();
            this.createExploreActions();
            this.createMenu();
            this.addListeners();
            this.setEnabledActions();
            this.setEnabled(this.connected);
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    private Button createCheckbox(Composite parent, String text) {
        Button res = new Button(parent, 32);
        res.setText(text);
        res.setSelection(true);
        res.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ElementsView.this.refresh();
            }
        });
        return res;
    }

    public void createActions() {
        this.newComponentAction = new Action("New Component", Activator.getImageDescriptor("addComponentIcon_16x16.png")){

            public void run() {
                try {
                    ComponentDialog cd = new ComponentDialog(null, ElementsView.this.owner.getShell());
                    if (cd.open() == 0) {
                        ElementsView.this.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.specializeComponentAction = new Action("Specialize Component", Activator.getImageDescriptor("addComponentIcon_16x16.png")){

            public void run() {
                try {
                    IStructuredSelection sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection();
                    Element selElement = (Element)sel.getFirstElement();
                    ComponentDialog cd = new ComponentDialog(selElement, ElementsView.this.owner.getShell());
                    if (cd.open() == 0) {
                        ElementsView.this.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.newStyleAction = new Action("New Style", Activator.getImageDescriptor("addStyleIcon_16x16.png")){

            public void run() {
                try {
                    StyleDialog cd = new StyleDialog(null, ElementsView.this.owner.getShell());
                    if (cd.open() == 0) {
                        ElementsView.this.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.specializeStyleAction = new Action("Specialize Style", Activator.getImageDescriptor("addStyleIcon_16x16.png")){

            public void run() {
                try {
                    IStructuredSelection sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection();
                    Element selElement = (Element)sel.getFirstElement();
                    StyleDialog cd = new StyleDialog(selElement, ElementsView.this.owner.getShell());
                    if (cd.open() == 0) {
                        ElementsView.this.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.newStyleVariationAction = new Action("New Style Variation", Activator.getImageDescriptor("addStyleVariationIcon_16x16.png")){

            public void run() {
                try {
                    StyleVariationDialog cd = new StyleVariationDialog(null, ElementsView.this.owner.getShell());
                    if (cd.open() == 0) {
                        ElementsView.this.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.specializeStyleVariationAction = new Action("Specialize Style Variation", Activator.getImageDescriptor("addStyleVariationIcon_16x16.png")){

            public void run() {
                try {
                    IStructuredSelection sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection();
                    Element selElement = (Element)sel.getFirstElement();
                    StyleVariationDialog cd = new StyleVariationDialog(selElement, ElementsView.this.owner.getShell());
                    if (cd.open() == 0) {
                        ElementsView.this.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.newImplementationAction = new Action("New Implementation", Activator.getImageDescriptor("addImplementationIcon_16x16.png")){

            public void run() {
                try {
                    ImplementationDialog cd = new ImplementationDialog(null, ElementsView.this.owner.getShell());
                    if (cd.open() == 0) {
                        ElementsView.this.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.specializeImplementationAction = new Action("Specialize Implementation", Activator.getImageDescriptor("addImplementationIcon_16x16.png")){

            public void run() {
                try {
                    IStructuredSelection sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection();
                    Element selElement = (Element)sel.getFirstElement();
                    ImplementationDialog cd = new ImplementationDialog(selElement, ElementsView.this.owner.getShell());
                    if (cd.open() == 0) {
                        ElementsView.this.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.editElementAction = new Action("Edit Element", Activator.getImageDescriptor("editIcon_16x16.png")){

            public void run() {
                if (!ElementsView.this.elementsTree.getSelection().isEmpty()) {
                    IStructuredSelection sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection();
                    Element selectedElement = (Element)sel.getFirstElement();
                    try {
                        if (selectedElement instanceof Component) {
                            ComponentDialog cd = new ComponentDialog(ElementsView.this.owner.getShell(), (Component)selectedElement);
                            cd.open();
                        } else if (selectedElement instanceof Style) {
                            StyleDialog sd = new StyleDialog(ElementsView.this.owner.getShell(), (Style)selectedElement);
                            sd.open();
                        } else if (selectedElement instanceof StyleVariation) {
                            StyleVariationDialog svd = new StyleVariationDialog(ElementsView.this.owner.getShell(), (StyleVariation)selectedElement);
                            svd.open();
                        } else if (selectedElement instanceof Implementation) {
                            ImplementationDialog id = new ImplementationDialog(ElementsView.this.owner.getShell(), (Implementation)selectedElement);
                            id.open();
                        }
                        ElementsView.this.refresh();
                    }
                    catch (DomainException e) {
                        if (e.getCause() == null) {
                            ElementsView.this.showError("Error", e.getMessage());
                        } else {
                            DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                            dd.open();
                        }
                    }
                    catch (Exception e) {
                        DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                        dd.open();
                    }
                }
            }
        };
        this.deleteElementAction = new Action("Delete Element", Activator.getImageDescriptor("remove_16x16.png")){

            public void run() {
                try {
                    if (!ElementsView.this.elementsTree.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection();
                        Element selectedElement = (Element)sel.getFirstElement();
                        boolean war = true;
                        String message = "Deleteing an element may affect other entities that are somehow related with it. Specially note that:\n\t- This will affect the decisions with are acting over this element.";
                        if (selectedElement instanceof Style) {
                            message = String.valueOf(message) + "\n\t- This will DELETE the variations of this style.";
                        }
                        if (war = MessageDialog.openConfirm((Shell)ElementsView.this.shell, (String)"WARNING", (String)(String.valueOf(message) + "\n\nDo you want to continue?"))) {
                            boolean del = true;
                            if (!selectedElement.getChildElements().isEmpty()) {
                                del = MessageDialog.openConfirm((Shell)ElementsView.this.shell, (String)"Delete Element", (String)"All the specialized elements will be deleted too.\n\nDo yo want to continue?");
                            }
                            if (del) {
                                HashSet decs = new HashSet();
                                Set variations = DomainController.getInstance().remove(selectedElement, decs);
                                for (StyleVariation var : variations) {
                                    if (!Model.getInstance().existsVariation(var)) continue;
                                    DomainController.getInstance().remove((Element)var, decs);
                                }
                                ElementsView.this.refresh();
                                if (!decs.isEmpty()) {
                                    boolean delDecs = true;
                                    String message2 = "The following decisions are acting over no element:";
                                    for (Decision dec : decs) {
                                        message2 = String.valueOf(message2) + "\n- " + dec.getName() + ".";
                                    }
                                    delDecs = MessageDialog.openConfirm((Shell)ElementsView.this.shell, (String)"Delete Decisions", (String)(message2 = String.valueOf(message2) + "\n\nDo you want to delete these decisions?"));
                                    if (delDecs) {
                                        for (Decision dec : decs) {
                                            DomainController.getInstance().remove(dec);
                                        }
                                        Activator.refreshDecisionsViewer();
                                    }
                                }
                                DomainController.getInstance().notifyModelChange();
                            }
                        }
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        ElementsView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
    }

    private void createExploreActions() {
        this.exploreValues = new Action("Property values"){

            public void run() {
                try {
                    LinkedList<TupleColumnDescriptor> columns = new LinkedList<TupleColumnDescriptor>();
                    columns.add(new TupleColumnDescriptor("Property", 0, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            PropertyValue pv = (PropertyValue)element;
                            return pv.getProperty().getName();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Property Description", 1, 600, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            PropertyValue pv = (PropertyValue)element;
                            return pv.getProperty().getDescription();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Property Type", 2, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            PropertyValue pv = (PropertyValue)element;
                            return pv.getProperty().getType().toString();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Value", 3, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            PropertyValue pv = (PropertyValue)element;
                            return pv.getValue();
                        }
                    }));
                    Element selElement = (Element)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    final Element element = selElement = DomainController.getInstance().getElementById(selElement.getId());
                    ExploreDialog dialog = new ExploreDialog(ElementsView.this.owner.getShell(), "Explore property values", "These are the values that the element puts over element properties", null, columns, 960);
                    dialog.setInput(selElement.getPropertyValues().toArray());
                    dialog.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object o1, Object o2) {
                            PropertyValue pv1 = (PropertyValue)o1;
                            PropertyValue pv2 = (PropertyValue)o2;
                            return pv1.getProperty().getName().compareToIgnoreCase(pv2.getProperty().getName());
                        }
                    });
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Element aux = DomainController.getInstance().getElementById(element.getId());
                            if (aux == null) {
                                return null;
                            }
                            return aux.getPropertyValues().toArray();
                        }
                    });
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreActions = new Action("Decision actions"){

            public void run() {
                try {
                    LinkedList<TupleColumnDescriptor> columns = new LinkedList<TupleColumnDescriptor>();
                    columns.add(new TupleColumnDescriptor("Decision", 0, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            DecisionAction da = (DecisionAction)element;
                            return da.getDecision().getName();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Decision Description", 1, 600, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            DecisionAction da = (DecisionAction)element;
                            return da.getDecision().getDescription();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Action", 2, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            DecisionAction da = (DecisionAction)element;
                            return Constants.ACTION_NAMES[da.getAction()];
                        }
                    }));
                    Element selElement = (Element)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    final Element element = selElement = DomainController.getInstance().getElementById(selElement.getId());
                    ExploreDialog dialog = new ExploreDialog(ElementsView.this.owner.getShell(), "Explore decision actions", "These are the actions that decisions will do over this element", null, columns, 840);
                    dialog.setInput(selElement.getDecisionActions().toArray());
                    dialog.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object o1, Object o2) {
                            DecisionAction da1 = (DecisionAction)o1;
                            DecisionAction da2 = (DecisionAction)o2;
                            return da1.getDecision().getName().compareToIgnoreCase(da2.getDecision().getName());
                        }
                    });
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Element aux = DomainController.getInstance().getElementById(element.getId());
                            if (aux == null) {
                                return null;
                            }
                            return aux.getDecisionActions().toArray();
                        }
                    });
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreRelated = new Action("Related elements"){

            public void run() {
                try {
                    Element selElement = (Element)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    final Element element = selElement = DomainController.getInstance().getElementById(selElement.getId());
                    ExploreDialog dialog = ElementsView.this.showExploreDialogGenericElement(true, true, selElement.getRelatedElements(), "Explore related elements", "these are the elements related to the selected element");
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Element aux = DomainController.getInstance().getElementById(element.getId());
                            if (aux == null) {
                                return null;
                            }
                            return aux.getRelatedElements().toArray();
                        }
                    });
                    dialog.setMenuType(0);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreRelatedInverse = new Action("Element related with this"){

            public void run() {
                try {
                    Element selElement = (Element)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getElementById(selElement.getId());
                    ExploreDialog dialog = ElementsView.this.showExploreDialogGenericElement(true, true, selElement.getIsRelatedWith(), "Explore elements related with this", "these are the elements that have the selected element as a related one");
                    final Element element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Element aux = DomainController.getInstance().getElementById(element.getId());
                            if (aux == null) {
                                return null;
                            }
                            return aux.getIsRelatedWith().toArray();
                        }
                    });
                    dialog.setMenuType(0);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreComposible = new Action("Composible components"){

            public void run() {
                try {
                    Component selElement = (Component)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getComponentById(selElement, false);
                    ExploreDialog dialog = ElementsView.this.showExploreDialogGenericElement(false, false, selElement.getComposableWith(), "Explore composible components", "the selected component can be composed with the following components");
                    final Component element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Component aux = DomainController.getInstance().getComponentById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getComposableWith().toArray();
                        }
                    });
                    dialog.setMenuType(1);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreConnectible = new Action("Connectible components"){

            public void run() {
                try {
                    Component selElement = (Component)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getComponentById(selElement, false);
                    ExploreDialog dialog = ElementsView.this.showExploreDialogGenericElement(false, false, selElement.getConnectedTo(), "Explore connectable components", "the selected component can be connected to the following components");
                    final Component element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Component aux = DomainController.getInstance().getComponentById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getConnectedTo().toArray();
                        }
                    });
                    dialog.setMenuType(1);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreComposibleInverse = new Action("Components composable with this"){

            public void run() {
                try {
                    Component selElement = (Component)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    final Component element = selElement = DomainController.getInstance().getComponentById(selElement, false);
                    ExploreDialog dialog = ElementsView.this.showExploreDialogGenericElement(false, false, selElement.getComposableWithInverse(), "Explore components composable with this", "the following components can be composed with the selected one");
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Component aux = DomainController.getInstance().getComponentById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getComposableWithInverse().toArray();
                        }
                    });
                    dialog.setMenuType(1);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreConnectibleInverse = new Action("Components connectable to this"){

            public void run() {
                try {
                    Component selElement = (Component)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getComponentById(selElement, false);
                    ExploreDialog dialog = ElementsView.this.showExploreDialogGenericElement(false, false, selElement.getConnectedToInverse(), "Explore components connectable to this", "the following components can be connected to the selected one");
                    final Component element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Component aux = DomainController.getInstance().getComponentById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getConnectedToInverse().toArray();
                        }
                    });
                    dialog.setMenuType(1);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreApplyToStyleVariation = new Action("Style variations to which apply"){

            public void run() {
                try {
                    Component selElement = (Component)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getComponentById(selElement, false);
                    ExploreDialog dialog = ElementsView.this.showExploreDialogStyleVariation(selElement.getApplyTo(), "Explore style variations to which apply", "the selected component applies to the following style variations");
                    final Component element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Component aux = DomainController.getInstance().getComponentById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getApplyTo().toArray();
                        }
                    });
                    dialog.setMenuType(3);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreApplyToStyle = new Action("Styles to which apply"){

            public void run() {
                try {
                    Component selElement = (Component)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getComponentById(selElement, false);
                    ExploreDialog dialog = ElementsView.this.showExploreDialogGenericElement(false, false, selElement.getApplyToStyle(), "Explore styles to which apply", "the selected component applies to the following styles");
                    final Component element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Component aux = DomainController.getInstance().getComponentById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getApplyToStyle().toArray();
                        }
                    });
                    dialog.setMenuType(2);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreImplementableWith = new Action("Implementations with which can be implemented"){

            public void run() {
                try {
                    Component selElement = (Component)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getComponentById(selElement, false);
                    ExploreDialog dialog = ElementsView.this.showExploreDialogGenericElement(false, false, selElement.getImplementableWith(), "Explore implementations with which can be implemented", "the selected component can be implemented using the following implementations");
                    final Component element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Component aux = DomainController.getInstance().getComponentById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getImplementableWith().toArray();
                        }
                    });
                    dialog.setMenuType(4);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreImplementableWithInverse = new Action("Components implementable"){

            public void run() {
                try {
                    Implementation selElement = (Implementation)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getImplementationById(selElement, false);
                    ExploreDialog dialog = ElementsView.this.showExploreDialogGenericElement(false, false, selElement.getComponents(), "Explore components implementable", "these are the components which can be implemented using the selected implementation");
                    final Implementation element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Implementation aux = DomainController.getInstance().getImplementationById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getComponents().toArray();
                        }
                    });
                    dialog.setMenuType(1);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreApplyToStyleInverse = new Action("Components that apply"){

            public void run() {
                try {
                    Style selElement = (Style)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getStyleById(selElement, false);
                    ExploreDialog dialog = ElementsView.this.showExploreDialogGenericElement(false, false, selElement.getComponents(), "Explore components that apply", "these are the components which apply to the selected style");
                    final Style element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Style aux = DomainController.getInstance().getStyleById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getComponents().toArray();
                        }
                    });
                    dialog.setMenuType(1);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreVariationForInverse = new Action("Style variations"){

            public void run() {
                try {
                    Style selElement = (Style)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getStyleById(selElement, false);
                    ExploreDialog dialog = ElementsView.this.showExploreDialogGenericElement(false, false, selElement.getStyleVariations(), "Explore style variations", "the selected style has the following variations");
                    final Style element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Style aux = DomainController.getInstance().getStyleById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getStyleVariations().toArray();
                        }
                    });
                    dialog.setMenuType(3);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreApplyToStyleVariationInverse = new Action("Components that apply"){

            public void run() {
                try {
                    StyleVariation selElement = (StyleVariation)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getStyleVariationById(selElement, false);
                    ExploreDialog dialog = ElementsView.this.showExploreDialogGenericElement(false, false, selElement.getComponents(), "Explore components that apply", "these are the components which apply to the selected style variation");
                    final StyleVariation element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            StyleVariation aux = DomainController.getInstance().getStyleVariationById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getComponents().toArray();
                        }
                    });
                    dialog.setMenuType(1);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
        this.exploreIncompatibleWith = new Action("Incompatible style variations"){

            public void run() {
                try {
                    StyleVariation selElement = (StyleVariation)((IStructuredSelection)ElementsView.this.elementsTree.getSelection()).getFirstElement();
                    selElement = DomainController.getInstance().getStyleVariationById(selElement, false);
                    ExploreDialog dialog = ElementsView.this.showExploreDialogStyleVariation(selElement.getIncompatibleWith(), "Explore incompatible style variations", "the following style variations are incompatible with the selected one");
                    final StyleVariation element = selElement;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            StyleVariation aux = DomainController.getInstance().getStyleVariationById(element, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getIncompatibleWith().toArray();
                        }
                    });
                    dialog.setMenuType(3);
                    dialog.setCanEdit(true);
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, ElementsView.this.shell);
                    dd.open();
                }
            }
        };
    }

    public ExploreDialog showExploreDialogGenericElement(boolean showtype, boolean showView, Set<?> input, String title, String description) {
        LinkedList<TupleColumnDescriptor> columns = new LinkedList<TupleColumnDescriptor>();
        columns.add(new TupleColumnDescriptor("Element", 0, 120, new ColumnLabelProvider(){

            public String getText(Object element) {
                Element el = (Element)element;
                if (showtype) {
                    return el.toString();
                }
                return el.getName();
            }
        }));
        columns.add(new TupleColumnDescriptor("Description", 1, 600, new ColumnLabelProvider(){

            public String getText(Object element) {
                Element el = (Element)element;
                return el.getDescription();
            }
        }));
        if (showView) {
            columns.add(new TupleColumnDescriptor("View", 2, 120, new ColumnLabelProvider(){

                public String getText(Object element) {
                    Element el = (Element)element;
                    return el.getArchitecturalView().getName();
                }
            }));
        }
        ExploreDialog dialog = new ExploreDialog(this.owner.getShell(), title, description, null, columns, showView ? 840 : 720);
        dialog.setInput(input.toArray());
        dialog.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                Element e1 = (Element)o1;
                Element e2 = (Element)o2;
                return e1.getName().compareToIgnoreCase(e2.getName());
            }
        });
        return dialog;
    }

    public ExploreDialog showExploreDialogStyleVariation(Set<?> input, String title, String description) {
        LinkedList<TupleColumnDescriptor> columns = new LinkedList<TupleColumnDescriptor>();
        columns.add(new TupleColumnDescriptor("Element", 0, 120, new ColumnLabelProvider(){

            public String getText(Object element) {
                StyleVariation el = (StyleVariation)element;
                return el.getName();
            }
        }));
        columns.add(new TupleColumnDescriptor("Description", 1, 600, new ColumnLabelProvider(){

            public String getText(Object element) {
                StyleVariation el = (StyleVariation)element;
                return el.getDescription();
            }
        }));
        columns.add(new TupleColumnDescriptor("Variation for", 2, 120, new ColumnLabelProvider(){

            public String getText(Object element) {
                StyleVariation el = (StyleVariation)element;
                return el.getVariationFor().getName();
            }
        }));
        ExploreDialog dialog = new ExploreDialog(this.owner.getShell(), title, description, null, columns, 840);
        dialog.setInput(input.toArray());
        dialog.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                Element e1 = (Element)o1;
                Element e2 = (Element)o2;
                return e1.getName().compareToIgnoreCase(e2.getName());
            }
        });
        return dialog;
    }

    public void createMenu() {
        this.popUpMenu = new MenuManager();
        this.popUpMenu.setRemoveAllWhenShown(true);
        this.popUpMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                Element selectedElement;
                IStructuredSelection sel;
                if (!ElementsView.this.elementsTree.getSelection().isEmpty()) {
                    sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection();
                    selectedElement = (Element)sel.getFirstElement();
                    if (selectedElement instanceof Component) {
                        mgr.add((IAction)ElementsView.this.specializeComponentAction);
                    } else if (selectedElement instanceof Style) {
                        mgr.add((IAction)ElementsView.this.specializeStyleAction);
                    } else if (selectedElement instanceof StyleVariation) {
                        mgr.add((IAction)ElementsView.this.specializeStyleVariationAction);
                    } else if (selectedElement instanceof Implementation) {
                        mgr.add((IAction)ElementsView.this.specializeImplementationAction);
                    }
                    mgr.add((IContributionItem)new Separator());
                    mgr.add((IAction)ElementsView.this.editElementAction);
                    mgr.add((IAction)ElementsView.this.deleteElementAction);
                }
                mgr.add((IAction)ElementsView.this.newComponentAction);
                mgr.add((IAction)ElementsView.this.newStyleAction);
                mgr.add((IAction)ElementsView.this.newStyleVariationAction);
                mgr.add((IAction)ElementsView.this.newImplementationAction);
                if (!ElementsView.this.elementsTree.getSelection().isEmpty()) {
                    sel = (IStructuredSelection)ElementsView.this.elementsTree.getSelection();
                    selectedElement = (Element)sel.getFirstElement();
                    if (selectedElement instanceof Component) {
                        ElementsView.this.addExploreActionsComponent(mgr);
                    } else if (selectedElement instanceof Style) {
                        ElementsView.this.addExploreActionsStyle(mgr);
                    } else if (selectedElement instanceof StyleVariation) {
                        ElementsView.this.addExploreActionsStyleVariation(mgr);
                    } else if (selectedElement instanceof Implementation) {
                        ElementsView.this.addExploreActionsImplementation(mgr);
                    }
                }
            }
        });
        Menu menu = this.popUpMenu.createContextMenu(this.elementsTree.getControl());
        this.elementsTree.getControl().setMenu(menu);
        this.getSite().registerContextMenu(this.popUpMenu, (ISelectionProvider)this.elementsTree);
        this.setMenuElements();
    }

    private void addExploreActionsComponent(IMenuManager mgr) {
        MenuManager g = this.addExploreActionsGeneric(mgr);
        g.add((IAction)this.exploreComposible);
        g.add((IAction)this.exploreComposibleInverse);
        g.add((IAction)this.exploreConnectible);
        g.add((IAction)this.exploreConnectibleInverse);
        g.add((IAction)this.exploreApplyToStyle);
        g.add((IAction)this.exploreApplyToStyleVariation);
        g.add((IAction)this.exploreImplementableWith);
    }

    private void addExploreActionsImplementation(IMenuManager mgr) {
        MenuManager g = this.addExploreActionsGeneric(mgr);
        g.add((IAction)this.exploreImplementableWithInverse);
    }

    private void addExploreActionsStyle(IMenuManager mgr) {
        MenuManager g = this.addExploreActionsGeneric(mgr);
        g.add((IAction)this.exploreApplyToStyleInverse);
        g.add((IAction)this.exploreVariationForInverse);
    }

    private void addExploreActionsStyleVariation(IMenuManager mgr) {
        MenuManager g = this.addExploreActionsGeneric(mgr);
        g.add((IAction)this.exploreApplyToStyleVariationInverse);
        g.add((IAction)this.exploreIncompatibleWith);
    }

    private MenuManager addExploreActionsGeneric(IMenuManager mgr) {
        MenuManager g = new MenuManager("Explore");
        mgr.add((IContributionItem)g);
        g.add((IAction)this.exploreValues);
        g.add((IAction)this.exploreActions);
        g.add((IAction)this.exploreRelated);
        g.add((IAction)this.exploreRelatedInverse);
        return g;
    }

    private void setMenuElements() {
        IToolBarManager tmgr = this.getViewSite().getActionBars().getToolBarManager();
        tmgr.removeAll();
        tmgr.add((IAction)this.newComponentAction);
        tmgr.add((IAction)this.newStyleAction);
        tmgr.add((IAction)this.newStyleVariationAction);
        tmgr.add((IAction)this.newImplementationAction);
        tmgr.add((IAction)this.deleteElementAction);
        tmgr.update(false);
    }

    private void addListeners() {
        this.elementsTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ElementsView.this.editElementAction.isEnabled()) {
                    ElementsView.this.editElementAction.run();
                }
            }
        });
        this.elementsTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementsView.this.setEnabledActions();
            }
        });
    }

    private void setEnabledActions() {
        boolean enabledED = true;
        enabledED = !this.elementsTree.getSelection().isEmpty();
        this.editElementAction.setEnabled(enabledED);
        this.deleteElementAction.setEnabled(enabledED);
    }

    private void setElements() {
        try {
            this.selectedElements = Model.getInstance().getElements();
            this.elementsTree.setInput(this.selectedElements);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    public Set<Class> getSelectedTypes() {
        HashSet<Class> res = new HashSet<Class>();
        if (this.typeCheckboxes[0].getSelection()) {
            res.add(Component.class);
        }
        if (this.typeCheckboxes[1].getSelection()) {
            res.add(Style.class);
        }
        if (this.typeCheckboxes[2].getSelection()) {
            res.add(StyleVariation.class);
        }
        if (this.typeCheckboxes[3].getSelection()) {
            res.add(Implementation.class);
        }
        return res;
    }

    public Set<String> getSelectedViewNames() {
        HashSet<String> res = new HashSet<String>();
        int i = 0;
        while (i < this.viewCheckboxes.length) {
            if (this.viewCheckboxes[i].getSelection()) {
                res.add(this.viewNames.get(i));
            }
            ++i;
        }
        return res;
    }

    public TreeViewer getElementsTree() {
        return this.elementsTree;
    }

    public void setFocus() {
        if (this.connected) {
            this.elementsTree.getControl().setFocus();
            this.setElements();
        }
    }

    public void refresh() {
        this.elementsTree.refresh();
        this.setElements();
    }

    public void refreshFromDbChange() {
        this.refresh();
        if (!this.connected) {
            this.connected = true;
            this.setEnabled(true);
        }
    }

    public void disconnect() {
        if (this.connected) {
            this.elementsTree.setInput(null);
            this.connected = false;
            this.setEnabled(false);
        }
    }

    public void dispose() {
        super.dispose();
        Activator.unregisterAsListener(this);
    }

    private void setEnabled(boolean enabled) {
        Button checkbox;
        this.elementsTree.getTree().setEnabled(enabled);
        Button[] buttonArray = this.typeCheckboxes;
        int n = this.typeCheckboxes.length;
        int n2 = 0;
        while (n2 < n) {
            checkbox = buttonArray[n2];
            checkbox.setEnabled(enabled);
            ++n2;
        }
        buttonArray = this.viewCheckboxes;
        n = this.viewCheckboxes.length;
        n2 = 0;
        while (n2 < n) {
            checkbox = buttonArray[n2];
            checkbox.setEnabled(enabled);
            ++n2;
        }
        this.newComponentAction.setEnabled(enabled);
        this.newStyleAction.setEnabled(enabled);
        this.newStyleVariationAction.setEnabled(enabled);
        this.newImplementationAction.setEnabled(enabled);
        this.editElementAction.setEnabled(enabled);
        this.deleteElementAction.setEnabled(enabled);
        if (enabled) {
            this.setEnabledActions();
        }
    }

    public void setStatusError(String message) {
        this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(Activator.getImageDescriptor("errorIcon.gif").createImage(), message);
    }

    public void removeStatusError() {
        this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null, null);
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 4 && event.getResource() instanceof IProject) {
            try {
                if (((IProject)event.getResource()).hasNature("architech.ProjectNature")) {
                    String location = Activator.getLocation((IProject)event.getResource());
                    Display display = this.elementsTree.getControl().getDisplay();
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (ElementsView.this.elementsTree.getControl().isDisposed()) {
                                    return;
                                }
                                if (Activator.getCurrentLocation().equals(location)) {
                                    ElementsView.this.disconnect();
                                }
                            }
                        });
                    }
                }
            }
            catch (CoreException coreException) {}
        }
    }
}

