/*
 * Decompiled with CFR 0.152.
 */
package upc.gessi.architech.gui.views.questions;

import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import upc.gessi.architech.Activator;
import upc.gessi.architech.controller.questions.QuestionContentProvider;
import upc.gessi.architech.controller.questions.QuestionLabelProvider;
import upc.gessi.architech.controller.questions.QuestionSorter;
import upc.gessi.architech.gui.dialogs.DetailsDialog;
import upc.gessi.architech.gui.dialogs.ExploreDialog;
import upc.gessi.architech.gui.dialogs.ExploreDialogRefresher;
import upc.gessi.architech.gui.dialogs.question.QuestionDialog;
import upc.gessi.architech.hibernatehelper.domain.controller.DomainController;
import upc.gessi.architech.hibernatehelper.domain.controller.Model;
import upc.gessi.architech.hibernatehelper.domain.domainModel.propertyRule.prQuestionRestriction;
import upc.gessi.architech.hibernatehelper.domain.domainModel.question.Question;
import upc.gessi.architech.hibernatehelper.domain.domainModel.questionRule.qrQuestionRestriction;
import upc.gessi.architech.hibernatehelper.exceptions.DomainException;
import upc.gessi.architech.utils.StackTraceUtil;
import upc.gessi.architech.utils.TupleColumnDescriptor;

public class QuestionsView
extends ViewPart
implements IResourceChangeListener {
    public static final int COL_NAME_WIDTH = 120;
    public static final int COL_TEXT_WIDTH = 450;
    public static final int COL_TYPE_WIDTH = 220;
    public static final int COL_RESTRICTION_WIDTH = 300;
    public static final int TOTAL_WIDTH_QUESTION_RESTRICTIONS = 1090;
    public static final int TOTAL_WIDTH_PROPERTY_RESTRICTIONS = 760;
    private Action newQuestionAction;
    private Action editQuestionAction;
    private Action deleteQuestionAction;
    private Action orderUpAction;
    private Action orderDownAction;
    private Action exploreQuestionRestrictions;
    private Action explorePropertyRestrictions;
    private ListViewer questionsList;
    private Composite owner;
    private Set<Question> allQuestions = null;
    Shell shell;
    private boolean connected;

    public QuestionsView() {
        Activator.registerAsListener(this);
        this.connected = Activator.isConnected();
    }

    public void createPartControl(Composite parent) {
        try {
            this.owner = parent;
            this.questionsList = new ListViewer(parent);
            this.questionsList.setContentProvider((IContentProvider)new QuestionContentProvider());
            this.questionsList.setLabelProvider((IBaseLabelProvider)new QuestionLabelProvider());
            this.questionsList.setSorter((ViewerSorter)new QuestionSorter());
            this.allQuestions = this.connected && this.allQuestions == null ? Model.getInstance().getQuestions() : null;
            this.questionsList.setInput(this.allQuestions);
            this.getSite().setSelectionProvider((ISelectionProvider)this.questionsList);
            this.shell = this.questionsList.getControl().getShell();
            this.createActions();
            this.createExploreActions();
            this.createMenu();
            this.addListeners();
            this.setEnabledActions();
            this.setEnabled(this.connected);
        }
        catch (DomainException e) {
            if (e.getCause() == null) {
                this.showError("Error", e.getMessage());
            } else {
                DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, this.shell);
                dd.open();
            }
        }
        catch (Exception e) {
            DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, this.shell);
            dd.open();
        }
    }

    public void createActions() {
        QuestionsView qView = this;
        this.newQuestionAction = new Action("New Question", Activator.getImageDescriptor("add_16x16.png")){

            public void run() {
                try {
                    QuestionDialog qd = new QuestionDialog(QuestionsView.this.owner.getShell(), qView);
                    if (qd.open() == 0) {
                        QuestionsView.this.questionsList.refresh();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                    dd.open();
                }
            }
        };
        this.editQuestionAction = new Action("Edit Question", Activator.getImageDescriptor("editIcon_16x16.png")){

            public void run() {
                try {
                    if (!QuestionsView.this.questionsList.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)QuestionsView.this.questionsList.getSelection();
                        Question selectedQuestion = (Question)sel.getFirstElement();
                        QuestionDialog qd = new QuestionDialog(QuestionsView.this.owner.getShell(), selectedQuestion, qView);
                        qd.open();
                        QuestionsView.this.questionsList.refresh();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        QuestionsView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                    dd.open();
                }
            }
        };
        this.deleteQuestionAction = new Action("Delete Question", Activator.getImageDescriptor("remove_16x16.png")){

            public void run() {
                try {
                    if (!QuestionsView.this.questionsList.getSelection().isEmpty()) {
                        IStructuredSelection sel = (IStructuredSelection)QuestionsView.this.questionsList.getSelection();
                        Question selectedQuestion = (Question)sel.getFirstElement();
                        boolean del = true;
                        if (!selectedQuestion.getQuestionRestrictions().isEmpty() || !selectedQuestion.getPropertyRestrictions().isEmpty()) {
                            del = MessageDialog.openConfirm((Shell)QuestionsView.this.shell, (String)"Delete Question", (String)"This question is being used in some question or property rules. The deletion of this question will modify these rules.\nDo yo want to continue?");
                        }
                        if (del) {
                            DomainController.getInstance().remove(selectedQuestion);
                        }
                        QuestionsView.this.questionsList.refresh();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        QuestionsView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                    dd.open();
                }
            }
        };
        this.orderUpAction = new Action("Go Up", Activator.getImageDescriptor("arrowUp_16x16.png")){

            public void run() {
                try {
                    IStructuredSelection selQuestion = (IStructuredSelection)QuestionsView.this.questionsList.getSelection();
                    int selIndex = QuestionsView.this.questionsList.getList().getSelectionIndex();
                    if (!selQuestion.isEmpty() && selIndex > 0) {
                        Question upQuestion = (Question)selQuestion.getFirstElement();
                        Question downQuestion = (Question)QuestionsView.this.questionsList.getElementAt(selIndex - 1);
                        DomainController.getInstance().swapQuestionsOrder(upQuestion, downQuestion);
                        QuestionsView.this.refresh();
                        QuestionsView.this.setEnabledActions();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        QuestionsView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                    dd.open();
                }
            }
        };
        this.orderDownAction = new Action("Go Down", Activator.getImageDescriptor("arrowDown_16x16.png")){

            public void run() {
                try {
                    IStructuredSelection selQuestion = (IStructuredSelection)QuestionsView.this.questionsList.getSelection();
                    int selIndex = QuestionsView.this.questionsList.getList().getSelectionIndex();
                    if (!selQuestion.isEmpty() && selIndex < QuestionsView.this.questionsList.getList().getItemCount() - 1) {
                        Question downQuestion = (Question)selQuestion.getFirstElement();
                        Question upQuestion = (Question)QuestionsView.this.questionsList.getElementAt(selIndex + 1);
                        DomainController.getInstance().swapQuestionsOrder(upQuestion, downQuestion);
                        QuestionsView.this.refresh();
                        QuestionsView.this.setEnabledActions();
                    }
                }
                catch (DomainException e) {
                    if (e.getCause() == null) {
                        QuestionsView.this.showError("Error", e.getMessage());
                    } else {
                        DetailsDialog dd = new DetailsDialog("Error", e.getMessage(), StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                        dd.open();
                    }
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                    dd.open();
                }
            }
        };
    }

    private void createExploreActions() {
        this.exploreQuestionRestrictions = new Action("Question Restrictions"){

            public void run() {
                try {
                    LinkedList<TupleColumnDescriptor> columns = new LinkedList<TupleColumnDescriptor>();
                    columns.add(new TupleColumnDescriptor("Rule Name", 0, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            qrQuestionRestriction rest = (qrQuestionRestriction)element;
                            return rest.getQuestionRule().getName();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Restriction on the answer", 1, 300, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            qrQuestionRestriction rest = (qrQuestionRestriction)element;
                            return rest.getRestriction();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Question text", 2, 450, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            qrQuestionRestriction rest = (qrQuestionRestriction)element;
                            return rest.getQuestionRule().getQuestion().getText();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Question type", 3, 220, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            qrQuestionRestriction rest = (qrQuestionRestriction)element;
                            return rest.getQuestionRule().getQuestion().getQuestionType().toString();
                        }
                    }));
                    ExploreDialog dialog = new ExploreDialog(QuestionsView.this.owner.getShell(), "Explore question restrictions", "This question appears in the left-hand side of the following question rules", null, columns, 1090);
                    Question selQuestion = (Question)((IStructuredSelection)QuestionsView.this.questionsList.getSelection()).getFirstElement();
                    selQuestion = DomainController.getInstance().getQuestionById(selQuestion, false);
                    dialog.setInput(selQuestion.getQuestionRestrictions().toArray());
                    dialog.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object o1, Object o2) {
                            qrQuestionRestriction rest1 = (qrQuestionRestriction)o1;
                            qrQuestionRestriction rest2 = (qrQuestionRestriction)o2;
                            return rest1.getQuestionRule().getQuestion().getOrder() - rest2.getQuestionRule().getQuestion().getOrder();
                        }
                    });
                    final Question question = selQuestion;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Question aux = DomainController.getInstance().getQuestionById(question, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getQuestionRestrictions().toArray();
                        }
                    });
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                    dd.open();
                }
            }
        };
        this.explorePropertyRestrictions = new Action("Property Restrictions"){

            public void run() {
                try {
                    LinkedList<TupleColumnDescriptor> columns = new LinkedList<TupleColumnDescriptor>();
                    columns.add(new TupleColumnDescriptor("Rule Name", 0, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            prQuestionRestriction rest = (prQuestionRestriction)element;
                            return rest.getPropertyRule().getName();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Restriction on the answer", 1, 300, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            prQuestionRestriction rest = (prQuestionRestriction)element;
                            return rest.getRestriction();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Property", 2, 120, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            prQuestionRestriction rest = (prQuestionRestriction)element;
                            return rest.getPropertyRule().getProperty().getName();
                        }
                    }));
                    columns.add(new TupleColumnDescriptor("Property type", 3, 220, new ColumnLabelProvider(){

                        public String getText(Object element) {
                            prQuestionRestriction rest = (prQuestionRestriction)element;
                            return rest.getPropertyRule().getProperty().getType().toString();
                        }
                    }));
                    ExploreDialog dialog = new ExploreDialog(QuestionsView.this.owner.getShell(), "Explore property restrictions", "This question appears in the left-hand side of the following property rules", null, columns, 760);
                    Question selQuestion = (Question)((IStructuredSelection)QuestionsView.this.questionsList.getSelection()).getFirstElement();
                    selQuestion = DomainController.getInstance().getQuestionById(selQuestion, false);
                    dialog.setInput(selQuestion.getPropertyRestrictions().toArray());
                    dialog.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object o1, Object o2) {
                            prQuestionRestriction rest1 = (prQuestionRestriction)o1;
                            prQuestionRestriction rest2 = (prQuestionRestriction)o2;
                            return rest1.getPropertyRule().getProperty().getName().compareToIgnoreCase(rest2.getPropertyRule().getProperty().getName());
                        }
                    });
                    final Question question = selQuestion;
                    dialog.setRefresher(new ExploreDialogRefresher(){

                        @Override
                        public Object[] refresh() throws DomainException {
                            Question aux = DomainController.getInstance().getQuestionById(question, false);
                            if (aux == null) {
                                return null;
                            }
                            return aux.getPropertyRestrictions().toArray();
                        }
                    });
                    dialog.open();
                }
                catch (Exception e) {
                    DetailsDialog dd = new DetailsDialog("Error", "Unknown Exception", StackTraceUtil.getStackTrace(e), 0, QuestionsView.this.shell);
                    dd.open();
                }
            }
        };
    }

    public void createMenu() {
        IToolBarManager tmgr = this.getViewSite().getActionBars().getToolBarManager();
        tmgr.add((IAction)this.newQuestionAction);
        tmgr.add((IAction)this.deleteQuestionAction);
        tmgr.add((IContributionItem)new Separator());
        tmgr.add((IAction)this.orderUpAction);
        tmgr.add((IAction)this.orderDownAction);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)QuestionsView.this.newQuestionAction);
                if (!QuestionsView.this.questionsList.getSelection().isEmpty()) {
                    mgr.add((IAction)QuestionsView.this.editQuestionAction);
                    mgr.add((IAction)QuestionsView.this.deleteQuestionAction);
                    int selIndex = QuestionsView.this.questionsList.getList().getSelectionIndex();
                    if (selIndex < QuestionsView.this.questionsList.getList().getItemCount() - 1) {
                        mgr.add((IAction)QuestionsView.this.orderDownAction);
                    }
                    if (selIndex != 0) {
                        mgr.add((IAction)QuestionsView.this.orderUpAction);
                    }
                    QuestionsView.this.addExploreActions(mgr);
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.questionsList.getControl());
        this.questionsList.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.questionsList);
    }

    private void addExploreActions(IMenuManager mgr) {
        MenuManager g = new MenuManager("Explore");
        mgr.add((IContributionItem)g);
        g.add((IAction)this.exploreQuestionRestrictions);
        g.add((IAction)this.explorePropertyRestrictions);
    }

    private void addListeners() {
        this.questionsList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                QuestionsView.this.editQuestionAction.run();
            }
        });
        this.questionsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                QuestionsView.this.setEnabledActions();
            }
        });
    }

    private void setEnabledActions() {
        boolean enabledED = true;
        boolean enabledU = true;
        boolean enabledD = true;
        if (this.questionsList.getSelection().isEmpty()) {
            enabledED = false;
            enabledU = false;
            enabledD = false;
        } else {
            int selIndex = this.questionsList.getList().getSelectionIndex();
            if (selIndex >= this.questionsList.getList().getItemCount() - 1) {
                enabledD = false;
            }
            if (selIndex == 0) {
                enabledU = false;
            }
        }
        this.editQuestionAction.setEnabled(enabledED);
        this.deleteQuestionAction.setEnabled(enabledED);
        this.orderUpAction.setEnabled(enabledU);
        this.orderDownAction.setEnabled(enabledD);
    }

    public ListViewer getQuestionsList() {
        return this.questionsList;
    }

    public void setFocus() {
        if (this.connected) {
            this.questionsList.getControl().setFocus();
        }
    }

    public void refresh() {
        this.questionsList.refresh();
    }

    public void refreshFromDbChange() {
        try {
            this.allQuestions = Model.getInstance().getQuestions();
            this.questionsList.setInput(this.allQuestions);
        }
        catch (DomainException e) {
            e.printStackTrace();
        }
        this.refresh();
        if (!this.connected) {
            this.connected = true;
            this.setEnabled(true);
        }
    }

    public void disconnect() {
        if (this.connected) {
            this.questionsList.setInput(null);
            this.connected = false;
            this.setEnabled(false);
        }
    }

    private void setEnabled(boolean enabled) {
        this.questionsList.getList().setEnabled(enabled);
        this.newQuestionAction.setEnabled(enabled);
        this.editQuestionAction.setEnabled(enabled);
        this.deleteQuestionAction.setEnabled(enabled);
        this.orderUpAction.setEnabled(enabled);
        this.orderDownAction.setEnabled(enabled);
        if (enabled) {
            this.setEnabledActions();
        }
    }

    public Question getQuestionAt(int order) {
        return (Question)this.questionsList.getElementAt(order - 1);
    }

    private void showError(String title, String message) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
    }

    public void dispose() {
        super.dispose();
        Activator.unregisterAsListener(this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 4 && event.getResource() instanceof IProject) {
            try {
                if (((IProject)event.getResource()).hasNature("architech.ProjectNature")) {
                    String location = Activator.getLocation((IProject)event.getResource());
                    Display display = this.questionsList.getControl().getDisplay();
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (QuestionsView.this.questionsList.getControl().isDisposed()) {
                                    return;
                                }
                                if (Activator.getCurrentLocation().equals(location)) {
                                    QuestionsView.this.disconnect();
                                }
                            }
                        });
                    }
                }
            }
            catch (CoreException coreException) {}
        }
    }
}

